
// Our Sims

// 0. 
// global version = "_unconstrained" 
global out_dir = "prod"
global version = "_constrained"
global initial = "_model_prod"


clear all 
cd "$project_code"

use "dta/sims_inputs${version}.dta", clear

global add = ""
global explosive_suffix = ""
// global explosive_suffix = "_xsection"


//10 or 100
global periods = 100
global xaxis_end = 100
global slope1_threshold = 0.01
global ss = "_ss" 
global reps = 1000
global s_u_str = ""
global vars "e_u  e_s  rminusg  b s"

// All data cleaning

// import cbo ltbo debt
preserve
import excel  "$project_code/raw/51119-2024-03-LTBO-budget.xlsx", clear ///
sheet("1. Summary Ext Baseline") ///
cellrange(A10:R41) firstrow


rename Federaldebtheldbythepublic debt
rename Fiscalyear year
rename GDPtrillionsofdollars gdp
rename Netinterest interest 
rename Revenues revenue
rename Totalspending outlays

g b = debt/100
replace gdp = gdp * 1000
replace revenue = revenue/100*gdp
replace outlays = outlays/100*gdp
replace debt = debt/100*gdp
replace interest = interest/100*gdp

gen deficit = outlays - revenue
gen primarydeficit = deficit - interest
gen s = - primarydeficit/gdp
sort year
gen g = gdp/gdp[_n-1] - 1
gen i = interest/(debt[_n-1] + .5*primarydeficit)
g rminusg = (i-g)/(1+g) //we call rho rminusg becasue of legacy code
keep year b rminusg  s
keep if year >=2025
replace year = year - 2025


save "dta/cbo_ltbo_debt.dta", replace
restore



/* Figure 1A sudden_r
debt
*/
preserve
use "dta/cbo_ltbo_debt.dta", clear
g comb = 1

append using "$project_code/out/sdsa/temp/sim_ar_1_0_0_100_years_no_poisson_full_ss_no_rminusg_constrained_model_prod.dta"
replace comb = 2 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1_30_0_100_years_no_poisson_full_ss_no_rminusg_constrained_model_prod.dta"
replace comb = 3 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1_0_5_100_years_no_poisson_full_ss_no_rminusg_constrained_model_prod.dta"
replace comb = 4 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1_0_0_15_100_years_no_poisson_full_ss_sudden_r_no_rminusg_constrained_model_prod.dta"
replace comb = 5 if comb == . //add sudden feedback here

//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[2] if  ///
!missing(e_u) & !missing(e_u[2]) & inrange(comb, 2, 5)
by year rep: assert e_s == e_s[2] if  ///
!missing(e_s) & !missing(e_s[2]) & inrange(comb, 2, 5)



replace b = 99999999999999999 if b == .
replace s = 99999999999999999 if s == .
replace rminusg = 99999999999999999 if rminusg == .

collapse (median) rminusg b s , by(year comb)

keep if year <=$xaxis_end + 1

sort comb year
replace b = . if b >2.5
replace b = . if (b[_n-1] == .) & (year >= 2)



twoway (scatter b year if comb == 1 , c(l) lwidth(medthick) color("$c1") lpattern("$l1") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 2, c(l) lwidth(medthick) color("$c2") lpattern("$l2") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 3, c(l) lwidth(medthick) color("$c3") lpattern("$l3") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 4, c(l) lwidth(medthick) color("$c4") lpattern("$l4") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 5, c(l) lwidth(medthick) color("$c5") lpattern("$l5") m(i) xlabel(0(10)$xaxis_end )), ///
ylabel(.5(.5)2.5) xtitle("Years after 2024")  ytitle("Debt-GDP ratio") ///
 xlab(, nogrid) ylab(,grid glpattern(solid) glwidth(vthin) glcolor(gs15)) ///
 legend(position(bottom) r(2) order(1  "CBO" 2 "No feedback" 3 "Deficit feedback (c=0.3)" 4 "Debt feedback (d=0.05)" 5 "Sudden feedback T=30" ))
graph export "out/${out_dir}/prod_ave_sim_b_certainty_feedback_sudden_r.png", replace
restore

/* Figure 1B sudden_r
s
*/
preserve
use "dta/cbo_ltbo_debt.dta", clear
g comb = 1

append using "$project_code/out/sdsa/temp/sim_ar_1_0_0_100_years_no_poisson_full_ss_no_rminusg_constrained_model_prod.dta"
replace comb = 2 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1_30_0_100_years_no_poisson_full_ss_no_rminusg_constrained_model_prod.dta"
replace comb = 3 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1_0_5_100_years_no_poisson_full_ss_no_rminusg_constrained_model_prod.dta"
replace comb = 4 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1_0_0_15_100_years_no_poisson_full_ss_sudden_r_no_rminusg_constrained_model_prod.dta"
replace comb = 5 if comb == . //add sudden feedback here

//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[2] if  ///
!missing(e_u) & !missing(e_u[2]) & inrange(comb, 2, 5)
by year rep: assert e_s == e_s[2] if  ///
!missing(e_s) & !missing(e_s[2]) & inrange(comb, 2, 5)

replace b = 99999999999999999 if b == .
replace s = 99999999999999999 if s == .
replace rminusg = 99999999999999999 if rminusg == .


collapse (median) rminusg b s, by(year comb)

keep if year <=$xaxis_end + 1

sort comb year
replace b = . if b >2.5
replace b = . if (b[_n-1] == .) & (year >= 2)
// drop if b == .
replace s = s*100 
replace s = . if abs(s) >4.25
replace s = . if (s[_n-1] == .) & (year >= 2)
drop if s == .

twoway (scatter s year if comb == 1 , c(l) lwidth(medthick) color("$c1") lpattern("$l1") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter s year if comb == 2, c(l) lwidth(medthick) color("$c2") lpattern("$l2") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter s year if comb == 3, c(l) lwidth(medthick) color("$c3") lpattern("$l3") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter s year if comb == 4, c(l) lwidth(medthick) color("$c4") lpattern("$l4") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter s year if comb == 5, c(l) lwidth(medthick) color("$c5") lpattern("$l5") m(i) xlabel(0(10)$xaxis_end )), ///
ylabel(-3(1)3) xtitle("Years after 2024")  ytitle("Primary surplus as a share of GDP (%)") ///
 xlab(, nogrid) ylab(,grid glpattern(solid) glwidth(vthin) glcolor(gs15)) ///
 legend(position(bottom) r(2) order(1  "CBO" 2 "No feedback" 3 "Deficit feedback (c=0.3)" 4 "Debt feedback (d=0.05)" 5 "Sudden feedback T=30" ))
graph export "out/${out_dir}/prod_ave_sim_s_certainty_feedback_sudden_r.png", replace
restore

/* Figure 1C sudden_r
rho
*/
preserve
use "dta/cbo_ltbo_debt.dta", clear
g comb = 1

append using "$project_code/out/sdsa/temp/sim_ar_1_0_0_100_years_no_poisson_full_ss_no_rminusg_constrained_model_prod.dta"
replace comb = 2 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1_30_0_100_years_no_poisson_full_ss_no_rminusg_constrained_model_prod.dta"
replace comb = 3 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1_0_5_100_years_no_poisson_full_ss_no_rminusg_constrained_model_prod.dta"
replace comb = 4 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1_0_0_15_100_years_no_poisson_full_ss_sudden_r_no_rminusg_constrained_model_prod.dta"
replace comb = 5 if comb == . //add sudden feedback here

//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[2] if  ///
!missing(e_u) & !missing(e_u[2]) & inrange(comb, 2, 5)
by year rep: assert e_s == e_s[2] if  ///
!missing(e_s) & !missing(e_s[2]) & inrange(comb, 2, 5)

replace b = 99999999999999999 if b == .
replace s = 99999999999999999 if s == .
replace rminusg = 99999999999999999 if rminusg == .

collapse (median) rminusg b, by(year comb)

keep if year <=$xaxis_end + 1

sort comb year
// replace rminusg = . if rminusg>1
// replace rminusg = . if (rminusg[_n-1] == .) & (year >= 2)
replace b = . if b >2.5
replace b = . if (b[_n-1] == .) & (year >= 2)
// drop if b == .

replace rminusg = rminus*100
replace rminusg = . if abs(rminusg) >3
replace rminusg = . if (rminusg[_n-1] == .) & (year >= 2)
drop if rminusg == .

g comb_str = ""
replace comb_str =  "CBO" if comb == 1
replace comb_str =  "No feedback" if comb == 2
replace comb_str =  "Deficit feedback (c=0.3)" if comb == 3
replace comb_str =  "Debt feedback (d=0.05)" if comb == 4
replace comb_str =  "Sudden feedback" if comb == 5



twoway (scatter rminusg year if comb == 1 , c(l) lwidth(medthick) color("$c1") lpattern("$l1") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter rminusg year if comb == 2, c(l) lwidth(medthick) color("$c2") lpattern("$l2") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter rminusg year if comb == 3, c(l) lwidth(medthick) color("$c3") lpattern("$l3") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter rminusg year if comb == 4, c(l) lwidth(medthick) color("$c4") lpattern("$l4") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter rminusg year if comb == 5, c(l) lwidth(medthick) color("$c5") lpattern("$l5") m(i) xlabel(0(10)$xaxis_end )), ///
 xtitle("Years after 2024")  ytitle("Excess interest rate (r-g)/(1+g) (%)") ///
 ylabel(-3(1)3) xlab(, nogrid) ylab(,grid glpattern(solid) glwidth(vthin) glcolor(gs15)) ///
 legend(position(bottom) r(2) order(1  "CBO" 2 "No feedback" 3 "Deficit feedback (c=0.3)" 4 "Debt feedback (d=0.05)" 5 "Sudden feedback T=30" ))
graph export "out/${out_dir}/prod_ave_sim_rminusg_certainty_feedback_sudden_r.png", replace
graph export "out/${out_dir}/prod_ave_sim_rminusg_certainty_feedback_sudden_r.pdf", replace


keep rminusg year comb_str
save  "out/fig1_data.dta", replace
export delimited using "out/fig1_data.csv", replace	

restore


/* Figure 3  sudden_r
Same as Figure 1, except different series: No risk or feedback, No feedback, Deficit feedback (c=0.3), Debt feedback (d=0.05), Sudden feedback. (Plot the averages here.)
*/

/* Figure 3A sudden_r
debt
*/
preserve
use "$project_code/out/sdsa/temp/sim_ar_1_0_0_100_years_no_poisson_full_ss_no_rminusg_constrained_model_prod.dta", clear
g comb = 1 

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_0_100_years_full_ss_constrained_model_prod.dta"
replace comb = 2 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_30_0_100_years_full_ss_constrained_model_prod.dta"
replace comb = 3 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_5_100_years_full_ss_constrained_model_prod.dta"
replace comb = 4 if comb == . 

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod.dta"
replace comb = 5 if comb == . //add sudden feedback here

//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[2] if  ///
!missing(e_u) & !missing(e_u[2]) & inrange(comb, 2, 5)
by year rep: assert e_s == e_s[2] if  ///
!missing(e_s) & !missing(e_s[2]) & inrange(comb, 2, 5)


replace b = 99999999999999999 if b == .
replace s = 99999999999999999 if s == .
replace rminusg = 99999999999999999 if rminusg == .


collapse (median) rminusg b , by(year comb)

keep if year <=$xaxis_end + 1

sort comb year




replace b = . if b >2.5
replace b = . if (b[_n-1] == .) & (year >= 2)

twoway (scatter b year if comb == 1 , c(l) lwidth(medthick) color("$c1") lpattern("$l1") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 2, c(l) lwidth(medthick) color("$c2") lpattern("$l2") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 3, c(l) lwidth(medthick) color("$c3") lpattern("$l3") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 4, c(l) lwidth(medthick) color("$c4") lpattern("$l4") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 5, c(l) lwidth(medthick) color("$c5") lpattern("$l5") m(i) xlabel(0(10)$xaxis_end )), ///
ylabel(.5(.5)2.5) xtitle("Years after 2024")   ytitle("Debt-GDP ratio") ///
 xlab(, nogrid) ylab(,grid glpattern(solid) glwidth(vthin) glcolor(gs15)) ///
 legend(position(bottom) r(2) order(1  "No risk or feedback" 2 "No feedback" 3 "Deficit feedback (c=0.3)" 4 "Debt feedback (d=0.05)" 5 "Sudden feedback T=30" ))
graph export "out/${out_dir}/prod_ave_sim_b_risk_feedback_sudden_r.png", replace
restore

/* Figure 3B sudden_r
s
*/
preserve
use "$project_code/out/sdsa/temp/sim_ar_1_0_0_100_years_no_poisson_full_ss_no_rminusg_constrained_model_prod.dta", clear
g comb = 1 

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_0_100_years_full_ss_constrained_model_prod.dta"
replace comb = 2 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_30_0_100_years_full_ss_constrained_model_prod.dta"
replace comb = 3 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_5_100_years_full_ss_constrained_model_prod.dta"
replace comb = 4 if comb == . 

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod.dta"
replace comb = 5 if comb == . //add sudden feedback here

//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[2] if  ///
!missing(e_u) & !missing(e_u[2]) & inrange(comb, 2, 5)
by year rep: assert e_s == e_s[2] if  ///
!missing(e_s) & !missing(e_s[2]) & inrange(comb, 2, 5)

replace b = 99999999999999999 if b == .
replace s = 99999999999999999 if s == .
replace rminusg = 99999999999999999 if rminusg == .



collapse (median) rminusg b s, by(year comb)

keep if year <=$xaxis_end + 1

sort comb year
replace b = . if b >2.5
replace b = . if (b[_n-1] == .) & (year >= 2)
// drop if b ==.
replace s = s*100 
replace s = . if abs(s) >4.25
replace s = . if (s[_n-1] == .) & (year >= 2)
drop if s == .

twoway (scatter s year if comb == 1 , c(l) lwidth(medthick) color("$c1") lpattern("$l1") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter s year if comb == 2, c(l) lwidth(medthick) color("$c2") lpattern("$l2") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter s year if comb == 3, c(l) lwidth(medthick) color("$c3") lpattern("$l3") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter s year if comb == 4, c(l) lwidth(medthick) color("$c4") lpattern("$l4") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter s year if comb == 5, c(l) lwidth(medthick) color("$c5") lpattern("$l5") m(i) xlabel(0(10)$xaxis_end )), ///
 xtitle("Years after 2024")  ytitle("Primary surplus as a share of GDP (%)") ///
ylabel(-3(1)3)  xlab(, nogrid) ylab(,grid glpattern(solid) glwidth(vthin) glcolor(gs15)) ///
 legend(position(bottom) r(2) order(1  "No risk or feedback" 2 "No feedback" 3 "Deficit feedback (c=0.3)" 4 "Debt feedback (d=0.05)" 5 "Sudden feedback T=30" ))
graph export "out/${out_dir}/prod_ave_sim_s_risk_feedback_sudden_r.png", replace
restore



/* Figure 3C sudden_r
rho
*/
preserve
use "$project_code/out/sdsa/temp/sim_ar_1_0_0_100_years_no_poisson_full_ss_no_rminusg_constrained_model_prod.dta",clear
g comb = 1 

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_0_100_years_full_ss_constrained_model_prod.dta"
replace comb = 2 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_30_0_100_years_full_ss_constrained_model_prod.dta"
replace comb = 3 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_5_100_years_full_ss_constrained_model_prod.dta"
replace comb = 4 if comb == . 

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod.dta"
replace comb = 5 if comb == . //add sudden feedback here


//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[2] if  ///
!missing(e_u) & !missing(e_u[2]) & inrange(comb, 2, 5)
by year rep: assert e_s == e_s[2] if  ///
!missing(e_s) & !missing(e_s[2]) & inrange(comb, 2, 5)

replace b = 99999999999999999 if b == .
replace s = 99999999999999999 if s == .
replace rminusg = 99999999999999999 if rminusg == .

collapse (median) rminusg b s, by(year comb)

keep if year <=$xaxis_end + 1

sort comb year
replace b = . if b >2.5
replace b = . if (b[_n-1] == .) & (year >= 2)
// drop if b ==.

replace rminusg = rminus*100
replace rminusg = . if abs(rminusg) >3
replace rminusg = . if (rminusg[_n-1] == .) & (year >= 2)
drop if rminusg == .

twoway (scatter rminusg year if comb == 1 , c(l) lwidth(medthick) color("$c1") lpattern("$l1") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter rminusg year if comb == 2, c(l) lwidth(medthick) color("$c2") lpattern("$l2") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter rminusg year if comb == 3, c(l) lwidth(medthick) color("$c3") lpattern("$l3") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter rminusg year if comb == 4, c(l) lwidth(medthick) color("$c4") lpattern("$l4") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter rminusg year if comb == 5, c(l) lwidth(medthick) color("$c5") lpattern("$l5") m(i) xlabel(0(10)$xaxis_end )), ///
 xtitle("Years after 2024")  ytitle("Excess interest rate (r-g)/(1+g) (%)") ///
 ylabel(-3(1)3) xlab(, nogrid) ylab(,grid glpattern(solid) glwidth(vthin) glcolor(gs15)) ///
 legend(position(bottom) r(2) order(1  "No risk or feedback" 2 "No feedback" 3 "Deficit feedback (c=0.3)" 4 "Debt feedback (d=0.05)" 5 "Sudden feedback T=30" ))
graph export "out/${out_dir}/prod_ave_sim_rminusg_risk_feedback_sudden_r.png", replace
restore


/* Figure 5 GENERAL
All graphs use the series: 
Baseline XX feedback (where XX is "deficit", "debt", or "sudden"), 
Initial surplus s_0 = -0.035, 
Initial surplus s_0 = -0.015, 
Excess interest sensitivity phi = 0.01, 
Excess interest sensitivity phi = 0, 
Feedback permanence theta = 0.
*/

/* Figure 5A 
Deficit Feedback
*/

preserve
use "$project_code/out/sdsa/temp/sim_ar_1000_30_0_100_years_full_ss_constrained_model_prod", clear
g comb = 1

append using "$project_code/out/sdsa/temp/sim_ar_1000_30_0_100_years_full_ss_constrained_model_prod_low_s.dta"
replace comb = 2 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_30_0_100_years_full_ss_constrained_model_prod_high_s.dta"
replace comb = 3 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_30_0_100_years_full_ss_constrained_model_prod_low_beta2.dta"
replace comb = 4 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_30_0_100_years_full_ss_constrained_model_prod_zero_beta2.dta"
replace comb = 5 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_30_0_100_years_full_ss_constrained_model_prod_low_theta.dta"
replace comb = 6 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_30_0_100_years_full_ss_constrained_model_prod_zero_lambda.dta"
replace comb = 7 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_30_0_100_years_full_ss_constrained_model_prod_high_lambda.dta"
replace comb = 8 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_30_0_100_years_full_ss_constrained_model_prod_high_var.dta"
replace comb = 9 if comb == .

//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, 8)
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & (inrange(comb, 1, 6) | inlist(comb, 9))

replace b = 99999999999999999 if b == .
replace s = 99999999999999999 if s == .
replace rminusg = 99999999999999999 if rminusg == .

collapse (median) rminusg b s, by(year comb)

keep if year <=$xaxis_end + 1

sort comb year
replace b = . if b >2.5
replace b = . if (b[_n-1] == .) & (year >= 2)
drop if b == .

twoway (scatter b year if comb == 1, c(l) lwidth(medthick) color("$c1") lpattern("$l1") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 2, c(l) lwidth(medthick) color("$c2") lpattern("$l2") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 3, c(l) lwidth(medthick) color("$c3") lpattern("$l3") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 4, c(l) lwidth(medthick) color("$c4") lpattern("$l4") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 5, c(l) lwidth(medthick) color("$c5") lpattern("$l5") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 6,  color("$c6") lpattern("$l6")  msize(small) msymbol(plus)  xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 7, msize(vsmall)msymbol("$l7")  xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 8, msize(vsmall)  msymbol("$l8") xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 9, msize(vsmall) msymbol("$l9") xlabel(0(10)$xaxis_end )), ///
ylabel(.5(.5)2.5) xlab(, nogrid) ylab(,grid glpattern(solid) glwidth(vthin) glcolor(gs15)) ///
 xtitle("Years after 2024")  ytitle("Debt-GDP ratio") ///
 legend(position(bottom) c(2) order(1 "Baseline deficit feedback" 2 "Initial surplus s_0 = -0.04" 3 "Initial surplus s_0 = -0.01" 4 "Excess interest sensitivity phi = 0.008" 5 "Excess interest sensitivity phi = 0" 6 "Feedback permanence theta = 0.9" 7 "Poisson shock freq. lambda = 0" 8 "Poisson shock freq. lambda = 4" 9 "Excess int. shock std. dev. s_u = 0.066"))
graph export "out/${out_dir}/prod_ave_sim_b_sensitivity_feedback_deficit.png", replace
restore



/* Figure 5B
Debt Feedback
*/

preserve
use "$project_code/out/sdsa/temp/sim_ar_1000_0_5_100_years_full_ss_constrained_model_prod", clear
g comb = 1

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_5_100_years_full_ss_constrained_model_prod_low_s.dta"
replace comb = 2 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_5_100_years_full_ss_constrained_model_prod_high_s.dta"
replace comb = 3 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_5_100_years_full_ss_constrained_model_prod_low_beta2.dta"
replace comb = 4 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_5_100_years_full_ss_constrained_model_prod_zero_beta2.dta"
replace comb = 5 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_5_100_years_full_ss_constrained_model_prod_low_theta.dta"
replace comb = 6 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_5_100_years_full_ss_constrained_model_prod_zero_lambda.dta"
replace comb = 7 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_5_100_years_full_ss_constrained_model_prod_high_lambda.dta"
replace comb = 8 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_5_100_years_full_ss_constrained_model_prod_high_var.dta"
replace comb = 9 if comb == .

//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, 8)
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & (inrange(comb, 1, 6) | inlist(comb, 9))

replace b = 99999999999999999 if b == .
replace s = 99999999999999999 if s == .
replace rminusg = 99999999999999999 if rminusg == .

collapse (median) rminusg b s, by(year comb)

keep if year <=$xaxis_end + 1
sort comb year
replace b = . if b >2.5
replace b = . if (b[_n-1] == .) & (year >= 2)
drop if b == .

twoway (scatter b year if comb == 1, c(l) lwidth(medthick) color("$c1") lpattern("$l1") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 2, c(l) lwidth(medthick) color("$c2") lpattern("$l2") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 3, c(l) lwidth(medthick) color("$c3") lpattern("$l3") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 4, c(l) lwidth(medthick) color("$c4") lpattern("$l4") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 5, c(l) lwidth(medthick) color("$c5") lpattern("$l5") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 6,  color("$c6") lpattern("$l6")  msize(small) msymbol(plus)  xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 7, msize(vsmall)msymbol("$l7")  xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 8, msize(vsmall)  msymbol("$l8") xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 9, msize(vsmall) msymbol("$l9") xlabel(0(10)$xaxis_end )), ///
    xtitle("Years after 2024")  ytitle("Debt-GDP ratio") ///
ylabel(.5(.5)2.5) xlab(, nogrid) ylab(,grid glpattern(solid) glwidth(vthin) glcolor(gs15)) ///
 legend(position(bottom) c(2) order(1 "Baseline debt feedback" 2 "Initial surplus s_0 = -0.04" 3 "Initial surplus s_0 = -0.01" 4 "Excess interest sensitivity phi = 0.008" 5 "Excess interest sensitivity phi = 0" 6 "Feedback permanence theta = 0.9" 7 "Poisson shock freq. lambda = 0" 8 "Poisson shock freq. lambda = 4" 9 "Excess int. shock std. dev. s_u = 0.066"))
graph export "out/${out_dir}/prod_ave_sim_b_sensitivity_feedback_debt.png", replace

restore




/* Figure 5C
Sudden Feedback
*/
preserve
use "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod", clear
g comb = 1

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod_low_s.dta"
replace comb = 2 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod_high_s.dta"
replace comb = 3 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod_low_beta2.dta"
replace comb = 4 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod_zero_beta2.dta"
replace comb = 5 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod_low_theta.dta"
replace comb = 6 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod_zero_lambda.dta"
replace comb = 7 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod_high_lambda.dta"
replace comb = 8 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod_high_var.dta"
replace comb = 9 if comb == .
//start
// sort year rep comb
// keep year rep comb a_s s lambda beta_2 theta b e_u e_s rminusg
//end
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, 8)
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & (inrange(comb, 1, 6) | inlist(comb, 9))

replace b = 99999999999999999 if b == .
replace s = 99999999999999999 if s == .
replace rminusg = 99999999999999999 if rminusg == .

collapse (median) rminusg b s, by(year comb)

keep if year <=$xaxis_end + 1
sort comb year
replace b = . if b >2.5
replace b = . if (b[_n-1] == .) & (year >= 2)
drop if b == .

twoway (scatter b year if comb == 1, c(l) lwidth(medthick) color("$c1") lpattern("$l1") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 2, c(l) lwidth(medthick) color("$c2") lpattern("$l2") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 3, c(l) lwidth(medthick) color("$c3") lpattern("$l3") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 4, c(l) lwidth(medthick) color("$c4") lpattern("$l4") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 5, c(l) lwidth(medthick) color("$c5") lpattern("$l5") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 6,  color("$c6") lpattern("$l6")  msize(small) msymbol(plus)  xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 7, msize(vsmall)msymbol("$l7")  xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 8, msize(vsmall)  msymbol("$l8") xlabel(0(10)$xaxis_end )) ///
(scatter b year if comb == 9, msize(vsmall) msymbol("$l9") xlabel(0(10)$xaxis_end )), ///
   xtitle("Years after 2024")  ytitle("Debt-GDP ratio") ///
ylabel(.5(.5)2.5) xlab(, nogrid) ylab(,grid glpattern(solid) glwidth(vthin) glcolor(gs15)) ///
 legend(position(bottom) c(2) order(1 "Baseline sudden feedback" 2 "Initial surplus s_0 = -0.04" 3 "Initial surplus s_0 = -0.01" 4 "Excess interest sensitivity phi = 0.008" 5 "Excess interest sensitivity phi = 0" 6 "Feedback permanence theta = 0.9" 7 "Poisson shock freq. lambda = 0" 8 "Poisson shock freq. lambda = 4" 9 "Excess int. shock std. dev. s_u = 0.066"))
graph export "out/${out_dir}/prod_ave_sim_b_sensitivity_feedback_sudden_r.png", replace
restore



/* Figure 5C DIAG
Sudden Feedback
*/
preserve
use "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod", clear
g comb = 1

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod_low_s.dta"
replace comb = 2 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod_high_s.dta"
replace comb = 3 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod_low_beta2.dta"
replace comb = 4 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod_zero_beta2.dta"
replace comb = 5 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod_low_theta.dta"
replace comb = 6 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod_zero_lambda.dta"
replace comb = 7 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod_high_lambda.dta"
replace comb = 8 if comb == .

append using "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod_high_var.dta"
replace comb = 9 if comb == .
//start
// sort year rep comb
// keep year rep comb a_s s lambda beta_2 theta b e_u e_s rminusg
// browse
//end
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, 8)
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & (inrange(comb, 1, 6) | inlist(comb, 9))

replace b = 99999999999999999 if b == .
replace s = 99999999999999999 if s == .
replace rminusg = 99999999999999999 if rminusg == .

collapse (median) rminusg b s, by(year comb)

keep if year <=$xaxis_end + 1
sort comb year
replace b = . if b >2.5
replace b = . if (b[_n-1] == .) & (year >= 2)
// drop if b == .
replace s = s*100 
replace s = . if abs(s) >4.25
replace s = . if (s[_n-1] == .) & (year >= 2)
drop if s == .


twoway (scatter s year if comb == 1, c(l) lwidth(medthick) color("$c1") lpattern("$l1") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter s year if comb == 2, c(l) lwidth(medthick) color("$c2") lpattern("$l2") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter s year if comb == 3, c(l) lwidth(medthick) color("$c3") lpattern("$l3") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter s year if comb == 4, c(l) lwidth(medthick) color("$c4") lpattern("$l4") m(i) xlabel(0(10)$xaxis_end )) ///
(scatter s year if comb == 5, c(l) lwidth(medthick) color("$c5") lpattern("$l5") m(i) xlabel(0(10)$xaxis_end )), ///
ylabel(-3(1)3) xtitle("Years after 2024")  ytitle("Primary surplus as a share of GDP (%)") ///
 xlab(, nogrid) ylab(,grid glpattern(solid) glwidth(vthin) glcolor(gs15)) ///
 legend(position(bottom) c(2) order(1 "Baseline sudden feedback" 2 "Initial surplus s_0 = -0.04" 3 "Initial surplus s_0 = -0.01" 4 "Excess interest sensitivity phi = 0.008" 5 "Excess interest sensitivity phi = 0" ))
graph export "out/${out_dir}/prod_ave_sim_s_sensitivity_feedback_sudden_r.png", replace
restore





/* Figure 2 GENERAL
Feedback Sensitivity of Fiscal Paths under Certainty
y-range: [1,2.5]. Ytitle: Debt-GDP ratio in 100 years
Only one series per graph (so no need for legends)
c {0,.05,.1,.15,...,1}
d {0,.05,.1,.15,...,1}

*/

/* Figure 2: combined c and d: certainty and risk 
 theta=0
 CREATE DATA
*/

preserve
global comb_range = "0 0.01 0.02 0.03 0.04 0.05(0.05)1 "
global x_axis_range = "0(0.05)1 "
use "$project_code/out/sdsa/temp/sim_ar_1_0_0_100_years_no_poisson_full_ss_no_rminusg_constrained_model_prod.dta", clear
g comb = 1
// g c = 0

global counter = 1
foreach c of numlist $comb_range {
	local c_name=round(`c' *100,1 ) 
	global counter = $counter +1
	append using "$project_code/out/sdsa/temp/sim_ar_1_`c_name'_0_100_years_no_poisson_full_ss_no_rminusg_constrained_model_prod.dta"
	replace comb = $counter if comb == .
// 	replace c = `c' if c == .
}

//create local for max value of comb extracted from tab comb
sum comb, meanonly
local comb_max = r(max)
di "`comb_max'"
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, `comb_max')
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & inrange(comb, 1, `comb_max')

replace b = 99999999999999999 if b == .
replace s = 99999999999999999 if s == .
replace rminusg = 99999999999999999 if rminusg == .

collapse (median) rminusg b c, by(year comb)

keep if year == 101
drop if b > 2.5
g type = "c"
rename c value
keep type rminusg b value

save "dta/threshold_certainty_min_c_cleaned.dta", replace


use "$project_code/out/sdsa/temp/sim_ar_1_0_0_100_years_no_poisson_full_ss_no_rminusg_constrained_model_prod.dta", clear
g comb = 1
// g d = 0

global counter = 1
foreach d of numlist $comb_range {
		local d_name=round(`d' *100,1 ) 
	global counter = $counter +1
	append using "$project_code/out/sdsa/temp/sim_ar_1_0_`d_name'_100_years_no_poisson_full_ss_no_rminusg_constrained_model_prod.dta"
	replace comb = $counter if comb == .
// 	replace d = `d' if d == .
}

//create local for max value of comb extracted from tab comb
sum comb, meanonly
local comb_max = r(max)
di "`comb_max'"
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, `comb_max')
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & inrange(comb, 1, `comb_max')

replace b = 99999999999999999 if b == .
replace s = 99999999999999999 if s == .
replace rminusg = 99999999999999999 if rminusg == .

collapse (median) rminusg b d, by(year comb)

keep if year == 101
drop if b > 2.5

g type = "d"
rename d value
keep type rminusg b value
save "dta/threshold_certainty_min_d_cleaned.dta", replace

append using "dta/threshold_certainty_min_c_cleaned.dta"

save "dta/threshold_certainty_min_c_d_cleaned.dta", replace
restore

preserve
global comb_range = "0 0.01 0.02 0.03 0.04 0.05(0.05)1 "
global x_axis_range = "0(0.05)1 "

use "$project_code/out/sdsa/temp/sim_ar_1000_0_0_100_years_full_ss_constrained_model_prod.dta", clear
g comb = 1
// g c = 0

global counter = 1
foreach c of numlist $comb_range {
	local c_name=round(`c' *100,1 ) 
	global counter = $counter +1
	append using "$project_code/out/sdsa/temp/sim_ar_1000_`c_name'_0_100_years_full_ss_constrained_model_prod.dta"
	replace comb = $counter if comb == .
// 	replace c = `c' if c == .
}

//create local for max value of comb extracted from tab comb
sum comb, meanonly
local comb_max = r(max)
di "`comb_max'"
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, `comb_max')
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & inrange(comb, 1, `comb_max')

replace b = 99999999999999999 if b == .
replace s = 99999999999999999 if s == .
replace rminusg = 99999999999999999 if rminusg == .

collapse (median) rminusg b c, by(year comb)

keep if year == 101
drop if b > 2.5

g type = "c"
rename c value
keep type rminusg b value

save "dta/threshold_risk_min_c_cleaned.dta", replace

use "$project_code/out/sdsa/temp/sim_ar_1000_0_0_100_years_full_ss_constrained_model_prod.dta", clear
g comb = 1
// g d = 0

global counter = 1
foreach d of numlist $comb_range {
		local d_name=round(`d' *100,1 ) 
	global counter = $counter +1
	append using "$project_code/out/sdsa/temp/sim_ar_1000_0_`d_name'_100_years_full_ss_constrained_model_prod.dta"
	replace comb = $counter if comb == .
// 	replace d = `d' if d == .
}

//create local for max value of comb extracted from tab comb
sum comb, meanonly
local comb_max = r(max)
di "`comb_max'"
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, `comb_max')
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & inrange(comb, 1, `comb_max')

replace b = 99999999999999999 if b == .
replace s = 99999999999999999 if s == .
replace rminusg = 99999999999999999 if rminusg == .

collapse (median) rminusg b d, by(year comb)

keep if year == 101
drop if b > 2.5

g type = "d"
rename d value
keep type rminusg b value
save "dta/threshold_risk_min_d_cleaned.dta", replace

append using "dta/threshold_risk_min_c_cleaned.dta"
save "dta/threshold_risk_min_c_d_cleaned.dta", replace
restore


preserve
use "dta/threshold_certainty_min_c_d_cleaned.dta", replace
g comb = 1
append using "dta/threshold_risk_min_c_d_cleaned.dta"
replace comb =2 if comb == .

twoway (scatter b value if (type == "c") & (comb == 1), c(l) lwidth(medthick) color("$c1") lpattern("$l1") m(i) xlabel(${comb_range}, labsize(small))) ///
(scatter b value if (type == "d") & (comb == 1), c(l) lwidth(medthick) color("$c2") lpattern("$l2") m(i) xlabel(${comb_range}, labsize(small))) ///
(scatter b value if (type == "c") & (comb == 2), c(l) lwidth(medthick) color("$c3") lpattern("$l3") m(i) xlabel(${comb_range}, labsize(small))) ///
(scatter b value if (type == "d") & (comb == 2), c(l) lwidth(medthick) color("$c4") lpattern("$l4") m(i) xlabel(${comb_range}, labsize(small))), ///
 xtitle("Feedback into primary surplus")  ytitle("Debt-GDP ratio in 100 years") ///
ylabel(.5(.5)2.5) xlab($x_axis_range, nogrid) ylab(,grid glpattern(solid) glwidth(vthin) glcolor(gs15)) ///
legend(position(bottom) row(2) order(1 "Deficit feedback c under certainty"  2 "Debt feedback d under certainty" 3 "Deficit feedback c under risk" 4 "Debt feedback d under risk"))
graph export "out/${out_dir}/prod_terminal_b_certainty_risk_by_feedback_deficit_debt_combined.png", replace

restore



/* Figure 2: combined c and d: certainty and risk 
 theta=0
 CREATE DATA
*/

preserve
global comb_range = "0 0.01 0.02 0.03 0.04 0.05 .1 "
global x_axis_range = "0(0.05)1 "
use "$project_code/out/sdsa/temp/sim_ar_1_0_0_100_years_no_poisson_full_ss_no_rminusg_constrained_model_prod.dta", clear
g comb = 1
// g c = 0

global counter = 1
foreach c of numlist $comb_range {
	local c_name=round(`c' *100,1 ) 
	global counter = $counter +1
	append using "$project_code/out/sdsa/temp/sim_ar_1_`c_name'_0_100_years_no_poisson_full_ss_no_rminusg_constrained_model_prod.dta"
	replace comb = $counter if comb == .
// 	replace c = `c' if c == .
}

//create local for max value of comb extracted from tab comb
sum comb, meanonly
local comb_max = r(max)
di "`comb_max'"
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, `comb_max')
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & inrange(comb, 1, `comb_max')

replace b = 99999999999999999 if b == .
replace s = 99999999999999999 if s == .
replace rminusg = 99999999999999999 if rminusg == .

collapse (median) rminusg b c, by(year comb)

keep if year == 101
drop if b > 2.5
g type = "c"
rename c value
keep type rminusg b value

save "dta/threshold_certainty_min_c_cleaned_no_poisson.dta", replace


use "$project_code/out/sdsa/temp/sim_ar_1_0_0_100_years_no_poisson_full_ss_no_rminusg_constrained_model_prod.dta", clear
g comb = 1
// g d = 0

global counter = 1
foreach d of numlist $comb_range {
		local d_name=round(`d' *100,1 ) 
	global counter = $counter +1
	append using "$project_code/out/sdsa/temp/sim_ar_1_0_`d_name'_100_years_no_poisson_full_ss_no_rminusg_constrained_model_prod.dta"
	replace comb = $counter if comb == .
// 	replace d = `d' if d == .
}

//create local for max value of comb extracted from tab comb
sum comb, meanonly
local comb_max = r(max)
di "`comb_max'"
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, `comb_max')
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & inrange(comb, 1, `comb_max')

replace b = 99999999999999999 if b == .
replace s = 99999999999999999 if s == .
replace rminusg = 99999999999999999 if rminusg == .

collapse (median) rminusg b d, by(year comb)

keep if year == 101
drop if b > 2.5

g type = "d"
rename d value
keep type rminusg b value
save "dta/threshold_certainty_min_d_cleaned_no_poisson.dta", replace

append using "dta/threshold_certainty_min_c_cleaned_no_poisson.dta"

save "dta/threshold_certainty_min_c_d_cleaned_no_poisson.dta", replace
restore

preserve
global comb_range = "0 0.01 0.02 0.03 0.04 0.05 .1 "
global x_axis_range = "0(0.05)1 "

use "$project_code/out/sdsa/temp/sim_ar_1000_0_0_100_years_no_poisson_full_ss_constrained_model_prod.dta", clear
g comb = 1
// g c = 0

global counter = 1
foreach c of numlist $comb_range {
	local c_name=round(`c' *100,1 ) 
	global counter = $counter +1
	append using "$project_code/out/sdsa/temp/sim_ar_1000_`c_name'_0_100_years_no_poisson_full_ss_constrained_model_prod.dta"
	replace comb = $counter if comb == .
// 	replace c = `c' if c == .
}

//create local for max value of comb extracted from tab comb
sum comb, meanonly
local comb_max = r(max)
di "`comb_max'"
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, `comb_max')
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & inrange(comb, 1, `comb_max')

replace b = 99999999999999999 if b == .
replace s = 99999999999999999 if s == .
replace rminusg = 99999999999999999 if rminusg == .

collapse (median) rminusg b c, by(year comb)

keep if year == 101
drop if b > 2.5

g type = "c"
rename c value
keep type rminusg b value

save "dta/threshold_risk_min_c_cleaned_no_poisson.dta", replace

use "$project_code/out/sdsa/temp/sim_ar_1000_0_0_100_years_no_poisson_full_ss_constrained_model_prod.dta", clear
g comb = 1
// g d = 0

global counter = 1
foreach d of numlist $comb_range {
		local d_name=round(`d' *100,1 ) 
	global counter = $counter +1
	append using "$project_code/out/sdsa/temp/sim_ar_1000_0_`d_name'_100_years_no_poisson_full_ss_constrained_model_prod.dta"
	replace comb = $counter if comb == .
// 	replace d = `d' if d == .
}

//create local for max value of comb extracted from tab comb
sum comb, meanonly
local comb_max = r(max)
di "`comb_max'"
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, `comb_max')
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & inrange(comb, 1, `comb_max')


replace b = 99999999999999999 if b == .
replace s = 99999999999999999 if s == .
replace rminusg = 99999999999999999 if rminusg == .

collapse (median) rminusg b d, by(year comb)

keep if year == 101
drop if b > 2.5

g type = "d"
rename d value
keep type rminusg b value
save "dta/threshold_risk_min_d_cleaned_no_poisson.dta", replace

append using "dta/threshold_risk_min_c_cleaned_no_poisson.dta"
save "dta/threshold_risk_min_c_d_cleaned_no_poisson.dta", replace
restore


/****** SUDDEN FEEDBACK ******/

/* Figure 2C sudden feedback by years
Sudden Feedback: certainty 
*/


preserve
use "$project_code/out/sdsa/temp/sim_ar_1_0_0_15_100_years_no_poisson_full_ss_sudden_r_no_rminusg_constrained_model_prod.dta", clear
g comb = 1
g si = 30

global counter = 1


foreach si of numlist  10(1)29 31(1)50 {
	global counter = $counter +1
	append using "$project_code/out/sdsa/temp/sim_ar_1_0_0_15_100_years_no_poisson_full_ss_sudden_r_no_rminusg_constrained_model_prod_`si'.dta"
	replace comb = $counter if comb == .
	replace si = `si' if si == .
}

//create local for max value of comb extracted from tab comb
sum comb, meanonly
local comb_max = r(max)
di "`comb_max'"
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, `comb_max')
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & inrange(comb, 1, `comb_max')

g series = "Certainty"
save "dta/sudden_feedback_certainty_by_year.dta", replace

use "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod.dta", clear
g comb = 1
g si = 30

global counter = 1


foreach si of numlist 10(1)29 31(1)50 {
	global counter = $counter +1
	append using "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod_`si'.dta"
	replace comb = $counter if comb == .
	replace si = `si' if si == .
}

//create local for max value of comb extracted from tab comb
sum comb, meanonly
local comb_max = r(max)
di "`comb_max'"
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, `comb_max')
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & inrange(comb, 1, `comb_max')

g series = "Risk"
append using "dta/sudden_feedback_certainty_by_year.dta"

replace b = 99999999999999999 if b == .
replace s = 99999999999999999 if s == .
replace rminusg = 99999999999999999 if rminusg == .

collapse (median) rminusg b si, by(year comb series)
sort si

keep if year == 101
drop if b > 2.5


twoway (scatter b si if series == "Certainty", c(l) lwidth(medthick) color("$c1") lpattern("$l1") m(i)) ///
(scatter b si if series == "Risk", c(l) lwidth(medthick) color("$c2") lpattern("$l2") m(i)), ///
 ylabel(.5(.5)2.5) xtitle("Minimum number of years T between sudden feedbacks into primary surplus")  ytitle("Debt-GDP ratio in 100 years") ///
 xlab(, nogrid) ylab(,grid glpattern(solid) glwidth(vthin) glcolor(gs15))  ///
 legend(order( ///
		1 "Certainty" ///
		2 "Risk") position(bottom) rows(1) size(small))
 graph export "out/${out_dir}/prod_terminal_b_sudden_r_by_year.png", replace
restore





*** CDFS
// deficit feedback
preserve
global comb_range = ".05 .1 .2 .3 .5"
use "$project_code/out/sdsa/temp/sim_ar_1000_0_0_100_years_full_ss_constrained_model_prod.dta", clear
g comb = 1
// g c = 0

global counter = 1
foreach c of numlist $comb_range {
	local c_name = round(`c' * 100, 1)
	global counter = $counter + 1
	append using "$project_code/out/sdsa/temp/sim_ar_1000_`c_name'_0_100_years_full_ss_constrained_model_prod.dta"
	replace comb = $counter if comb == .
// 	replace c = `c' if c == .
}

//create local for max value of comb extracted from tab comb
sum comb, meanonly
local comb_max = r(max)
di "`comb_max'"
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, `comb_max')
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & inrange(comb, 1, `comb_max')


replace b = 99999999999999999 if b == .
keep if year == 101
// keep if year == 4

cumul b, gen(b_cum) by(comb)

keep if b < 5 & b>0
sort b_cum
replace b_cum = b_cum*100

twoway (line b_cum b if comb == 1, sort lc("${c1}")) ///
	(line b_cum b if comb == 2, sort lc("${c2}")) ///
	(line b_cum b if comb == 3, sort lc("${c3}")) ///
	(line b_cum b if comb == 4, sort lc("${c4}")) ///
	(line b_cum b if comb == 5, sort lc("${c5}")) ///
	(line b_cum b if comb == 6, sort lc("${c6}")), ///
	ytitle("Share of simulations with terminal debt-GDP ratio" "less than x-axis value (%)") 	///
	xtitle("Debt-GDP ratio") ///
	xlab(, nogrid) ylab(,grid glpattern(solid) glwidth(vthin) glcolor(gs15)) ///
	legend(order( ///
		1 "c = 0" ///
		2 "c = 0.05" ///
		3 "c = 0.10" ///
		4 "c = 0.20" ///
		5 "c = 0.30" ///
		6 "c = 0.50" ) position(right) cols(1) size(small)) ///
	name(cdf_plot, replace)
graph export "out/${out_dir}/cdf_deficit.png", replace

restore

//debt feedback
//create same plot as for deficit feedback but for debt feedback

preserve
global comb_range = "0.01 0.02 0.03 0.05 0.1"
use "$project_code/out/sdsa/temp/sim_ar_1000_0_0_100_years_full_ss_constrained_model_prod.dta", clear
g comb = 1

global counter = 1
foreach d of numlist $comb_range {
	local d_name = round(`d' * 100, 1)
	global counter = $counter + 1
	append using "$project_code/out/sdsa/temp/sim_ar_1000_0_`d_name'_100_years_full_ss_constrained_model_prod.dta"
	replace comb = $counter if comb == .
}

//create local for max value of comb extracted from tab comb
sum comb, meanonly
local comb_max = r(max)
di "`comb_max'"
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, `comb_max')
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & inrange(comb, 1, `comb_max')

replace b = 99999999999999999 if b == .
keep if year == 101

cumul b, gen(b_cum) by(comb)

keep if b < 5 & b >0
sort b_cum
replace b_cum = b_cum*100




twoway (line b_cum b if comb == 1, sort lc("${c1}")) ///
	(line b_cum b if comb == 2, sort lc("${c2}")) ///
	(line b_cum b if comb == 3, sort lc("${c3}")) ///
	(line b_cum b if comb == 4, sort lc("${c4}")) ///
	(line b_cum b if comb == 5, sort lc("${c5}")) ///
	(line b_cum b if comb == 6, sort lc("${c6}")), ///
	ytitle("Share of simulations with terminal debt-GDP ratio" "less than x-axis value (%)") 	///
	xtitle("Debt-GDP ratio") ///
	xlab(, nogrid) ylab(,grid glpattern(solid) glwidth(vthin) glcolor(gs15)) ///
	legend(order( ///
		1 "d = 0" ///
		2 "d = 0.01" ///
		3 "d = 0.02" ///
		4 "d = 0.03" ///
		5 "d = 0.05" ///
		6 "d = 0.10" ) position(right) cols(1) size(small)) ///
	name(cdf_plot, replace)

graph export "out/${out_dir}/cdf_debt.png", replace

keep if comb ==1 
g si = 100
save  "dta/cdf_c0_d0.dta", replace
restore

//sudden r feedback CDF
preserve
use "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod.dta", clear
g si = 30
foreach si of numlist 10 20 40 50 {
	append using "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod_`si'.dta"
	replace si = `si' if si == .
}

//create local for max value of comb extracted from tab comb
sum si, meanonly
local comb_max = r(max)
di "`comb_max'"
//assert test e_u and e_s same for each comb
sort year rep si
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(si, 10, `comb_max')
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & inrange(si, 10, `comb_max')


replace b = 99999999999999999 if b == .
keep if year == 101

cumul b, gen(b_cum) by(si)

keep if b < 5 & b >0
sort b_cum
replace b_cum = b_cum*100
append using "dta/cdf_c0_d0.dta"

twoway (line b_cum b if si == 100, sort lc("${c1}")) ///
	(line b_cum b if si == 50, sort lc("${c2}")) ///
	(line b_cum b if si == 40, sort lc("${c3}")) ///
	(line b_cum b if si == 30, sort lc("${c4}")) ///
	(line b_cum b if si == 20, sort lc("${c5}")) ///
	(line b_cum b if si == 10, sort lc("${c6}")), ///
	ytitle("Share of simulations with terminal debt-GDP ratio" "less than x-axis value (%)") 	///
	xtitle("Debt-GDP ratio") ///
	xlab(, nogrid) ylab(,grid glpattern(solid) glwidth(vthin) glcolor(gs15)) ///
	legend(order( ///
		1 "No sudden feedback" ///
		2 "T = 50" ///
		3 "T = 40" ///
		4 "T = 30" ///
		5 "T = 20" ///
		6 "T = 10" ) position(right) cols(1) size(small)) ///
	name(cdf_plot, replace)

graph export "out/${out_dir}/cdf_sudden_r.png", replace

restore 



**** TABLES ****

/* Table 1
Table 1: How Strong Does Feedback Need to Be? 
- 11 columns 2024-2034
*/
//get min_c certainty
preserve
global comb_range = "0.01 0.02 0.03 0.04 0.05(0.05)1 "

use "$project_code/out/sdsa/temp/sim_ar_1_0_0_100_years_no_poisson_full_ss_no_rminusg_constrained_model_prod.dta", clear
g comb = 1
// g c = 0

global counter = 1
// foreach c of numlist 0.0005(0.0005).05  {
	foreach c of numlist $comb_range  {
		local c_name=round(`c' *100,1 ) 
	global counter = $counter +1
	append using "$project_code/out/sdsa/temp/sim_ar_1_`c_name'_0_100_years_no_poisson_full_ss_no_rminusg_constrained_model_prod.dta"
	replace comb = $counter if comb == .
// 	replace c = `c' if c == .
}

//create local for max value of comb extracted from tab comb
sum comb, meanonly
local comb_max = r(max)
di "`comb_max'"
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, `comb_max')
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & inrange(comb, 1, `comb_max')

keep if year == 101
sort comb
foreach b_max of numlist 1.5 2 2.5  5 {
	local b_name=round(`b_max' *10,1 ) 
	g 	b_below_`b_name' = 0
	replace b_below_`b_name' = 1 if b<`b_max'
	g 	first_b_below_`b_name' = 0
	replace first_b_below_`b_name' = 1 if (b_below_`b_name' == 1) & (b_below_`b_name'[_n-1] == 0)
// 	replace first_b_below_`b_name' = 1 if ((b_below_`b_name' == 1) & (b_below_`b_name'[_n-1] == 0) | _n == 1) 

}

keep if (first_b_below_15 == 1) | (first_b_below_20 == 1) | (first_b_below_25 == 1) | (first_b_below_50 == 1)
keep c  first_*
g threshold = _n 

reshape long first_b_below_, i(threshold) j(threshold_value)
drop if first_b_below_ == 0
keep c threshold_value threshold
rename c value
g type = "c"
g value_str = string(value,"%9.2f")
drop value
rename value_str  value
save "dta/threshold_certainty_min_c.dta", replace
restore

//get min_d certainty

preserve
global comb_range = "0.01 0.02 0.03 0.04 0.05(0.05)1 "

use "$project_code/out/sdsa/temp/sim_ar_1_0_0_100_years_no_poisson_full_ss_no_rminusg_constrained_model_prod.dta", clear
g comb = 1
// g d = 0

global counter = 1
// foreach d of numlist 0.0005(0.0005).05  {
	foreach d of numlist $comb_range    {
		local d_name=round(`d' *100,1 ) 
	global counter = $counter +1
	append using "$project_code/out/sdsa/temp/sim_ar_1_0_`d_name'_100_years_no_poisson_full_ss_no_rminusg_constrained_model_prod.dta"
	replace comb = $counter if comb == .
// 	replace d = `d' if d == .
}

//create local for max value of comb extracted from tab comb
sum comb, meanonly
local comb_max = r(max)
di "`comb_max'"
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, `comb_max')
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & inrange(comb, 1, `comb_max')

keep if year == 101
sort comb
foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	g 	b_below_`b_name' = 0
	replace b_below_`b_name' = 1 if b<`b_max'
	g 	first_b_below_`b_name' = 0
	replace first_b_below_`b_name' = 1 if (b_below_`b_name' == 1) & (b_below_`b_name'[_n-1] == 0)
}

keep if (first_b_below_15 == 1) | (first_b_below_20 == 1) | (first_b_below_25 == 1) | (first_b_below_50 == 1)
keep d  first_*
g threshold = _n 

reshape long first_b_below_, i(threshold) j(threshold_value)
drop if first_b_below_ == 0
keep d threshold_value threshold
rename d value
g type = "d"
g value_str = string(value,"%9.2f")
drop value
rename value_str  value
save "dta/threshold_certainty_min_d.dta", replace
restore


//get min_si certainty

preserve
use "$project_code/out/sdsa/temp/sim_ar_1_0_0_15_100_years_no_poisson_full_ss_sudden_r_no_rminusg_constrained_model_prod.dta", clear
g comb = 21
g si = 30

global counter = 1


foreach si of numlist 10(1)29 31(1)100 {
	global counter = $counter -1
	append using "$project_code/out/sdsa/temp/sim_ar_1_0_0_15_100_years_no_poisson_full_ss_sudden_r_no_rminusg_constrained_model_prod_`si'.dta"
	replace comb = $counter if comb == .
	replace si = `si' if si == .
}

//create local for max value of comb extracted from tab comb
sum comb, meanonly
local comb_max = r(max)
di "`comb_max'"
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, `comb_max')
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & inrange(comb, 1, `comb_max')

keep if year == 101
g si_desc = -si
sort si_desc
// keep b si 
// save "dta/threshold_certainty_min_si_manual.dta", replace

foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	g 	b_below_`b_name' = 0
	replace b_below_`b_name' = 1 if b<`b_max'
	g 	first_b_below_`b_name' = 0
	replace first_b_below_`b_name' = 1 if (b_below_`b_name' == 1) & ((b_below_`b_name'[_n-1] == 0) | (_n == 1))
}

keep if (first_b_below_15 == 1) | (first_b_below_20 == 1) | (first_b_below_25 == 1) | (first_b_below_50 == 1)
keep si  first_*
g threshold = _n 

reshape long first_b_below_, i(threshold) j(threshold_value)
drop if first_b_below_ == 0
g si_str = string(si,"%9.0f")

keep si_str threshold_value threshold
rename si_str value
g type = "si"
save "dta/threshold_certainty_min_si.dta", replace
restore



//Table 6b: uncertainty 
//get min_c uncertainty
preserve
use "$project_code/out/sdsa/temp/sim_ar_1000_0_0_100_years_full_ss_constrained_model_prod.dta", clear
g comb = 1
// g c = 0

global counter = 1
foreach c of numlist 0(0.01)0.20 0.25(0.05)1  {
		local c_name=round(`c' *100,1 ) 
	global counter = $counter +1
	append using "$project_code/out/sdsa/temp/sim_ar_1000_`c_name'_0_100_years_full_ss_constrained_model_prod.dta"
	replace comb = $counter if comb == .
// 	replace c = `c' if c == .
}

//create local for max value of comb extracted from tab comb
sum comb, meanonly
local comb_max = r(max)
di "`comb_max'"
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, `comb_max')
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & inrange(comb, 1, `comb_max')


keep if year == 101
sort comb
foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	g 	b_below_`b_name' = 0
	replace b_below_`b_name' = 1 if b<`b_max'
}

collapse (sum) b_below_*, by(c comb)

foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	g	b_below_`b_name'_prop = b_below_`b_name'/1000
	g 	first_b_below_`b_name'_tag = 0
	replace first_b_below_`b_name'_tag = 1 if  (b_below_`b_name'_prop>= .95) & (b_below_`b_name'_prop[_n-1] < .95)
	gen first_b_below_`b_name'_cum = sum(first_b_below_`b_name'_tag)
	g 	first_b_below_`b_name' = 0
	replace first_b_below_`b_name' = 1 if (first_b_below_`b_name'_cum ==1) & (first_b_below_`b_name'_cum[_n-1] == 0)
}

g c_str = string(c,"%9.2f")
g last = _n == _N
expand 2 if last

replace c_str = "NA" if _n == _N 


foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	egen first_b_below_`b_name'_total = total(first_b_below_`b_name')
	replace first_b_below_`b_name' = 1 if (first_b_below_`b_name'_total == 0 ) & c_str == "NA"
}



keep if (first_b_below_15 == 1) | (first_b_below_20 == 1) | (first_b_below_25 == 1) | (first_b_below_50 == 1)
keep c_str first_b_below_15 first_b_below_20 first_b_below_25 first_b_below_50
g threshold = _n 

reshape long first_b_below_, i(threshold) j(threshold_value)
drop if first_b_below_ == 0
keep c_str threshold_value threshold
rename c_str value
g type = "c"
save "dta/threshold_uncertainty_min_c.dta", replace
restore


//get min_d uncertainty
preserve
use "$project_code/out/sdsa/temp/sim_ar_1000_0_0_100_years_full_ss_constrained_model_prod.dta", clear
g comb = 1
// g d = 0

global counter = 1
foreach d of numlist 0(0.01)0.20 0.25(0.05)1  {
		local d_name=round(`d' *100,1 ) 
	global counter = $counter +1
	append using "$project_code/out/sdsa/temp/sim_ar_1000_0_`d_name'_100_years_full_ss_constrained_model_prod.dta"
	replace comb = $counter if comb == .
// 	replace d = `d' if d == .
}

//create local for max value of comb extracted from tab comb
sum comb, meanonly
local comb_max = r(max)
di "`comb_max'"
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, `comb_max')
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & inrange(comb, 1, `comb_max')

keep if year == 101
sort comb
foreach b_max of numlist 1.5 2 2.5 5  {
	local b_name=round(`b_max' *10,1 ) 
	g 	b_below_`b_name' = 0
	replace b_below_`b_name' = 1 if b<`b_max'
}

collapse (sum) b_below_*, by(d comb)

foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	g	b_below_`b_name'_prop = b_below_`b_name'/1000
	g 	first_b_below_`b_name'_tag = 0
	replace first_b_below_`b_name'_tag = 1 if  (b_below_`b_name'_prop>= .95) & (b_below_`b_name'_prop[_n-1] < .95)
	gen first_b_below_`b_name'_cum = sum(first_b_below_`b_name'_tag)
	g 	first_b_below_`b_name' = 0
	replace first_b_below_`b_name' = 1 if (first_b_below_`b_name'_cum ==1) & (first_b_below_`b_name'_cum[_n-1] == 0)
}

g d_str = string(d,"%9.2f")
g last = _n == _N
expand 2 if last

replace d_str = "NA" if _n == _N 


foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	egen first_b_below_`b_name'_total = total(first_b_below_`b_name')
	replace first_b_below_`b_name' = 1 if (first_b_below_`b_name'_total == 0 ) & d_str == "NA"
}



keep if (first_b_below_15 == 1) | (first_b_below_20 == 1) | (first_b_below_25 == 1) | (first_b_below_50 == 1)
keep d_str first_b_below_15 first_b_below_20 first_b_below_25 first_b_below_50
g threshold = _n 


reshape long first_b_below_, i(threshold) j(threshold_value)
drop if first_b_below_ == 0
keep d_str threshold_value threshold
rename d_str value
g type = "d"
save "dta/threshold_uncertainty_min_d.dta", replace
restore



//get min_si uncertainty
preserve
use "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod.dta", clear
g comb = 21
g si = 30

global counter = 1


foreach si of numlist 5(1)29 {
	global counter = $counter -1
	append using "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod_`si'.dta"
	replace comb = $counter if comb == .
	replace si = `si' if si == .
}

//create local for max value of comb extracted from tab comb
sum comb, meanonly
local comb_max = r(max)
di "`comb_max'"
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, `comb_max')
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & inrange(comb, 1, `comb_max')


keep if year == 101

foreach b_max of numlist 1.5 2 2.5 5  {
	local b_name=round(`b_max' *10,1 ) 
	g 	b_below_`b_name' = 0
	replace b_below_`b_name' = 1 if b<`b_max'
}

collapse (sum) b_below_*, by(si comb)
g si_desc = -si
sort si_desc

foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	g	b_below_`b_name'_prop = b_below_`b_name'/1000
	g 	first_b_below_`b_name'_tag = 0
	replace first_b_below_`b_name'_tag = 1 if  (b_below_`b_name'_prop>= .95) & ((b_below_`b_name'_prop[_n-1] < .95) | (_n == 1))
	gen first_b_below_`b_name'_cum = sum(first_b_below_`b_name'_tag)
	g 	first_b_below_`b_name' = 0
	replace first_b_below_`b_name' = 1 if (first_b_below_`b_name'_cum ==1) & ((first_b_below_`b_name'_cum[_n-1] == 0)  | (_n == 1))
}

g si_str = string(si,"%9.0f")
g last = _n == _N
expand 2 if last

replace si_str = "NA" if _n == _N 


foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	egen first_b_below_`b_name'_total = total(first_b_below_`b_name')
	replace first_b_below_`b_name' = 1 if (first_b_below_`b_name'_total == 0 ) & si_str == "NA"
}



keep if (first_b_below_15 == 1) | (first_b_below_20 == 1) | (first_b_below_25 == 1) | (first_b_below_50 == 1)
keep si_str first_b_below_15 first_b_below_20 first_b_below_25 first_b_below_50
g threshold = _n 


reshape long first_b_below_, i(threshold) j(threshold_value)
drop if first_b_below_ == 0
sort threshold_value
drop threshold 
g threshold = _n 
keep si_str threshold_value threshold
rename si_str value
g type = "si"
//hacky
// drop if _n == _N
save "dta/threshold_uncertainty_min_si.dta", replace
restore


//table 1A: certainty
preserve
use "$project_code/dta/threshold_certainty_min_c", clear
g comb = 1

append using "$project_code/dta/threshold_certainty_min_d"
replace comb = 2 if comb == .

append using "$project_code/dta/threshold_certainty_min_si" 
replace comb = 3 if comb == .

keep value type threshold_value
reshape wide value, j(type) i(threshold_value) string

g threshold_value_str = ""
foreach i of numlist 15 20 25 50  {
replace threshold_value_str = "`i'0\% of GDP" if threshold_value == `i'
}
drop threshold_value
order threshold_value_str valuec valued
//change the valuec, valued, valuesi to have 2 deiimal points "%9.3f"

replace valuesi = "NA" if valuesi == ""


forvalues		s=0/3 {
g						s`s'="&"
}
g					l="\\"
replace			l="\\\bottomrule" in 4
order threshold_value s0 valuec s1 valued s2 valuesi l 
keep threshold_value s0 valuec s1 valued s2 valuesi l 
export delimited "out/${out_dir}/table_certainty_min_feedback.tex", novarnames delimiter(tab) replace
restore

//table 1B: uncertainty
preserve
use "$project_code/dta/threshold_uncertainty_min_c", clear
g comb = 1

append using "$project_code/dta/threshold_uncertainty_min_d"
replace comb = 2 if comb == .

append using "$project_code/dta/threshold_uncertainty_min_si"
replace comb = 3 if comb == .


keep value type threshold_value
reshape wide value, j(type) i(threshold_value) string

g threshold_value_str = ""
foreach i of numlist 15 20 25 50  {
replace threshold_value_str = "`i'0\% of GDP" if threshold_value == `i'
}
drop threshold_value
order threshold_value_str valuec valued



forvalues		s=0/3 {
g						s`s'="&"
}
g					l="\\"
replace			l="\\\bottomrule" in 4

order				threshold_value_str s0 valuec s1 valued s2 valuesi l 
keep				threshold_value_str s0 valuec s1 valued s2 valuesi l 
export delimited "out/${out_dir}/table_uncertainty_min_feedback.tex", novarnames delimiter(tab) replace
restore




//Table 6b: Only r-g risk 
//get min_c Only r-g risk
preserve
use "$project_code/out/sdsa/temp/sim_ar_1000_0_0_100_years_no_poisson_full_ss_constrained_model_prod.dta", clear
g comb = 1
// g c = 0

global counter = 1
foreach c of numlist 0.05(0.05)1  {
		local c_name=round(`c' *100,1 ) 
	global counter = $counter +1
	append using "$project_code/out/sdsa/temp/sim_ar_1000_`c_name'_0_100_years_no_poisson_full_ss_constrained_model_prod.dta"
	replace comb = $counter if comb == .
// 	replace c = `c' if c == .
}

//create local for max value of comb extracted from tab comb
sum comb, meanonly
local comb_max = r(max)
di "`comb_max'"
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, `comb_max')
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & inrange(comb, 1, `comb_max')


keep if year == 101
sort comb
foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	g 	b_below_`b_name' = 0
	replace b_below_`b_name' = 1 if b<`b_max'
}

collapse (sum) b_below_*, by(c comb)

foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	g	b_below_`b_name'_prop = b_below_`b_name'/1000
	g 	first_b_below_`b_name'_tag = 0
	replace first_b_below_`b_name'_tag = 1 if  (b_below_`b_name'_prop>= .95) & (b_below_`b_name'_prop[_n-1] < .95)
	gen first_b_below_`b_name'_cum = sum(first_b_below_`b_name'_tag)
	g 	first_b_below_`b_name' = 0
	replace first_b_below_`b_name' = 1 if (first_b_below_`b_name'_cum ==1) & (first_b_below_`b_name'_cum[_n-1] == 0)
}

g c_str = string(c,"%9.2f")
g last = _n == _N
expand 2 if last

replace c_str = "NA" if _n == _N 


foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	egen first_b_below_`b_name'_total = total(first_b_below_`b_name')
	replace first_b_below_`b_name' = 1 if (first_b_below_`b_name'_total == 0 ) & c_str == "NA"
}



keep if (first_b_below_15 == 1) | (first_b_below_20 == 1) | (first_b_below_25 == 1) | (first_b_below_50 == 1)
keep c_str first_b_below_15 first_b_below_20 first_b_below_25 first_b_below_50
g threshold = _n 

reshape long first_b_below_, i(threshold) j(threshold_value)
drop if first_b_below_ == 0
keep c_str threshold_value threshold
rename c_str value
g type = "c"
save "dta/threshold_uncertainty_min_c_no_poisson.dta", replace
restore


//get min_d Only r-g risk
preserve
use "$project_code/out/sdsa/temp/sim_ar_1000_0_0_100_years_no_poisson_full_ss_constrained_model_prod.dta", clear
g comb = 1
// g d = 0

global counter = 1
foreach d of numlist 0.05(0.05)1  {
		local d_name=round(`d' *100,1 ) 
	global counter = $counter +1
	append using "$project_code/out/sdsa/temp/sim_ar_1000_0_`d_name'_100_years_no_poisson_full_ss_constrained_model_prod.dta"
	replace comb = $counter if comb == .
// 	replace d = `d' if d == .
}

//create local for max value of comb extracted from tab comb
sum comb, meanonly
local comb_max = r(max)
di "`comb_max'"
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, `comb_max')
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & inrange(comb, 1, `comb_max')

keep if year == 101
sort comb
foreach b_max of numlist 1.5 2 2.5 5  {
	local b_name=round(`b_max' *10,1 ) 
	g 	b_below_`b_name' = 0
	replace b_below_`b_name' = 1 if b<`b_max'
}

collapse (sum) b_below_*, by(d comb)

foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	g	b_below_`b_name'_prop = b_below_`b_name'/1000
	g 	first_b_below_`b_name'_tag = 0
	replace first_b_below_`b_name'_tag = 1 if  (b_below_`b_name'_prop>= .95) & (b_below_`b_name'_prop[_n-1] < .95)
	gen first_b_below_`b_name'_cum = sum(first_b_below_`b_name'_tag)
	g 	first_b_below_`b_name' = 0
	replace first_b_below_`b_name' = 1 if (first_b_below_`b_name'_cum ==1) & (first_b_below_`b_name'_cum[_n-1] == 0)
}

g d_str = string(d,"%9.2f")
g last = _n == _N
expand 2 if last

replace d_str = "NA" if _n == _N 


foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	egen first_b_below_`b_name'_total = total(first_b_below_`b_name')
	replace first_b_below_`b_name' = 1 if (first_b_below_`b_name'_total == 0 ) & d_str == "NA"
}



keep if (first_b_below_15 == 1) | (first_b_below_20 == 1) | (first_b_below_25 == 1) | (first_b_below_50 == 1)
keep d_str first_b_below_15 first_b_below_20 first_b_below_25 first_b_below_50
g threshold = _n 


reshape long first_b_below_, i(threshold) j(threshold_value)
drop if first_b_below_ == 0
keep d_str threshold_value threshold
rename d_str value
g type = "d"
save "dta/threshold_uncertainty_min_d_no_poisson.dta", replace
restore



//get min_si Only r-g risk
preserve
use "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_no_poisson_full_ss_sudden_r_constrained_model_prod.dta", clear
g comb = 21
g si = 30

global counter = 1


foreach si of numlist 1(1)29 {
	global counter = $counter -1
	append using "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_no_poisson_full_ss_sudden_r_constrained_model_prod_`si'.dta"
	replace comb = $counter if comb == .
	replace si = `si' if si == .
}

//create local for max value of comb extracted from tab comb
sum comb, meanonly
local comb_max = r(max)
di "`comb_max'"
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, `comb_max')
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & inrange(comb, 1, `comb_max')


keep if year == 101

foreach b_max of numlist 1.5 2 2.5 5  {
	local b_name=round(`b_max' *10,1 ) 
	g 	b_below_`b_name' = 0
	replace b_below_`b_name' = 1 if b<`b_max'
}

collapse (sum) b_below_*, by(si comb)
g si_desc = -si
sort si_desc

foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	g	b_below_`b_name'_prop = b_below_`b_name'/1000
	g 	first_b_below_`b_name'_tag = 0
	replace first_b_below_`b_name'_tag = 1 if  (b_below_`b_name'_prop>= .95) & ((b_below_`b_name'_prop[_n-1] < .95) | (_n == 1))
	gen first_b_below_`b_name'_cum = sum(first_b_below_`b_name'_tag)
	g 	first_b_below_`b_name' = 0
	replace first_b_below_`b_name' = 1 if (first_b_below_`b_name'_cum ==1) & ((first_b_below_`b_name'_cum[_n-1] == 0)  | (_n == 1))
}

g si_str = string(si,"%9.0f")
g last = _n == _N
expand 2 if last

replace si_str = "NA" if _n == _N 


foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	egen first_b_below_`b_name'_total = total(first_b_below_`b_name')
	replace first_b_below_`b_name' = 1 if (first_b_below_`b_name'_total == 0 ) & si_str == "NA"
}



keep if (first_b_below_15 == 1) | (first_b_below_20 == 1) | (first_b_below_25 == 1) | (first_b_below_50 == 1)
keep si_str first_b_below_15 first_b_below_20 first_b_below_25 first_b_below_50
g threshold = _n 


reshape long first_b_below_, i(threshold) j(threshold_value)
drop if first_b_below_ == 0
sort threshold_value
drop threshold 
g threshold = _n 
keep si_str threshold_value threshold
rename si_str value
g type = "si"
//hacky
// drop if _n == _N
save "dta/threshold_uncertainty_min_si_no_poisson.dta", replace
restore



//table 1B: Only r-g risk
preserve
use "$project_code/dta/threshold_uncertainty_min_c_no_poisson", clear
g comb = 1

append using "$project_code/dta/threshold_uncertainty_min_d_no_poisson"
replace comb = 2 if comb == .

append using "$project_code/dta/threshold_uncertainty_min_si_no_poisson"
replace comb = 3 if comb == .


keep value type threshold_value
reshape wide value, j(type) i(threshold_value) string

g threshold_value_str = ""
foreach i of numlist 15 20 25 50  {
replace threshold_value_str = "`i'0\% of GDP" if threshold_value == `i'
}
drop threshold_value
order threshold_value_str valuec valued



forvalues		s=0/3 {
g						s`s'="&"
}
g					l="\\"
replace			l="\\\bottomrule" in 4

order				threshold_value_str s0 valuec s1 valued s2 valuesi l 
keep				threshold_value_str s0 valuec s1 valued s2 valuesi l 
export delimited "out/${out_dir}/table_uncertainty_min_feedback_no_poisson.tex", novarnames delimiter(tab) replace
restore






//Table 6b: Only Poisson risk
//get min_c Only Poisson risk
preserve
use "$project_code/out/sdsa/temp/sim_ar_1000_0_0_100_years_full_ss_no_rminusg_constrained_model_prod.dta", clear
g comb = 1
// g c = 0

global counter = 1
foreach c of numlist 0.05(0.05)1  {
		local c_name=round(`c' *100,1 ) 
	global counter = $counter +1
	append using "$project_code/out/sdsa/temp/sim_ar_1000_`c_name'_0_100_years_full_ss_no_rminusg_constrained_model_prod.dta"
	replace comb = $counter if comb == .
// 	replace c = `c' if c == .
}

//create local for max value of comb extracted from tab comb
sum comb, meanonly
local comb_max = r(max)
di "`comb_max'"
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, `comb_max')
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & inrange(comb, 1, `comb_max')


keep if year == 101
sort comb
foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	g 	b_below_`b_name' = 0
	replace b_below_`b_name' = 1 if b<`b_max'
}

collapse (sum) b_below_*, by(c comb)

foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	g	b_below_`b_name'_prop = b_below_`b_name'/1000
	g 	first_b_below_`b_name'_tag = 0
	replace first_b_below_`b_name'_tag = 1 if  (b_below_`b_name'_prop>= .95) & (b_below_`b_name'_prop[_n-1] < .95)
	gen first_b_below_`b_name'_cum = sum(first_b_below_`b_name'_tag)
	g 	first_b_below_`b_name' = 0
	replace first_b_below_`b_name' = 1 if (first_b_below_`b_name'_cum ==1) & (first_b_below_`b_name'_cum[_n-1] == 0)
}

g c_str = string(c,"%9.2f")
g last = _n == _N
expand 2 if last

replace c_str = "NA" if _n == _N 


foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	egen first_b_below_`b_name'_total = total(first_b_below_`b_name')
	replace first_b_below_`b_name' = 1 if (first_b_below_`b_name'_total == 0 ) & c_str == "NA"
}



keep if (first_b_below_15 == 1) | (first_b_below_20 == 1) | (first_b_below_25 == 1) | (first_b_below_50 == 1)
keep c_str first_b_below_15 first_b_below_20 first_b_below_25 first_b_below_50
g threshold = _n 

reshape long first_b_below_, i(threshold) j(threshold_value)
drop if first_b_below_ == 0
keep c_str threshold_value threshold
rename c_str value
g type = "c"
save "dta/threshold_uncertainty_min_c_no_rminusg.dta", replace
restore


//get min_d Only Poisson risk
preserve
use "$project_code/out/sdsa/temp/sim_ar_1000_0_0_100_years_full_ss_no_rminusg_constrained_model_prod.dta", clear
g comb = 1
// g d = 0

global counter = 1
foreach d of numlist 0.05(0.05)1  {
		local d_name=round(`d' *100,1 ) 
	global counter = $counter +1
	append using "$project_code/out/sdsa/temp/sim_ar_1000_0_`d_name'_100_years_full_ss_no_rminusg_constrained_model_prod.dta"
	replace comb = $counter if comb == .
// 	replace d = `d' if d == .
}

//create local for max value of comb extracted from tab comb
sum comb, meanonly
local comb_max = r(max)
di "`comb_max'"
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, `comb_max')
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & inrange(comb, 1, `comb_max')

keep if year == 101
sort comb
foreach b_max of numlist 1.5 2 2.5 5  {
	local b_name=round(`b_max' *10,1 ) 
	g 	b_below_`b_name' = 0
	replace b_below_`b_name' = 1 if b<`b_max'
}

collapse (sum) b_below_*, by(d comb)

foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	g	b_below_`b_name'_prop = b_below_`b_name'/1000
	g 	first_b_below_`b_name'_tag = 0
	replace first_b_below_`b_name'_tag = 1 if  (b_below_`b_name'_prop>= .95) & (b_below_`b_name'_prop[_n-1] < .95)
	gen first_b_below_`b_name'_cum = sum(first_b_below_`b_name'_tag)
	g 	first_b_below_`b_name' = 0
	replace first_b_below_`b_name' = 1 if (first_b_below_`b_name'_cum ==1) & (first_b_below_`b_name'_cum[_n-1] == 0)
}

g d_str = string(d,"%9.2f")
g last = _n == _N
expand 2 if last

replace d_str = "NA" if _n == _N 


foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	egen first_b_below_`b_name'_total = total(first_b_below_`b_name')
	replace first_b_below_`b_name' = 1 if (first_b_below_`b_name'_total == 0 ) & d_str == "NA"
}



keep if (first_b_below_15 == 1) | (first_b_below_20 == 1) | (first_b_below_25 == 1) | (first_b_below_50 == 1)
keep d_str first_b_below_15 first_b_below_20 first_b_below_25 first_b_below_50
g threshold = _n 


reshape long first_b_below_, i(threshold) j(threshold_value)
drop if first_b_below_ == 0
keep d_str threshold_value threshold
rename d_str value
g type = "d"
save "dta/threshold_uncertainty_min_d_no_rminusg.dta", replace
restore



//get min_si Only Poisson risk
preserve
use "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_no_rminusg_constrained_model_prod.dta", clear
g comb = 21
g si = 30

global counter = 1


foreach si of numlist 1(1)29 {
	global counter = $counter -1
	append using "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_no_rminusg_constrained_model_prod_`si'.dta"
	replace comb = $counter if comb == .
	replace si = `si' if si == .
}

//create local for max value of comb extracted from tab comb
sum comb, meanonly
local comb_max = r(max)
di "`comb_max'"
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, `comb_max')
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & inrange(comb, 1, `comb_max')


keep if year == 101

foreach b_max of numlist 1.5 2 2.5 5  {
	local b_name=round(`b_max' *10,1 ) 
	g 	b_below_`b_name' = 0
	replace b_below_`b_name' = 1 if b<`b_max'
}

collapse (sum) b_below_*, by(si comb)
g si_desc = -si
sort si_desc

foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	g	b_below_`b_name'_prop = b_below_`b_name'/1000
	g 	first_b_below_`b_name'_tag = 0
	replace first_b_below_`b_name'_tag = 1 if  (b_below_`b_name'_prop>= .95) & ((b_below_`b_name'_prop[_n-1] < .95) | (_n == 1))
	gen first_b_below_`b_name'_cum = sum(first_b_below_`b_name'_tag)
	g 	first_b_below_`b_name' = 0
	replace first_b_below_`b_name' = 1 if (first_b_below_`b_name'_cum ==1) & ((first_b_below_`b_name'_cum[_n-1] == 0)  | (_n == 1))
}

g si_str = string(si,"%9.0f")
g last = _n == _N
expand 2 if last

replace si_str = "NA" if _n == _N 


foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	egen first_b_below_`b_name'_total = total(first_b_below_`b_name')
	replace first_b_below_`b_name' = 1 if (first_b_below_`b_name'_total == 0 ) & si_str == "NA"
}



keep if (first_b_below_15 == 1) | (first_b_below_20 == 1) | (first_b_below_25 == 1) | (first_b_below_50 == 1)
keep si_str first_b_below_15 first_b_below_20 first_b_below_25 first_b_below_50
g threshold = _n 


reshape long first_b_below_, i(threshold) j(threshold_value)
drop if first_b_below_ == 0
sort threshold_value
drop threshold 
g threshold = _n 
keep si_str threshold_value threshold
rename si_str value
g type = "si"
//hacky
// drop if _n == _N
save "dta/threshold_uncertainty_min_si_no_rminusg.dta", replace
restore



//table 1B: Only Poisson risk
preserve
use "$project_code/dta/threshold_uncertainty_min_c_no_rminusg", clear
g comb = 1

append using "$project_code/dta/threshold_uncertainty_min_d_no_rminusg"
replace comb = 2 if comb == .

append using "$project_code/dta/threshold_uncertainty_min_si_no_rminusg"
replace comb = 3 if comb == .


keep value type threshold_value
reshape wide value, j(type) i(threshold_value) string

g threshold_value_str = ""
foreach i of numlist 15 20 25 50  {
replace threshold_value_str = "`i'0\% of GDP" if threshold_value == `i'
}
drop threshold_value
order threshold_value_str valuec valued



forvalues		s=0/3 {
g						s`s'="&"
}
g					l="\\"
replace			l="\\\bottomrule" in 4

order				threshold_value_str s0 valuec s1 valued s2 valuesi l 
keep				threshold_value_str s0 valuec s1 valued s2 valuesi l 
export delimited "out/${out_dir}/table_uncertainty_min_feedback_no_rminusg.tex", novarnames delimiter(tab) replace
restore





//Table 6b: uncertainty, _zero_beta2
//get min_c uncertainty, _zero_beta2
preserve
use "$project_code/out/sdsa/temp/sim_ar_1000_0_0_100_years_full_ss_constrained_model_prod_zero_beta2.dta", clear
g comb = 1
// g c = 0

global counter = 1
foreach c of numlist 0.05(0.05)1  {
		local c_name=round(`c' *100,1 ) 
	global counter = $counter +1
	append using "$project_code/out/sdsa/temp/sim_ar_1000_`c_name'_0_100_years_full_ss_constrained_model_prod_zero_beta2.dta"
	replace comb = $counter if comb == .
// 	replace c = `c' if c == .
}

//create local for max value of comb extracted from tab comb
sum comb, meanonly
local comb_max = r(max)
di "`comb_max'"
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, `comb_max')
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & inrange(comb, 1, `comb_max')

keep if year == 101
sort comb
foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	g 	b_below_`b_name' = 0
	replace b_below_`b_name' = 1 if b<`b_max'
}

collapse (sum) b_below_*, by(c comb)

foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	g	b_below_`b_name'_prop = b_below_`b_name'/1000
	g 	first_b_below_`b_name'_tag = 0
	replace first_b_below_`b_name'_tag = 1 if  (b_below_`b_name'_prop>= .95) & (b_below_`b_name'_prop[_n-1] < .95)
	gen first_b_below_`b_name'_cum = sum(first_b_below_`b_name'_tag)
	g 	first_b_below_`b_name' = 0
	replace first_b_below_`b_name' = 1 if (first_b_below_`b_name'_cum ==1) & (first_b_below_`b_name'_cum[_n-1] == 0)
}

g c_str = string(c,"%9.2f")
g last = _n == _N
expand 2 if last

replace c_str = "NA" if _n == _N 


foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	egen first_b_below_`b_name'_total = total(first_b_below_`b_name')
	replace first_b_below_`b_name' = 1 if (first_b_below_`b_name'_total == 0 ) & c_str == "NA"
}



keep if (first_b_below_15 == 1) | (first_b_below_20 == 1) | (first_b_below_25 == 1) | (first_b_below_50 == 1)
keep c_str first_b_below_15 first_b_below_20 first_b_below_25 first_b_below_50
g threshold = _n 

reshape long first_b_below_, i(threshold) j(threshold_value)
drop if first_b_below_ == 0
keep c_str threshold_value threshold
rename c_str value
g type = "c"
save "dta/threshold_uncertainty_min_c_zero_beta2.dta", replace
restore


//get min_d uncertainty
preserve
use "$project_code/out/sdsa/temp/sim_ar_1000_0_0_100_years_full_ss_constrained_model_prod_zero_beta2.dta", clear
g comb = 1
// g d = 0

global counter = 1
foreach d of numlist 0.05(0.05)1  {
		local d_name=round(`d' *100,1 ) 
	global counter = $counter +1
	append using "$project_code/out/sdsa/temp/sim_ar_1000_0_`d_name'_100_years_full_ss_constrained_model_prod_zero_beta2.dta"
	replace comb = $counter if comb == .
// 	replace d = `d' if d == .
}

//create local for max value of comb extracted from tab comb
sum comb, meanonly
local comb_max = r(max)
di "`comb_max'"
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, `comb_max')
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & inrange(comb, 1, `comb_max')

keep if year == 101
sort comb
foreach b_max of numlist 1.5 2 2.5 5  {
	local b_name=round(`b_max' *10,1 ) 
	g 	b_below_`b_name' = 0
	replace b_below_`b_name' = 1 if b<`b_max'
}

collapse (sum) b_below_*, by(d comb)

foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	g	b_below_`b_name'_prop = b_below_`b_name'/1000
	g 	first_b_below_`b_name'_tag = 0
	replace first_b_below_`b_name'_tag = 1 if  (b_below_`b_name'_prop>= .95) & (b_below_`b_name'_prop[_n-1] < .95)
	gen first_b_below_`b_name'_cum = sum(first_b_below_`b_name'_tag)
	g 	first_b_below_`b_name' = 0
	replace first_b_below_`b_name' = 1 if (first_b_below_`b_name'_cum ==1) & (first_b_below_`b_name'_cum[_n-1] == 0)
}

g d_str = string(d,"%9.2f")
g last = _n == _N
expand 2 if last

replace d_str = "NA" if _n == _N 


foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	egen first_b_below_`b_name'_total = total(first_b_below_`b_name')
	replace first_b_below_`b_name' = 1 if (first_b_below_`b_name'_total == 0 ) & d_str == "NA"
}



keep if (first_b_below_15 == 1) | (first_b_below_20 == 1) | (first_b_below_25 == 1) | (first_b_below_50 == 1)
keep d_str first_b_below_15 first_b_below_20 first_b_below_25 first_b_below_50
g threshold = _n 


reshape long first_b_below_, i(threshold) j(threshold_value)
drop if first_b_below_ == 0
keep d_str threshold_value threshold
rename d_str value
g type = "d"
save "dta/threshold_uncertainty_min_d_zero_beta2.dta", replace
restore



//get min_si uncertainty
preserve
use "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod_zero_beta2.dta", clear
g comb = 21
g si = 30

global counter = 1


foreach si of numlist 1(1)29 {
	global counter = $counter -1
	append using "$project_code/out/sdsa/temp/sim_ar_1000_0_0_15_100_years_full_ss_sudden_r_constrained_model_prod_zero_beta2_`si'.dta"
	replace comb = $counter if comb == .
	replace si = `si' if si == .
}

//create local for max value of comb extracted from tab comb
sum comb, meanonly
local comb_max = r(max)
di "`comb_max'"
//assert test e_u and e_s same for each comb
sort year rep comb
by year rep: assert e_u == e_u[1] if  ///
!missing(e_u) & !missing(e_u[1]) & inrange(comb, 1, `comb_max')
by year rep: assert e_s == e_s[1] if  ///
!missing(e_s) & !missing(e_s[1]) & inrange(comb, 1, `comb_max')


keep if year == 101

foreach b_max of numlist 1.5 2 2.5 5  {
	local b_name=round(`b_max' *10,1 ) 
	g 	b_below_`b_name' = 0
	replace b_below_`b_name' = 1 if b<`b_max'
}

collapse (sum) b_below_*, by(si comb)
g si_desc = -si
sort si_desc

foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	g	b_below_`b_name'_prop = b_below_`b_name'/1000
	g 	first_b_below_`b_name'_tag = 0
	replace first_b_below_`b_name'_tag = 1 if  (b_below_`b_name'_prop>= .95) & ((b_below_`b_name'_prop[_n-1] < .95) | (_n == 1))
	gen first_b_below_`b_name'_cum = sum(first_b_below_`b_name'_tag)
	g 	first_b_below_`b_name' = 0
	replace first_b_below_`b_name' = 1 if (first_b_below_`b_name'_cum ==1) & ((first_b_below_`b_name'_cum[_n-1] == 0)  | (_n == 1))
}

g si_str = string(si,"%9.0f")
g last = _n == _N
expand 2 if last

replace si_str = "NA" if _n == _N 


foreach b_max of numlist 1.5 2 2.5 5 {
	local b_name=round(`b_max' *10,1 ) 
	egen first_b_below_`b_name'_total = total(first_b_below_`b_name')
	replace first_b_below_`b_name' = 1 if (first_b_below_`b_name'_total == 0 ) & si_str == "NA"
}



keep if (first_b_below_15 == 1) | (first_b_below_20 == 1) | (first_b_below_25 == 1) | (first_b_below_50 == 1)
keep si_str first_b_below_15 first_b_below_20 first_b_below_25 first_b_below_50
g threshold = _n 


reshape long first_b_below_, i(threshold) j(threshold_value)
drop if first_b_below_ == 0
sort threshold_value
drop threshold 
g threshold = _n 
keep si_str threshold_value threshold
rename si_str value
g type = "si"
//hacky
// drop if _n == _N
save "dta/threshold_uncertainty_min_si_zero_beta2.dta", replace
restore



//table 1B: _zero_beta2
preserve
use "$project_code/dta/threshold_uncertainty_min_c_zero_beta2", clear
g comb = 1

append using "$project_code/dta/threshold_uncertainty_min_d_zero_beta2"
replace comb = 2 if comb == .

append using "$project_code/dta/threshold_uncertainty_min_si_zero_beta2"
replace comb = 3 if comb == .


keep value type threshold_value
reshape wide value, j(type) i(threshold_value) string

g threshold_value_str = ""
foreach i of numlist 15 20 25 50  {
replace threshold_value_str = "`i'0\% of GDP" if threshold_value == `i'
}
drop threshold_value
order threshold_value_str valuec valued



forvalues		s=0/3 {
g						s`s'="&"
}
g					l="\\"
replace			l="\\\bottomrule" in 4

order				threshold_value_str s0 valuec s1 valued s2 valuesi l 
keep				threshold_value_str s0 valuec s1 valued s2 valuesi l 
export delimited "out/${out_dir}/table_uncertainty_min_feedback_zero_beta2.tex", novarnames delimiter(tab) replace
restore


// cd "$project_code/do/"