/*
This code does two things:
1. Creates the AR regression table 
2. Collects inputs for our models -- both the AR components and Poisson shocks.
*/

clear all 
cd "$project_code"

use "dta/historicaldebtevolution_cleaned.dta", clear
keep year rminusg debt g_nom gdp
sort year
tsset year
global baseline = 0
global beta_2_cbo = 0.01


g restricted = 0
replace restricted =1 if inrange(year, 1940, 1945) | ///
inrange(year, 1950, 1980) | inrange(year, 2008, 2011) | year>=2020

g b = debt/gdp
g rho = rminusg/(1+g_nom)

/* Fit beta: response to debt*/
global version = "_unconstrained"
/* 
So we'd like to see columns added to Table 4: a new column 3 that is 1972-2022, 
and a new column 7 that is 1972-2022. Importantly,
make sure those regressions do not use any data from before 1972, 
i.e. the lags should begin in 1972.
*/


tsset year 
eststo ar1: reg rho L.rho L.b if year>=1972, r
eststo ar2: reg rho L.rho L.b, r //L.x is the first lag
eststo ar3: reg rho L.rho L.b if year>=1900, r
eststo ar4: reg rho L.rho L.b if year>=1985, r


esttab ar1 ar2  ar3 ar4 using "$project_code/out/prod/reg_ar1${version}.tex",   cells(b(fmt(%9.3f) ) se(par fmt(%9.3f))) replace ///
		order(  L.rho   L.b _cons) ///
		coeflabels( L.rho  "Lagged excess interest rate" L.b "Lagged debt/GDP" _cons "Constant")  ///
			mtitles("1972-2023" "1793-2023" "1900-2023" "1985-2023") ///
	collabels(none) stats(N rmse, fmt(%9.0g %9.3f) labels("N" "Std. dev. of residuals"))
	

/* Inputs for models*/

	
global version = "_constrained"
#d					;
matrix 			input table=(0,0,0,0,0,0,0);
#d				cr



sort year
tsset year 
g rho_lhs = rho if _n==1 
replace rho_lhs = rho -${beta_2_cbo} *b[_n-1] if _n>=2

	
/* Fit beta: response to debt*/

eststo ar0: reg rho L.rho L.b  if year>=1972, r
matrix			table[1, 1]=_b[L1.rho]
matrix			table[1, 2]=_b[_cons]
matrix			table[1, 3]=e(rmse)


// cap drop resid
// predict double resid, residuals
// summarize resid
// matrix			table[1, 3]=r(sd)


eststo ar0: reg rho_lhs L.rho  if year>=1972, r //L.x is the first lag
matrix			table[1, 4]=_b[L1.rho]
matrix			table[1, 5]=_b[_cons]
matrix			table[1, 6]=e(rmse)

// cap drop resid
// predict double resid, residuals
// summarize resid
//  matrix			table[1, 6]=r(sd)

eststo ar1: reg rho_lhs L.rho, r  //L.x is the first lag
eststo ar2: reg rho_lhs L.rho if year>=1900, r
eststo ar3: reg rho_lhs L.rho if year>=1985, r


esttab ar0 ar1 ar2 ar3  using "$project_code/out/prod/reg_ar1${version}.tex",   cells(b(fmt(%9.3f) ) se(par fmt(%9.3f))) replace ///
		order(_cons  L.rho  ) ///
		coeflabels(_cons "Constant" L.rho  "Lagged rho")  ///
			mtitles("1972-2023" "1793-2023" "1900-2023" "1990-2023") ///
	collabels(none) 	
	


gen rminusg_pp = rminusg*100
cap drop restricted_area
g restricted_area = 30 if restricted == 1
replace restricted_area = -30 if restricted == 0

// Figure: Evolution of r - g over time

// twoway (area restricted_area year,   color(gs14) base(-30)) ///
// (scatter rminusg_pp year, c(l) lwidth(thick) color("$c4") m(i) xlabel(1800(20)2020)) ///
// (scatter rminusg_pp year if year >= 1990, c(l) lwidth(thick) color("$c3") m(i) xlabel(1800(20)2020)) ///
// (scatter rminusg_pp year, c(l) lpattern(shortdash) lwidth(thick) color("$c4") m(i) xlabel(1800(20)2020)), ///
// xtitle("") subtitle("r-g (in percentage points)", size(medium) margin(medium)  justification(left)) ylabel(-30(10)30)  legen(position(bottom)  label(1 "periods omitted in restricted sample") label(2 "r-g (1793+)") label(3 "r-g (1990+)") order( 2 3 1))
// graph export "out/prod/plot_rminusg_1793.png", replace



// e: poisson shocks
clear
cd "$project_code"
import delimited "/Users/tcejka/Documents/repo/debt/stata/raw/55022-2023-07-Historical-Economic-Data/2023-07-Historical-Economic-Data/Annual_FY_July2023.csv", clear
rename date year
rename potential_gdp pgdp
keep year pgdp
merge 1:1 year using "dta/historicaldebtevolution_cleaned.dta"
drop gdp
rename pgdp gdp
drop if gdp == "NA"
destring gdp, replace



g b = debt/gdp


keep year b
sort year
tsset year

foreach year of numlist 1934 1929 1928 2009 2007 2006 2021 2020 2014  2019 2018  {
	g b`year' = b if year == `year'
	egen b_`year' = max(b`year')
}


g shock_1_raw = b_2020-b_2019
g shock_2_raw = b_2014-b_2007


duplicates drop shock_1_raw, force
g e_s_size = (shock_1_raw+shock_2_raw)/2

global e_s_size = e_s_size[_n==1]
di $e_s_size

matrix			table[1, 7]=$e_s_size


clear
svmat				table


rename table1  beta_1_risk
rename table2  cons_risk
rename table3  s_u_hat_risk
rename table4 beta_1
rename table5 cons
rename table6  s_u_hat
rename table7  e_s_size



save		"$project_code/dta/sims_inputs${version}.dta", replace



cd "$project_code/do/"





