
cap program drop sim_full
program define sim_full, rclass
		args c d s_u e_s_size rep initial 
		drop _all
		set obs $obs 
		//start 
	// local c = 0.02
	// 	local d = 0
	// 	local s_u = $s_u_hat
	// 	local e_s_size = $e_s_size
	// 	local rep =1
	// 	local sudden_increase =0.02
	// 	global sudden_threshold = 0.02
	// 	set seed 1000
// 		//end
		
		local c_name=round(`c' *100,1 ) 

		local d_name=round(`d' *100,1 ) 
		
		local theta = $theta
		if "`initial'" == "_model_prod_low_theta" {
			local theta = 0.9
		}
		
		//different s_u
		if "`initial'" == "_model_prod_high_var" {
			local s_u = 0.066
		}
		//different phis 
		if "`initial'" == "_model_prod_low_beta2" {
			local beta_2 = 0.008

		}
		else if "`initial'" == "_model_prod_zero_beta2" {
			local beta_2 = 0
		} 
		else	{
			local beta_2 = $beta_2
		}

		//different lambdas
		if "`initial'" == "_model_prod_zero_lambda" {
			local lambda = 0

		}
		else if "`initial'" == "_model_prod_high_lambda" {
			local lambda = .04
		} 
		else	{
			local lambda = $lambda
		}
				
		local a_u = $rminusg_0-${beta_1}*$rminusg_0-`beta_2'

 

		//calculate a_s s.t. s(1) = -.025 
		local a_s = -.025  // will be multiplied by zero when theta = 1
		
		
		if "`initial'" == "_model_prod_low_s" {
			local a_s = -0.04
		}
		else if "`initial'" == "_model_prod_high_s" {
			local a_s = -.01
		} 
	
		g a_s = `a_s'
		g lambda = `lambda'
		g e_u = rnormal(0, `s_u' )

		if "${no_rminusg}" == "_no_rminusg" {
			replace e_u = 0
		}

		if "${no_poisson}" == "_no_poisson" {
			local e_s_size = 0
		}

		g e_s = `e_s_size' * rpoisson(`lambda') //negative if enters through primary balance eq
		if "`initial'" == "_model_prod_zero_lambda" {
			replace e_s = `e_s_size' * rpoisson(.02) 
			replace e_s = 0
		} 
		//just need to take draws from poisson, doesn't matter what lambda is

		// FIRST PERIOD
		g 	rminusg = $rminusg_0 if _n<=2
		g 	b = $b_0 if _n==1
		g   s= a_s  if _n<=2 // initialize at a_s

		// get b in t=2
		replace b = (1+rminusg)*b[_n-1] + e_s - s if _n==2
		
		// loop
		forvalues i = 3(1)$last_period {

			replace rminusg = `a_u' + ${beta_1}*rminusg[_n-1] + `beta_2'*b[_n-1] + e_u if _n==`i'
		
			
			
			replace s = `theta'*s[_n-1] + (1-`theta')*`a_s' + `c'*(rminusg*b[_n-1] - `theta'*s[_n-1]-(1-`theta')*`a_s' ) + `d' * (b[_n-1] - $b_0 )  if _n==`i'
			
	
			
			replace	b = (1+rminusg)*b[_n-1] + e_s - s if _n==`i' // additive shock

		}
				
		//extra two periods: 102, 103
		replace e_u = 0 if _n>=102
		replace e_s = 0 if _n>=102

		forvalues i = 102(1)103 {

			replace rminusg = $rminusg_0 + `beta_2'*(b[_n-1]- $b_0 ) if _n==`i'

			replace s = `theta'*s[_n-1] + (1-`theta')*`a_s' + `c'*(rminusg*b[_n-1] - `theta'*s[_n-1]-(1-`theta')*`a_s' ) + `d' * (b[_n-1] - $b_0 )  if _n==`i'


			
			replace	b = (1+rminusg)*b[_n-1] - s if _n==`i' 
		}
		
		//for diag
		g c = `c'
		g d = `d'
		g theta = `theta'
		g a_u = `a_u'
		g beta_1 = $beta_1
		g beta_2 = `beta_2'
		g s_u = `s_u'
		
		di "Done"
		di `rep'
		g rep = `rep'
		g year = _n
		if `rep' == 1 {
			save "$project_code/out/sdsa/temp/sim_ar_${reps}_`c_name'_`d_name'_${periods}_years${no_poisson}${s_u_str}_full${ss}${add}${no_rminusg}${version}`initial'.dta", replace
		}
		else {
			append using "$project_code/out/sdsa/temp/sim_ar_${reps}_`c_name'_`d_name'_${periods}_years${no_poisson}${s_u_str}_full${ss}${add}${no_rminusg}${version}`initial'.dta"
			save "$project_code/out/sdsa/temp/sim_ar_${reps}_`c_name'_`d_name'_${periods}_years${no_poisson}${s_u_str}_full${ss}${add}${no_rminusg}${version}`initial'.dta", replace
		}
end



cap program drop sim_full_sudden_alt
program define sim_full_sudden_alt, rclass
		args sudden_threshold sudden_increase s_u e_s_size rep initial years_constraint
		drop _all
		// global obs_plus_10 = $obs + 10
		set obs $obs 
		//start 
		// global c = 0
		// global d = 0
		// local s_u = $s_u_hat
		// local e_s_size = $e_s_size
		// local years_constraint = 30
		// local rep =1
		// local sudden_increase =0.015
		// local sudden_threshold = 0.02
		// local initial = "_model_prod_high_s"
		// global initial = "_model_prod"
		// global no_poisson = "_no_poisson" 
		// global no_rminusg = "_no_rminusg" 
		// set seed 1000
 		//end

		local years_constraint_suffix = ""

		if `years_constraint' != 30 {
			local years_constraint_suffix = "_" + "`years_constraint'"
		}
		
		local c_name=round($c *100,1 ) 

		local d_name=round($d *100,1 ) 
		
		local sudden_increase_name=round(`sudden_increase' *1000,1 ) 

		
		local theta = $theta

 
		if "`initial'" == "_model_prod_low_theta" {
			local theta = 0.9
		}

		//different s_u
		if "`initial'" == "_model_prod_high_var" {
			local s_u = 0.066
		}
		
		//different phis 
		if "`initial'" == "_model_prod_low_beta2" {
			local beta_2 = 0.008

		}
		else if "`initial'" == "_model_prod_zero_beta2" {
			local beta_2 = 0
		} 
		else	{
			local beta_2 = $beta_2
		}

		//different lambdas
		if "`initial'" == "_model_prod_zero_lambda" {
			local lambda = 0

		}
		else if "`initial'" == "_model_prod_high_lambda" {
			local lambda = .04
		} 
		else	{
			local lambda = $lambda
		}
		
		local a_u = $rminusg_0-${beta_1}*$rminusg_0-`beta_2'

		local a_s = -.025  // will be multiplied by zero when theta = 1
		

		if "`initial'" == "_model_prod_low_s" {
			local a_s = -0.04
		}
		else if "`initial'" == "_model_prod_high_s" {
			local a_s = -.01
		} 
		

		g a_s = `a_s'
		g lambda = `lambda'
		g e_u = rnormal(0, `s_u' )

		if "${no_rminusg}" == "_no_rminusg" {
			replace e_u = 0
		}

		
		if "${no_poisson}" == "_no_poisson" {
			local e_s_size = 0
		}

		g e_s = `e_s_size' * rpoisson(`lambda') //negative if enters through primary balance eq
		if "`initial'" == "_model_prod_zero_lambda" {
			replace e_s = `e_s_size' * rpoisson(.02) 
			replace e_s = 0
		} 
		//just need to take draws from poisson, doesn't matter what lambda is

		// GET R
		global 	gnom = .035
		global 	pi= .02
		// FIRST PERIOD
		g rminusg=${rminusg_0} if _n==1
		g b=${b_0} if _n==1
		g s=a_s if _n==1
		g sudfeed=0 if _n==1
		g lastsudfeed=-999 if _n==1
		g year = _n

		foreach varroot in rminusgfwd bfwd rrealfwd rnifwd {
			forv fwd=0/10 {
				gen `varroot'`fwd'=.
			}
		}
		drop rminusgfwd0 rrealfwd0 rnifwd0
		gen rnifwdavg=.
		// compute r_net_ave 
		
		forv t=2/101 {
			*(A) SET LAST SUDDEN FEEDBACK YEAR, BASED ON LAST YEAR'S ACTIONS
			replace lastsudfeed=year[_n-1] if sudfeed[_n-1]>0 & year==`t'
			replace lastsudfeed=lastsudfeed[_n-1] if lastsudfeed==. & year==`t'
			*(B) SET rminusg_t, BASED ON LAST YEAR'S rminusg AND THIS YEAR'S SHOCK
			replace rminusg=`a_u' + ${beta_1}*rminusg[_n-1] 	+ `beta_2' *b[_n-1] + e_u if year==`t'
			*(C) SET 10-YEAR-FORWARD VARS
			**FIRST SET THE rminusg AND B VARS FOR FORWARD YEARS 0-1
			replace bfwd0=b[_n-1] if year==`t'
			replace rminusgfwd1=rminusg if year==`t'
			replace bfwd1=(1+rminusgfwd1)*bfwd0-s[_n-1] if year==`t'

			**THEN ROLL rminusg AND THEN B FORWARD FOR FORWARD YEARS 2-10
			forv fwd=2/10 {
				local fwdminus1 = `fwd'-1
				replace rminusgfwd`fwd' = `a_u' + ${beta_1}*rminusgfwd`fwdminus1' + `beta_2'*bfwd`fwdminus1' if year==`t'
				replace bfwd`fwd' = (1+rminusgfwd`fwd')*bfwd`fwdminus1'-s[_n-1] if year==`t'
			}
			**THEN COMPUTE THE REAL RATE AND REAL NET INTEREST FOR EVERY FORWARD YEAR
			forv fwd=1/10 {
				local fwdminus1 = `fwd'-1
				replace rrealfwd`fwd' = rminusgfwd`fwd'*(1+${gnom}) + ${gnom} - ${pi} if year==`t'
				replace rnifwd`fwd' = rrealfwd`fwd'*bfwd`fwdminus1' if year==`t'
			}

			**FINALLY COMPUTE THE TEN-YEAR-FORWARD AVERAGE REAL NET INTEREST
			replace rnifwdavg = (rnifwd1+rnifwd2+rnifwd3+rnifwd4+rnifwd5+rnifwd6+rnifwd7+rnifwd8+rnifwd9+rnifwd10)/10 if year==`t'
			*(D) SET SUDDEN FEEDBACK
			replace sudfeed=`sudden_increase' if rnifwdavg>`sudden_threshold' & rnifwd10>`sudden_threshold' & year-lastsudfeed>=`years_constraint' & year==`t'
			replace sudfeed=0 if sudfeed==. & year==`t'
			*(E) SET SURPLUS (ASSUMES THETA=1)
			replace s = `theta'*s[_n-1] + (1-`theta')*`a_s' + $c *(rminusg*b[_n-1] - `theta'*s[_n-1]-(1-`theta')*`a_s' ) + $d * (b[_n-1] - $b_0 ) + sudfeed if year==`t'
			*(F) SET DEBT
			replace b = (1+rminusg)*b[_n-1] - s + e_s if year==`t'
		}
				
		//extra two periods: 102, 103
		replace e_u = 0 if _n>=102
		replace e_s = 0 if _n>=102

		forvalues i = 102(1)103 {
			replace rminusg = $rminusg_0 + `beta_2'*(b[_n-1]- $b_0 ) if _n==`i'
			replace s = `theta'*s[_n-1] + (1-`theta')*`a_s' + $c *(rminusg*b[_n-1] - `theta'*s[_n-1]-(1-`theta')*`a_s' ) + $d * (b[_n-1] - $b_0 )  if _n==`i'

			replace	b = (1+rminusg)*b[_n-1] - s if _n==`i' 
		}
		
		//for diag
		g c = $c
		g d = $d
		g theta = `theta'
		g a_u = `a_u'
		g beta_1 = $beta_1
		g beta_2 = `beta_2'
		g s_u = `s_u'
	
		di "Done"
		di `rep'
		g rep = `rep'
		keep if _n<=103
		if `rep' == 1 {
			save "$project_code/out/sdsa/temp/sim_ar_${reps}_`c_name'_`d_name'_`sudden_increase_name'_${periods}_years${no_poisson}${s_u_str}_full${ss}${add}${no_rminusg}${version}`initial'`years_constraint_suffix'.dta", replace
		}
		else {
			append using "$project_code/out/sdsa/temp/sim_ar_${reps}_`c_name'_`d_name'_`sudden_increase_name'_${periods}_years${no_poisson}${s_u_str}_full${ss}${add}${no_rminusg}${version}`initial'`years_constraint_suffix'.dta"
			save "$project_code/out/sdsa/temp/sim_ar_${reps}_`c_name'_`d_name'_`sudden_increase_name'_${periods}_years${no_poisson}${s_u_str}_full${ss}${add}${no_rminusg}${version}`initial'`years_constraint_suffix'.dta", replace
		}
end



