// Our Sims

// 0. 
//fixed globals
global version = "_constrained"
global add = ""
global ss = "_ss" 
global periods = 100
global vars "e_u  e_s  rminusg  b s"
global obs = $periods + 3
global last_period = $periods + 1 
global reps = 1000
global s_u_str = ""


clear all 
cd "$project_code"

use "dta/sims_inputs${version}.dta", clear

//intitialize
global b_0 = 1
global rminusg_0 = -.005
global beta_2 = 0.004 //CBO estimate
global e_s_size = 0.25
global lambda = .02
global beta_1 = beta_1_risk[_n==1]
global s_u_hat = s_u_hat_risk[_n==1]
global theta = 1

di $rminusg_0-${beta_1}*$rminusg_0-$beta_2
di $beta_1
di $s_u_hat


drop _all
cd "$project_code/do/"
do m0_programs.do //loads two simulation programs: sim_full (for c and d channel) and sim_full_sudden (for sudden channel)


// c: main
global d = 0
global theta = 1

global initial = "_model_prod"

global no_poisson = "_no_poisson" 
global no_rminusg = "_no_rminusg" 
global reps = 1

foreach c of numlist 0 0.01 .02 0.03 0.04 0.05(0.05)1  {
	preserve
	set seed 1000 //want same draws for each c 
		forvalues rep=1(1)$reps {
			sim_full `c' $d $s_u_hat $e_s_size `rep' $initial
	}
	restore
}

global no_poisson = "" 
global no_rminusg = "" 
global reps = 1000

foreach c of numlist 0(0.01)0.20 0.25(0.05)1  {
	preserve
	set seed 1000 //want same draws for each c 
		forvalues rep=1(1)$reps {
			sim_full `c' $d $s_u_hat $e_s_size `rep' $initial
	}
	restore
}


// Only r-g risk
global no_poisson = "_no_poisson" 
global no_rminusg = "" 
global reps = 1000

foreach c of numlist 0 0.01 .02 0.03 0.04 0.05(0.05)1  {
	preserve
	set seed 1000 //want same draws for each c 
		forvalues rep=1(1)$reps {
			sim_full `c' $d $s_u_hat $e_s_size `rep' $initial
	}
	restore
}

// Only Poisson risk
global no_poisson = "" 
global no_rminusg = "_no_rminusg" 
global reps = 1000

foreach c of numlist 0 0.01 .02 0.03 0.04 0.05(0.05)1  {
	preserve
	set seed 1000 //want same draws for each c 
		forvalues rep=1(1)$reps {
			sim_full `c' $d $s_u_hat $e_s_size `rep' $initial
	}
	restore
}

// Phi=0 
global no_poisson = "" 
global no_rminusg = "" 
global reps = 1000

foreach c of numlist 0 0.01 .02 0.03 0.04 0.05(0.05)1  {
	preserve
	set seed 1000 //want same draws for each c 
		forvalues rep=1(1)$reps {
			sim_full `c' $d $s_u_hat $e_s_size `rep' "_model_prod_zero_beta2"
	}
	restore
}




//c: robustness 
global initial_list  "_model_prod_low_beta2" "_model_prod_zero_beta2" "_model_prod_low_theta" "_model_prod_low_s" "_model_prod_high_s" "_model_prod_zero_lambda" "_model_prod_high_lambda" "_model_prod_high_var"
// global initial_list  "_model_prod_high_var"
// global initial_list "_model_prod_low_s" "_model_prod_high_s"
// global initial_list "_model_prod_zero_lambda" 

global no_poisson = "_no_poisson" 
global no_rminusg = "_no_rminusg" 
global reps = 1

foreach i in $initial_list {
	preserve
	set seed 1000 //want same draws for each c 
		forvalues rep=1(1)$reps {
			sim_full 0.3 $d $s_u_hat $e_s_size `rep' "`i'"
}
	restore
}

global no_poisson = "" 
global no_rminusg = "" 
global reps = 1000

foreach i in $initial_list {
	preserve
	set seed 1000 //want same draws for each c 
		forvalues rep=1(1)$reps {
			sim_full 0.3 $d $s_u_hat $e_s_size `rep' "`i'"
}
	restore
}




// d: main
global c = 0
global theta = 0
global initial = "_model_prod"

global no_poisson = "_no_poisson" 
global no_rminusg = "_no_rminusg" 
global reps = 1

foreach d of numlist 0.01 .02 0.03 0.04 0.05(0.05)1  {
	preserve
	set seed 1000 //want same draws for each c 
		forvalues rep=1(1)$reps {
			sim_full $c `d' $s_u_hat $e_s_size `rep' $initial
	}
	restore
}


global no_poisson = "" 
global no_rminusg = "" 
global reps = 1000


foreach d of numlist 0(0.01)0.20 0.25(0.05)1  {
	preserve
	set seed 1000 //want same draws for each c 
		forvalues rep=1(1)$reps {
			sim_full $c `d' $s_u_hat $e_s_size `rep' $initial
	}
	restore
}


// Only r-g risk
global no_poisson = "_no_poisson" 
global no_rminusg = "" 
global reps = 1000

foreach d of numlist 0 0.01 .02 0.03 0.04 0.05(0.05)1  {
	preserve
	set seed 1000 //want same draws for each c 
		forvalues rep=1(1)$reps {
			sim_full $c `d' $s_u_hat $e_s_size `rep' $initial
	}
	restore
}

// Only Poisson risk
global no_poisson = "" 
global no_rminusg = "_no_rminusg" 
global reps = 1000

foreach d of numlist 0 0.01 .02 0.03 0.04 0.05(0.05)1  {
	preserve
	set seed 1000 //want same draws for each c 
		forvalues rep=1(1)$reps {
			sim_full $c `d' $s_u_hat $e_s_size `rep' $initial
	}
	restore
}

// Phi=0 
global no_poisson = "" 
global no_rminusg = "" 
global reps = 1000

foreach d of numlist 0 0.01 .02 0.03 0.04 0.05(0.05)1  {
	preserve
	set seed 1000 //want same draws for each c 
		forvalues rep=1(1)$reps {
			sim_full $c `d' $s_u_hat $e_s_size `rep' "_model_prod_zero_beta2"
	}
	restore
}



//d: robustness 
global initial_list  "_model_prod_low_beta2" "_model_prod_zero_beta2" "_model_prod_low_theta" "_model_prod_low_s" "_model_prod_high_s" "_model_prod_zero_lambda" "_model_prod_high_lambda" "_model_prod_high_var"
// global initial_list  "_model_prod_high_var"
// global initial_list "_model_prod_low_s" "_model_prod_high_s"
// global initial_list "_model_prod_zero_lambda" 

global no_poisson = "_no_poisson" 
global no_rminusg = "_no_rminusg" 
global reps = 1

foreach i in $initial_list {
	preserve
	set seed 1000 //want same draws for each c 
		forvalues rep=1(1)$reps {
			sim_full $c 0.05 $s_u_hat $e_s_size `rep' "`i'"
}
	restore
}

global no_poisson = "" 
global no_rminusg = "" 
global reps = 1000

foreach i in $initial_list {
	preserve
	set seed 1000 //want same draws for each c 
		forvalues rep=1(1)$reps {
			sim_full $c 0.05 $s_u_hat $e_s_size `rep' "`i'"
}
	restore
}

//si r: main
global add = "_sudden_r" 	
global theta = 1
global sudden_threshold = 0.02
global d =0
global c =0
global years_constraint = 30

global initial = "_model_prod"

global no_poisson = "_no_poisson" 
global no_rminusg = "_no_rminusg" 
global reps = 1

foreach sudden_increase of numlist 0.015 {
	preserve
	set seed 1000 //want same draws for each c 
		forvalues rep=1(1)$reps {
			sim_full_sudden_alt $sudden_threshold `sudden_increase' $s_u_hat $e_s_size `rep' $initial $years_constraint
	}
	restore
}

foreach years_constraint of numlist  10(1)29 31(1)50  {
	preserve
	set seed 1000 //want same draws for each c 
		forvalues rep=1(1)$reps {
			sim_full_sudden_alt $sudden_threshold 0.015 $s_u_hat $e_s_size `rep' $initial `years_constraint'
	}
	restore
}

global no_poisson = "" 
global no_rminusg = "" 
global reps = 1000


foreach sudden_increase of numlist 0.015 {
	preserve
	set seed 1000 //want same draws for each c 
		forvalues rep=1(1)$reps {
			sim_full_sudden_alt $sudden_threshold `sudden_increase' $s_u_hat $e_s_size `rep' $initial $years_constraint
	}
	restore
}

foreach years_constraint of numlist 10(1)29 31(1)50  {
	preserve
	set seed 1000 //want same draws for each c 
		forvalues rep=1(1)$reps {
			sim_full_sudden_alt $sudden_threshold 0.015 $s_u_hat $e_s_size `rep' $initial `years_constraint'
	}
	restore
}


// Only r-g risk
global no_poisson = "_no_poisson" 
global no_rminusg = "" 
global reps = 1000


foreach sudden_increase of numlist 0.015 {
	preserve
	set seed 1000 //want same draws for each c 
		forvalues rep=1(1)$reps {
			sim_full_sudden_alt $sudden_threshold `sudden_increase' $s_u_hat $e_s_size `rep' $initial $years_constraint
	}
	restore
}


foreach years_constraint of numlist 10(1)29    {
	preserve
	set seed 1000 //want same draws for each c 
		forvalues rep=1(1)$reps {
			sim_full_sudden_alt $sudden_threshold 0.015 $s_u_hat $e_s_size `rep' $initial `years_constraint'
	}
	restore
}
// Only Poisson risk
global no_poisson = "" 
global no_rminusg = "_no_rminusg" 
global reps = 1000


foreach sudden_increase of numlist 0.015 {
	preserve
	set seed 1000 //want same draws for each c 
		forvalues rep=1(1)$reps {
			sim_full_sudden_alt $sudden_threshold `sudden_increase' $s_u_hat $e_s_size `rep' $initial $years_constraint
	}
	restore
}

foreach years_constraint of numlist 1(1)29  {
	preserve
	set seed 1000 //want same draws for each c 
		forvalues rep=1(1)$reps {
			sim_full_sudden_alt $sudden_threshold 0.015 $s_u_hat $e_s_size `rep' $initial `years_constraint'
	}
	restore
}
// Phi=0 
global no_poisson = "" 
global no_rminusg = "" 
global reps = 1000


foreach sudden_increase of numlist 0.015 {
	preserve
	set seed 1000 //want same draws for each c 
		forvalues rep=1(1)$reps {
			sim_full_sudden_alt $sudden_threshold `sudden_increase' $s_u_hat $e_s_size `rep' "_model_prod_zero_beta2" $years_constraint
	}
	restore
}


foreach years_constraint of numlist 1(1)29  {
	preserve
	set seed 1000 //want same draws for each c 
		forvalues rep=1(1)$reps {
			sim_full_sudden_alt $sudden_threshold 0.015 $s_u_hat $e_s_size `rep' "_model_prod_zero_beta2" `years_constraint'
	}
	restore
}


//si r: robustness 
global initial_list  "_model_prod_low_beta2" "_model_prod_zero_beta2" "_model_prod_low_theta" "_model_prod_low_s" "_model_prod_high_s" "_model_prod_zero_lambda" "_model_prod_high_lambda" "_model_prod_high_var" 
// global initial_list "_model_prod_s_05" "_model_prod_s_10" "_model_prod_s_30"  "_model_prod_s_40" "_model_prod_s_45"
// global initial_list "_model_prod_low_s" "_model_prod_high_s"
// global initial_list "_model_prod_low_s" "_model_prod_high_s" "_model_prod_s_10"  "_model_prod_s_40"

global years_constraint = 30
// global years_constraint = 10

global no_poisson = "_no_poisson" 
global no_rminusg = "_no_rminusg" 
global reps = 1


foreach i in $initial_list {
	preserve
	set seed 1000 //want same draws for each c 
		forvalues rep=1(1)$reps {
			sim_full_sudden_alt $sudden_threshold 0.015 $s_u_hat $e_s_size `rep' "`i'" $years_constraint
			}
			restore
}


global no_poisson = "" 
global no_rminusg = "" 
global reps = 1000


foreach i in $initial_list {
	preserve
	set seed 1000 //want same draws for each c 
		forvalues rep=1(1)$reps {
			sim_full_sudden_alt $sudden_threshold 0.015 $s_u_hat $e_s_size `rep' "`i'" $years_constraint
}
	restore
}


cd "$project_code/do/"








