clear all 
cd "$project_code"

import excel "dta/CBO10yr_v4_to_read.xlsx", firstrow

* Create the graph
graph twoway (line b year if type == "CBO",c(l) lwidth(medthick) color("$c1") lpattern("$l1") m(i)) ///
(line b year if type == "Deficit feedback",c(l) lwidth(medthick) color("$c2") lpattern("$l2") m(i)) ///
(line b year if type == "Debt feedback",c(l) lwidth(medthick) color("$c3") lpattern("$l3") m(i)), ///
xtitle("") ytitle("Debt-GDP ratio", size(medium) margin(medium) justification(left)) ylabel(0(0.2)1) ///
xlab(, nogrid) ylab(,grid glpattern(solid) glwidth(vthin) glcolor(gs15)) ///
 legend(position(bottom) r(1) order(1  "Actual" 2 "Counterfactual: Deficit feedback c=0.3" 3 "Counterfactual: Debt feedback d=0.05" ) size(small))

graph export "out/prod/cbo_vs_xfactual.png", replace

cd "$project_code/do/"
