clear all 
cd "$project_code"

**De-facto phi graph from CBO LTBO. 

import excel "raw/51119-2024-03-LTBO-budget - 2024-2054 LTBO INPUTS FOR EXCESS INTEREST.xlsx", ///
sheet("1. Summary Ext Baseline") firstrow clear ///
cellrange(A10:AC41) 

keep revenue outlays interest gdp  debt Fiscalyear
* Perform necessary data transformations and calculations here
tsset Fiscalyear

gen b = debt / gdp
// gen s = (revenue - outlays + interest) / gdp
// gen r = interest / gdp

gen deficit = outlays - revenue
gen primarydeficit = deficit - interest
gen s = - primarydeficit/gdp
gen i = interest/(debt[_n-1] + .5*primarydeficit)
//need primarydeficit
// need  i = interest/(debt[_n-1] + .5*primarydeficit)


gen g = gdp / l1.gdp -1
gen rho = (i - g) / (1 + g)
g l1b = l1.b
g l2b = l2.b
g l1r = l1.rho

gen implied_rho = (rho - l1.rho) / (l1.b - l2.b)

* Create the graph
graph twoway (line implied_rho Fiscalyear if Fiscalyear >= 2027,  ///
xtitle("") xlab(2025(5)2055, nogrid) ylab(, grid glpattern(solid) glwidth(vthin) glcolor(gs15)) ///
 ytitle("Annual pp. change in the excess interest rate divided by" ///
"annual pp. change in the debt-ratio") ylabel(0(0.010)0.08) ///
 c(l) lwidth(medthick) color("$c1") lpattern("$l1") m(i))

graph export "out/prod/implied_phi_cbo.png", replace

 cd "$project_code/do/"

    