********************************************************************************
******* Program run different specifications of CBO feedback regression *******
********************************************************************************

clear all 

cd "$project_code" 

**** Load regression dataset ****
use  "dta/merged_budget_rminusg_data.dta", clear
keep  year gdp pgdp  debt b primarysurplus r
duplicates drop 
// check that year has no duplicates
bysort year: gen tot_year = sum(year)
drop if tot_year>3000

isid year
sort year
tsset year 
 g b_l1 = b[_n-1]

// need surplus_t0
forvalues lead = 0(1)5 {
		g pgdp_lead_`lead' = .
}

forvalues lag = 1(1)2 {
		g pgdp_lag_`lag' =.
		g b_lag_`lag' = .

}

forvalues lead = 0(1)5 {
		replace pgdp_lead_`lead' = F`lead'.pgdp 

}

forvalues lag = 1(1)2 {
		replace pgdp_lag_`lag' = L`lag'.pgdp 
		replace b_lag_`lag' = L`lag'.b 

}

*COMPUTE EXPECTED b BASED ON PGDP
gen gnomexp_t0 = pgdp_lead_0/pgdp_lag_1 - 1
forv t=1/4 {
	local tminus1 = `t'-1
	gen gnomexp_t`t' = pgdp_lead_`t'/pgdp_lead_`tminus1' - 1
}

save "dta/merged_budget_rminusg_data_yearly.dta", replace

//do "code/create_regress_dataset.do" 
use "dta/excess_interest_analysis_data.dta" if source=="cbohistorical", clear
g surplus_raw = - deficit
g primarysurplus = - primarydeficit
keep year     surplus_raw   primarysurplus   interest

sort year
// add a new last row to this dataset 
expand 2 if _n == _N
replace year = 2024 if _n == _N
replace surplus_raw = . if _n == _N
replace primarysurplus = . if _n == _N
replace interest = . if _n == _N


//Extended table vars
//Replace surplus_exp with lagged interest/potentialGDP
g interest_l1 = interest[_n-1]
g surplus_raw_l1 = surplus_raw[_n-1]

merge m:1 year using "dta/merged_budget_rminusg_data_yearly.dta"
drop _merge

g r_l1 = r[_n-1]

g interest_pgdp_l1 = interest_l1/pgdp_lag_1 

// Replace surplus_exp with lagged interest/GDP
g interest_gdp_l1 = interest_l1/gdp[_n-1] 

//Add lagged realinterest/potentialGDP 
// (define real interest as the lagged real interest rate from your historical data set times 
//  lagged debt divided by potential GDP)
g realinterest_pgdp_l1 = (r_l1*debt[_n-1])/pgdp_lag_1 // r is real interest rate from historical data set

//Replace surplus_exp with lagged primarysurplus/potentialGDP
g primarysurplus_pgdp_l1 = primarysurplus[_n-1]/pgdp_lag_1


//Replace surplus_exp with lagged surplus/potentialGDP
g surplus_pgdp_l1 = surplus_raw_l1/pgdp_lag_1

save "dta/excess_interest_and_merged_yearly.dta", replace


use  "dta/merged_budget_rminusg_data.dta", clear
merge m:1 year using "dta/excess_interest_and_merged_yearly.dta"
keep if year>=1983

keep if _merge!=2
drop _merge


*COMPUTE EXPECTED b BASED ON PGDP
gen deltabexp_t0 = -1*surplus_t0/pgdp_lead_0 - gnomexp_t0/(1+gnomexp_t0)*b_lag_1
gen bexp_t0 = b_lag_1 + deltabexp_t0
forv t=1/4 {
	local tminus1 = `t'-1	
	gen deltabexp_t`t' = -1*surplus_t`t'/pgdp_lead_`t' - gnomexp_t`t'/(1+gnomexp_t`t')*bexp_t`tminus1'
	gen bexp_t`t' = bexp_t`tminus1' + deltabexp_t`t'
}

*COMPUTE EXPECTED CHANGE IN b
gen deltabexp_t0_t4 = bexp_t4 - b_lag_1
replace deltabexp_t0_t4 = deltabexp_t0_t4/5


// Control for a quartic in the lagged output gap
g lag_outgap_pgdp2 = lag_outgap_pgdp^2
g lag_outgap_pgdp3 = lag_outgap_pgdp^3
g lag_outgap_pgdp4 = lag_outgap_pgdp^4

********************************************************************************
******* Run Regression *******
********************************************************************************

gen periodid = string(report_year) + "0" + string(report_half)
destring periodid, replace
// Replication of Table 2 
gen sample_0 = 1 if periodid <= 202402
gen sample_1= periodid >= 198402 & periodid <= 200301 //Tab 2A Years 1984 through 2003 (original Auerbach 2003 period)
gen sample_2= periodid >= 200401 & periodid <= 202402 & periodid !=202002 //Tab 2B: Years 2004 through 2024
gen sample_3= periodid >= 200401 & periodid <= 202402 & periodid !=202002 //Appendix 1A: Years 2004 through 2024
gen sample_4= periodid >= 200401 & periodid <= 202402  //Appendix 1B: Years 2004 through 2024, inc 202002
gen sample_5= periodid >= 198402 & periodid <= 202402  & periodid !=202002 //Appendix 2A: Years 1984 through 2024
gen sample_6= periodid >= 198402 & periodid <= 202402  //Appendix 2A: Years 1984 through 2024, inc 202002
** Create vars **
//debt
sort report_year report_half

browse periodid surplus lag_outgap_pgdp surplus_exp interest pgdp gdp interest_pgdp_l1 interest_gdp_l1  r realinterest_pgdp_l1 ///
 primarysurplus primarysurplus_pgdp_l1 surplus_t0 surplus_pgdp_l1 b b_lag_1 deltabexp_t0_t4
order periodid surplus lag_outgap_pgdp surplus_exp interest pgdp gdp interest_pgdp_l1 interest_gdp_l1  r realinterest_pgdp_l1 ///
 primarysurplus primarysurplus_pgdp_l1 surplus_t0 surplus_pgdp_l1 b b_lag_1 deltabexp_t0_t4
preserve
keep periodid surplus lag_outgap_pgdp surplus_exp interest pgdp gdp interest_pgdp_l1 interest_gdp_l1  r realinterest_pgdp_l1 ///
 primarysurplus primarysurplus_pgdp_l1 surplus_t0 surplus_pgdp_l1 b b_lag_1 deltabexp_t0_t4
export delimited "dta/tab_2_diag_data.csv", replace
restore 
//panel a 
forv i=1/2 {

    preserve
    keep if sample_`i' == 1

    //start
    // keep periodid surplus lag_outgap_pgdp surplus_exp _est* interest_pgdp_l1
    // sort periodid 
    // browse
    //end

    //baseline
    eststo r0: reg surplus lag_outgap_pgdp surplus_exp, r  

    //Replace surplus_exp with lagged interest/potentialGDP
    eststo r1: reg surplus lag_outgap_pgdp interest_pgdp_l1, r 
    //Add lagged interest/potentialGDP as a covariate along with surplus_exp 
    //(I'd like to see both coefficients and the coeff on lagged output gap, both here and analogously in the other bullets) 
    eststo r2: reg surplus lag_outgap_pgdp surplus_exp interest_pgdp_l1, r
    // Replace surplus_exp with lagged interest/GDP
    eststo r3: reg surplus lag_outgap_pgdp interest_gdp_l1, r
    eststo r4: reg surplus lag_outgap_pgdp surplus_exp interest_gdp_l1, r

    //Add lagged realinterest/potentialGDP 
    // (i.e.  as a covariate along with surplus_exp)
    eststo r5a: reg surplus lag_outgap_pgdp  realinterest_pgdp_l1, r

    eststo r5: reg surplus lag_outgap_pgdp surplus_exp realinterest_pgdp_l1, r

    //Replace surplus_exp with lagged primarysurplus/potentialGDP
    eststo r6: reg surplus lag_outgap_pgdp primarysurplus_pgdp_l1, r 

    //Add lagged primarysurplus/potentialGDP as a covariate along with surplus_exp
    eststo r7: reg surplus lag_outgap_pgdp surplus_exp primarysurplus_pgdp_l1, r

    //Replace surplus_exp with lagged surplus/potentialGDP
    eststo r8: reg surplus lag_outgap_pgdp surplus_pgdp_l1, r 

    //Add lagged surplus/potentialGDP as a covariate along with surplus_exp
    eststo r9: reg surplus lag_outgap_pgdp surplus_exp surplus_pgdp_l1, r

    esttab r0 r1 r2 r3 r4 r5a r5 r6 r7 r8 r9  using "out/prod/table_2_sample_`i'_extd.tex",    ///
        cells(b(fmt(%9.3f)) se(par fmt(%9.3f)))  replace ///
    label /// 
    collabels(none) ///
    mgroups("Primary surplus" "Primary surplus" "Primary surplus" "Primary surplus" "Primary surplus" "Primary surplus" "Primary surplus" "Primary surplus"  "Primary surplus" "Primary surplus" "Primary surplus", pattern(1 1 1 1 1 1  1 1 1 1 1)) mlabels(none)  ///
            order(  surplus_exp interest_pgdp_l1 interest_gdp_l1  realinterest_pgdp_l1 primarysurplus_pgdp_l1 surplus_pgdp_l1 lag_outgap_pgdp _cons) ///
            coeflabels( lag_outgap_pgdp "Lagged output gap"  surplus_exp "Projected surplus"  interest_pgdp_l1 "Lagged interest (to PGDP)" interest_gdp_l1 "Lagged interest (to GDP)" realinterest_pgdp_l1 "Lagged real interest (to PGDP)" primarysurplus_pgdp_l1 "Lagged primary surplus (to PGDP)" surplus_pgdp_l1 "Lagged  surplus (to PGDP)" _cons "Constant") ///
            stats(N r2, fmt(%9.0fc %9.2fc)) 

    esttab r0 r1 r2 r3 r4 r5a r5 r6 r7 r8 r9  using "out/prod/table_2_sample_`i'_extd.csv",    ///
        cells(b(fmt(%9.3f)) se(par fmt(%9.3f)))  replace ///
    label /// 
    collabels(none) ///
    mgroups("Primary surplus" "Primary surplus" "Primary surplus" "Primary surplus" "Primary surplus" "Primary surplus" "Primary surplus" "Primary surplus"  "Primary surplus" "Primary surplus" "Primary surplus", pattern(1 1 1 1 1 1  1 1 1 1 1)) mlabels(none)  ///
            order(  surplus_exp interest_pgdp_l1 interest_gdp_l1  realinterest_pgdp_l1 primarysurplus_pgdp_l1 surplus_pgdp_l1 lag_outgap_pgdp _cons) ///
            coeflabels( lag_outgap_pgdp "Lagged output gap"  surplus_exp "Projected surplus"  interest_pgdp_l1 "Lagged interest (to PGDP)" interest_gdp_l1 "Lagged interest (to GDP)" realinterest_pgdp_l1 "Lagged real interest (to PGDP)" primarysurplus_pgdp_l1 "Lagged primary surplus (to PGDP)" surplus_pgdp_l1 "Lagged  surplus (to PGDP)" _cons "Constant") ///
            stats(N r2, fmt(%9.0fc %9.2fc)) 
    restore
}

preserve
keep if sample_1 == 1
//make a binscatter of surplus residualized by lag_outgap_pgdp  (y axis)  and surplus_pgdp_l1 (x axis)  
**RESIDUALIZE
foreach var in surplus primarysurplus_pgdp_l1 {
	sum `var'
	local mean = r(mean)
	reg `var' lag_outgap_pgdp
	predict `var'_resid, resid
	replace `var'_resid = `var'_resid + `mean'
}
**CONFIRM RESIDUAL REGRESSION EXACTLY REPLICATES THE MAIN REGRESSION
reg surplus lag_outgap_pgdp primarysurplus_pgdp_l1, r 
reg surplus_resid primarysurplus_pgdp_l1_resid, r 

**MAKE BEST-FIT LINE AMONG RESIDUALS
reg surplus_resid primarysurplus_pgdp_l1_resid, r
predict surplus_resid_bestfit
gen report_half_char = "a"
replace report_half_char = "b" if report_half==2
gen periodidchar = string(report_year) + report_half_char

**PLOT SCATTER WITH LABELS
twoway (scatter surplus_resid_bestfit primarysurplus_pgdp_l1_resid, lc(cranberry) lp(solid) m(i) c(l)) ///
  || (scatter surplus_resid primarysurplus_pgdp_l1_resid, mlabel(periodidchar) mlabposition(0) mlabcolor(navy) ///
    mlabposition(3) msymbol(i) mcolor(none)), ///
  ytitle("Primary surplus residualized by lag_outgap_pgdp") ///
  xtitle("Lagged primarysurplus/pgdp residualized by lag_outgap_pgdp") ///
  xlab(, nogrid) ylab(, grid glpattern(solid) glwidth(vthin) glcolor(gs15)) ///
  legend(off)
graph export "out/diag_binscatter_primarysurplus.png", replace

restore

forv i=1/2 {

preserve
keep if sample_`i' == 1

eststo r1: reg surplus lag_outgap_pgdp lag_outgap_pgdp2 lag_outgap_pgdp3 lag_outgap_pgdp4 surplus_exp, r  
eststo r2: reg revenue lag_outgap_pgdp lag_outgap_pgdp2 lag_outgap_pgdp3 lag_outgap_pgdp4 surplus_exp, r
eststo r3: reg outlays lag_outgap_pgdp lag_outgap_pgdp2 lag_outgap_pgdp3 lag_outgap_pgdp4 surplus_exp, r
eststo r4: reg surplus lag_outgap_pgdp lag_outgap_pgdp2 lag_outgap_pgdp3 lag_outgap_pgdp4 deltabexp_t0_t4, r
eststo r5: reg surplus lag_outgap_pgdp lag_outgap_pgdp2 lag_outgap_pgdp3 lag_outgap_pgdp4 bexp_t4, r
eststo r6: reg surplus lag_outgap_pgdp lag_outgap_pgdp2 lag_outgap_pgdp3 lag_outgap_pgdp4 b_lag_1, r
eststo r7: reg surplus lag_outgap_pgdp lag_outgap_pgdp2 lag_outgap_pgdp3 lag_outgap_pgdp4 surplus_exp bexp_t4, r

esttab r1 r2 r3 r4 r5 r6 r7  using "out/prod/table_2_sample_`i'_extd2.tex",    ///
	cells(b(fmt(%9.3f)) se(par fmt(%9.3f)))  replace ///
label /// 
collabels(none) ///
mgroups("Primary surplus" "Revenues" "Primary outlays"  "Primary surplus" "Primary surplus"  "Primary surplus" "Primary surplus", pattern(1 1 1 1 1 1 1)) mlabels(none)  ///
		order(  surplus_exp deltabexp_t0_t4 bexp_t4  b_lag_1 lag_outgap_pgdp lag_outgap_pgdp2 lag_outgap_pgdp3 lag_outgap_pgdp4 _cons) ///
		coeflabels( lag_outgap_pgdp "Lagged output gap" lag_outgap_pgdp2 "Lagged output gap ^2" lag_outgap_pgdp3 "Lagged output gap ^3" lag_outgap_pgdp4 "Lagged output gap ^4" surplus_exp "Projected surplus"  bexp_t4 "Projected debt-GDP ratio" deltabexp_t0_t4 "Projected debt-GDP ratio change" b_lag_1 "Lagged debt-GDP ratio" _cons "Constant") ///
		stats(N r2, fmt(%9.0fc %9.2fc)) 

esttab r1 r2 r3 r4 r5 r6 r7  using "out/prod/table_2_sample_`i'_extd2.csv",    ///
	cells(b(fmt(%9.3f)) se(par fmt(%9.3f)))  replace ///
label /// 
collabels(none) ///
mgroups("Primary surplus" "Revenues" "Primary outlays"  "Primary surplus" "Primary surplus"  "Primary surplus" "Primary surplus", pattern(1 1 1 1 1 1 1)) mlabels(none)  ///
		order(  surplus_exp deltabexp_t0_t4 bexp_t4  b_lag_1 lag_outgap_pgdp lag_outgap_pgdp2 lag_outgap_pgdp3 lag_outgap_pgdp4 _cons) ///
		coeflabels( lag_outgap_pgdp "Lagged output gap" lag_outgap_pgdp2 "Lagged output gap ^2" lag_outgap_pgdp3 "Lagged output gap ^3" lag_outgap_pgdp4 "Lagged output gap ^4" surplus_exp "Projected surplus"  bexp_t4 "Projected debt-GDP ratio" deltabexp_t0_t4 "Projected debt-GDP ratio change" b_lag_1 "Lagged debt-GDP ratio" _cons "Constant") ///
		stats(N r2, fmt(%9.0fc %9.2fc)) 

restore
}

// Remove fiscal years with any recession months, plus the entire 2008-2012 fiscal years
// Remove fiscal years with any recession months, plus the entire 2008-2014 fiscal years 
g sample_1_restr_1 = sample_1 & (!inlist(year, 1990, 1991, 2001, 2008, 2009, 2020)) // Remove fiscal years with any recession months
g sample_2_restr_1 = sample_2 & (!inlist(year, 1990, 1991, 2001, 2008, 2009, 2020)) // Remove fiscal years with any recession months
g sample_1_restr_2 = sample_1_restr_1 & (!inrange(year, 2008, 2012)) // Remove fiscal years with any recession months, plus the entire 2008-2012 fiscal years
g sample_2_restr_2 = sample_2_restr_1 & (!inrange(year, 2008, 2012)) // Remove fiscal years with any recession months, plus the entire 2008-2012 fiscal years
g sample_1_restr_3 = sample_1_restr_1 & (!inrange(year, 2008, 2014)) // Remove fiscal years with any recession months, plus the entire 2008-2014 fiscal years
g sample_2_restr_3 = sample_2_restr_1 & (!inrange(year, 2008, 2014)) // Remove fiscal years with any recession months, plus the entire 2008-2014 fiscal years
g sample_1_restr_4 = sample_1_restr_2 & (!inlist(year, 2021)) // Remove fiscal years with any recession months, plus the entire 2008-2014 fiscal years
g sample_2_restr_4 = sample_2_restr_2 & (!inlist(year, 2021)) // Remove fiscal years with any recession months, plus the entire 2008-2014 fiscal years
g sample_1_restr_5 = sample_1_restr_3 & (!inlist(year, 2021)) // Remove fiscal years with any recession months, plus the entire 2008-2014 fiscal years
g sample_2_restr_5 = sample_2_restr_3 & (!inlist(year, 2021)) // Remove fiscal years with any recession months, plus the entire 2008-2014 fiscal years

forv sample_i=1/2 {
    forv restr_i=1/5 {

preserve
keep if sample_`sample_i'_restr_`restr_i' == 1

eststo r1: reg surplus lag_outgap_pgdp surplus_exp, r  
eststo r2: reg revenue lag_outgap_pgdp surplus_exp, r
eststo r3: reg outlays lag_outgap_pgdp surplus_exp, r
eststo r4: reg surplus lag_outgap_pgdp deltabexp_t0_t4, r
eststo r5: reg surplus lag_outgap_pgdp bexp_t4, r
eststo r6: reg surplus lag_outgap_pgdp b_lag_1, r
eststo r7: reg surplus lag_outgap_pgdp surplus_exp bexp_t4, r

esttab r1 r2 r3 r4 r5 r6 r7  using "out/prod/table_2_sample_`sample_i'_restr_`restr_i'.tex",    ///
	cells(b(fmt(%9.3f)) se(par fmt(%9.3f)))  replace ///
label /// 
collabels(none) ///
mgroups("Primary surplus" "Revenues" "Primary outlays"  "Primary surplus" "Primary surplus"  "Primary surplus" "Primary surplus", pattern(1 1 1 1 1 1 1)) mlabels(none)  ///
		order(  surplus_exp deltabexp_t0_t4 bexp_t4  b_lag_1 lag_outgap_pgdp _cons) ///
		coeflabels( lag_outgap_pgdp "Lagged output gap"  surplus_exp "Projected surplus"  bexp_t4 "Projected debt-GDP ratio" deltabexp_t0_t4 "Projected debt-GDP ratio change" b_lag_1 "Lagged debt-GDP ratio" _cons "Constant") ///
		stats(N r2, fmt(%9.0fc %9.2fc)) 

esttab r1 r2 r3 r4 r5 r6 r7  using "out/prod/table_2_sample_`sample_i'_restr_`restr_i'.csv",    ///
	cells(b(fmt(%9.3f)) se(par fmt(%9.3f)))  replace ///
label /// 
collabels(none) ///
mgroups("Primary surplus" "Revenues" "Primary outlays"  "Primary surplus" "Primary surplus"  "Primary surplus" "Primary surplus", pattern(1 1 1 1 1 1 1)) mlabels(none)  ///
		order(  surplus_exp deltabexp_t0_t4 bexp_t4  b_lag_1 lag_outgap_pgdp _cons) ///
		coeflabels( lag_outgap_pgdp "Lagged output gap"  surplus_exp "Projected surplus"  bexp_t4 "Projected debt-GDP ratio" deltabexp_t0_t4 "Projected debt-GDP ratio change" b_lag_1 "Lagged debt-GDP ratio" _cons "Constant") ///
		stats(N r2, fmt(%9.0fc %9.2fc)) 

restore
}
}

// Table 7a: please replicate Table 2b _ext  except that you apply Table 5's year exclusions. 
// Table 7b: please replicate Table 2b _ext except that you apply Table 6's year exclusions.

forv sample_i=1/2 {
    forv restr_i=1/3 {

 preserve
    keep if sample_`sample_i'_restr_`restr_i' == 1

    //baseline
    eststo r0: reg surplus lag_outgap_pgdp surplus_exp, r  

    //Replace surplus_exp with lagged interest/potentialGDP
    eststo r1: reg surplus lag_outgap_pgdp interest_pgdp_l1, r 
    //Add lagged interest/potentialGDP as a covariate along with surplus_exp 
    //(I'd like to see both coefficients and the coeff on lagged output gap, both here and analogously in the other bullets) 
    eststo r2: reg surplus lag_outgap_pgdp surplus_exp interest_pgdp_l1, r
    // Replace surplus_exp with lagged interest/GDP
    eststo r3: reg surplus lag_outgap_pgdp interest_gdp_l1, r
    eststo r4: reg surplus lag_outgap_pgdp surplus_exp interest_gdp_l1, r

    //Add lagged realinterest/potentialGDP 
    // (i.e.  as a covariate along with surplus_exp)
    eststo r5a: reg surplus lag_outgap_pgdp  realinterest_pgdp_l1, r

    eststo r5: reg surplus lag_outgap_pgdp surplus_exp realinterest_pgdp_l1, r

    //Replace surplus_exp with lagged primarysurplus/potentialGDP
    eststo r6: reg surplus lag_outgap_pgdp primarysurplus_pgdp_l1, r 

    //Add lagged primarysurplus/potentialGDP as a covariate along with surplus_exp
    eststo r7: reg surplus lag_outgap_pgdp surplus_exp primarysurplus_pgdp_l1, r

    //Replace surplus_exp with lagged surplus/potentialGDP
    eststo r8: reg surplus lag_outgap_pgdp surplus_pgdp_l1, r 

    //Add lagged surplus/potentialGDP as a covariate along with surplus_exp
    eststo r9: reg surplus lag_outgap_pgdp surplus_exp surplus_pgdp_l1, r

    esttab r0 r1 r2 r3 r4 r5a r5 r6 r7 r8 r9  using "out/prod/table_2_sample_`sample_i'_restr_`restr_i'_extd.tex",    ///
        cells(b(fmt(%9.3f)) se(par fmt(%9.3f)))  replace ///
    label /// 
    collabels(none) ///
    mgroups("Primary surplus" "Primary surplus" "Primary surplus" "Primary surplus" "Primary surplus" "Primary surplus" "Primary surplus" "Primary surplus"  "Primary surplus" "Primary surplus" "Primary surplus", pattern(1 1 1 1 1 1 1  1 1 1 1)) mlabels(none)  ///
            order(  surplus_exp interest_pgdp_l1 interest_gdp_l1  realinterest_pgdp_l1 primarysurplus_pgdp_l1 surplus_pgdp_l1 lag_outgap_pgdp _cons) ///
            coeflabels( lag_outgap_pgdp "Lagged output gap"  surplus_exp "Projected surplus"  interest_pgdp_l1 "Lagged interest (to PGDP)" interest_gdp_l1 "Lagged interest (to GDP)" realinterest_pgdp_l1 "Lagged real interest (to PGDP)" primarysurplus_pgdp_l1 "Lagged primary surplus (to PGDP)" surplus_pgdp_l1 "Lagged  surplus (to PGDP)" _cons "Constant") ///
            stats(N r2, fmt(%9.0fc %9.2fc)) 
   
    esttab r0 r1 r2 r3 r4 r5 r5a r6 r7 r8 r9  using "out/prod/table_2_sample_`sample_i'_restr_`restr_i'_extd.csv",    ///
        cells(b(fmt(%9.3f)) se(par fmt(%9.3f)))  replace ///
    label /// 
    collabels(none) ///
    mgroups("Primary surplus" "Primary surplus" "Primary surplus" "Primary surplus" "Primary surplus" "Primary surplus" "Primary surplus" "Primary surplus"  "Primary surplus" "Primary surplus" "Primary surplus", pattern(1 1 1 1 1 1 1  1 1 1 1)) mlabels(none)  ///
            order(  surplus_exp interest_pgdp_l1 interest_gdp_l1  realinterest_pgdp_l1 primarysurplus_pgdp_l1 surplus_pgdp_l1 lag_outgap_pgdp _cons) ///
            coeflabels( lag_outgap_pgdp "Lagged output gap"  surplus_exp "Projected surplus"  interest_pgdp_l1 "Lagged interest (to PGDP)" interest_gdp_l1 "Lagged interest (to GDP)" realinterest_pgdp_l1 "Lagged real interest (to PGDP)" primarysurplus_pgdp_l1 "Lagged primary surplus (to PGDP)" surplus_pgdp_l1 "Lagged  surplus (to PGDP)" _cons "Constant") ///
            stats(N r2, fmt(%9.0fc %9.2fc)) 
    restore
}
}

//DIAGNOSTIC WITH DANNY START

reg surplus surplus_exp lag_outgap_pgdp if periodid>=200400 & periodid!=202002


reg surplus surplus_exp lag_outgap_pgdp if ///
 periodid>=200400 & periodid!=202002 & ~inrange(periodid, 200801,201402) & ///
  ~inrange(periodid,202001,202002) & ~inrange(periodid,202101,202102), r

reg surplus surplus_exp lag_outgap_pgdp if sample_2_restr_3==1, r

g danny_rest2 = periodid>=200400 & periodid!=202002 & ~inrange(periodid, 200801,201402) & ///
  ~inrange(periodid,202001,202002) & ///
   ~inrange(periodid,202101,202102)
tab  periodid sample_2_restr_3 
g danny_rest1 = periodid>=200400 & periodid!=202002 & ~inrange(periodid, 200801,201402) & ///
   ~inrange(periodid,202001,202002)

reg surplus surplus_exp lag_outgap_pgdp if sample_2_restr_3==1, r
reg surplus surplus_exp lag_outgap_pgdp if danny_rest1==1, r
reg surplus surplus_exp lag_outgap_pgdp if danny_rest2==1, r


preserve
keep periodid sample_2_restr_3  danny_rest1 danny_rest2
duplicates drop
export delimited "dta/diag_danny_tim_periods_table6.csv", replace
restore 


//panel a 
forv i=1/6 {

preserve
keep if sample_`i' == 1

eststo r1: reg surplus lag_outgap_pgdp surplus_exp, r  
eststo r2: reg revenue lag_outgap_pgdp surplus_exp, r
eststo r3: reg outlays lag_outgap_pgdp surplus_exp, r
// eststo r4: reg surplus lag_outgap_pgdp surplus_exp_ewtd, r
eststo r4: reg surplus lag_outgap_pgdp deltabexp_t0_t4, r
eststo r5: reg surplus lag_outgap_pgdp bexp_t4, r
eststo r6: reg surplus lag_outgap_pgdp b_lag_1, r
eststo r7: reg surplus lag_outgap_pgdp surplus_exp bexp_t4, r

esttab r1 r2 r3 r4 r5 r6 r7  using "out/prod/table_2_sample_`i'.tex",    ///
	cells(b(fmt(%9.3f)) se(par fmt(%9.3f)))  replace ///
label /// 
collabels(none) ///
mgroups("Primary surplus" "Revenues" "Primary outlays"  "Primary surplus" "Primary surplus"  "Primary surplus" "Primary surplus", pattern(1 1 1 1 1 1 1)) mlabels(none)  ///
		order(  surplus_exp deltabexp_t0_t4 bexp_t4  b_lag_1 lag_outgap_pgdp _cons) ///
		coeflabels( lag_outgap_pgdp "Lagged output gap"  surplus_exp "Projected surplus"  bexp_t4 "Projected debt-GDP ratio" deltabexp_t0_t4 "Projected debt-GDP ratio change" b_lag_1 "Lagged debt-GDP ratio" _cons "Constant") ///
		stats(N r2, fmt(%9.0fc %9.2fc)) 

  esttab r1 r2 r3 r4 r5 r6 r7  using "out/prod/table_2_sample_`i'.csv",    ///
	cells(b(fmt(%9.3f)) se(par fmt(%9.3f)))  replace ///
label /// 
collabels(none) ///
mgroups("Primary surplus" "Revenues" "Primary outlays"  "Primary surplus" "Primary surplus"  "Primary surplus" "Primary surplus", pattern(1 1 1 1 1 1 1)) mlabels(none)  ///
		order(  surplus_exp deltabexp_t0_t4 bexp_t4  b_lag_1 lag_outgap_pgdp _cons) ///
		coeflabels( lag_outgap_pgdp "Lagged output gap"  surplus_exp "Projected surplus"  bexp_t4 "Projected debt-GDP ratio" deltabexp_t0_t4 "Projected debt-GDP ratio change" b_lag_1 "Lagged debt-GDP ratio" _cons "Constant") ///
		stats(N r2, fmt(%9.0fc %9.2fc)) 
restore
}

//Table 3

global lag_outgap_pgdp_quartic "lag_outgap_pgdp2 lag_outgap_pgdp3 lag_outgap_pgdp4"

forv sample_i=1/2 {
eststo r0: reg surplus lag_outgap_pgdp surplus_exp if sample_`sample_i' == 1, r  
eststo r1: reg surplus lag_outgap_pgdp ${lag_outgap_pgdp_quartic} surplus_exp ///
 if sample_`sample_i' == 1, r  
eststo r2: reg surplus lag_outgap_pgdp surplus_pgdp_l1 if sample_`sample_i' == 1, r 
eststo r3: reg surplus lag_outgap_pgdp surplus_exp surplus_pgdp_l1 if sample_`sample_i' == 1, r
eststo r4: reg surplus lag_outgap_pgdp primarysurplus_pgdp_l1 if sample_`sample_i' == 1, r 
eststo r5: reg surplus lag_outgap_pgdp surplus_exp primarysurplus_pgdp_l1 if sample_`sample_i' == 1, r
eststo r6: reg surplus lag_outgap_pgdp interest_pgdp_l1 if sample_`sample_i' == 1, r 
eststo r7: reg surplus lag_outgap_pgdp surplus_exp interest_pgdp_l1 if sample_`sample_i' == 1, r
eststo r8: reg surplus lag_outgap_pgdp  realinterest_pgdp_l1 if sample_`sample_i' == 1, r
eststo r9: reg surplus lag_outgap_pgdp surplus_exp realinterest_pgdp_l1 if sample_`sample_i' == 1, r
eststo r10: reg surplus lag_outgap_pgdp surplus_exp if sample_`sample_i'_restr_1 == 1, r  
eststo r11: reg surplus lag_outgap_pgdp surplus_exp if sample_`sample_i'_restr_5 == 1, r  

//create a table with results r0-r11 with columns (1), (2), etc (no names), N, R2, and Control for lagged output gap having an X if included in the regression
esttab r0 r1 r2 r3 r4 r5 r6 r7 r8 r9 r10 r11 using "out/prod/table_3_sample_`sample_i'_top.tex",    ///
  cells(b(fmt(%9.3f)) se(par fmt(%9.3f)))  replace ///
  label ///
  collabels(none) ///
  order(surplus_exp surplus_pgdp_l1 primarysurplus_pgdp_l1 interest_pgdp_l1   realinterest_pgdp_l1  ) ///
  coeflabels(  surplus_exp "Projected surplus" surplus_pgdp_l1 ///
  "Lagged  surplus" primarysurplus_pgdp_l1 "Lagged primary surplus"  ///
  interest_pgdp_l1 "Lagged interest" realinterest_pgdp_l1 "Lagged real interest"  ) ///
  noconstant ///
  nonumber ///
  nomtitle noobs  nocons fragment nolines nogaps drop(_cons lag_outgap_pgdp ${lag_outgap_pgdp_quartic})
//esttab only N and r2, no other rows, no coefficients

esttab r0 r1 r2 r3 r4 r5 r6 r7 r8 r9 r10 r11 using "out/prod/table_3_sample_`sample_i'_bottom.tex",    ///
  drop(*) ///
  stats(N r2, fmt(%9.0fc %9.2fc)) replace ///
  noconstant ///
  nonumber ///
  nomtitle fragment nolines nogaps
}




//Table 1: Summary stats for feedback regressions
/*
can you also add rows for the lagged surplus, 
lagged primary surplus, lagged interest, and lagged real interest
 to the bottom of each panel of Table 1? And can you add a column 
 for the standard deviation at the end of each panel?
surplus_pgdp_l1 primarysurplus_pgdp_l1 interest_pgdp_l1 realinterest_pgdp_l1
*/
global vars "surplus revenue outlays surplus_exp  bexp_t4 deltabexp_t0_t4 b_lag_1 surplus_pgdp_l1 primarysurplus_pgdp_l1 interest_pgdp_l1 realinterest_pgdp_l1 lag_outgap_pgdp"


forv i=0/2 {

preserve
keep if sample_`i' == 1

est clear
estpost tabstat $vars , col(statistics) statistics(mean p10 p50 p90 sd)
esttab using "out/prod/summary_stats_`i'.tex", sub("1.00" "   ") cells("mean(label(Mean) fmt(%9.3fc)) p10(label(p10) fmt(%9.3fc)) p50(label(p50) fmt(%9.3fc)) p90(label(p90) fmt(%9.3fc)) sd(label(St. Dev.) fmt(%9.3fc))") unstack ///
nodepvar nomtitle nonumber  ///
coeflabels(surplus "Legislated change to primary surplus" revenue "Legislated change to revenues" outlays "Legislated change to primary outlays" lag_outgap_pgdp "Lagged output gap"  surplus_exp "Projected surplus"  bexp_t4 "Projected debt-GDP ratio" deltabexp_t0_t4 "Projected debt-GDP ratio change" b_lag_1 "Lagged debt-GDP ratio" ///
surplus_pgdp_l1  "Lagged  surplus" primarysurplus_pgdp_l1 "Lagged primary surplus"  ///
  interest_pgdp_l1 "Lagged interest" realinterest_pgdp_l1 "Lagged real interest"  ) noobs replace

esttab using "out/prod/summary_stats_`i'.csv", sub("1.00" "   ") cells("mean(label(Mean) fmt(%9.3fc)) p10(label(p10) fmt(%9.3fc)) p50(label(p50) fmt(%9.3fc)) p90(label(p90) fmt(%9.3fc)) sd(label(St. Dev.) fmt(%9.3fc))") unstack ///
nodepvar nomtitle nonumber  ///
coeflabels(surplus "Legislated change to primary surplus" revenue "Legislated change to revenues" outlays "Legislated change to primary outlays" lag_outgap_pgdp "Lagged output gap"  surplus_exp "Projected surplus"  bexp_t4 "Projected debt-GDP ratio" deltabexp_t0_t4 "Projected debt-GDP ratio change" b_lag_1 "Lagged debt-GDP ratio" ///
surplus_pgdp_l1  "Lagged  surplus" primarysurplus_pgdp_l1 "Lagged primary surplus"  ///
  interest_pgdp_l1 "Lagged interest" realinterest_pgdp_l1 "Lagged real interest"  ) noobs replace

restore
}

*Binscatters
global bins = 20



*Binscatter: 1984-2003 PERIOD
gen report_half_char = "a"
replace report_half_char = "b" if report_half==2
gen periodidchar = string(report_year) + report_half_char




**RESIDUALIZE
preserve

keep if sample_1 == 1
foreach var in surplus surplus_exp lag_outgap_pgdp {
    replace `var' = 100*`var'
}
*CHANGE THE X-AXIS TO DEFICIT
foreach var in surplus_exp {
	replace `var' = -1*`var'
}
foreach var in surplus surplus_exp {
	sum `var'
	local mean = r(mean)
	reg `var' lag_outgap_pgdp
	predict `var'_resid, resid
	replace `var'_resid = `var'_resid + `mean'
}
**CONFIRM RESIDUAL REGRESSION EXACTLY REPLICATES THE MAIN REGRESSION
reg surplus surplus_exp lag_outgap_pgdp, r
reg surplus_resid surplus_exp_resid, r
**MAKE BEST-FIT LINE AMONG RESIDUALS
reg surplus_resid surplus_exp_resid, r
predict surplus_resid_bestfit
**PLOT SCATTER WITH LABELS
twoway (scatter surplus_resid_bestfit surplus_exp_resid, lc(cranberry) lp(solid) m(i) c(l)) ///
  || (scatter surplus_resid surplus_exp_resid, mlabel(periodidchar) mlabposition(0) mlabcolor(navy) ///
    mlabposition(3) msymbol(i) mcolor(none)), ///
  ytitle("Congress's deficit reduction this period (% of GDP)") ///
  xtitle("CBO's projected deficit as of last period (% of GDP)") ///
  xlab(-2(2)4.2, nogrid) ylab(-.5(.25).75, grid glpattern(solid) glwidth(vthin) glcolor(gs15)) ///
  legend(off) 

rename surplus_resid y
rename surplus_exp_resid x
keep x y periodidchar
sort x 
export delimited "out/prod/auerbach2003_binscatter_19842003.csv", replace

graph export "out/prod/auerbach2003_binscatter_19842003.png", replace
graph export "out/prod/auerbach2003_binscatter_19842003.pdf", replace

restore 
// .1461845 

*Binscatter: 2004-2024 PERIOD
preserve
keep if sample_3 == 1

foreach var in surplus surplus_exp lag_outgap_pgdp {
    replace `var' = 100*`var'
}
*CHANGE THE X-AXIS TO DEFICIT
foreach var in surplus_exp {
	replace `var' = -1*`var'
}
**RESIDUALIZE
foreach var in surplus surplus_exp {
	sum `var'
	local mean = r(mean)
	reg `var' lag_outgap_pgdp
	predict `var'_resid, resid
	replace `var'_resid = `var'_resid + `mean'
}
**CONFIRM RESIDUAL REGRESSION EXACTLY REPLICATES THE MAIN REGRESSION
reg surplus surplus_exp lag_outgap_pgdp, r
reg surplus_resid surplus_exp_resid, r
**MAKE BEST-FIT LINE AMONG RESIDUALS
reg surplus_resid surplus_exp_resid, r
predict surplus_resid_bestfit
**PLOT SCATTER WITH LABELS
twoway (scatter surplus_resid_bestfit surplus_exp_resid, lc(cranberry) lp(solid) m(i) c(l)) ///
  || (scatter surplus_resid surplus_exp_resid, mlabel(periodidchar) mlabposition(0) mlabcolor(navy) ///
    mlabposition(3) msymbol(i) mcolor(none)), ///
  ytitle("Congress's deficit reduction this period (% of GDP)") ///
  xtitle("CBO's projected deficit as of last period (% of GDP)") ///
  xlab(1(2)7.3, nogrid) ylab(, grid glpattern(solid) glwidth(vthin) glcolor(gs15)) ///
  legend(off)


rename surplus_resid y
rename surplus_exp_resid x
keep x y periodidchar
sort x

export delimited "out/prod/auerbach2003_binscatter_20042024.csv", replace

graph export "out/prod/auerbach2003_binscatter_20042024.png", replace
graph export "out/prod/auerbach2003_binscatter_20042024.pdf", replace

restore



**COMBINE BINNED DATA AND CREATE PLOT

preserve
import delimited "temp/bindata_1", clear
g sample = 1
tempfile bindata_1 //declare the temporary file
sa "temp/bindata_1", replace //save the temporary file
import delimited "temp/bindata_2", clear
append using "temp/bindata_1" //append (both now .dta)
replace sample =2 if sample == . 

**CREATE COMBINED BINNED SCATTER PLOT
twoway (scatter surplus_resid surplus_exp_resid if sample == 1, ///
            mcolor(green) msymbol(circle)) ///
       (lfit surplus_resid surplus_exp_resid if sample == 1, ///
            lcolor(green)) ///
       (scatter surplus_resid surplus_exp_resid if sample == 2, ///
            mcolor(orange) msymbol(Sh)) ///
       (lfit surplus_resid surplus_exp_resid if sample == 2, ///
            lcolor(orange)), ///
    ytitle("Congress's deficit reduction this period (% of GDP)", size(small)) ///
    xtitle("CBO's projected deficit as of last period (% of GDP)", size(small)) ///
    xlab(, nogrid) ylab(, grid glpattern(solid) glwidth(vthin) glcolor(gs15)) ///
    legend(order(1 "1984-2003" 3 "2004-2024") rows(1) position(bottom) size(small)) ///
    name(combined_binscatter, replace) 

g sample_str = "1984-2003" if sample == 1
replace sample_str = "2004-2024" if sample == 2

rename surplus_resid y
rename surplus_exp_resid x
keep x y sample_str 
sort sample x
export delimited "out/prod/auerbach2003_binscatter_combined_20.csv", replace

graph export "out/prod/auerbach2003_binscatter_combined_20.png", replace
graph export "out/prod/auerbach2003_binscatter_combined_20.pdf", replace

restore
// END 

