********************************************************************************
******* Program to quantify r-g risk *******
********************************************************************************


// TC to Danny: define global project_code as your path to "../debt/stata"  
// idea is to only change 0_prelim.do when switching between users         
cd "$project_code" 

set more off
global gpr = "plotregion(fcolor(white) lcolor(white) m(tiny)) graphregion(fcolor(white) lcolor(white))"
global end = "pdf"

clear all 

*LOAD HISTORICAL R AND G DATA AND COMPUTE QUANTILES
insheet using "raw/historicaldebtevolution.csv", comma clear
**PUT DOLLAR VALUES IN BILLIONS
foreach var in interest debt {
    replace `var' = `var'/1000
}
**PUT ZERO INTEREST FOR YEARS WITH NO DEBT
replace interest=0 if interest==.

*COMPUTE r AND G
**NOTE: THERE ARE THREE MISSING YEARS OF R, BECAUSE YEARS 1984-1986 HAD ZERO DEBT
gen inflation = pricelevel/pricelevel[_n-1] - 1
gen g_nom = gdp/gdp[_n-1] - 1
gen g = g_nom - inflation
**LATER, SHOULD COMPUTE NOMINAL INTEREST MORE SOPHISTICATEDLY, BY ALLOWING FOR 
** HALF OF CURRENT YEAR PRIMARY DEFICITS TO ACCUMULATE INTEREST
gen r_nom = interest/debt[_n-1]
gen r = r_nom - inflation
gen rminusg = r-g
g rho = rminusg/(1+g_nom)


save "dta/historicaldebtevolution_cleaned.dta", replace


// set rminusg to be rho
drop rminusg
g 	rminusg = rho

*COMPUTE 30-YEAR ROLLING AVERAGE
**THIS DOES NOT HANDLE MISSINGS CORRECTLY. HAVE TO SET TO ZERO FOR NOW.
replace rminusg=0 if rminusg==.
tsset year
foreach length in 5 10 15 20 25 30 45 50 60 75 100 {
	local lengthminus1 = `length'-1
	egen rminusg_`length'yr = filter(rminusg), lags(0/`lengthminus1')
	replace rminusg_`length'yr = rminusg_`length'yr/`length'
}
foreach length in 5 10 15 20 25 30 45 50 60 75 100 {
	gen rminusg_diff`length' = rminusg_10yr - rminusg_`length'yr[_n-`length']
}




*PRODUCTION
// multiply by 100 to get pp
gen rminusg_1yr = rminusg

foreach year of numlist 1 5 10 20 30 50 75 100 {
	gen rminusg_`year'yr_pp = rminusg_`year'yr*100
}

// Figure: Evolution of r - g over time
twoway (scatter rminusg_5yr_pp year, c(l) lwidth(medthick) color("$c1") lpattern("$l1") m(i)xlabel(1800(20)2020)) ///
	(scatter rminusg_30yr_pp year, c(l) lwidth(medthick) color("$c2") lpattern("$l2") m(i) xlabel(1800(20)2020)) ///
	(scatter rminusg_50yr_pp year, c(l) lwidth(medthick) color("$c3") lpattern("$l3") m(i) xlabel(1800(20)2020)) ///
	(scatter rminusg_100yr_pp year, c(l) lwidth(medthick) color("$c4") lpattern("$l4") m(i) xlabel(1800(20)2020)), ///
xtitle("") ytitle("Excess interest rate (r-g)/(1+g) (%)", size(medium) margin(medium) justification(left)) ylabel(-15(5)15) ///
xlab(, nogrid) ylab(,grid glpattern(solid) glwidth(vthin) glcolor(gs15)) ///
legen(position(bottom) r(1) subtitle("Average over:", justification(left) pos(9)) ///
label(1 "5 years") label(2 "30 years") label(3 "50 years") label(4 "100 years"))
graph export "out/prod/plot_rminusg_over_time.png", replace

// Figure: Debt-GDP ratio over time 2000-20023
g b = debt/gdp
twoway (scatter b year if inrange(year, 2000, 2023), c(l) lwidth(medthick) color("$c1") lpattern("$l1") m(i)), ///
xtitle("") ytitle("Debt-GDP ratio", size(medium) margin(medium) justification(left)) ylabel(0(0.2)1) ///
xlab(, nogrid) ylab(,grid glpattern(solid) glwidth(vthin) glcolor(gs15)) 
graph export "out/prod/plot_b_over_time.png", replace



// Table: Distribution of r - g by horizon
preserve
keep year rminusg_*_pp
// since 1790 (start of sample)
estpost tabstat rminusg_*_pp, statistics(mean p1 p5 p10 p25 p50 p75 p90 p95 p99) 
esttab using "out/prod/table_dist_rminusg.tex",  ///
cells("rminusg_1yr_pp(fmt(1)) rminusg_5yr_pp rminusg_10yr_pp rminusg_20yr_pp rminusg_30yr_pp rminusg_50yr_pp rminusg_75yr_pp rminusg_100yr_pp") ///
 nodepvar nomtitle nonumber noobs  ///
collabels(1 5 10 20 30 50 75 100 ) ///
coeflabels(mean "Mean" p1 "1^{\text{th}}" p5 "5^{\text{th}}" p10 "10^{\text{th}}" p25 "25^{\text{th}}" p50 "50^{\text{th}}" p75 "75^{\text{th}}" p90 "90^{\text{th}}" p95 "95^{\text{th}}" p99 "99^{\text{th}}") ///
mgroups("Horizon in years", pattern(0 1 1 1 1 1 1 1 1) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) ///
refcat(p1 "\textit{Percentile}", nolabel) ///
replace

restore
// since 1900
preserve
keep if year >= 1900
estpost tabstat rminusg_*_pp, statistics(mean p1 p5 p10 p25 p50 p75 p90 p95 p99) 
esttab using "out/prod/table_dist_rminusg_since_1900.tex",  ///
cells("rminusg_1yr_pp(fmt(1)) rminusg_5yr_pp rminusg_10yr_pp rminusg_20yr_pp rminusg_30yr_pp rminusg_50yr_pp rminusg_75yr_pp rminusg_100yr_pp") ///
 nodepvar nomtitle nonumber noobs  ///
collabels(1 5 10 20 30 50 75 100 ) ///
coeflabels(mean "Mean" p1 "1^{\text{th}}" p5 "5^{\text{th}}" p10 "10^{\text{th}}" p25 "25^{\text{th}}" p50 "50^{\text{th}}" p75 "75^{\text{th}}" p90 "90^{\text{th}}" p95 "95^{\text{th}}" p99 "99^{\text{th}}") ///
mgroups("Horizon in years", pattern(0 1 1 1 1 1 1 1 1) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) ///
refcat(p1 "\textit{Percentile}", nolabel) ///
replace
restore
cd "$project_code/do/"



