********************************************************************************
******* Program run different specifications of CBO feedback regression *******
********************************************************************************

clear all 

cd "$project_code" 

**** Load regression dataset ****

//do "code/create_regress_dataset.do" 

use  "dta/leg_regression_final.dta", clear
********************************************************************************
******* Run Regression *******
********************************************************************************

gen periodid = string(report_year) + "0" + string(report_half)
destring periodid, replace


//plots
// Plots for sample excluding periodid 202002 
preserve
keep if periodid != 202002  
// rolling sample - 10 and 20 years
local indep_vars "lag_outgap_pgdp surplus_exp"
local dep_vars "surplus"	
foreach span of numlist  20 {
	foreach v in `dep_vars' {
				if  "`v'" == "surplus" {
			local v_name "Surplus"
			}
		foreach b in `indep_vars' {
			if  "`b'" == "surplus_exp" {
			local b_ytitle1 "Dollars of legislated surplus change"
			local b_ytitle2  " per dollar of lagged projected surplus"
			}
			else if "`b'" == "lag_outgap_pgdp" {
			local b_ytitle1 "Dollars of legislated surplus change"

			local b_ytitle2 " per dollar of lagged output gap"

			}

			local b_name "output gap"
			if  "`b'" == "surplus_exp" {
			local b_name "projected surplus"
			}
			di "`b_name'"
			local allyears
			local labels
			local labels_abb
			local y_abb
			eststo clear 
			forvalues year = 1993(1)2024 {
				local end_pid = string(`year') + "02"
				local start_pid = string(`year' - `span' + 1) + "01"
		// 		dis `start_pid'
		// 		dis `end_pid'
				eststo y`year': regress  `v' lag_outgap_pgdp surplus_exp if inrange(periodid, `start_pid', `end_pid'), r
				local allyears `allyears' y`year' ||
				local labels `labels' `year'
			}

		// 	display "`allyears'"
		// 	display `"`labels'"'

			// abbreviate labels
			foreach l of local labels {
				local y_abb = "" + substr("`l'", 3, 4)
				local labels_abb `labels_abb' `y_abb'
			}
			display "`labels_abb'"
				
			coefplot `allyears', keep(`b') vertical  ciopts(color("$c1")) color("$c1") bycoefs bylabels(`labels_abb') ///
			yline(0, lpattern("$l1")) ///
			 xtitle("Terminal year of rolling 20-year sample frame") ///
			 ytitle("`b_ytitle1'" "`b_ytitle2'") ///			
			 yscale(r(0))  xlabel(,labsize(small)) ylabel(-.6(.2).2) ///
			 xlab(, nogrid) ylab(,grid glpattern(solid) glwidth(vthin) glcolor(gs15))
			graph export "out/prod/plot_roll_`span'_yrs_coeff_`b'_in_`v'_excl_202002.png", replace
}
	esttab using "out/prod/tab_roll_`span'_yrs_`v'_excl_202002.csv",  star(* 0.10 ** 0.05 *** 0.01)  ///
			cells(b( fmt(%9.3f)) se(par fmt(%9.3f)))   replace ///
			order(_cons lag_outgap_pgdp  surplus_exp) ///
			coeflabels(_cons "Constant" lag_outgap_pgdp "Lagged output gap"  surplus_exp "Projected surplus") ///
			mtitles collabels(none)  
}
}
restore
cd "$project_code/do/"







