********************************************************************************
******* Program to import and format potential GDP *******
********************************************************************************

clear all 

cd $project_code


****************** Load  excel file w/ potential GDP *******************************

 * Specifying cell rows because the first handful of rows are blank in excel spreadsheet *
import delimited "raw/0_prod/55022-2024-06-Historical-Economic-Data/Annual_FY_June2024.csv"
	 
****************** Format pgdp data in way that makes sense for regression  *******************************

keep date potential_gdp
rename potential_gdp pgdp
rename date report_year

destring report_year, replace 
keep if report_year>=1980

destring pgdp, replace 


save "dta/pgdp.dta", replace


clear
 * Specifying cell rows because the first handful of rows are blank in excel spreadsheet *
import delimited "raw/0_prod/55022-2024-06-Historical-Economic-Data/Quarterly_June2024.csv"
gen year = substr(date, 1, 4)
gen quarter = "0" + substr(date, 6, 6)
destring quarter year, replace

gen report_half=.
replace report_half = 1 if quarter==2
replace report_half = 2 if quarter==4

rename output_gap outgap

collapse (mean) outgap, by(year report_half)

keep if year>=1980

rename year report_year

drop if report_half==.

save "dta/outgap_q.dta", replace



****************** Load  excel file w/ other variables *******************************
clear 
 * Specifying cell rows because the first handful of rows are blank in excel spreadsheet *
import excel "raw/0_prod/51134-2024-02-Historical-Budget-Data.xlsx" , ///
	 firstrow case(lower) sheet("1. Rev, Outlays, Surplus, Debt") cellrange(A9:H71) //HARDCODED RANGE!!! AFFECTS YEAR! report_year HARDCODED

rename a report_year
rename onbudget surplus_act
rename debtheldbythepublica debt_act 

keep report_year surplus_act debt_act
merge 1:1 report_year using  "dta/pgdp.dta"
drop _merge 

save "dta/budget_vars.dta", replace
cd "$project_code/do/"
