/*---------------------------------------------------- 
Figure 2: Estimated effects on deficits of an increase 
in green cards to holders of advanced STEM degrees, 
conventional and population-change approaches
* Paper: "Dynamic Scoring: A Progress Report on Why, When, and How"
----------------------------------------------------*/

version 18
clear all
graph query gridstyle
grstyle init
grstyle set plain, horizontal grid dotted


import excel using "$d/accounting_population_effects.xlsx", cellrange(A4:C25) firstrow sheet(Figure 1) clear
rename (Year Conventionalbasis Accountingforpopulationchange) (year conv popc)

twoway (line conv year, lcolor(midblue) mcolor(midblue)lpattern(solid) ) ///
	(line popc year, lcolor(maroon) mcolor(maroon) lpattern(dash) ) ///
	(scatter conv year, lcolor(midblue) mcolor(midblue) msymbol(circle)) ///
	(scatter popc year, lcolor(maroon) mcolor(maroon) msymbol(circle) ) ///
	(rarea conv popc year, color(gray%20)  ) ///
	, legend(off) xline(2034, lcolor(gray) lwidth(0.2) lpattern(solid) ) yline(0, lcolor(gray) lwidth(0.2) lpattern(solid) )  /*title("{bf:Estimated effect on the primary deficit}")*/ subtitle("{it:Billions of dollars}", size(small)) ytitle("") xtitle("")  xlabel(2024(2)2044 , labsize(small)) ylabel(-100(20)20 , labsize(small))  ///
	text(15 2041 "{bf: Conventional basis}" ///
		-74 2041 "{bf:Accounting for population change}" ///
		, color(black) just(left) place(sw) size(small))  
graph export "$o/figure2.svg", replace width(1000) 



