# Figure 1. Gross budgetary effects and the major legislation rule
# Paper: "Dynamic Scoring: A Progress Report on Why, When, and How"

library(tidyverse)
library(readxl)
library(ggplot2)
library(svglite)

histogram_data=read.csv("data/Histogram_Yearly_data_duplicates_removed.csv", check.names = F)
test = histogram_data[!(duplicated(histogram_data[, c("gbe", "year", "content")])), ]

check = setdiff(histogram_data[(duplicated(histogram_data[, c("gbe", "year", "content")])), ], 
                histogram_data[(duplicated(histogram_data[, c("gbe", "year", "law")])), ])

custom_format <- function(x) {
  format(x, scientific = FALSE, drop0trailing = TRUE)
}

ggplot(test, aes(x = gbe/GDP)) +
  geom_histogram(binwidth = .2, alpha = 0.5, position = "identity", color = 'black', fill = "#dddf1a") +
  scale_x_log10(labels = custom_format) +
  labs(x = "Gross Budgetary Effect",
       y = "Count") +
  geom_vline(xintercept = .025)+
  theme_classic()
ggsave("output/figure1.svg", width = 3250/2, height = 2500/2, units = 'px')
