%% Import data from spreadsheet
% Script for importing data from the following spreadsheet:
%
%    Workbook: /cmc/ahn-projects/BPEA/MS_BPEA_discussion_Ustar.xlsx
%    Worksheet: Sheet1
%
% Auto-generated by MATLAB on 21-Sep-2024 20:19:09

%% Set up the Import Options and import the data
opts = spreadsheetImportOptions("NumVariables", 31);

% Specify sheet and range
opts.Sheet = "Sheet1";
opts.DataRange = "A2:AE885";

% Specify column names and types
opts.VariableNames = ["year", "V_hwi", "VLF", "ULF", "Ustar", "Ustar1", "Ustar2", "Vnonfarmvacancy", "L", "U", "RU", "POP", "LPOP", "EPOP", "LFPT", "Hktrend", "Hktrend_sm", "VarName18", "EstarLFPR", "EstarLFPT", "DifLFPR", "DifLFPT", "BreakevenLFPR", "Breakeven6LFPR", "Breakeven12LFPR", "BreakevenLFPT", "Breakeven6LFPT", "Breakeven12LFPT", "PayrollEmployment", "PayrollEmployment_12", "Recession"];
opts.VariableTypes = ["datetime", "double", "double", "double", "double", "double", "double", "string", "double", "double", "double", "double", "double", "double", "double", "string", "string", "string", "double", "double", "double", "double", "double", "double", "double", "double", "double", "double", "double", "double", "double"];

% Specify variable properties
opts = setvaropts(opts, ["Vnonfarmvacancy", "Hktrend", "Hktrend_sm", "VarName18"], "WhitespaceRule", "preserve");
opts = setvaropts(opts, ["Vnonfarmvacancy", "Hktrend", "Hktrend_sm", "VarName18"], "EmptyFieldRule", "auto");

% Import the data
MSBPEAdiscussionUstar = readtable("MS_BPEA_discussion_Ustar.xlsx", opts, "UseExcel", false);


%% Clear temporary variables
clear opts