% ------------------------------------- 
% BPEA discussion by Hie Joo Ahn
% This code generates the Figures 5 and 7
% -------------------------------------

clear all; close all;

Readin_Race

data = MSBPEAdiscussionUstarS6;

date = table2array(data(:,"VarName1"));

ru = table2array(data(:,"UR"));
ru_white = table2array(data(:,"White"));
ru_black = table2array(data(:,"Black"));
ru_other = table2array(data(:,"Other"));
feru_base = table2array(data(:,"Total_ustar"));
feru_white = table2array(data(:,"White_ustar"));
feru_black = table2array(data(:,"Black_ustar"));
feru_other = table2array(data(:,"Other_ustar"));
feru_race = table2array(data(:,"wgt_pop"));

% -------------- %
% Create Figures %
% -------------- %

nbg = 1;nend = 584; 

figure(1)
hold on
plot(date(nbg:nend),ru_white(nbg:nend),'LineWidth',2,'LineStyle','--','Color','blue')
plot(date(nbg:nend),feru_white(nbg:nend),'Linewidth',2,'LineStyle','-','Color','blue')
plot(date(nbg:nend),zeros(nend-nbg+1),'Color',[0 0 0])
recessionplot
legend('Unemployment rate (White)','FERU(White)','Location','northwest')
set(gca,'Fontsize',17)
hold off

figure(2)
hold on
plot(date(nbg:nend),ru_black(nbg:nend),'LineWidth',2,'LineStyle','--','Color','red')
plot(date(nbg:nend),feru_black(nbg:nend),'Linewidth',2,'LineStyle','-','Color','red')
plot(date(nbg:nend),zeros(nend-nbg+1),'Color',[0 0 0])
recessionplot
legend('Unemployment rate (Black)','FERU(Black)','Location','northwest')
set(gca,'Fontsize',17)
hold off

figure(3)
hold on
plot(date(nbg:nend),ru(nbg:nend),'LineWidth',1,'LineStyle','-.','Color','black')
plot(date(nbg:nend),feru_base(nbg:nend),'Linewidth',2,'LineStyle','-','Color','blue')
plot(date(nbg:nend),feru_race(nbg:nend),'Linewidth',2,'LineStyle',':','Color','blue')
plot(date(nbg:nend),zeros(nend-nbg+1),'Color',[0 0 0])
ylim([2 15])
recessionplot
legend('Unemployment rate','FERU','FERU (race)','Location','northwest')
set(gca,'Fontsize',15)
hold off