% ------------------------------------- 
% BPEA discussion by Hie Joo Ahn
% This code generates Figure 8
% -------------------------------------

clear all; close all;

Readin_Meas

data = MSBPEAdiscussionUstarS4;

date = table2array(data(:,"date"));

ru = table2array(data(:,"BLS"));
vr = table2array(data(:,"VR"));
feru_base = table2array(data(:,"FERU"));
feru_AH = table2array(data(:,"AH_ustar"));
feru_FH = table2array(data(:,"FH_ustar"));
feru_AZ = table2array(data(:,"AZ_ustar"));
feru_U6 = table2array(data(:,"Ustar6"));

AH = table2array(data(:,"AH"));
FH = table2array(data(:,"FH"));
AZ = table2array(data(:,"AZ"));
U6 = table2array(data(:,"U6"));

nbg = 1;
nend = 234;

close all;

figure(1)
hold on
plot(date(nbg:nend),ru(nbg:nend) - feru_base(nbg:nend),'Linewidth',3,'LineStyle','-','Color','black')
plot(date(nbg:nend),FH(nbg:nend) - feru_FH(nbg:nend),'Linewidth',2,'LineStyle','--','Color','blue')
plot(date(nbg:nend),AH(nbg:nend) - feru_AH(nbg:nend),'Linewidth',2,'LineStyle','-','Color','red')
plot(date(nbg:nend),AZ(nbg:nend) - feru_AZ(nbg:nend),'Linewidth',2,'LineStyle',':','Color','magenta')
plot(date(nbg:nend),zeros(nend-nbg+1),'Color',[0 0 0])
recessionplot
legend('FERU','Feng-Hu','Ahn-Hamilton','Abowd-Zellner','Location','northwest')
set(gca,'Fontsize',15)
hold off
