% ------------------------------------- 
% BPEA discussion by Hie Joo Ahn
% This code generates Figures 1-4 
% -------------------------------------

clear all; close all;

Readin_Data

data = MSBPEAdiscussionUstar;

date = table2array(data(:,'year'));
BE12 = table2array(data(:,"Breakeven12LFPT"));
BE12_LFPR = table2array(data(:,"Breakeven12LFPR"));
PE12 = table2array(data(:,"PayrollEmployment_12"));
PE = table2array(data(:,"PayrollEmployment"));
estar_lfpr = table2array(data(:,"EstarLFPR"));
estar_lfpt = table2array(data(:,"EstarLFPT"));
epop = table2array(data(:,"EPOP"));
feru = table2array(data(:,"Ustar"));
ru = table2array(data(:,"ULF"));
LPOP = table2array(data(:,"LPOP"));
LFPT = table2array(data(:,"LFPT"));

%--------------- %
% Create Figures %
% -------------- %

nbg = 312; 
nend = 828;

figure(1)
hold on
plot(date(nbg:nend),LPOP(nbg:nend),'LineWidth',1,'Color','black')
plot(date(nbg:nend),LFPT(nbg:nend),'Linewidth',2,'LineStyle','--','Color','blue')
recessionplot
legend('LFPR','LFPT','Location','southeast')
set(gca,'Fontsize',14)
hold off

figure(2)
hold on
plot(date(nbg:nend),feru(nbg:nend),'LineWidth',2,'Color','black')
plot(date(nbg:nend),ru(nbg:nend),'Linewidth',2,'LineStyle','--','Color','blue')
plot(date(nbg:nend),zeros(nend-nbg+1),'Color',[0 0 0])
recessionplot
legend('FERU','Unemployment rate','Location','southwest')
set(gca,'Fontsize',14)
hold off

figure(3)
hold on
plot(date(nbg:nend),100*estar_lfpt(nbg:nend)/100,'LineWidth',2,'Color','black')
plot(date(nbg:nend),100*epop(nbg:nend)/100,'Linewidth',2,'LineStyle','--','Color','blue')
plot(date(nbg:nend),zeros(nend-nbg+1),'Color',[0 0 0])
ylim(100*[0.54 0.66])
recessionplot
legend('FEEP','EPOP ratio','Location','southwest')
set(gca,'Fontsize',14)
hold off

figure(4)
hold on
plot(date(nbg:nend),BE12(nbg:nend)/100,'LineWidth',1,'Color','black')
plot(date(nbg:nend),PE12(nbg:nend)/100,'Linewidth',2,'LineStyle','--','Color','blue')
plot(date(nbg:nend),zeros(nend-nbg+1),'Color',[0 0 0])
ylim([-600 500])
recessionplot
legend('FEEP gains','Payroll gains','Location','southwest')
set(gca,'Fontsize',14)
hold off

nend1 = 884;
nbg1 = nend1 - 56;

PE3 = movavg(PE,'linear',3);

figure(5)
hold on
plot(date(nbg1:nend1),BE12(nbg1:nend1)/100,'LineWidth',2,'Color','black')
plot(date(nbg1:nend1),PE3(nbg1:nend1)/100,'Linewidth',2,'LineStyle','--','Color','blue')
plot(date(nbg1:nend1),zeros(nend1-nbg1+1),'Color',[0 0 0])
ylim([-1000 1000])
xlim([date(nbg1),date(nend1)])
recessionplot
legend('FEEP gains','Payroll gains','Location','southeast')
set(gca,'Fontsize',14)
hold off

figure(6)
hold on
plot(date(nbg1:nend1),100*estar_lfpt(nbg1:nend1)/100,'LineWidth',2,'Color','black')
plot(date(nbg1:nend1),100*epop(nbg1:nend1)/100,'Linewidth',2,'LineStyle','--','Color','blue')
plot(date(nbg1:nend1),zeros(nend1-nbg1+1),'Color',[0 0 0])
ylim(100*[0.5 0.62])
xlim([date(nbg1),date(nend1)])
recessionplot
legend('FEEP','EPOP ratio','Location','southeast')
set(gca,'Fontsize',14)
hold off
