clear all

/* Set root directory */
*global dir " " //set origin path
global code "$dir/replication_package/codes"
global survey_data "$dir/replication_package/data"
global output "$dir/replication_package/output"
global figures "$output/figures"
global tables "$output/tables"


*import and clean data
do "$code/data_cleaning/creating_dataset_A"

grstyle init
grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"

*generate variables used in the analysis
gen rep=0 if !missing( political_agg)
replace rep=1 if political_agg==2
label var rep "Republican"

gen ind=0 if !missing( political_agg)
replace ind=1 if political_agg==3
label var ind "Independent"


*generate indicators for answers to question "Imagine that next year the inflation rate unexpectedly doubles. How long would it probably take before your income has increased enough so that you can afford the same things as you do today? In other words, how long will it be before a full inflation correction in your income has taken place?" 
gen less_than_seven = 0 if pers_imp_work_2_me_en!=. & pers_imp_work_2_me_en!=6
replace less_than_seven = 1 if pers_imp_work_2_me_en<3

gen btw_seven_and_one = 0 if pers_imp_work_2_me_en!=.& pers_imp_work_2_me_en!=6
replace btw_seven_and_one = 1 if pers_imp_work_2_me_en==3

gen more_than_one = 0 if pers_imp_work_2_me_en!=.& pers_imp_work_2_me_en!=6
replace more_than_one = 1 if pers_imp_work_2_me_en>3 & pers_imp_work_2_me_en!=. & pers_imp_work_2_me_en!=6

*generate indicator equal to 1 if answer is "my income would be higher" to the question "Try to imagine how things would be different if we had not experienced the inflation we did over the last two years, so that prices of things you buy had not risen to the levels that we actually see today. How different do you think your income (the total dollars you earn in a month) would be now, in comparison with your actual income now, if we had had no inflation?"
gen income_would_be_higher = 0 if pers_imp_work_hyp_sh_en!=.&pers_imp_work_hyp_sh_en!=4
replace income_would_be_higher = 1 if pers_imp_work_hyp_sh_en==3

*generate indicator equal to 1 if answered concerned to question "Considering the impact of inflation, how concerned are you about your future earnings and employment status?""
gen dummy_concern = 0 if concern_future_work_en!=.
replace dummy_concern = 1 if concern_future_work_en>3 & concern_future_work_en!=.

  
**#TABLE A15: CORRELATES OF INFLATION IMPACTS AS A WORKER
{

eststo clear
global table_name "$tables/TABLE_A15"

* Table end
file open  holder using $tables/temp_end.tex, write replace text
file write holder "\hline \hline \end{tabular}" _n
file close holder

* Table start
file open holder using $table_name.tex, write replace text
file write holder "\begin{tabular}{lccccccccc} " _n
file write holder "& \multicolumn{9}{c}{ \textit{Dependent variable}}  \\" _n
file write holder "& \multicolumn{3}{c}{ \textbf{If inflation doubled, how long}} & \multicolumn{3}{c}{ \textbf{Work impacts of inflation}} & \multicolumn{3}{c}{ \textbf{Rate of wage increases}}   \\" _n
file write holder "& \multicolumn{3}{c}{ \textbf{until your wage doubles?}} & \multicolumn{3}{c}{ } & \multicolumn{3}{c}{ }   \\" _n
file write holder " \cmidrule(lr){2-4} \cmidrule(lr){5-7}  \cmidrule(lr){8-10}" _n
file write holder "& Less than  & Between & More than & Very concerned & If inflation & If my wage increased, & Prices & Wages of higher & Wages of other \\" _n
file write holder "& 7 months & 7 months & 1 year & about future  & had been lower & but prices increased just  & increase & income people are & people are rising \\ " _n
file write holder "&  & and 1 year &  & employment &  my income would & as much, my job & faster than & rising more & more quickly \\ " _n
file write holder "&  &  &  & and earnings & be higher & satisfaction would be lower  &  wages & quickly than mine & than mine \\ \hline" _n
file write holder " \cmidrule(lr){2-10}" _n
file close holder

	
global controls_main women age_class_agg2 age_class_agg3  dummy_race_agg2 dummy_race_agg3 dummy_race_agg4  incomegroup_agg_2 incomegroup_agg_3 dummy_employment_agg2 dummy_employment_agg1 dummy_employment_agg4 dummy_married dummy_children dummy_us_area1 dummy_us_area2 dummy_us_area3  college republican political_agg3


eststo clear


eststo: reg less_than_seven  $controls_main , vce(robust)
local r1: display %5.3f `e(r2_a)'

qui sum less_than_seven if e(sample) 
local mean1: display %5.3f `r(mean)'
local obs1: display %5.0f `r(N)'
local sd1: display %5.3f `r(sd)'

eststo: reg btw_seven_and_one  $controls_main , vce(robust)
local r2: display %5.3f `e(r2_a)'

qui sum btw_seven_and_one if e(sample) 
local mean2: display %5.3f `r(mean)'
local obs2: display %5.0f `r(N)'
local sd2: display %5.3f `r(sd)'

eststo: reg more_than_one  $controls_main , vce(robust)
local r3: display %5.3f `e(r2_a)'

qui sum more_than_one if e(sample) 
local mean3: display %5.3f `r(mean)'
local obs3: display %5.0f `r(N)'
local sd3: display %5.3f `r(sd)'


eststo: reg dummy_concern  $controls_main , vce(robust)
local r4: display %5.3f `e(r2_a)'

qui sum dummy_concern if e(sample) 
local mean4: display %5.3f `r(mean)'
local obs4: display %5.0f `r(N)'
local sd4: display %5.3f `r(sd)'


eststo: reg income_would_be_higher  $controls_main , vce(robust)
local r5: display %5.3f `e(r2_a)'

qui sum income_would_be_higher if e(sample) 
local mean5: display %5.3f `r(mean)'
local obs5: display %5.0f `r(N)'
local sd5: display %5.3f `r(sd)'


eststo: reg dummy_work_satisf  $controls_main , vce(robust)
local r6: display %5.3f `e(r2_a)'

qui sum dummy_work_satisf if e(sample) 
local mean6: display %5.3f `r(mean)'
local obs6: display %5.0f `r(N)'
local sd6: display %5.3f `r(sd)'

eststo: reg dummy_wage_prices  $controls_main , vce(robust)
local r7: display %5.3f `e(r2_a)'

qui sum dummy_wage_prices if e(sample) 
local mean7: display %5.3f `r(mean)'
local obs7: display %5.0f `r(N)'
local sd7: display %5.3f `r(sd)'

eststo: reg dummy_wage_high_rel  $controls_main , vce(robust)
local r8: display %5.3f `e(r2_a)'

qui sum dummy_wage_high_rel if e(sample) 
local mean8: display %5.3f `r(mean)'
local obs8: display %5.0f `r(N)'
local sd8: display %5.3f `r(sd)'

eststo: reg dummy_wage_rel  $controls_main , vce(robust)
local r9: display %5.3f `e(r2_a)'

qui sum dummy_wage_rel if e(sample) 
local mean9: display %5.3f `r(mean)'
local obs9: display %5.0f `r(N)'
local sd9: display %5.3f `r(sd)'


esttab using $tables/panel.tex, replace fragment booktabs noconst nobase label cells(b(fmt(3) star) se(par fmt(3))) collabels(none) /// 
starlevels(* .1 ** .05 *** .01) se nonumbers nomtitles nolines nocon noobs compress

eststo clear

*** Means ***
file open holder using $tables/panel_means.tex, write replace text
file write holder "\hline " _n
file write holder "Observations & `obs1' & `obs2' & `obs3' & `obs4' & `obs5' & `obs6' & `obs7' & `obs8'  & `obs9'  \\" _n     
file write holder "Adj. R$^{2}$ & `r1' & `r2' & `r3' & `r4' & `r5' & `r6' & `r7' & `r8'  & `r9'   \\" _n 
file write holder "Dependent variable mean & `mean1' & `mean2' & `mean3'  & `mean4'  & `mean5'  & `mean6' & `mean7' & `mean8' & `mean9' \\" _n   
file write holder "Dependent variable std. dev. & `sd1' & `sd2' & `sd3' & `sd4' & `sd5' & `sd6' & `sd7' & `sd8' & `sd9'  \\" _n
file close holder

appendfile $tables/panel.tex $table_name.tex
appendfile $tables/panel_means.tex $table_name.tex
appendfile $tables/temp_end.tex $table_name.tex

erase $tables/panel.tex
erase $tables/panel_means.tex
erase $tables/temp_end.tex 

eststo clear
}

