clear all

/* Set root directory */
*global dir " " //set origin path
global code "$dir/replication_package/codes"
global survey_data "$dir/replication_package/data"
global output "$dir/replication_package/output"
global figures "$output/figures"
global tables "$output/tables"


*import and clean data
do "$code/data_cleaning/creating_dataset_A"


grstyle init
grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"


*generate indicators for the analysis
gen dummy_react_wage_up=0 if !missing(job_change_wage_en)
replace dummy_react_wage_up = 1 if (job_change_wage_en==1)
label var dummy_react_wage_up "Received a wage increase, regardless if asked for"


**#FIGURE A8: PERSONAL REACTIONS TO INFLATION AS A WORKER, SPLIT BY POLITICAL AFFILIATION
***split respondents by political leaning and represent the answers to the inflation impacts as a consumer questions for "democrat", "republican" and "full sample"
{
preserve

global wage_react dummy_infl_adjustment dummy_career_progression dummy_react_wage_up react_wage_askrec_agg_en react_wage_ask_agg_en 

global work_react  dummy_react_incr_hours react_switch_job_agg_en react_find_addjob_agg_en react_add_job_agg_en

**need to clean some vars for the shares to be of the sample we are interested in
foreach var_selec of varlist $work_react $wage_react{
	recode `var_selec' (2=0)
}
**found an additional job was asked only to those who said they looked for it, here we extend it to the whole sample
replace react_find_addjob_agg_en = 0 if react_add_job_agg_en==0

**receive the wage salary was only for those who asked it, here we extend it to the whole sample
replace react_wage_askrec_agg_en = 0 if react_wage_ask_agg_en==0

**receive the wage salary was only for those who asked it, here we extend it to the whole sample
replace dummy_career_progression = 0 if dummy_career_progression==.

**receive the wage salary was only for those who asked it, here we extend it to the whole sample
replace dummy_infl_adjustment = 0 if dummy_infl_adjustment==.

**asked only to those who have changed job, here we extend it to the whole sample
replace react_switch_job_agg_en = 0 if job_change_en==2 & react_switch_job_agg_en==.

global j=1

foreach var_selec of varlist $wage_react{
sum `var_selec' if political_agg==1
	scalar    low_wage_react_${j}=r(mean)*100 
	scalar se_low_wage_react_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
sum `var_selec'
	scalar    wage_react_${j}=r(mean)*100 
	scalar se_wage_react_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
sum `var_selec' if political_agg==2
	scalar    high_wage_react_${j}=r(mean)*100 
	scalar se_high_wage_react_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +2
}

global j=$j +2

foreach var_selec of varlist $work_react{
sum `var_selec' if political_agg==1
	scalar    low_work_react_${j}=r(mean)*100 
	scalar se_low_work_react_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
sum `var_selec'
	scalar    work_react_${j}=r(mean)*100 
	scalar se_work_react_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
sum `var_selec' if political_agg==2
	scalar    high_work_react_${j}=r(mean)*100 
	scalar se_high_work_react_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +2
}



clear
set obs 37
egen n = seq()

foreach var in low_work_react work_react high_work_react low_wage_react wage_react high_wage_react{
gen `var' = . 
gen min_`var' = .
gen max_`var' = . 
}

foreach x in 1 5 9 13 17{
replace low_wage_react = low_wage_react_`x' if n == `x'
replace min_low_wage_react = low_wage_react_`x'  - 1.645 * se_low_wage_react_`x'  if n == `x'
replace max_low_wage_react = low_wage_react_`x'  + 1.645 * se_low_wage_react_`x'  if n == `x'
scalar up_`x'=low_wage_react_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+10
}

foreach x in 2 6 10 14 18{
replace wage_react = wage_react_`x' if n == `x'
replace min_wage_react = wage_react_`x'  - 1.645 * se_wage_react_`x'  if n == `x'
replace max_wage_react = wage_react_`x'  + 1.645 * se_wage_react_`x'  if n == `x'
scalar up_`x'=wage_react_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+10
}


foreach x in 3 7 11 15 19{
replace high_wage_react = high_wage_react_`x' if n == `x'
replace min_high_wage_react = high_wage_react_`x'  - 1.645 * se_high_wage_react_`x'  if n == `x'
replace max_high_wage_react = high_wage_react_`x'  + 1.645 * se_high_wage_react_`x'  if n == `x'
scalar up_`x'=high_wage_react_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+10
}


foreach x in 23 27 31 35 {
replace low_work_react = low_work_react_`x' if n == `x'
replace min_low_work_react = low_work_react_`x'  - 1.645 * se_low_work_react_`x'  if n == `x'
replace max_low_work_react = low_work_react_`x'  + 1.645 * se_low_work_react_`x'  if n == `x'
scalar up_`x'=low_work_react_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+10
}

foreach x in 24 28 32 36{
replace work_react = work_react_`x' if n == `x'
replace min_work_react = work_react_`x'  - 1.645 * se_work_react_`x'  if n == `x'
replace max_work_react = work_react_`x'  + 1.645 * se_work_react_`x'  if n == `x'
scalar up_`x'=work_react_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+15
}

foreach x in 25 29 33 37{
replace high_work_react = high_work_react_`x' if n == `x'
replace min_high_work_react = high_work_react_`x'  - 1.645 * se_high_work_react_`x'  if n == `x'
replace max_high_work_react = high_work_react_`x'  + 1.645 * se_high_work_react_`x'  if n == `x'
scalar up_`x'=high_work_react_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+10
}


grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"
graph twoway (bar low_wage_react n, horizontal color(ebblue) barwidth(1)) (rcap min_low_wage_react max_low_wage_react n, horizontal color(ebblue)) (bar wage_react n, horizontal color(gray) barwidth(1)) (rcap min_wage_react max_wage_react n, horizontal color(gray)) (bar high_wage_react n, horizontal color(cranberry) barwidth(1)) (rcap min_high_wage_react max_high_wage_react n, horizontal color(cranberry)) (bar low_work_react n, horizontal color(ebblue) barwidth(1)) (rcap min_low_work_react max_low_work_react n, horizontal color(ebblue)) (bar work_react n, horizontal color(gray) barwidth(1)) (rcap min_work_react max_work_react n, horizontal color(gray)) (bar high_work_react n, horizontal color(cranberry) barwidth(1)) (rcap min_high_work_react max_high_work_react n, horizontal color(cranberry)), ///
legend(order(1 3 5) lab(1 "{bf:Democrat}") lab(3 "{bf:Full sample}") lab(5 "{bf:Republican}")  size(large) position(6) cols(3) region(lcolor(black%50) lwidth(thin)) forces  symysize(4) symxsize(4) rowgap(0.7) colgap(0.6) just(left) placement(center)) ///
xlabel(0(10)100, nogrid noticks labsize(large)) ylabel(2 `" "Wage increase primarily due to inflation" "' 24 `" "Increased hours worked due to inflation" "' 6 `" "Wage increase primarily due to job performance" "' 28  `" "Switched to a higher paying job due to inflation" "' 10 `" "Received wage increase regardless of asking" "' 32 `" "Found an additional job due to inflation" "' 14 `" "Received wage increase they asked" "' 18   `" "Asked for a wage increase due to inflation" "' 21 `" "{bf:Wage increases}" "' 36   `" "Looked for an additional job due to inflation" "' 39 `" "{bf:Job changes}" "' , labsize(large) noticks nogrid)  xtitle(`"Share of respondents"', size(large)) ytitle("") ///
			text(1.3 `=pos3_1' "{bf:`=num_1'%}", size(medsmall) just(center) color(black%90)) ///
			text(2.3 `=pos3_2' "{bf:`=num_2'%}", size(medsmall) just(center) color(black%90)) ///
			text(3.3 `=pos3_3' "{bf:`=num_3'%}", size(medsmall) just(center) color(black%90)) ///
			text(5.3 `=pos3_5' "{bf:`=num_5'%}", size(medsmall) just(center) color(black%90)) ///
			text(6.3 `=pos3_6' "{bf:`=num_6'%}", size(medsmall) just(center) color(black%90)) ///
			text(7.3 `=pos3_7' "{bf:`=num_7'%}", size(medsmall) just(center) color(black%90)) ///
			text(9.3 `=pos3_9' "{bf:`=num_9'%}", size(medsmall) just(center) color(black%90)) ///
			text(10.3 `=pos3_10' "{bf:`=num_10'%}", size(medsmall) just(center) color(black%90)) ///
			text(11.3 `=pos3_11' "{bf:`=num_11'%}", size(medsmall) just(center) color(black%90)) ///
			text(13.3 `=pos3_13' "{bf:`=num_13'%}", size(medsmall) just(center) color(black%90)) ///
			text(14.3 `=pos3_14' "{bf:`=num_14'%}", size(medsmall) just(center) color(black%90)) ///
			text(15.3 `=pos3_15' "{bf:`=num_15'%}", size(medsmall) just(center) color(black%90)) ///
			text(17.3 `=pos3_17' "{bf:`=num_17'%}", size(medsmall) just(center) color(black%90)) ///
			text(18.3 `=pos3_18' "{bf:`=num_18'%}", size(medsmall) just(center) color(black%90)) ///
			text(19.3 `=pos3_19' "{bf:`=num_19'%}", size(medsmall) just(center) color(black%90)) ///
			text(23.3 `=pos3_23' "{bf:`=num_23'%}", size(medsmall) just(center) color(black%90)) ///
			text(24.3 `=pos3_24' "{bf:`=num_24'%}", size(medsmall) just(center) color(black%90)) ///
			text(25.3 `=pos3_25' "{bf:`=num_25'%}", size(medsmall) just(center) color(black%90)) ///
			text(27.3 `=pos3_27' "{bf:`=num_27'%}", size(medsmall) just(center) color(black%90)) ///
			text(28.3 `=pos3_28' "{bf:`=num_28'%}", size(medsmall) just(center) color(black%90)) ///
			text(29.3 `=pos3_29' "{bf:`=num_29'%}", size(medsmall) just(center) color(black%90)) ///
			text(31.3 `=pos3_31' "{bf:`=num_31'%}", size(medsmall) just(center) color(black%90)) ///
			text(32.3 `=pos3_32' "{bf:`=num_32'%}", size(medsmall) just(center) color(black%90)) ///
			text(33.3 `=pos3_33' "{bf:`=num_33'%}", size(medsmall) just(center) color(black%90)) ///
			text(35.3 `=pos3_35' "{bf:`=num_35'%}", size(medsmall) just(center) color(black%90)) ///
			text(36.3 `=pos3_36' "{bf:`=num_36'%}", size(medsmall) just(center) color(black%90)) ///
			text(37.3 `=pos3_37' "{bf:`=num_37'%}", size(medsmall) just(center) color(black%90)) ///

			resize, xsize(25cm) ysize(20cm)
graph save "$figures/FIG_A8.gpf", replace
graph export "$figures/FIG_A8.png", as(png) width(5000) height(4000) replace

restore

}
