clear all

/* Set root directory */
*global dir " " //set origin path
global code "$dir/replication_package/codes"
global survey_data "$dir/replication_package/data"
global output "$dir/replication_package/output"
global figures "$output/figures"
global tables "$output/tables"


*import and clean data
do "$code/data_cleaning/creating_dataset_A"

grstyle init
grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"


*generate indicators for the analysis
tab inf_exp_react_now_en, gen(inf_exp_react_now_agg_)
tab inf_exp_react_later_en, gen(inf_exp_react_later_agg_)

gen dummy_accel_ess = 0 if !missing(react_delay_ess_agg_en)
replace dummy_accel_ess=1 if react_delay_ess_agg_en==1|react_delay_ess_agg_en==2
label var dummy_accel_ess "Accelerated at least some essential goods"

gen dummy_accel_noess = 0 if !missing(react_delay_noess_agg_en)
replace dummy_accel_noess=1 if react_delay_noess_agg_en==1|react_delay_noess_agg_en==2
label var dummy_accel_noess "Accelerated at least some non essential goods"

gen inf_exp_react_now_decrease = 0 if!missing(inf_exp_react_now_en)
replace inf_exp_react_now_decrease=1 if inf_exp_react_now_en==3|inf_exp_react_now_en==4
label var inf_exp_react_now_decrease "Decreased spending somewhat or a lot right away"

gen inf_exp_react_now_increase = 0 if!missing(inf_exp_react_now_en)
replace inf_exp_react_now_increase =1 if inf_exp_react_now_en==1|inf_exp_react_now_en==2
label var inf_exp_react_now_increase "Increased spending somewhat or a lot right away"

gen inf_exp_react_later_decrease = 0 if!missing(inf_exp_react_later_en)
replace inf_exp_react_later_decrease=1 if inf_exp_react_later_en==3|inf_exp_react_later_en==4
label var inf_exp_react_later_decrease "Decrease spending somewhat or a lot later"

gen inf_exp_react_later_increase = 0 if!missing(inf_exp_react_later_en)
replace inf_exp_react_later_increase=1 if inf_exp_react_later_en==1|inf_exp_react_later_en==2
label var inf_exp_react_later_increase "Increase spending somewhat or a lot later"



**#FIGURE A6: PERSONAL REACTIONS TO INFLATION AS A CONSUMER, SPLIT BY POLITICAL AFFILIATION
***split respondents by political leaning and represent the answers to the inflation impacts as a consumer questions for "democrat", "republican" and "full sample"
{
preserve


global consumer_reactions  dummy_react_qual  dummy_accel_ess dummy_delay_ess dummy_accel_noess dummy_delay_noess  dummy_react_quant

global higher_inf dummy_react_timing_later dummy_react_timing_now   

global now  inf_exp_react_now_increase inf_exp_react_now_decrease

global later  inf_exp_react_later_increase inf_exp_react_later_decrease




global j=1

foreach var_selec of varlist $later{
	sum `var_selec' if political_agg==1
	scalar    low_later_${j}=r(mean)*100 
	scalar se_low_later_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
	sum `var_selec'
	scalar    full_later_${j}=r(mean)*100 
	scalar se_full_later_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
sum `var_selec' if political_agg==2
	scalar    high_later_${j}=r(mean)*100 
	scalar se_high_later_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +2
}

global j=$j +3

foreach var_selec of varlist $now{
	sum `var_selec' if political_agg==1
	scalar    low_now_${j}=r(mean)*100 
	scalar se_low_now_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
	sum `var_selec' 
	scalar    full_now_${j}=r(mean)*100 
	scalar se_full_now_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
	sum `var_selec' if political_agg==2
	scalar    high_now_${j}=r(mean)*100 
	scalar se_high_now_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +2
}

global j=$j +3

foreach var_selec of varlist $higher_inf {
	sum `var_selec' if political_agg==1
	scalar    low_react_high_${j}=r(mean)*100 
	scalar se_low_react_high_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
	sum `var_selec' 
	scalar    full_react_high_${j}=r(mean)*100 
	scalar se_full_react_high_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
	sum `var_selec' if political_agg==2
	scalar    high_react_high_${j}=r(mean)*100 
	scalar se_high_react_high_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +2
}

global j=$j +3

foreach var_selec of varlist $consumer_reactions{
	sum `var_selec' if political_agg==1
	scalar    low_react_cons_${j}=r(mean)*100 
	scalar se_low_react_cons_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
	sum `var_selec' 
	scalar    full_react_cons_${j}=r(mean)*100 
	scalar se_full_react_cons_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
	sum `var_selec' if political_agg==2
	scalar    high_react_cons_${j}=r(mean)*100 
	scalar se_high_react_cons_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +2
}




clear
set obs 56
egen n = seq()

foreach var in low_later full_later high_later low_now full_now high_now low_react_high full_react_high high_react_high low_react_cons full_react_cons high_react_cons {
gen `var' = . 
gen min_`var' = .
gen max_`var' = . 
}

foreach x in 1 5 {
replace low_later = low_later_`x' if n == `x'
replace min_low_later = low_later_`x'  - 1.645 * se_low_later_`x'  if n == `x'
replace max_low_later = low_later_`x'  + 1.645 * se_low_later_`x'  if n == `x'
scalar up_`x'=low_later_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+14
}

foreach x in 2 6  {
replace full_later = full_later_`x' if n == `x'
replace min_full_later = full_later_`x'  - 1.645 * se_full_later_`x'  if n == `x'
replace max_full_later = full_later_`x'  + 1.645 * se_full_later_`x'  if n == `x'
scalar up_`x'=full_later_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+14
}

foreach x in 3 7  {
replace high_later = high_later_`x' if n == `x'
replace min_high_later = high_later_`x'  - 1.645 * se_high_later_`x'  if n == `x'
replace max_high_later = high_later_`x'  + 1.645 * se_high_later_`x'  if n == `x'
scalar up_`x'=high_later_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+14
}

foreach x in 12 16 {
replace low_now = low_now_`x' if n == `x'
replace min_low_now = low_now_`x'  - 1.645 * se_low_now_`x'  if n == `x'
replace max_low_now = low_now_`x'  + 1.645 * se_low_now_`x'  if n == `x'
scalar up_`x'=low_now_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+14
}

foreach x in 13 17  {
replace full_now = full_now_`x' if n == `x'
replace min_full_now = full_now_`x'  - 1.645 * se_full_now_`x'  if n == `x'
replace max_full_now = full_now_`x'  + 1.645 * se_full_now_`x'  if n == `x'
scalar up_`x'=full_now_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+14
}

foreach x in 14 18  {
replace high_now = high_now_`x' if n == `x'
replace min_high_now = high_now_`x'  - 1.645 * se_high_now_`x'  if n == `x'
replace max_high_now = high_now_`x'  + 1.645 * se_high_now_`x'  if n == `x'
scalar up_`x'=high_now_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+14
}


foreach x in 23 27 {
replace low_react_high = low_react_high_`x' if n == `x'
replace min_low_react_high = low_react_high_`x'  - 1.645 * se_low_react_high_`x'  if n == `x'
replace max_low_react_high = low_react_high_`x'  + 1.645 * se_low_react_high_`x'  if n == `x'
scalar up_`x'=low_react_high_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+14
}

foreach x in 24 28 {
replace full_react_high = full_react_high_`x' if n == `x'
replace min_full_react_high = full_react_high_`x'  - 1.645 * se_full_react_high_`x'  if n == `x'
replace max_full_react_high = full_react_high_`x'  + 1.645 * se_full_react_high_`x'  if n == `x'
scalar up_`x'=full_react_high_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+14
}

foreach x in 25 29 {
replace high_react_high = high_react_high_`x' if n == `x'
replace min_high_react_high = high_react_high_`x'  - 1.645 * se_high_react_high_`x'  if n == `x'
replace max_high_react_high = high_react_high_`x'  + 1.645 * se_high_react_high_`x'  if n == `x'
scalar up_`x'=high_react_high_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+14
}

foreach x in 34 38 42 46 50 54 {
replace low_react_cons = low_react_cons_`x' if n == `x'
replace min_low_react_cons = low_react_cons_`x'  - 1.645 * se_low_react_cons_`x'  if n == `x'
replace max_low_react_cons = low_react_cons_`x'  + 1.645 * se_low_react_cons_`x'  if n == `x'
scalar up_`x'=low_react_cons_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+14
}

foreach x in 35 39 43 47 51 55{
replace full_react_cons = full_react_cons_`x' if n == `x'
replace min_full_react_cons = full_react_cons_`x'  - 1.645 * se_full_react_cons_`x'  if n == `x'
replace max_full_react_cons = full_react_cons_`x'  + 1.645 * se_full_react_cons_`x'  if n == `x'
scalar up_`x'=full_react_cons_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+14
}

foreach x in 36 40 44 48 52 56 {
replace high_react_cons = high_react_cons_`x' if n == `x'
replace min_high_react_cons = high_react_cons_`x'  - 1.645 * se_high_react_cons_`x'  if n == `x'
replace max_high_react_cons = high_react_cons_`x'  + 1.645 * se_high_react_cons_`x'  if n == `x'
scalar up_`x'=high_react_cons_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+14
}



grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"
graph twoway (bar low_react_cons n, horizontal color(ebblue) barwidth(1)) (rcap min_low_react_cons max_low_react_cons n, horizontal color(ebblue)) (bar full_react_cons n, horizontal color(gray) barwidth(1)) (rcap min_full_react_cons max_full_react_cons n, horizontal color(gray))   (bar high_react_cons n, horizontal color(cranberry) barwidth(1) ) (rcap min_high_react_cons max_high_react_cons n, horizontal color(cranberry))  ///
  (bar low_react_high n, horizontal color(ebblue) barwidth(1) ) (rcap min_low_react_high max_low_react_high n, horizontal color(ebblue)) (bar full_react_high n, horizontal color(gray) barwidth(1) ) (rcap min_full_react_high max_full_react_high n, horizontal color(gray)) (bar high_react_high n, horizontal color(cranberry) barwidth(1) ) (rcap min_high_react_high max_high_react_high n, horizontal color(cranberry)) ///
  (bar low_now n, horizontal color(ebblue) barwidth(1) ) (rcap min_low_now max_low_now n, horizontal color(ebblue)) (bar full_now n, horizontal color(gray) barwidth(1) ) (rcap min_full_now max_full_now n, horizontal color(gray))  (bar high_now n, horizontal color(cranberry) barwidth(1) ) (rcap min_high_now max_high_now n, horizontal color(cranberry)) ///
  (bar low_later n, horizontal color(ebblue) barwidth(1) ) (rcap min_low_later max_low_later n, horizontal color(ebblue)) (bar full_later n, horizontal color(gray) barwidth(1) ) (rcap min_full_later max_full_later n, horizontal color(gray)) (bar high_later n, horizontal color(cranberry) barwidth(1) ) (rcap min_high_later max_high_later n, horizontal color(cranberry)), ///
			 legend(order(1 3 5) lab(1 "{bf:Democrat}") lab(3 "{bf:Full sample}") lab(5 "{bf:Republican}")  size(large) position(6) cols(3) region(lcolor(black%50) lwidth(thin)) forces  symysize(4) symxsize(4) rowgap(0.7) colgap(0.6) just(left) placement(center)) ///
			 xlabel(0(10)100, nogrid noticks labsize(large)) ylabel(2 `" Increase somewhat or a lot"' 6 `" Decrease somewhat or a lot "'  9.5  `" "{bf:Change in spending close to the time when prices increase:}" "' ///
			 13 `" Increase somewhat or a lot "'  17 `" Decrease somewhat or a lot"'  20.5 `" "{bf:Change in spending right away:}" "'  /// 
			 24 `" "Change spending close to the time when I expect prices to increase" "'  28 `" "Change spending right away if I expect prices to increase" "'  31.5  `" "{bf:Reactions to higher expected inflation:}" "' 55 `" "Reduced the quantity of goods purchased" "' 35 `" "Shifted shopping towards lower-priced lower-quality goods" "' 39 `" "Accelerated the purchase of essential goods"  "' 43  `" "Delayed the purchase of essential goods"  "'47 `" "Accelerated the purchase of non-essential goods"  "' 51  `" "Delayed the purchase of non-essential goods"  "' 58.5 `" "{bf:Personal reactions to inflation in household spending:}" "' , labsize(large) noticks nogrid) title("") xtitle("Share of respondents" , size(large)) ytitle("")  xsize(11) ysize(5) ///
			  text(1.5 `=pos3_1' "{bf:`=num_1'%}", size(medium) just(center) color(black%90)) ///
			text(2.5 `=pos3_2' "{bf:`=num_2'%}", size(medium) just(center) color(black%90)) ///
			text(3.5 `=pos3_3' "{bf:`=num_3'%}", size(medium) just(center) color(black%90)) ///
			text(5.5 `=pos3_5' "{bf:`=num_5'%}", size(medium) just(center) color(black%90)) ///
			text(6.5 `=pos3_6' "{bf:`=num_6'%}", size(medium) just(center) color(black%90)) ///
			text(7.5 `=pos3_7' "{bf:`=num_7'%}", size(medium) just(center) color(black%90)) ///
			text(12.5 `=pos3_12' "{bf:`=num_12'%}", size(medium) just(center) color(black%90)) ///
			text(13.5 `=pos3_13' "{bf:`=num_13'%}", size(medium) just(center) color(black%90)) ///
			text(14.5 `=pos3_14' "{bf:`=num_14'%}", size(medium) just(center) color(black%90)) ///
			text(16.5 `=pos3_16' "{bf:`=num_16'%}", size(medium) just(center) color(black%90)) ///
			text(17.5 `=pos3_17' "{bf:`=num_17'%}", size(medium) just(center) color(black%90)) ///
			text(18.5 `=pos3_18' "{bf:`=num_18'%}", size(medium) just(center) color(black%90)) ///
			text(23.5 `=pos3_23' "{bf:`=num_23'%}", size(medium) just(center) color(black%90)) ///
			text(24.5 `=pos3_24' "{bf:`=num_24'%}", size(medium) just(center) color(black%90)) ///
			text(25.5 `=pos3_25' "{bf:`=num_25'%}", size(medium) just(center) color(black%90)) ///
			text(27.5 `=pos3_27' "{bf:`=num_27'%}", size(medium) just(center) color(black%90)) ///
			text(28.5 `=pos3_28' "{bf:`=num_28'%}", size(medium) just(center) color(black%90)) ///
			text(29.5 `=pos3_29' "{bf:`=num_29'%}", size(medium) just(center) color(black%90)) ///
			text(29.5 `=pos3_29' "{bf:`=num_29'%}", size(medium) just(center) color(black%90)) ///
			text(34.5 `=pos3_34' "{bf:`=num_34'%}", size(medium) just(center) color(black%90)) ///
			text(35.5 `=pos3_35' "{bf:`=num_35'%}", size(medium) just(center) color(black%90)) ///
			text(36.5 `=pos3_36' "{bf:`=num_36'%}", size(medium) just(center) color(black%90)) ///
			text(38.5 `=pos3_38' "{bf:`=num_38'%}", size(medium) just(center) color(black%90)) ///
			text(39.5 `=pos3_39' "{bf:`=num_39'%}", size(medium) just(center) color(black%90)) ///
			text(40.5 `=pos3_40' "{bf:`=num_40'%}", size(medium) just(center) color(black%90)) ///
			text(42.5 `=pos3_42' "{bf:`=num_42'%}", size(medium) just(center) color(black%90)) ///
			text(43.5 `=pos3_43' "{bf:`=num_43'%}", size(medium) just(center) color(black%90)) ///
			text(44.5 `=pos3_44' "{bf:`=num_44'%}", size(medium) just(center) color(black%90)) ///
			text(46.5 `=pos3_46' "{bf:`=num_46'%}", size(medium) just(center) color(black%90)) ///
			text(47.5 `=pos3_47' "{bf:`=num_47'%}", size(medium) just(center) color(black%90)) ///
			text(48.5 `=pos3_48' "{bf:`=num_48'%}", size(medium) just(center) color(black%90)) ///
			text(50.5 `=pos3_50' "{bf:`=num_50'%}", size(medium) just(center) color(black%90)) ///
			text(51.5 `=pos3_51' "{bf:`=num_51'%}", size(medium) just(center) color(black%90)) ///
			text(52.5 `=pos3_52' "{bf:`=num_52'%}", size(medium) just(center) color(black%90)) ///
			text(54.5 `=pos3_54' "{bf:`=num_54'%}", size(medium) just(center) color(black%90)) ///
			text(55.5 `=pos3_55' "{bf:`=num_55'%}", size(medium) just(center) color(black%90)) ///
			text(56.5 `=pos3_56' "{bf:`=num_56'%}", size(medium) just(center) color(black%90)) ///
		
 
			
			resize, xsize(35cm) ysize(30cm)
			
			
graph save "$figures/FIG_A6.gpf", replace
graph export "$figures/FIG_A6.png", as(png) width(5000) height(4285) replace

restore

}

