clear all

/* Set root directory */
*global dir " " //set origin path
global code "$dir/replication_package/codes"
global survey_data "$dir/replication_package/data"
global output "$dir/replication_package/output"
global figures "$output/figures"
global tables "$output/tables"


*import and clean data
do "$code/data_cleaning/creating_dataset_A"


grstyle init
grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"


*generate indicators for the analysis
tab inf_pol_cohesion_en, gen(inf_pol_cohesion_)
tab inf_pol_int_rep_en, gen(inf_pol_int_rep_)
tab inf_pol_cause_pol_en, gen(inf_pol_cause_pol_)




**# FIGURE A3: PERCEIVED SOCIAL AND POLITICAL CONSEQUENCES OF INFLATION, SPLIT BY INCOME
***split respondents by income and represent the answers to the inflation impacts as a consumer questions for "low income", "high income" and "full sample"
{
preserve

global politics  dummy_inf_pol_cohesion dummy_inf_pol_stability  dummy_inf_pol_reputation

global j=1

foreach var_selec of varlist $politics{
	sum `var_selec' if incomegroup_agg==1
	scalar    politics_d_${j}=r(mean)*100 
	scalar se_politics_d_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
	sum `var_selec'
	scalar    politics_f_${j}=r(mean)*100 
	scalar se_politics_f_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
sum `var_selec' if incomegroup_agg==3
	scalar    politics_r_${j}=r(mean)*100 
	scalar se_politics_r_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +2
}

clear
set obs 11
egen n = seq()

foreach var in politics_d politics_r politics_f {
gen `var' = . 
gen min_`var' = .
gen max_`var' = . 
}

foreach x in 1 5 9  {
replace politics_d = politics_d_`x' if n == `x'
replace min_politics_d = politics_d_`x'  - 1.645 * se_politics_d_`x'  if n == `x'
replace max_politics_d = politics_d_`x'  + 1.645 * se_politics_d_`x'  if n == `x'
scalar up_`x'=politics_d_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+10
}

foreach x in 2 6 10  {
replace politics_f = politics_f_`x' if n == `x'
replace min_politics_f = politics_f_`x'  - 1.645 * se_politics_f_`x'  if n == `x'
replace max_politics_f = politics_f_`x'  + 1.645 * se_politics_f_`x'  if n == `x'
scalar up_`x'=politics_f_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+10
}

foreach x in 3 7 11{
replace politics_r = politics_r_`x' if n == `x'
replace min_politics_r = politics_r_`x'  - 1.645 * se_politics_r_`x'  if n == `x'
replace max_politics_r = politics_r_`x'  + 1.645 * se_politics_r_`x'  if n == `x'
scalar up_`x'=politics_r_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+10
}




grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"
graph twoway (bar politics_d n, horizontal color(orange) barwidth(1)) (rcap min_politics_d max_politics_d n, horizontal color(orange)) (bar politics_f n, horizontal color(gray) barwidth(1)) (rcap min_politics_f max_politics_f n, horizontal color(gray)) (bar politics_r n, horizontal color("17 119 51") barwidth(1)) (rcap min_politics_r max_politics_r n, horizontal color("17 119 51")), ///
			 legend(order(1 3 5) lab(1 "{bf:Income <$40k}") lab(3 "{bf:Full sample}") lab(5 "{bf:Income >$125k}")  size(medium) position(6) cols(3) region(lcolor(black%50) lwidth(thin)) forces symysize(4) symxsize(4) rowgap(0.7) colgap(0.6) just(left) placement(center)) ///
			 xlabel(0(10)100, nogrid noticks labsize(large)) ylabel(2 `" "Inflation decreases social cohesion" "' 6 `" "Inflation decreases political stability" "' 10 `" "Inflation hurts international reputation" "', labsize(large) noticks nogrid)   xtitle(`"Share of respondents"', size(large)) ytitle("") ///
			text(1 `=pos3_1' "{bf:`=num_1'%}", size(medmsall) just(center) color(black%90)) ///
			text(2 `=pos3_2' "{bf:`=num_2'%}", size(medmsall) just(center) color(black%90)) ///
			text(3 `=pos3_3' "{bf:`=num_3'%}", size(medmsall) just(center) color(black%90)) ///
			text(5 `=pos3_5' "{bf:`=num_5'%}", size(medmsall) just(center) color(black%90)) ///
			text(6 `=pos3_6' "{bf:`=num_6'%}", size(medmsall) just(center) color(black%90)) ///
			text(7 `=pos3_7' "{bf:`=num_7'%}", size(medmsall) just(center) color(black%90)) ///
			text(9 `=pos3_9' "{bf:`=num_9'%}", size(medmsall) just(center) color(black%90)) ///
			text(10 `=pos3_10' "{bf:`=num_10'%}", size(medmsall) just(center) color(black%90)) ///
			text(11 `=pos3_11' "{bf:`=num_11'%}", size(medmsall) just(center) color(black%90)) ///
			xsize(10) ysize(5)
			 
			 

graph save "$figures/FIG_A3.gpf", replace
graph export "$figures/FIG_A3.png", as(png) width(4000) height(2000) replace

restore

}


