clear all

/* Set root directory */
*global dir " " //set origin path
global code "$dir/replication_package/codes"
global survey_data "$dir/replication_package/data"
global output "$dir/replication_package/output"
global figures "$output/figures"
global tables "$output/tables"


*import and clean data
do "$code/data_cleaning/creating_dataset_A"

grstyle init
grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"

*generate variables used in the analysis
gen rep=0 if !missing( political_agg)
replace rep=1 if political_agg==2
label var rep "Republican"

gen ind=0 if !missing( political_agg)
replace ind=1 if political_agg==3
label var ind "Independent"


tab inf_wage_theories, gen(inf_wage_theories_)


**#FIGURE8: WAGE ADJUSTMENT IN SMALL VS LARGE COMPANIES 
*generate indicators for analysis for the questions of interest
tab inf_adj_how_many_sf, gen(inf_adj_how_many_sf_)
tab inf_adj_how_many_bf, gen(inf_adj_how_many_bf_)
tab inf_adjust_why_sf, gen(inf_adjust_why_sf_)
tab inf_adjust_why_bf, gen(inf_adjust_why_bf_)
tab inf_notadjust_why_sf, gen(inf_notadjust_why_sf_)
tab inf_notadjust_why_bf, gen(inf_notadjust_why_bf_)	

{
preserve

global how_many_sf inf_adj_how_many_sf_1 inf_adj_how_many_sf_2 inf_adj_how_many_sf_3 inf_adj_how_many_sf_4 

global how_many_bf inf_adj_how_many_bf_1 inf_adj_how_many_bf_2 inf_adj_how_many_bf_3 inf_adj_how_many_bf_4  

global adjust_sf inf_adjust_why_sf_1 inf_adjust_why_sf_2 inf_adjust_why_sf_4 inf_adjust_why_sf_5 inf_adjust_why_sf_3

global adjust_bf inf_adjust_why_bf_1 inf_adjust_why_bf_2 inf_adjust_why_bf_4 inf_adjust_why_bf_5 inf_adjust_why_bf_3 

global not_adjust_sf inf_notadjust_why_sf_3 inf_notadjust_why_sf_1 inf_notadjust_why_sf_4 inf_notadjust_why_sf_2 

global not_adjust_bf inf_notadjust_why_bf_3 inf_notadjust_why_bf_1 inf_notadjust_why_bf_4 inf_notadjust_why_bf_2 



global j=1

foreach var_selec of varlist $adjust_sf{
	sum `var_selec'
	scalar    adjust_sf_${j}=r(mean)*100 
	scalar se_adjust_sf_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +3
}

global k=2

foreach var_selec of varlist $adjust_bf{
	sum `var_selec'
	scalar    adjust_bf_${k}=r(mean)*100 
	scalar se_adjust_bf_${k}=(r(sd)/sqrt(r(N)))*100
global k=$k +3
}

global j=$j +4

foreach var_selec of varlist $not_adjust_sf{
	sum `var_selec'
	scalar    not_adjust_sf_${j}=r(mean)*100 
	scalar se_not_adjust_sf_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +3
}

global k=$k +4

foreach var_selec of varlist $not_adjust_bf{
	sum `var_selec'
	scalar    not_adjust_bf_${k}=r(mean)*100 
	scalar se_not_adjust_bf_${k}=(r(sd)/sqrt(r(N)))*100
global k=$k +3
}

global j=$j +4

foreach var_selec of varlist $how_many_sf{
	sum `var_selec'
	scalar    many_sf_${j}=r(mean)*100 
	scalar se_many_sf_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +3
}

global k=$k +4

foreach var_selec of varlist $how_many_bf{
	sum `var_selec'
	scalar    many_bf_${k}=r(mean)*100 
	scalar se_many_bf_${k}=(r(sd)/sqrt(r(N)))*100
global k=$k +3
}


clear
set obs 46
egen n = seq()

foreach var in many_sf many_bf adjust_sf adjust_bf not_adjust_sf not_adjust_bf {
gen `var' = . 
gen min_`var' = .
gen max_`var' = . 
}

foreach x in 1 4 7 10 13 {
replace adjust_sf = adjust_sf_`x' if n == `x'
replace min_adjust_sf = adjust_sf_`x'  - 1.645 * se_adjust_sf_`x'  if n == `x'
replace max_adjust_sf = adjust_sf_`x'  + 1.645 * se_adjust_sf_`x'  if n == `x'
scalar up_`x'=adjust_sf_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}


foreach x in 2 5 8 11 14 {
replace adjust_bf = adjust_bf_`x' if n == `x'
replace min_adjust_bf = adjust_bf_`x'  - 1.645 * se_adjust_bf_`x'  if n == `x'
replace max_adjust_bf = adjust_bf_`x'  + 1.645 * se_adjust_bf_`x'  if n == `x'
scalar up_`x'=adjust_bf_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}


foreach x in 20 23 26 29 {
replace not_adjust_sf = not_adjust_sf_`x' if n == `x'
replace min_not_adjust_sf = not_adjust_sf_`x'  - 1.645 * se_not_adjust_sf_`x'  if n == `x'
replace max_not_adjust_sf = not_adjust_sf_`x'  + 1.645 * se_not_adjust_sf_`x'  if n == `x'
scalar up_`x'=not_adjust_sf_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}

foreach x in 21 24 27 30 {
replace not_adjust_bf = not_adjust_bf_`x' if n == `x'
replace min_not_adjust_bf = not_adjust_bf_`x'  - 1.645 * se_not_adjust_bf_`x'  if n == `x'
replace max_not_adjust_bf = not_adjust_bf_`x'  + 1.645 * se_not_adjust_bf_`x'  if n == `x'
scalar up_`x'=not_adjust_bf_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}

foreach x in 36 39 42 45{
replace many_sf = many_sf_`x' if n == `x'
replace min_many_sf = many_sf_`x'  - 1.645 * se_many_sf_`x'  if n == `x'
replace max_many_sf = many_sf_`x'  + 1.645 * se_many_sf_`x'  if n == `x'
scalar up_`x'=many_sf_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}

foreach x in 37 40 43 46{
replace many_bf = many_bf_`x' if n == `x'
replace min_many_bf = many_bf_`x'  - 1.645 * se_many_bf_`x'  if n == `x'
replace max_many_bf = many_bf_`x'  + 1.645 * se_many_bf_`x'  if n == `x'
scalar up_`x'=many_bf_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}

grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"
graph twoway (bar many_sf n, horizontal color(dknavy%80) barwidth(1))  (rcap min_many_sf max_many_sf n, horizontal color(dknavy%80)) ///
(bar many_bf n, horizontal color(cranberry%80) barwidth(1) ) (rcap min_many_bf max_many_bf n, horizontal color(cranberry%80)) ///
(bar adjust_sf n, horizontal color(dknavy%80) barwidth(1) ) (rcap min_adjust_sf max_adjust_sf n, horizontal color(dknavy%80)) ///
(bar adjust_bf n, horizontal color(cranberry%80) barwidth(1) ) (rcap min_adjust_bf max_adjust_bf n, horizontal color(cranberry%80)) ///
(bar not_adjust_sf n, horizontal color(dknavy%80) barwidth(1) ) (rcap min_not_adjust_sf max_not_adjust_sf n, horizontal color(dknavy%80)) ///
(bar not_adjust_bf n, horizontal color(cranberry%80) barwidth(1) ) (rcap min_not_adjust_bf max_not_adjust_bf n, horizontal color(cranberry%80)), ///
			  xlabel(0(10)100, nogrid noticks labsize(large)) ylabel( 1.5 `" "To ensure fairness" "' 4.5 `" "To preserve purchasing power of employees" "' 7.5 `" "To make employees work harder" "' 10.5 `" "To maintain employee morale" "' 13.5 `" "To attract and retain workers" "' 17 `" "{bf:Reasons why firms adjust wages:}" "' ///
			20.5 `" "To push workers to work harder" "' 23.5 `" "To deal with future uncertainty" "' 26.5 `" "To leverage employees low bargaining power" "' 29.5 `" "To control costs and increase profits" "' 33 `" "{bf:Reasons why firms do not adjust wages:}" "' 36.5 `" "Almost none" "' 39.5 `" "A few" "' 42.5 `" "Many"  "' 45.5 `" "Almost all" "'  49 `" "{bf:How many firms adjust wages in response to inflation?}" "' , labsize(large) noticks nogrid)  legend(order(1 3) lab(1 "{bf:Small firms}") lab(3 "{bf:Large firms}")  size(large) position(6) cols(2) region(lcolor(black%50) lwidth(thin)) forces  symysize(2) symxsize(3) rowgap(0.7) colgap(0.6) just(left) placement(center)) xtitle(`"Share of respondents"', size(large)) ytitle("")  ///
			text(1.2 `=pos3_1' "{bf:`=num_1'%}", size(medium) just(center) color(black%90)) ///
			text(2.2 `=pos3_2' "{bf:`=num_2'%}", size(medium) just(center) color(black%90)) ///
			text(4.2 `=pos3_4' "{bf:`=num_4'%}", size(medium) just(center) color(black%90)) ///
			text(5.2 `=pos3_5' "{bf:`=num_5'%}", size(medium) just(center) color(black%90)) ///
			text(7.2 `=pos3_7' "{bf:`=num_7'%}", size(medium) just(center) color(black%90)) ///
			text(8.2 `=pos3_8' "{bf:`=num_8'%}", size(medium) just(center) color(black%90)) ///
			text(10.2 `=pos3_10' "{bf:`=num_10'%}", size(medium) just(center) color(black%90)) ///
			text(11.2 `=pos3_11' "{bf:`=num_11'%}", size(medium) just(center) color(black%90)) ///
			text(13.2 `=pos3_13' "{bf:`=num_13'%}", size(medium) just(center) color(black%90)) ///
			text(14.2 `=pos3_14' "{bf:`=num_14'%}", size(medium) just(center) color(black%90)) ///
			text(20.2 `=pos3_20' "{bf:`=num_20'%}", size(medium) just(center) color(black%90)) ///
			text(21.2 `=pos3_21' "{bf:`=num_21'%}", size(medium) just(center) color(black%90)) ///
			text(23.2 `=pos3_23' "{bf:`=num_23'%}", size(medium) just(center) color(black%90)) ///
			text(24.2 `=pos3_24' "{bf:`=num_24'%}", size(medium) just(center) color(black%90)) ///
			text(26.2 `=pos3_26' "{bf:`=num_26'%}", size(medium) just(center) color(black%90)) ///
			text(27.2 `=pos3_27' "{bf:`=num_27'%}", size(medium) just(center) color(black%90)) ///
			text(29.2 `=pos3_29' "{bf:`=num_29'%}", size(medium) just(center) color(black%90)) ///
			text(30.2 `=pos3_30' "{bf:`=num_30'%}", size(medium) just(center) color(black%90)) ///
			text(36.2 `=pos3_36' "{bf:`=num_36'%}", size(medium) just(center) color(black%90)) ///
			text(37.2 `=pos3_37' "{bf:`=num_37'%}", size(medium) just(center) color(black%90)) ///
			text(39.2 `=pos3_39' "{bf:`=num_39'%}", size(medium) just(center) color(black%90)) ///
			text(40.2 `=pos3_40' "{bf:`=num_40'%}", size(medium) just(center) color(black%90)) ///
			text(42.2 `=pos3_42' "{bf:`=num_42'%}", size(medium) just(center) color(black%90)) ///
			text(43.2 `=pos3_43' "{bf:`=num_43'%}", size(medium) just(center) color(black%90)) ///
			text(45.2 `=pos3_45' "{bf:`=num_45'%}", size(medium) just(center) color(black%90)) ///
			text(46.2 `=pos3_46' "{bf:`=num_46'%}", size(medium) just(center) color(black%90)) ///
			xsize(10) ysize(10)
			
			resize, xsize(25cm) ysize(20cm)

graph save "$figures/FIG_8.gpf", replace
graph export "$figures/FIG_8.png", as(png) width(5000) height(4000) replace

restore

}