clear all

/* Set root directory */
*global dir " " //set origin path
global code "$dir/replication_package/codes"
global survey_data "$dir/replication_package/data"
global output "$dir/replication_package/output"
global figures "$output/figures"
global tables "$output/tables"


*import and clean data
do "$code/data_cleaning/creating_dataset_A"

grstyle init
grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"

*generate variables used in the analysis
gen rep=0 if !missing( political_agg)
replace rep=1 if political_agg==2
label var rep "Republican"

gen ind=0 if !missing( political_agg)
replace ind=1 if political_agg==3
label var ind "Independent"



tab pers_imp_ass_fin_ass, gen(pers_imp_ass_fin_ass_)
tab pers_imp_ass_savings, gen(pers_imp_ass_savings_)
tab pers_imp_ass_debt_va, gen(pers_imp_ass_debt_va_)
tab pers_imp_ass_debt_re, gen(pers_imp_ass_debt_re_)	

**#FIGURE 11: INFLATION IMPACTS AS AN ASSET HOLDER
***split respondents by income and represent the answers to the inflation impacts as a consumer questions for "low income", "high income" and "full sample"
{

preserve

global assets pers_imp_ass_fin_ass_3 pers_imp_ass_debt_va_3 pers_imp_ass_savings_3  pers_imp_ass_debt_re_3




global j=1

foreach var_selec of varlist $assets{
	sum `var_selec' if incomegroup_agg==1
	scalar    low_fin_ass_${j}=r(mean)*100 
	scalar low_se_fin_ass_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
	sum `var_selec' 
	scalar    full_fin_ass_${j}=r(mean)*100 
	scalar full_se_fin_ass_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
sum `var_selec' if incomegroup_agg==3
	scalar    high_fin_ass_${j}=r(mean)*100 
	scalar high_se_fin_ass_${j}=(r(sd)/sqrt(r(N)))*100
	global j=$j +2
}



clear
set obs 15
egen n = seq()

foreach var in low_fin_ass full_fin_ass high_fin_ass {
gen `var' = . 
gen min_`var' = .
gen max_`var' = . 
}

foreach x in 1 5 9 13{
replace low_fin_ass = low_fin_ass_`x' if n == `x'
replace min_low_fin_ass = low_fin_ass_`x'  - 1.645 * low_se_fin_ass_`x'  if n == `x'
replace max_low_fin_ass = low_fin_ass_`x'  + 1.645 * low_se_fin_ass_`x'  if n == `x'
scalar up_`x'=low_fin_ass_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}

foreach x in 2 6 10 14{
replace full_fin_ass = full_fin_ass_`x' if n == `x'
replace min_full_fin_ass = full_fin_ass_`x'  - 1.645 * full_se_fin_ass_`x'  if n == `x'
replace max_full_fin_ass = full_fin_ass_`x'  + 1.645 * full_se_fin_ass_`x'  if n == `x'
scalar up_`x'=full_fin_ass_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}


foreach x in 3 7 11 15{
replace high_fin_ass = high_fin_ass_`x' if n == `x'
replace min_high_fin_ass = high_fin_ass_`x'  - 1.645 * high_se_fin_ass_`x'  if n == `x'
replace max_high_fin_ass = high_fin_ass_`x'  + 1.645 * high_se_fin_ass_`x'  if n == `x'
scalar up_`x'=high_fin_ass_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}



grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"
graph twoway (bar low_fin_ass n, horizontal color(orange) barwidth(1) ) (rcap min_low_fin_ass max_low_fin_ass n, horizontal color(orange)) ///
(bar full_fin_ass n, horizontal color(gray) barwidth(1) ) (rcap min_full_fin_ass max_full_fin_ass n, horizontal color(gray)) ///
(bar high_fin_ass n, horizontal color("17 119 51") barwidth(1)) (rcap min_high_fin_ass max_high_fin_ass n, horizontal color("17 119 51")), ///
			 legend(order(1 3 5) lab(1 "{bf:Income <$40k}") lab(3 "{bf:Full sample}") lab(5 "{bf:Income >$125k}")  size(small) position(6) cols(3) region(lcolor(black%50) lwidth(thin)) forces  symysize(2) symxsize(3) rowgap(0.7) colgap(0.6) just(left) placement(center)) ///
			 xlabel(0(10)100, nogrid noticks) ylabel(2 `" "Inflation decreased the value of my financial assets" "' 10 `" "Inflation decreased the value of my savings" "' ///
			 6 `" "Inflation increased the real value of my debt" "' 14 `" "Inflation made repaying debts/loans harder than before" "' , labsize(medsmall) noticks nogrid) xtitle(`"Share of respondents"') ytitle("") ///
			text(1.2 `=pos3_1' "{bf:`=num_1'%}", size(medsmall) just(center) color(black%90)) ///
			text(2.2 `=pos3_2' "{bf:`=num_2'%}", size(medsmall) just(center) color(black%90)) ///
			text(3.2 `=pos3_3' "{bf:`=num_3'%}", size(medsmall) just(center) color(black%90)) ///
			text(5.2 `=pos3_5' "{bf:`=num_5'%}", size(medsmall) just(center) color(black%90)) ///
			text(6.2 `=pos3_6' "{bf:`=num_6'%}", size(medsmall) just(center) color(black%90)) ///
			text(7.2 `=pos3_7' "{bf:`=num_7'%}", size(medsmall) just(center) color(black%90)) ///
			text(9.2 `=pos3_9' "{bf:`=num_9'%}", size(medsmall) just(center) color(black%90)) ///
			text(10.2 `=pos3_10' "{bf:`=num_10'%}", size(medsmall) just(center) color(black%90)) ///
			text(11.2 `=pos3_11' "{bf:`=num_11'%}", size(medsmall) just(center) color(black%90)) ///
			text(13.2 `=pos3_13' "{bf:`=num_13'%}", size(medsmall) just(center) color(black%90)) ///
			text(14.2 `=pos3_14' "{bf:`=num_14'%}", size(medsmall) just(center) color(black%90)) ///
			text(15.2 `=pos3_15' "{bf:`=num_15'%}", size(medsmall) just(center) color(black%90)) ///
			xsize(10) ysize(5)

graph save "$figures/FIG_11.gpf", replace
graph export "$figures/FIG_11.png", as(png) width(6000) height(3333) replace

restore
	
}