clear all

/* Set root directory */
*global dir " " //set origin path
global code "$dir/replication_package/codes"
global survey_data "$dir/replication_package/data"
global output "$dir/replication_package/output"
global figures "$output/figures"
global tables "$output/tables"


*import and clean data
do "$code/data_cleaning/creating_dataset_A"

grstyle init
grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"

*generate variables used in the analysis
gen rep=0 if !missing( political_agg)
replace rep=1 if political_agg==2
label var rep "Republican"

gen ind=0 if !missing( political_agg)
replace ind=1 if political_agg==3
label var ind "Independent"


*generate indicators for analysis for the questions of interest
tab inf_adj_how_many_sf, gen(inf_adj_how_many_sf_)
tab inf_adj_how_many_bf, gen(inf_adj_how_many_bf_)
tab inf_adjust_why_sf, gen(inf_adjust_why_sf_)
tab inf_adjust_why_bf, gen(inf_adjust_why_bf_)
tab inf_notadjust_why_sf, gen(inf_notadjust_why_sf_)
tab inf_notadjust_why_bf, gen(inf_notadjust_why_bf_)	




**#TABLE A9: CORRELATES OF WAGE ADJUSTMENT IN SMALL COMPANIES 
{
eststo clear
global table_name "$tables/TABLE_A9"

* Table end
file open  holder using $tables/temp_end.tex, write replace text
file write holder "\hline \hline \end{tabular}" _n
file close holder

* Table start
file open holder using $table_name.tex, write replace text
file write holder "\begin{tabular}{lccccccccccccc} " _n
file write holder "& \multicolumn{13}{c}{ \textit{Dependent variable}}  \\" _n
file write holder "& \multicolumn{4}{c}{ \textbf{How many firms adjust wages}} & \multicolumn{4}{c}{ \textbf{Reasons why firms do not}} & \multicolumn{5}{c}{ \textbf{Reasons why firms}} \\" _n
file write holder "& \multicolumn{4}{c}{ \textbf{in response to inflation}} & \multicolumn{4}{c}{ \textbf{adjust wages}} & \multicolumn{5}{c}{ \textbf{adjust wages}} \\" _n
file write holder "  \cmidrule(lr){2-5}  \cmidrule(lr){6-9}  \cmidrule(lr){10-14} " _n
file write holder "& Almost  & Many & A few  & Almost & To control costs & To leverage & To deal with & To push workers & To attract and & To maintain & To make employees & To preserve & To ensure \\" _n
file write holder "& all & & & none & and increase profits & employees low & future uncertainty & to work harder & retain workers & employee morale & work harder & purchasing power & fairness \\ " _n
file write holder " & & & & & & bargaining power & & & & & & of employees & \\ \hline" _n
file write holder " \cmidrule(lr){2-13}" _n
file close holder

	
global controls_main women age_class_agg2 age_class_agg3  dummy_race_agg2 dummy_race_agg3 dummy_race_agg4  incomegroup_agg_2 incomegroup_agg_3 dummy_employment_agg2 dummy_employment_agg1 dummy_employment_agg4 dummy_married dummy_children dummy_us_area1 dummy_us_area2 dummy_us_area3  college republican political_agg3


eststo clear


eststo: reg inf_adj_how_many_sf_4  $controls_main , vce(robust)
local r1: display %5.3f `e(r2_a)'

qui sum inf_adj_how_many_sf_4 if e(sample) 
local mean1: display %5.3f `r(mean)'
local obs1: display %5.0f `r(N)'
local sd1: display %5.3f `r(sd)'

eststo: reg inf_adj_how_many_sf_3  $controls_main , vce(robust)
local r2: display %5.3f `e(r2_a)'

qui sum inf_adj_how_many_sf_3 if e(sample) 
local mean2: display %5.3f `r(mean)'
local obs2: display %5.0f `r(N)'
local sd2: display %5.3f `r(sd)'

eststo: reg inf_adj_how_many_sf_2  $controls_main , vce(robust)
local r3: display %5.3f `e(r2_a)'

qui sum inf_adj_how_many_sf_2 if e(sample) 
local mean3: display %5.3f `r(mean)'
local obs3: display %5.0f `r(N)'
local sd3: display %5.3f `r(sd)'


eststo: reg inf_adj_how_many_sf_1  $controls_main , vce(robust)
local r4: display %5.3f `e(r2_a)'

qui sum inf_adj_how_many_sf_1 if e(sample) 
local mean4: display %5.3f `r(mean)'
local obs4: display %5.0f `r(N)'
local sd4: display %5.3f `r(sd)'


eststo: reg inf_notadjust_why_sf_2  $controls_main , vce(robust)
local r5: display %5.3f `e(r2_a)'

qui sum inf_notadjust_why_sf_2 if e(sample) 
local mean5: display %5.3f `r(mean)'
local obs5: display %5.0f `r(N)'
local sd5: display %5.3f `r(sd)'


eststo: reg inf_notadjust_why_sf_4  $controls_main , vce(robust)
local r6: display %5.3f `e(r2_a)'

qui sum inf_notadjust_why_sf_4 if e(sample) 
local mean6: display %5.3f `r(mean)'
local obs6: display %5.0f `r(N)'
local sd6: display %5.3f `r(sd)'

eststo: reg inf_notadjust_why_sf_1  $controls_main , vce(robust)
local r7: display %5.3f `e(r2_a)'

qui sum inf_notadjust_why_sf_1 if e(sample) 
local mean7: display %5.3f `r(mean)'
local obs7: display %5.0f `r(N)'
local sd7: display %5.3f `r(sd)'

eststo: reg inf_notadjust_why_sf_3  $controls_main , vce(robust)
local r8: display %5.3f `e(r2_a)'

qui sum inf_notadjust_why_sf_3 if e(sample) 
local mean8: display %5.3f `r(mean)'
local obs8: display %5.0f `r(N)'
local sd8: display %5.3f `r(sd)'

eststo: reg inf_adjust_why_sf_3  $controls_main , vce(robust)
local r9: display %5.3f `e(r2_a)'

qui sum inf_adjust_why_sf_3 if e(sample) 
local mean9: display %5.3f `r(mean)'
local obs9: display %5.0f `r(N)'
local sd9: display %5.3f `r(sd)'

eststo: reg inf_adjust_why_sf_5  $controls_main , vce(robust)
local r10: display %5.3f `e(r2_a)'

qui sum inf_adjust_why_sf_5 if e(sample) 
local mean10: display %5.3f `r(mean)'
local obs10: display %5.0f `r(N)'
local sd10: display %5.3f `r(sd)'


eststo: reg inf_adjust_why_sf_4  $controls_main , vce(robust)
local r11: display %5.3f `e(r2_a)'

qui sum inf_adjust_why_sf_4 if e(sample) 
local mean11: display %5.3f `r(mean)'
local obs11: display %5.0f `r(N)'
local sd11: display %5.3f `r(sd)'


eststo: reg inf_adjust_why_sf_2  $controls_main , vce(robust)
local r12: display %5.3f `e(r2_a)'

qui sum inf_adjust_why_sf_2 if e(sample) 
local mean12: display %5.3f `r(mean)'
local obs12: display %5.0f `r(N)'
local sd12: display %5.3f `r(sd)'

eststo: reg inf_adjust_why_sf_1  $controls_main , vce(robust)
local r13: display %5.3f `e(r2_a)'

qui sum inf_adjust_why_sf_1 if e(sample) 
local mean13: display %5.3f `r(mean)'
local obs13: display %5.0f `r(N)'
local sd13: display %5.3f `r(sd)'


esttab using $tables/panel.tex, replace fragment booktabs noconst nobase label cells(b(fmt(3) star) se(par fmt(3))) collabels(none) /// 
starlevels(* .1 ** .05 *** .01) se nonumbers nomtitles nolines nocon noobs compress

eststo clear

*** Means ***
file open holder using $tables/panel_means.tex, write replace text
file write holder "\hline " _n
file write holder "Observations & `obs1' & `obs2' & `obs3' & `obs4' & `obs5' & `obs6' & `obs7' & `obs8'  & `obs9' & `obs10' & `obs11' & `obs12' & `obs13'  \\" _n     
file write holder "Adj. R$^{2}$ & `r1' & `r2' & `r3' & `r4' & `r5' & `r6' & `r7' & `r8'  & `r9' & `r10' & `r11' & `r12' & `r13'  \\" _n 
file write holder "Dependent variable mean & `mean1' & `mean2' & `mean3'  & `mean4'  & `mean5'  & `mean6' & `mean7' & `mean8' & `mean9' & `mean10' & `mean11' & `mean12' & `mean13' \\" _n   
file write holder "Dependent variable std. dev. & `sd1' & `sd2' & `sd3' & `sd4' & `sd5' & `sd6' & `sd7' & `sd8' & `sd9' & `sd10' & `sd11' & `sd12' & `sd13'  \\" _n
file close holder

appendfile $tables/panel.tex $table_name.tex
appendfile $tables/panel_means.tex $table_name.tex
appendfile $tables/temp_end.tex $table_name.tex

erase $tables/panel.tex
erase $tables/panel_means.tex
erase $tables/temp_end.tex 

eststo clear
	
}

