clear all

/* Set root directory */
*global dir " " //set origin path
global code "$dir/replication_package/codes"
global survey_data "$dir/replication_package/data"
global output "$dir/replication_package/output"
global figures "$output/figures"
global tables "$output/tables"


*import and clean data
do "$code/data_cleaning/creating_dataset_A"


grstyle init
grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"



*generate indicator for ranking questions
tab inf_priority_rank_ec_1_en, gen(inf_priority_rank_ec_1_en_)
tab inf_priority_rank_ec_2_en, gen(inf_priority_rank_ec_2_en_)
tab inf_priority_rank_ec_3_en, gen(inf_priority_rank_ec_3_en_)	
tab inf_priority_rank_ec_4_en, gen(inf_priority_rank_ec_4_en_)
tab inf_priority_rank_ec_5_en, gen(inf_priority_rank_ec_5_en_)

tab inf_priority_rank_sc_1_en, gen(inf_priority_rank_sc_1_en_)
tab inf_priority_rank_sc_2_en, gen(inf_priority_rank_sc_2_en_)
tab inf_priority_rank_sc_3_en, gen(inf_priority_rank_sc_3_en_)	
tab inf_priority_rank_sc_4_en, gen(inf_priority_rank_sc_4_en_)
tab inf_priority_rank_sc_5_en, gen(inf_priority_rank_sc_5_en_)
tab inf_priority_rank_sc_6_en, gen(inf_priority_rank_sc_6_en_)



**#TABLE A22: CORRELATES OF RANKING OF SOCIAL AND ECONOMIC ISSUES
{

eststo clear
global table_name "$tables/TABLE_A22"

* Table end
file open  holder using $tables/temp_end.tex, write replace text
file write holder "\hline \hline \end{tabular}" _n
file close holder

* Table start
file open holder using $table_name.tex, write replace text
file write holder "\begin{tabular}{lccccccccccc} " _n
file write holder "& \multicolumn{11}{c}{ \textit{Dependent variable}}  \\" _n
file write holder "& \multicolumn{5}{c}{ \textbf{Economic issues}} & \multicolumn{6}{c}{ \textbf{Social issues}} \\" _n
file write holder "  \cmidrule(lr){2-6}  \cmidrule(lr){7-12}  " _n
file write holder "& Inflation & Financial & Economic & Low & National & Inflation & Healthcare & Civil & Education & Gun & Abortion \\" _n
file write holder "& & stability & growth & unemployment & defense & & & rights & & rights & \\ \hline" _n
file write holder " \cmidrule(lr){2-12}" _n
file close holder

	
global controls_main women age_class_agg2 age_class_agg3  dummy_race_agg2 dummy_race_agg3 dummy_race_agg4  incomegroup_agg_2 incomegroup_agg_3 dummy_employment_agg2 dummy_employment_agg1 dummy_employment_agg4 dummy_married dummy_children dummy_us_area1 dummy_us_area2 dummy_us_area3  college republican political_agg3


eststo clear


eststo: reg dummy_inf_first_ec  $controls_main , vce(robust)
local r1: display %5.3f `e(r2_a)'

qui sum dummy_inf_first_ec if e(sample) 
local mean1: display %5.3f `r(mean)'
local obs1: display %5.0f `r(N)'
local sd1: display %5.3f `r(sd)'

eststo: reg dummy_finstab_first_ec  $controls_main , vce(robust)
local r2: display %5.3f `e(r2_a)'

qui sum dummy_finstab_first_ec if e(sample) 
local mean2: display %5.3f `r(mean)'
local obs2: display %5.0f `r(N)'
local sd2: display %5.3f `r(sd)'

eststo: reg dummy_growth_first_ec  $controls_main , vce(robust)
local r3: display %5.3f `e(r2_a)'

qui sum dummy_growth_first_ec if e(sample) 
local mean3: display %5.3f `r(mean)'
local obs3: display %5.0f `r(N)'
local sd3: display %5.3f `r(sd)'


eststo: reg dummy_lowu_first_ec  $controls_main , vce(robust)
local r4: display %5.3f `e(r2_a)'

qui sum dummy_lowu_first_ec if e(sample) 
local mean4: display %5.3f `r(mean)'
local obs4: display %5.0f `r(N)'
local sd4: display %5.3f `r(sd)'


eststo: reg dummy_defense_first_ec  $controls_main , vce(robust)
local r5: display %5.3f `e(r2_a)'

qui sum dummy_defense_first_ec if e(sample) 
local mean5: display %5.3f `r(mean)'
local obs5: display %5.0f `r(N)'
local sd5: display %5.3f `r(sd)'


eststo: reg dummy_inf_first_sc  $controls_main , vce(robust)
local r6: display %5.3f `e(r2_a)'

qui sum dummy_inf_first_sc if e(sample) 
local mean6: display %5.3f `r(mean)'
local obs6: display %5.0f `r(N)'
local sd6: display %5.3f `r(sd)'

eststo: reg dummy_health_first_sc  $controls_main , vce(robust)
local r7: display %5.3f `e(r2_a)'

qui sum dummy_health_first_sc if e(sample) 
local mean7: display %5.3f `r(mean)'
local obs7: display %5.0f `r(N)'
local sd7: display %5.3f `r(sd)'

eststo: reg dummy_civil_first_sc  $controls_main , vce(robust)
local r8: display %5.3f `e(r2_a)'

qui sum dummy_civil_first_sc if e(sample) 
local mean8: display %5.3f `r(mean)'
local obs8: display %5.0f `r(N)'
local sd8: display %5.3f `r(sd)'

eststo: reg dummy_educ_first_sc  $controls_main , vce(robust)
local r9: display %5.3f `e(r2_a)'

qui sum dummy_educ_first_sc if e(sample) 
local mean9: display %5.3f `r(mean)'
local obs9: display %5.0f `r(N)'
local sd9: display %5.3f `r(sd)'

eststo: reg dummy_gun_first_sc  $controls_main , vce(robust)
local r10: display %5.3f `e(r2_a)'

qui sum dummy_gun_first_sc if e(sample) 
local mean10: display %5.3f `r(mean)'
local obs10: display %5.0f `r(N)'
local sd10: display %5.3f `r(sd)'


eststo: reg dummy_abortion_first_sc  $controls_main , vce(robust)
local r11: display %5.3f `e(r2_a)'

qui sum dummy_abortion_first_sc if e(sample) 
local mean11: display %5.3f `r(mean)'
local obs11: display %5.0f `r(N)'
local sd11: display %5.3f `r(sd)'


esttab using $tables/panel.tex, replace fragment booktabs noconst nobase label cells(b(fmt(3) star) se(par fmt(3))) collabels(none) /// 
starlevels(* .1 ** .05 *** .01) se nonumbers nomtitles nolines nocon noobs compress

eststo clear

*** Means ***
file open holder using $tables/panel_means.tex, write replace text
file write holder "\hline " _n
file write holder "Observations & `obs1' & `obs2' & `obs3' & `obs4' & `obs5' & `obs6' & `obs7' & `obs8'  & `obs9' & `obs10' & `obs11' \\" _n     
file write holder "Adj. R$^{2}$ & `r1' & `r2' & `r3' & `r4' & `r5' & `r6' & `r7' & `r8'  & `r9' & `r10' & `r11'    \\" _n 
file write holder "Dependent variable mean & `mean1' & `mean2' & `mean3'  & `mean4'  & `mean5'  & `mean6' & `mean7' & `mean8' & `mean9' & `mean10' & `mean11' \\" _n   
file write holder "Dependent variable std. dev. & `sd1' & `sd2' & `sd3' & `sd4' & `sd5' & `sd6' & `sd7' & `sd8' & `sd9' & `sd10' & `sd11'  \\" _n
file close holder

appendfile $tables/panel.tex $table_name.tex
appendfile $tables/panel_means.tex $table_name.tex
appendfile $tables/temp_end.tex $table_name.tex

erase $tables/panel.tex
erase $tables/panel_means.tex
erase $tables/temp_end.tex 

eststo clear
	
}



