clear all

/* Set root directory */
*global dir " " //set origin path
global code "$dir/replication_package/codes"
global survey_data "$dir/replication_package/data"
global output "$dir/replication_package/output"
global figures "$output/figures"
global tables "$output/tables"



grstyle init
grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"

*****CREATING THE DATASET
{
*import the first waves of collection and append the last one
do "$code/data_cleaning/creating_dataset_B_2"
tempfile B2
save `B2'

do "$code/data_cleaning/creating_dataset_B_1"
append using `B2'


*here we keep only the relevant het variables. Modify this if you need more
keep screen gender ResponseId income_group pol_aff pers_imp_feelings age race education_level emp_status marital_status us_area children
*Income group (coarser partition aggregating groups)
encode screen, gen(complete)

gen women=.
replace women=0 if complete==1
replace women=1 if gender==2

gen dummy_children=.
replace dummy_children=0 if (complete==1 & children==1)
replace dummy_children=1 if complete==1 & (children==2|children==3|children==4|children==5|children==6)

gen age_class_agg= 0 if !mi(age)
replace age_class_agg=1 if age >= 18 & age <= 29
replace age_class_agg=2 if age >= 30 & age <= 49
replace age_class_agg=3 if age >= 50 & age <= 69
label define age_class_agg 1 "18-29" 2 "30-49" 3 "50-69"
label val age_class_agg age_class_agg

tab(age_class_agg), gen(age_class_agg)

tab(us_area), gen(dummy_us_area)


gen 			race_group = "White" 	if complete==1
replace 		race_group = "Black" 	if(race==2 & complete==1)
replace 		race_group = "Hispanic" if(race==3 & complete==1)
replace 		race_group = "Other" 	if(race>3 & complete==1)
label define 	race_agg 0 "White" 1 "Black" 2 "Hispanic" 3 "Other"
encode 			race_group, gen(race_agg) label(race_agg)

tab race_agg, gen(dummy_race_agg)



gen 			incomegroup_agg =.
replace 		incomegroup_agg = 1 if income_group == 1 | income_group == 2
replace 		incomegroup_agg = 2 if income_group == 3 | income_group == 4 | income_group == 5 
replace 		incomegroup_agg = 3 if  income_group == 6
label define 	incomegroup_agg 1 "0k-39k" 2 "40k-124k" 3 "124k+"
label val 		incomegroup_agg incomegroup_agg

tab incomegroup_agg, gen(incomegroup_agg_)

gen political_agg = 1 if( pol_aff==2)
	replace political_agg = 2 if(pol_aff==1)
	replace political_agg = 3 if(pol_aff>2)
label define political_agg 1 "Democrat" 2 "Republican" 3 "Independent and others"
label val political_agg political_agg

tab political_agg, gen(political_agg)


gen 			college=.
replace 		college=0 if complete==1
replace 		college=1 if education_level>5 
label define 	college_degree 0 "No College" 1 "4-year College Degree"
label val 		college college_degree
label var 		college "College Degree"



gen employment_agg = 1 if complete==1
	replace employment_agg = 2 if(complete==1 & emp_status<4)
	replace employment_agg = 3 if(complete==1 & emp_status==4 |complete==1 & emp_status==6)
	replace employment_agg = 4 if(complete==1 & emp_status==7)
label define employment_agg 1 "Student" 2 "Working" 3 "Not working" 4 "Retiree"
label val employment_agg employment_agg

tab employment_agg, gen(dummy_employment_agg)


gen dummy_married = 0 if !missing(marital_status)
replace dummy_married=1 if marital_status==2



gen republican=.
replace republican=0 if complete==1
replace republican=1 if pol_aff==1

gen democrat=.
replace democrat=0 if complete==1
replace democrat=1 if pol_aff==2



label var age_class_agg1 "Age 18-29"
label var age_class_agg2 "Age 30-49"
label var age_class_agg3 "Age 50-69"
label var political_agg2 "Republican"
label var incomegroup_agg_1 "Low-income"
label var incomegroup_agg_2 "Middle-income"
label var incomegroup_agg_3 "High-income"
label var women "Female"
label var democrat "Democrat"
label var republican "Republican"
label var political_agg3 "Independent and Others"
label var dummy_race_agg1 "White"
label var dummy_race_agg2 "Black"
label var dummy_race_agg3 "Hispanic"
label var dummy_race_agg4 "Other"
label var dummy_employment_agg1 "Student"
label var dummy_employment_agg2 "Working"
label var dummy_employment_agg3 "Not working"
label var dummy_employment_agg4 "Retiree"
label var dummy_children "Has children"
label var dummy_us_area1 "Northeast"
label var dummy_us_area2 "South"
label var dummy_us_area3 "Midwest"
label var dummy_us_area4 "West"
label var college "4-year college"
label var dummy_married "Married"

tempfile survey
save `survey'

*progressively merge with survey data: why interesting inflation
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("inf_info_int_why") firstrow  clear
foreach var of varlist inf_info_int_why_*{
	replace `var'=0 if `var'==.
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m
tempfile survey
save `survey'

*progressively merge with survey data: what bad could happen if inflation too high?
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("inf_info_bad_what") firstrow  clear
foreach var of varlist inf_info_bad_what_*{
	replace `var'=0 if `var'==.
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m
tempfile survey
save `survey'

*progressively merge with survey data: what bad could happen if inflation too high?
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("inf_info_high_why") firstrow  clear
foreach var of varlist inf_info_high_why_*{
	replace `var'=0 if `var'==.
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m
tempfile survey
save `survey'

*progressively merge with survey data: positivie impact of inflation?
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("inf_info_positive") firstrow  clear
foreach var of varlist inf_info_positive_*{
	replace `var'=0 if `var'==.
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m
tempfile survey
save `survey'

*progressively merge with survey data: impact of inflation?
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("pers_imp_me") firstrow  clear
foreach var of varlist pers_imp_me_*{
	replace `var'=0 if `var'==.
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m
tempfile survey
save `survey'

*progressively merge with survey data: what caused changes in income
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("pers_imp_inc_change") firstrow  clear
foreach var of varlist pers_imp_inc_change_*{
	replace `var'=0 if `var'==.
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m
tempfile survey
save `survey'

*progressively merge with survey data: angry at who
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("pers_imp_angry_who") firstrow  clear
drop G H I
foreach var of varlist pers_imp_angry_who_*{
	replace `var' = 0 if `var' == .
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m
tempfile survey
save `survey'

*progressively merge with survey data: definition
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("inf_def_open_1") firstrow  clear
foreach var of varlist inf_def_open_1_*{
	replace `var'=0 if `var'==.
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m

drop if ResponseId=="TOTAL"
drop if incomegroup_agg==.

*merge the emotion classification
merge 1:1 ResponseId using $survey_data/emotion_classification.dta
drop _m
levelsof emotion_inflation, local(emotions)

foreach name of local emotions {
        gen emotion_`name' = (emotion_inflation == "`name'") 
 
}

*Drop all the ResponseId which were not correctly merged. Now you have 504 observations
drop if substr(ResponseId, 1, 2) != "R_"
}


**#TABLE A20: CORRELATES OF "WHEN I WENT TO THE STORE AND SAW THAT PRICES WERE HIGHER, I FELT ANGRY AT... [OPEN-ENDED TEXT]"
{

eststo clear
global table_name "$tables/TABLE_A20"

* Table end
file open  holder using $tables/temp_end.tex, write replace text
file write holder "\hline \hline \end{tabular}" _n
file close holder

* Table start
file open holder using $table_name.tex, write replace text
file write holder "\begin{tabular}{lcccc} " _n
file write holder "& \multicolumn{4}{c}{ \textit{Dependent variable: When I went to the store and saw that}}  \\" _n
file write holder "& \multicolumn{4}{c}{ \textit{prices were higher, I felt angry at...}}  \\" _n
file write holder "& Government & Business & Overall system & Biden \\ \hline" _n
file write holder " \cmidrule(lr){2-5}" _n
file close holder

	
global controls_main women age_class_agg2 age_class_agg3  dummy_race_agg2 dummy_race_agg3 dummy_race_agg4  incomegroup_agg_2 incomegroup_agg_3 dummy_employment_agg2 dummy_employment_agg1 dummy_employment_agg4 dummy_married dummy_children dummy_us_area1 dummy_us_area2 dummy_us_area3  college republican political_agg3


eststo clear


eststo: reg pers_imp_angry_who_government  $controls_main , vce(robust)
local r1: display %5.3f `e(r2_a)'

qui sum pers_imp_angry_who_government if e(sample) 
local mean1: display %5.3f `r(mean)'
local obs1: display %5.0f `r(N)'
local sd1: display %5.3f `r(sd)'

eststo: reg pers_imp_angry_who_businesses  $controls_main , vce(robust)
local r2: display %5.3f `e(r2_a)'

qui sum pers_imp_angry_who_businesses if e(sample) 
local mean2: display %5.3f `r(mean)'
local obs2: display %5.0f `r(N)'
local sd2: display %5.3f `r(sd)'

eststo: reg pers_imp_angry_who_system  $controls_main , vce(robust)
local r3: display %5.3f `e(r2_a)'

qui sum pers_imp_angry_who_system if e(sample) 
local mean3: display %5.3f `r(mean)'
local obs3: display %5.0f `r(N)'
local sd3: display %5.3f `r(sd)'


eststo: reg pers_imp_angry_who_biden  $controls_main , vce(robust)
local r4: display %5.3f `e(r2_a)'

qui sum pers_imp_angry_who_biden if e(sample) 
local mean4: display %5.3f `r(mean)'
local obs4: display %5.0f `r(N)'
local sd4: display %5.3f `r(sd)'


esttab using $tables/panel.tex, replace fragment booktabs noconst nobase label cells(b(fmt(3) star) se(par fmt(3))) collabels(none) /// 
starlevels(* .1 ** .05 *** .01) se nonumbers nomtitles nolines nocon noobs compress

eststo clear

*** Means ***
file open holder using $tables/panel_means.tex, write replace text
file write holder "\hline " _n
file write holder "Observations & `obs1' & `obs2' & `obs3' & `obs4'   \\" _n     
file write holder "Adj. R$^{2}$ & `r1' & `r2' & `r3' & `r4'  \\" _n 
file write holder "Dependent variable mean & `mean1' & `mean2' & `mean3'  & `mean4'   \\" _n   
file write holder "Dependent variable std. dev. & `sd1' & `sd2' & `sd3' & `sd4'  \\" _n
file close holder

appendfile $tables/panel.tex $table_name.tex
appendfile $tables/panel_means.tex $table_name.tex
appendfile $tables/temp_end.tex $table_name.tex

erase $tables/panel.tex
erase $tables/panel_means.tex
erase $tables/temp_end.tex 

eststo clear
}
   