clear all

/* Set root directory */
*global dir " " //set origin path
global code "$dir/replication_package/codes"
global survey_data "$dir/replication_package/data"
global output "$dir/replication_package/output"
global figures "$output/figures"
global tables "$output/tables"


*import and clean data
do "$code/data_cleaning/creating_dataset_A"


grstyle init
grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"


*generate indicators for the analysis
gen dummy_react_wage_up=0 if !missing(job_change_wage_en)
replace dummy_react_wage_up = 1 if (job_change_wage_en==1)
label var dummy_react_wage_up "Received a wage increase, regardless if asked for"


**#TABLE A16: CORRELATES OF PERSONAL REACTIONS TO INFLATION AS A WORKER
{
preserve 

global wage_react dummy_infl_adjustment dummy_career_progression dummy_react_wage_up react_wage_askrec_agg_en react_wage_ask_agg_en 

global work_react  dummy_react_incr_hours react_switch_job_agg_en react_find_addjob_agg_en react_add_job_agg_en

**need to clean some vars for the shares to be of the sample we are interested in
foreach var_selec of varlist $work_react $wage_react{
	recode `var_selec' (2=0)
}
**found an additional job was asked only to those who said they looked for it, here we extend it to the whole sample
replace react_find_addjob_agg_en = 0 if react_add_job_agg_en==0

**receive the wage salary was only for those who asked it, here we extend it to the whole sample
replace react_wage_askrec_agg_en = 0 if react_wage_ask_agg_en==0

**receive the wage salary was only for those who asked it, here we extend it to the whole sample
replace dummy_career_progression = 0 if dummy_career_progression==.

**receive the wage salary was only for those who asked it, here we extend it to the whole sample
replace dummy_infl_adjustment = 0 if dummy_infl_adjustment==.

**asked only to those who have changed job, here we extend it to the whole sample
replace react_switch_job_agg_en = 0 if job_change_en==2 & react_switch_job_agg_en==.

eststo clear
global table_name "$tables/TABLE_A16"

* Table end
file open  holder using $tables/temp_end.tex, write replace text
file write holder "\hline \hline \end{tabular}" _n
file close holder

* Table start
file open holder using $table_name.tex, write replace text
file write holder "\begin{tabular}{lccccccccc} " _n
file write holder "& \multicolumn{9}{c}{ \textit{Dependent variable}}  \\" _n
file write holder "& \multicolumn{4}{c}{ \textbf{Job changes}} & \multicolumn{5}{c}{ \textbf{Wage increases}} \\" _n
file write holder " \cmidrule(lr){2-5} \cmidrule(lr){6-10}" _n
file write holder "& Looked for an  & Found an & Switched to a higher & Increased & Asked for a & Received & Received wage & Wage increase & Wage increase \\" _n
file write holder "& additional job & additional job & paying job & hours worked  & wage increase & wage increase & increase regardless & primarily due to & primarily \\ " _n
file write holder "& due to inflation & due to inflation & due to inflation & due to inflation & due to inflation & they asked  & of asking & job performance & due to inflation \\ \hline" _n
file write holder " \cmidrule(lr){2-10}" _n
file close holder

	
global controls_main women age_class_agg2 age_class_agg3  dummy_race_agg2 dummy_race_agg3 dummy_race_agg4  incomegroup_agg_2 incomegroup_agg_3 dummy_employment_agg2 dummy_employment_agg1 dummy_employment_agg4 dummy_married dummy_children dummy_us_area1 dummy_us_area2 dummy_us_area3  college republican political_agg3


eststo clear


eststo: reg react_add_job_agg_en  $controls_main , vce(robust)
local r1: display %5.3f `e(r2_a)'

qui sum react_add_job_agg_en if e(sample) 
local mean1: display %5.3f `r(mean)'
local obs1: display %5.0f `r(N)'
local sd1: display %5.3f `r(sd)'

eststo: reg react_find_addjob_agg_en  $controls_main , vce(robust)
local r2: display %5.3f `e(r2_a)'

qui sum react_find_addjob_agg_en if e(sample) 
local mean2: display %5.3f `r(mean)'
local obs2: display %5.0f `r(N)'
local sd2: display %5.3f `r(sd)'

eststo: reg react_switch_job_agg_en  $controls_main , vce(robust)
local r3: display %5.3f `e(r2_a)'

qui sum react_switch_job_agg_en if e(sample) 
local mean3: display %5.3f `r(mean)'
local obs3: display %5.0f `r(N)'
local sd3: display %5.3f `r(sd)'


eststo: reg dummy_react_incr_hours  $controls_main , vce(robust)
local r4: display %5.3f `e(r2_a)'

qui sum dummy_react_incr_hours if e(sample) 
local mean4: display %5.3f `r(mean)'
local obs4: display %5.0f `r(N)'
local sd4: display %5.3f `r(sd)'


eststo: reg react_wage_ask_agg_en  $controls_main , vce(robust)
local r5: display %5.3f `e(r2_a)'

qui sum react_wage_ask_agg_en if e(sample) 
local mean5: display %5.3f `r(mean)'
local obs5: display %5.0f `r(N)'
local sd5: display %5.3f `r(sd)'


eststo: reg react_wage_askrec_agg_en  $controls_main , vce(robust)
local r6: display %5.3f `e(r2_a)'

qui sum react_wage_askrec_agg_en if e(sample) 
local mean6: display %5.3f `r(mean)'
local obs6: display %5.0f `r(N)'
local sd6: display %5.3f `r(sd)'

eststo: reg dummy_react_wage_up  $controls_main , vce(robust)
local r7: display %5.3f `e(r2_a)'

qui sum dummy_react_wage_up if e(sample) 
local mean7: display %5.3f `r(mean)'
local obs7: display %5.0f `r(N)'
local sd7: display %5.3f `r(sd)'

eststo: reg dummy_career_progression  $controls_main , vce(robust)
local r8: display %5.3f `e(r2_a)'

qui sum dummy_career_progression if e(sample) 
local mean8: display %5.3f `r(mean)'
local obs8: display %5.0f `r(N)'
local sd8: display %5.3f `r(sd)'

eststo: reg dummy_infl_adjustment  $controls_main , vce(robust)
local r9: display %5.3f `e(r2_a)'

qui sum dummy_infl_adjustment if e(sample) 
local mean9: display %5.3f `r(mean)'
local obs9: display %5.0f `r(N)'
local sd9: display %5.3f `r(sd)'


esttab using $tables/panel.tex, replace fragment booktabs noconst nobase label cells(b(fmt(3) star) se(par fmt(3))) collabels(none) /// 
starlevels(* .1 ** .05 *** .01) se nonumbers nomtitles nolines nocon noobs compress

eststo clear

*** Means ***
file open holder using $tables/panel_means.tex, write replace text
file write holder "\hline " _n
file write holder "Observations & `obs1' & `obs2' & `obs3' & `obs4' & `obs5' & `obs6' & `obs7' & `obs8'  & `obs9'  \\" _n     
file write holder "Adj. R$^{2}$ & `r1' & `r2' & `r3' & `r4' & `r5' & `r6' & `r7' & `r8'  & `r9'   \\" _n 
file write holder "Dependent variable mean & `mean1' & `mean2' & `mean3'  & `mean4'  & `mean5'  & `mean6' & `mean7' & `mean8' & `mean9' \\" _n   
file write holder "Dependent variable std. dev. & `sd1' & `sd2' & `sd3' & `sd4' & `sd5' & `sd6' & `sd7' & `sd8' & `sd9'  \\" _n
file close holder

restore

appendfile $tables/panel.tex $table_name.tex
appendfile $tables/panel_means.tex $table_name.tex
appendfile $tables/temp_end.tex $table_name.tex

erase $tables/panel.tex
erase $tables/panel_means.tex
erase $tables/temp_end.tex 

eststo clear


}
    
