clear all

/* Set root directory */
*global dir " " //set origin path
global code "$dir/replication_package/codes"
global survey_data "$dir/replication_package/data"
global output "$dir/replication_package/output"
global figures "$output/figures"
global tables "$output/tables"


*import and clean data
do "$code/data_cleaning/creating_dataset_A"

grstyle init
grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"

*generate variables used in the analysis
gen rep=0 if !missing( political_agg)
replace rep=1 if political_agg==2
label var rep "Republican"

gen ind=0 if !missing( political_agg)
replace ind=1 if political_agg==3
label var ind "Independent"


tab inf_wage_theories, gen(inf_wage_theories_)




**#FIGUREA4: THEORIES ABOUT INFLATION AND WAGES, SPLIT BY POLITICAL AFFILIATION
***split respondents by political leaning and represent the answers to the inflation impacts as a consumer questions for "democrat", "republican" and "full sample"
{
preserve

global wage_theories  inf_wage_theories_3 inf_wage_theories_2  inf_wage_theories_1

global j=1

foreach var_selec of varlist $wage_theories{
	sum `var_selec' if political_agg==1
	scalar    wage_l_${j}=r(mean)*100 
	scalar se_wage_l_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
	sum `var_selec'
	scalar    wage_f_${j}=r(mean)*100 
	scalar se_wage_f_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
sum `var_selec' if political_agg==2
	scalar    wage_h_${j}=r(mean)*100 
	scalar se_wage_h_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +2
}

clear
set obs 11
egen n = seq()

foreach var in wage_l wage_f wage_h {
gen `var' = . 
gen min_`var' = .
gen max_`var' = . 
}

foreach x in 1 5 9  {
replace wage_l = wage_l_`x' if n == `x'
replace min_wage_l = wage_l_`x'  - 1.645 * se_wage_l_`x'  if n == `x'
replace max_wage_l = wage_l_`x'  + 1.645 * se_wage_l_`x'  if n == `x'
scalar up_`x'=wage_l_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+10
}

foreach x in 2 6 10  {
replace wage_f = wage_f_`x' if n == `x'
replace min_wage_f = wage_f_`x'  - 1.645 * se_wage_f_`x'  if n == `x'
replace max_wage_f = wage_f_`x'  + 1.645 * se_wage_f_`x'  if n == `x'
scalar up_`x'=wage_f_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+10
}

foreach x in 3 7 11{
replace wage_h = wage_h_`x' if n == `x'
replace min_wage_h = wage_h_`x'  - 1.645 * se_wage_h_`x'  if n == `x'
replace max_wage_h = wage_h_`x'  + 1.645 * se_wage_h_`x'  if n == `x'
scalar up_`x'=wage_h_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+10
}




grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"
graph twoway (bar wage_l n, horizontal color(ebblue) barwidth(1)) (rcap min_wage_l max_wage_l n, horizontal color(ebblue)) (bar wage_f n, horizontal color(gray) barwidth(1)) (rcap min_wage_f max_wage_f n, horizontal color(gray)) (bar wage_h n, horizontal color(cranberry) barwidth(1)) (rcap min_wage_h max_wage_h n, horizontal color(cranberry)), ///
			 legend(order(1 3 5) lab(1 "{bf:Democrat}") lab(3 "{bf:Full sample}") lab(5 "{bf:Republican}")  size(medium) position(6) cols(3) region(lcolor(black%50) lwidth(thin)) forces symysize(4) symxsize(4) rowgap(0.7) colgap(0.6) just(left) placement(center)) ///
			 xlabel(0(10)100, nogrid noticks labsize(large)) ylabel(6 `" "Inflation increases competition across companies," "which could lead my employer to raise my wage" "to match other offers" "' 2 `" "A sense of fairness and proper behavior" "will cause my employer to raise my pay" "' 10 `" "Inflation will increase my employer profits," "but she will not feel the need to increase my pay" "', labsize(large) noticks nogrid)   xtitle(`"Share of respondents"', size(large)) ytitle("") ///
			text(1 `=pos3_1' "{bf:`=num_1'%}", size(medmsall) just(center) color(black%90)) ///
			text(2 `=pos3_2' "{bf:`=num_2'%}", size(medmsall) just(center) color(black%90)) ///
			text(3 `=pos3_3' "{bf:`=num_3'%}", size(medmsall) just(center) color(black%90)) ///
			text(5 `=pos3_5' "{bf:`=num_5'%}", size(medmsall) just(center) color(black%90)) ///
			text(6 `=pos3_6' "{bf:`=num_6'%}", size(medmsall) just(center) color(black%90)) ///
			text(7 `=pos3_7' "{bf:`=num_7'%}", size(medmsall) just(center) color(black%90)) ///
			text(9 `=pos3_9' "{bf:`=num_9'%}", size(medmsall) just(center) color(black%90)) ///
			text(10 `=pos3_10' "{bf:`=num_10'%}", size(medmsall) just(center) color(black%90)) ///
			text(11 `=pos3_11' "{bf:`=num_11'%}", size(medmsall) just(center) color(black%90)) ///
			xsize(15) ysize(5)
			 
			 

graph save "$figures/FIG_A4.gpf", replace
graph export "$figures/FIG_A4.png", as(png) width(4000) height(1333) replace

restore

}
