clear all

/* Set root directory */
*global dir " " //set origin path
global code "$dir/replication_package/codes"
global survey_data "$dir/replication_package/data"
global output "$dir/replication_package/output"
global figures "$output/figures"
global tables "$output/tables"


*import and clean data
do "$code/data_cleaning/creating_dataset_A"


grstyle init
grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"


*generate indicators for the analysis
tab react_savings_agg_en, gen(react_savings_agg_)
tab react_saving_cash_agg_en, gen(react_saving_cash_agg_)
tab react_sell_finass_agg_en, gen(react_sell_finass_agg_)	
tab react_borrowings_agg_en, gen(react_borrowings_agg_)
tab react_repay_loan_agg_en, gen(react_repay_loan_agg_)
tab react_switch_mort_agg_en, gen(react_switch_mort_agg_)
tab react_repay_bills_agg_en, gen(react_repay_bills_agg_)



**#FIGURE A10: PERSONAL REACTIONS TO INFLATION AS AN ASSET HOLDER, SPLIT BY POLITICAL AFFILIATION
***split respondents by political leaning and represent the answers to the inflation impacts as a consumer questions for "democrat", "republican" and "full sample"
{
preserve

global financials react_switch_mort_agg_1 react_switch_mort_agg_2 react_sell_finass_agg_3 react_borrowings_agg_1 react_repay_loan_agg_3 dummy_cash_savings dummy_savings dummy_diff_bills

global j=1

foreach var_selec of varlist $financials{
	sum `var_selec' if political_agg==1
	scalar    low_financials_${j}=r(mean)*100 
	scalar se_low_financials_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
	sum `var_selec' 
	scalar    full_financials_${j}=r(mean)*100 
	scalar se_full_financials_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
sum `var_selec' if political_agg==2
	scalar    high_financials_${j}=r(mean)*100 
	scalar se_high_financials_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +2
}



clear
set obs 31
egen n = seq()

foreach var in low_financials full_financials high_financials{
gen `var' = . 
gen min_`var' = .
gen max_`var' = . 
}

foreach x in 1 5 9 13 17 21 25 29{
replace low_financials = low_financials_`x' if n == `x'
replace min_low_financials = low_financials_`x'  - 1.645 * se_low_financials_`x'  if n == `x'
replace max_low_financials = low_financials_`x'  + 1.645 * se_low_financials_`x'  if n == `x'
scalar up_`x'=low_financials_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}

foreach x in 2 6 10 14 18 22 26 30{
replace full_financials = full_financials_`x' if n == `x'
replace min_full_financials = full_financials_`x'  - 1.645 * se_full_financials_`x'  if n == `x'
replace max_full_financials = full_financials_`x'  + 1.645 * se_full_financials_`x'  if n == `x'
scalar up_`x'=full_financials_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}


foreach x in 3 7 11 15 19 23 27 31{
replace high_financials = high_financials_`x' if n == `x'
replace min_high_financials = high_financials_`x'  - 1.645 * se_high_financials_`x'  if n == `x'
replace max_high_financials = high_financials_`x'  + 1.645 * se_high_financials_`x'  if n == `x'
scalar up_`x'=high_financials_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}



grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"
graph twoway (bar low_financials n, horizontal color(ebblue) barwidth(1) ) (rcap min_low_financials max_low_financials n, horizontal color(ebblue)) (bar full_financials n, horizontal color(gray) barwidth(1) ) (rcap min_full_financials max_full_financials n, horizontal color(gray)) (bar high_financials n, horizontal color(cranberry) barwidth(1) ) (rcap min_high_financials max_high_financials n, horizontal color(cranberry)) , ///
			 legend(order(1 3 5) lab(1 "{bf:Democrat}") lab(3 "{bf:Full sample}") lab(5 "{bf:Republican}")  size(large) position(6) cols(3) region(lcolor(black%50) lwidth(thin)) forces  symysize(4) symxsize(4) rowgap(0.7) colgap(0.6) just(left) placement(center)) ///
			 xlabel(0(10)100, nogrid noticks labsize(medsmall)) ylabel(26 `" "Saved less" "' 22 `" "Saved less in cash"  "'  30 `" "More difficult to repay regular bills" "' ///
			 10 `" "Sold financial assets" "' 14 `" "Borrowed more" "' 18 `" "Repaid loans slower" "' 2 `" "Switched to fixed rate mortgage" "' 6 `" "Switched to variable rate mortgage" "' ///
			 , labsize(large) noticks nogrid)   xtitle(`"Share of respondents"', size(large)) ytitle("") ///
			text(1.3 `=pos3_1' "{bf:`=num_1'%}", size(medsmall) just(center) color(black%90)) ///
			text(2.3 `=pos3_2' "{bf:`=num_2'%}", size(medsmall) just(center) color(black%90)) ///
			text(3.3 `=pos3_3' "{bf:`=num_3'%}", size(medsmall) just(center) color(black%90)) ///
			text(5.3 `=pos3_5' "{bf:`=num_5'%}", size(medsmall) just(center) color(black%90)) ///
			text(6.3 `=pos3_6' "{bf:`=num_6'%}", size(medsmall) just(center) color(black%90)) ///
			text(7.3 `=pos3_7' "{bf:`=num_7'%}", size(medsmall) just(center) color(black%90)) ///
			text(9.3 `=pos3_9' "{bf:`=num_9'%}", size(medsmall) just(center) color(black%90)) ///
			text(10.3 `=pos3_10' "{bf:`=num_10'%}", size(medsmall) just(center) color(black%90)) ///
			text(11.3 `=pos3_11' "{bf:`=num_11'%}", size(medsmall) just(center) color(black%90)) ///
			text(13.3 `=pos3_13' "{bf:`=num_13'%}", size(medsmall) just(center) color(black%90)) ///
			text(14.3 `=pos3_14' "{bf:`=num_14'%}", size(medsmall) just(center) color(black%90)) ///
			text(15.3 `=pos3_15' "{bf:`=num_15'%}", size(medsmall) just(center) color(black%90)) ///
			text(17.3 `=pos3_17' "{bf:`=num_17'%}", size(medsmall) just(center) color(black%90)) ///
			text(18.3 `=pos3_18' "{bf:`=num_18'%}", size(medsmall) just(center) color(black%90)) ///
			text(19.3 `=pos3_19' "{bf:`=num_19'%}", size(medsmall) just(center) color(black%90)) ///
			text(21.3 `=pos3_21' "{bf:`=num_21'%}", size(medsmall) just(center) color(black%90)) ///
			text(22.3 `=pos3_22' "{bf:`=num_22'%}", size(medsmall) just(center) color(black%90)) ///
			text(23.3 `=pos3_23' "{bf:`=num_23'%}", size(medsmall) just(center) color(black%90)) ///
			text(25.3 `=pos3_25' "{bf:`=num_25'%}", size(medsmall) just(center) color(black%90)) ///
			text(26.3 `=pos3_26' "{bf:`=num_26'%}", size(medsmall) just(center) color(black%90)) ///
			text(27.3 `=pos3_27' "{bf:`=num_27'%}", size(medsmall) just(center) color(black%90)) ///
			text(29.3 `=pos3_29' "{bf:`=num_29'%}", size(medsmall) just(center) color(black%90)) ///
			text(30.3 `=pos3_30' "{bf:`=num_30'%}", size(medsmall) just(center) color(black%90)) ///
			text(31.3 `=pos3_31' "{bf:`=num_31'%}", size(medsmall) just(center) color(black%90)) ///
			xsize(10) ysize(5)
			resize, xsize(25cm) ysize(20cm)
			 

graph save "$figures/FIG_A10.gpf", replace
graph export "$figures/FIG_A10.png", as(png) width(5000) height(4000) replace

restore

}
