clear all

/* Set root directory */
*global dir " " //set origin path
global code "$dir/replication_package/codes"
global survey_data "$dir/replication_package/data"
global output "$dir/replication_package/output"
global figures "$output/figures"
global tables "$output/tables"


*import and clean data
do "$code/data_cleaning/creating_dataset_A"


*Set figures style 
grstyle init
grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"

*FIGURE A1:  DISTRIBUTION OF TIME SPENT IN THE SURVEY A
*time distribution figure censoring the dataset at 120min maximum of completion time
{
su Durationinminutes if Durationinminutes <120, det
return list

hist Durationinminutes if Durationinminutes <120 , color(dknavy) width(5) xline(`r(mean)', lcolor(dknavy) lwidth(thick)) xline(`r(p50)', lcolor(red) lwidth(thick)) ///
	xaxis(1 2) xtitle(" " "Time spent on survey", axis(1) size(large)) xtitle("", axis(2) size(medium)) xlabel(0(10)120, nogrid) xlabel(`r(mean)' "Mean" `r(p50)' "Median", axis(2) angle(45) labsize(medium)) ylabel(, nogrid)   
graph display, ysize(5) xsize(8)
graph export "$figures/FIG_A1.png", as(png)width(5000) height(3333) replace
}
