clear all

/* Set root directory */
*global dir " " //set origin path
global code "$dir/replication_package/codes"
global survey_data "$dir/replication_package/data"
global output "$dir/replication_package/output"
global figures "$output/figures"
global tables "$output/tables"


*import and clean data
do "$code/data_cleaning/creating_dataset_A"


grstyle init
grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"


*generate indicators of interest
tab infl_unemp_pref_en, gen(infl_unemp_pref_)

**#FIGURE 21: THE INFLATION VERSUS UNEMPLOYMENT TRADE-OFF
***split respondents by political leaning and represent the answers to the inflation impacts as a consumer questions for "democrat", "republican" and "full sample"
{
global relation dummy_infl_unemp_dir dummy_infl_unemp_know

global preferences infl_unemp_pref_1 infl_unemp_pref_2 infl_unemp_pref_3 infl_unemp_pref_4 infl_unemp_pref_5  

global others dummy_infl_exports dummy_infl_bad_signal 
	
preserve

global j=1

foreach var_selec of varlist $others{
	sum `var_selec' if political_agg==1
	scalar    other_d_${j}=r(mean)*100 
	scalar se_other_d_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
	sum `var_selec' 
	scalar    other_f_${j}=r(mean)*100 
	scalar se_other_f_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
sum `var_selec' if political_agg==2
	scalar    other_r_${j}=r(mean)*100 
	scalar se_other_r_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +2
}

global j=$j +3

foreach var_selec of varlist $preferences{
	sum `var_selec' if political_agg==1
	scalar    pref_d_${j}=r(mean)*100 
	scalar se_pref_d_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
	sum `var_selec' 
	scalar    pref_f_${j}=r(mean)*100 
	scalar se_pref_f_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
sum `var_selec' if political_agg==2
	scalar    pref_r_${j}=r(mean)*100 
	scalar se_pref_r_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +2
}

global j=$j +3

foreach var_selec of varlist $relation{
	sum `var_selec' if political_agg==1
	scalar    rel_d_${j}=r(mean)*100 
	scalar se_rel_d_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
	sum `var_selec' 
	scalar    rel_f_${j}=r(mean)*100 
	scalar se_rel_f_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
	sum `var_selec' if political_agg==2
	scalar    rel_r_${j}=r(mean)*100 
	scalar se_rel_r_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +2
}

clear
set obs 41
egen n = seq()

foreach var in other_d other_f other_r pref_d pref_f pref_r rel_d rel_f rel_r {
gen `var' = . 
gen min_`var' = .
gen max_`var' = . 
}

foreach x in 1 5 {
replace other_d = other_d_`x' if n == `x'
replace min_other_d = other_d_`x'  - 1.645 * se_other_d_`x'  if n == `x'
replace max_other_d = other_d_`x'  + 1.645 * se_other_d_`x'  if n == `x'
scalar up_`x'=other_d_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+12
}

foreach x in 2 6 {
replace other_f = other_f_`x' if n == `x'
replace min_other_f = other_f_`x'  - 1.645 * se_other_f_`x'  if n == `x'
replace max_other_f = other_f_`x'  + 1.645 * se_other_f_`x'  if n == `x'
scalar up_`x'=other_f_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+12
}

foreach x in 3 7 {
replace other_r = other_r_`x' if n == `x'
replace min_other_r = other_r_`x'  - 1.645 * se_other_r_`x'  if n == `x'
replace max_other_r = other_r_`x'  + 1.645 * se_other_r_`x'  if n == `x'
scalar up_`x'=other_r_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+12
}


foreach x in 12 16 20 24 28 {
replace pref_d = pref_d_`x' if n == `x'
replace min_pref_d = pref_d_`x'  - 1.645 * se_pref_d_`x'  if n == `x'
replace max_pref_d = pref_d_`x'  + 1.645 * se_pref_d_`x'  if n == `x'
scalar up_`x'=pref_d_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+12
}

foreach x in 13 17 21 25 29 {
replace pref_f = pref_f_`x' if n == `x'
replace min_pref_f = pref_f_`x'  - 1.645 * se_pref_f_`x'  if n == `x'
replace max_pref_f = pref_f_`x'  + 1.645 * se_pref_f_`x'  if n == `x'
scalar up_`x'=pref_f_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+12
}

foreach x in 14 18 22 26 30 {
replace pref_r = pref_r_`x' if n == `x'
replace min_pref_r = pref_r_`x'  - 1.645 * se_pref_r_`x'  if n == `x'
replace max_pref_r = pref_r_`x'  + 1.645 * se_pref_r_`x'  if n == `x'
scalar up_`x'=pref_r_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+12
}

foreach x in 35 39 {
replace rel_d = rel_d_`x' if n == `x'
replace min_rel_d = rel_d_`x'  - 1.645 * se_rel_d_`x'  if n == `x'
replace max_rel_d = rel_d_`x'  + 1.645 * se_rel_d_`x'  if n == `x'
scalar up_`x'=rel_d_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+9
	scalar pos3_`x'=up_`x'+12
}

foreach x in 36 40 {
replace rel_f = rel_f_`x' if n == `x'
replace min_rel_f = rel_f_`x'  - 1.645 * se_rel_f_`x'  if n == `x'
replace max_rel_f = rel_f_`x'  + 1.645 * se_rel_f_`x'  if n == `x'
scalar up_`x'=rel_f_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+9
	scalar pos3_`x'=up_`x'+12
}

foreach x in 37 41 {
replace rel_r = rel_r_`x' if n == `x'
replace min_rel_r = rel_r_`x'  - 1.645 * se_rel_r_`x'  if n == `x'
replace max_rel_r = rel_r_`x'  + 1.645 * se_rel_r_`x'  if n == `x'
scalar up_`x'=rel_r_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+9
	scalar pos3_`x'=up_`x'+12
}


grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"
graph twoway (bar other_d n, horizontal color(ebblue) barwidth(1)) (rcap min_other_d max_other_d n, horizontal color(ebblue)) (bar other_f n, horizontal color(gray) barwidth(1)) (rcap min_other_f max_other_f n, horizontal color(gray))  (bar other_r n, horizontal color(cranberry) barwidth(1) ) (rcap min_other_r max_other_r n, horizontal color(cranberry)) ///
      (bar pref_d n, horizontal color(ebblue) barwidth(1)) (rcap min_pref_d max_pref_d n, horizontal color(ebblue))    (bar pref_f n, horizontal color(gray) barwidth(1)) (rcap min_pref_f max_pref_f n, horizontal color(gray))       (bar pref_r n, horizontal color(cranberry) barwidth(1) ) (rcap min_pref_r max_pref_r n, horizontal color(cranberry))   ///
	  (bar rel_d n, horizontal color(ebblue) barwidth(1) ) (rcap min_rel_d max_rel_d n, horizontal color(ebblue)) (bar rel_f n, horizontal color(gray) barwidth(1) ) (rcap min_rel_f max_rel_f n, horizontal color(gray))   (bar rel_r n, horizontal color(cranberry) barwidth(1) ) (rcap min_rel_r max_rel_r n, horizontal color(cranberry)), ///
			 legend(order(1 3 5) lab(1 "{bf:Democrat}") lab(3 "{bf:Full sample}") lab(5 "{bf:Republican}")  size(large) position(6) cols(3) region(lcolor(black%50) lwidth(thin)) forces symysize(4) symxsize(4) rowgap(0.7) colgap(0.6) just(left) placement(center)) ///
			 			 xlabel(0(10)100, nogrid noticks labsize(large)) ylabel(2 `"Inflation decreases exports"' 6 `"Inflation indicates a poor state of the economy"' 9.5 `" "{bf:Inflation and the economy:}" "' ///
			 13 `"Low unemployment at all costs"' 17 `"Priority to unemployment, but mindful of inflation"' 21 `"Equal priority"' 25 `"Priority to inflation, but mindful of unemployment"'     29 `"Low inflation at all costs"' 32.5 `" "{bf:Policy preferences:}" "' ///
			 36 `" Inflation and unemployment are negatively related"' 40 `"Inflation and unemployment are related"' 43.5 `" "{bf:Inflation and unemployment:}" "' , labsize(large)  noticks nogrid) xtitle(`"Share of respondents"', size(large)) ytitle("") xsize(10) ysize(5) ///
			 text(1 `=pos3_1' "{bf:`=num_1'%}", size(medsmall) just(center) color(black%90)) ///
			text(2 `=pos3_2' "{bf:`=num_2'%}", size(medsmall) just(center) color(black%90)) ///
			text(3 `=pos3_3' "{bf:`=num_3'%}", size(medsmall) just(center) color(black%90)) ///
			text(5 `=pos3_5' "{bf:`=num_5'%}", size(medsmall) just(center) color(black%90)) ///
			text(6 `=pos3_6' "{bf:`=num_6'%}", size(medsmall) just(center) color(black%90)) ///
			text(7 `=pos3_7' "{bf:`=num_7'%}", size(medsmall) just(center) color(black%90)) ///
			text(12 `=pos3_12' "{bf:`=num_12'%}", size(medsmall) just(center) color(black%90)) ///
			text(13 `=pos3_13' "{bf:`=num_13'%}", size(medsmall) just(center) color(black%90)) ///
			text(14 `=pos3_14' "{bf:`=num_14'%}", size(medsmall) just(center) color(black%90)) ///
			text(16 `=pos3_16' "{bf:`=num_16'%}", size(medsmall) just(center) color(black%90)) ///
			text(17 `=pos3_17' "{bf:`=num_17'%}", size(medsmall) just(center) color(black%90)) ///
			text(18 `=pos3_18' "{bf:`=num_18'%}", size(medsmall) just(center) color(black%90)) ///
			text(20 `=pos3_20' "{bf:`=num_20'%}", size(medsmall) just(center) color(black%90)) ///
			text(21 `=pos3_21' "{bf:`=num_21'%}", size(medsmall) just(center) color(black%90)) ///
			text(22 `=pos3_22' "{bf:`=num_22'%}", size(medsmall) just(center) color(black%90)) ///
			text(24 `=pos3_24' "{bf:`=num_24'%}", size(medsmall) just(center) color(black%90)) ///
			text(25 `=pos3_25' "{bf:`=num_25'%}", size(medsmall) just(center) color(black%90)) ///
			text(26 `=pos3_26' "{bf:`=num_26'%}", size(medsmall) just(center) color(black%90)) ///
			text(28 `=pos3_28' "{bf:`=num_28'%}", size(medsmall) just(center) color(black%90)) ///
			text(29 `=pos3_29' "{bf:`=num_29'%}", size(medsmall) just(center) color(black%90)) ///
			text(30 `=pos3_30' "{bf:`=num_30'%}", size(medsmall) just(center) color(black%90)) ///
			text(35 `=pos3_35' "{bf:`=num_35'%}", size(medsmall) just(center) color(black%90)) ///
			text(36 `=pos3_36' "{bf:`=num_36'%}", size(medsmall) just(center) color(black%90)) ///
			text(37 `=pos3_37' "{bf:`=num_37'%}", size(medsmall) just(center) color(black%90)) ///
			text(39 `=pos2_39' "{bf:`=num_39'%}", size(medsmall) just(center) color(black%90)) ///
			text(40 `=pos2_40' "{bf:`=num_40'%}", size(medsmall) just(center) color(black%90)) ///
			text(41 `=pos2_41' "{bf:`=num_41'%}", size(medsmall) just(center) color(black%90)) 
			
			resize, xsize(25cm) ysize(20cm)

			
			 
			 

graph save "$figures/FIG_21.gpf", replace
graph export "$figures/FIG_21.png", as(png) width(5000) height(4000) replace

restore

}
