clear all

/* Set root directory */
*global dir " " //set origin path
global code "$dir/replication_package/codes"
global survey_data "$dir/replication_package/data"
global output "$dir/replication_package/output"
global figures "$output/figures"
global tables "$output/tables"


*import and clean data
do "$code/data_cleaning/creating_dataset_A"

grstyle init
grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"

*generate variables used in the analysis
gen rep=0 if !missing( political_agg)
replace rep=1 if political_agg==2
label var rep "Republican"

gen ind=0 if !missing( political_agg)
replace ind=1 if political_agg==3
label var ind "Independent"


tab inf_wage_theories, gen(inf_wage_theories_)

**# FIGURE10: INFLATION IMPACTS AS A CONSUMER 
***split respondents by income and represent the answers to the inflation impacts as a consumer questions for "low income", "high income" and "full sample"
{
preserve

global consumer  dummy_ppower_know dummy_compar_shopping dummy_cons_quality dummy_shrinkflation dummy_ppower




global j=1

foreach var_selec of varlist $consumer{
	sum `var_selec' if incomegroup_agg==1
	scalar    low_cons_impact_${j}=r(mean)*100 
	scalar low_se_cons_impact_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
sum `var_selec' 
	scalar    full_cons_impact_${j}=r(mean)*100 
	scalar full_se_cons_impact_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
sum `var_selec' if incomegroup_agg==3
	scalar    high_cons_impact_${j}=r(mean)*100 
	scalar high_se_cons_impact_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +2

}



clear
set obs 19
egen n = seq()

foreach var in full_cons_impact low_cons_impact high_cons_impact{
gen `var' = . 
gen min_`var' = .
gen max_`var' = . 
}

foreach x in 1 5 9 13 17 {
replace low_cons_impact = low_cons_impact_`x' if n == `x'
replace min_low_cons_impact = low_cons_impact_`x'  - 1.645 * low_se_cons_impact_`x'  if n == `x'
replace max_low_cons_impact = low_cons_impact_`x'  + 1.645 * low_se_cons_impact_`x'  if n == `x'
scalar up_`x'=low_cons_impact_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+13
}

foreach x in 2 6 10 14 18 {
replace full_cons_impact = full_cons_impact_`x' if n == `x'
replace min_full_cons_impact = full_cons_impact_`x'  - 1.645 * full_se_cons_impact_`x'  if n == `x'
replace max_full_cons_impact = full_cons_impact_`x'  + 1.645 * full_se_cons_impact_`x'  if n == `x'
scalar up_`x'=full_cons_impact_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+13
}

foreach x in 3 7 11 15 19 {
replace high_cons_impact = high_cons_impact_`x' if n == `x'
replace min_high_cons_impact = high_cons_impact_`x'  - 1.645 * high_se_cons_impact_`x'  if n == `x'
replace max_high_cons_impact = high_cons_impact_`x'  + 1.645 * high_se_cons_impact_`x'  if n == `x'
scalar up_`x'=high_cons_impact_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+13
}




grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"
graph twoway (bar low_cons_impact n, horizontal color(orange) barwidth(1) bargap(0.5)) (rcap min_low_cons_impact max_low_cons_impact n, horizontal color(orange)) (bar full_cons_impact n, horizontal color(gray) barwidth(1) bargap(0.5)) (rcap min_full_cons_impact max_full_cons_impact n, horizontal color(gray))(bar high_cons_impact n, horizontal color("17 119 51") barwidth(1) bargap(0.5)) (rcap min_high_cons_impact max_high_cons_impact n, horizontal color("17 119 51")), legend(order(1 3 5) lab(1 "{bf:Income <$40k}") lab(3 "{bf:Full sample}") lab(5 "{bf:Income >$125k}")  size(small) position(6) cols(3) region(lcolor(black%50) lwidth(thin))  symysize(4) symxsize(4) rowgap(-2) colgap(0.6) just(left) symplacement(center)) ///
			 xlabel(0(10)100, nogrid noticks labsize(medsmall)) ylabel(18 `" "Purchasing power has decreased" "' 2 `" "Even if salaries and prices increased at the same rate," "purchasing power would decrease" "'  6 `" "Comparison shopping has become harder" "' 10 `""Quality of goods purchased has decreased" "' 14 `" Shrinkflation has become more widespread"' , labsize(medium) noticks nogrid)   xtitle(`"Share of respondents"') ytitle("") ///
			text(1 `=pos3_1' "{bf:`=num_1'%}", size(medsmall) just(center) color(black%90)) ///
			text(2 `=pos3_2' "{bf:`=num_2'%}", size(medsmall) just(center) color(black%90)) ///
			text(3 `=pos3_3' "{bf:`=num_3'%}", size(medsmall) just(center) color(black%90)) ///
			text(5 `=pos3_5' "{bf:`=num_5'%}", size(medsmall) just(center) color(black%90)) ///
			text(6 `=pos3_6' "{bf:`=num_6'%}", size(medsmall) just(center) color(black%90)) ///
			text(7 `=pos3_7' "{bf:`=num_7'%}", size(medsmall) just(center) color(black%90)) ///
			text(9 `=pos3_9' "{bf:`=num_9'%}", size(medsmall) just(center) color(black%90)) ///
			text(10 `=pos3_10' "{bf:`=num_10'%}", size(medsmall) just(center) color(black%90)) ///
			text(11 `=pos3_11' "{bf:`=num_11'%}", size(medsmall) just(center) color(black%90)) ///
			text(13 `=pos3_13' "{bf:`=num_13'%}", size(medsmall) just(center) color(black%90)) ///
			text(14 `=pos3_14' "{bf:`=num_14'%}", size(medsmall) just(center) color(black%90)) ///
			text(15 `=pos3_15' "{bf:`=num_15'%}", size(medsmall) just(center) color(black%90)) ///
			text(17 `=pos3_17' "{bf:`=num_17'%}", size(medsmall) just(center) color(black%90)) ///
			text(18 `=pos3_18' "{bf:`=num_18'%}", size(medsmall) just(center) color(black%90)) ///
			text(19 `=pos3_19' "{bf:`=num_19'%}", size(medsmall) just(center) color(black%90)) ///
			xsize(10) ysize(5) 

graph save "$figures/FIG_10.gpf", replace
graph export "$figures/FIG_10.png", as(png) width(5000) height(2500) replace

restore
}