clear all

/* Set root directory */
*global dir "" //set origin path
global code "$dir/replication_package/codes"
global survey_data "$dir/replication_package/data"
global output "$dir/replication_package/output"
global figures "$output/figures"
global tables "$output/tables"


*import and clean data
do "$code/data_cleaning/creating_dataset_A"


*set images style
grstyle init
grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"

*generate specific indicators for republican and democrat
gen rep=0 if !missing( political_agg)
replace rep=1 if political_agg==2
label var rep "Republican"

gen ind=0 if !missing( political_agg)
replace ind=1 if political_agg==3
label var ind "Independent"



**#FIGURE 1: DISTRIBUTION OF ESTIMATES OF PAST AND EXPECTED FUTURE INFLATION 
***censoring at -10 and 25 percent guesses
{
sum inf_info_num_i if inf_info_num_i<25&inf_info_num_i>-10, detail
scalar mean_inf_past= round(r(mean),0.1)
scalar pc25_inf_past= round(r(p25),0.1)
scalar pc50_inf_past= round(r(p50),0.1)
scalar pc75_inf_past= round(r(p75),0.1)
scalar sd_inf_past= round(r(sd),0.1)

twoway (hist inf_info_num_i if inf_info_num_i<25&inf_info_num_i>-10, bin(30) color(dknavy%70)) , xtitle("Inflation in the past 12 months", size(medium)) xlabel(-10(10)25, nogrid ) ylabel(,nogrid noticks) yscale(r(0 0.2)) ytitle("Frequency") xline(3.4, lpattern(dash) lcolor(black) lwidth(thin)) ///
text(0.18 15.5 "{bf:25{superscript:th} percentile:} `=pc25_inf_past'%" ///
			"{bf:Median:} `=pc50_inf_past'%"	///
			"{bf:Mean:} 7.1%"	///
			"{bf:75{superscript:th} percentile:} `=pc75_inf_past'%" ///
			"{bf:Standard deviation:} 5.6%",  box size(small) just(left) color(black%90) margin(l+2 r t+1 b+1)) ///
			text(0.19 -3 "{bf:Actual inflation:} 3.4%", just(left) size(small)) saving(inf_past, replace)

*		graph save "$figures/inf_past_distribution_censor25.gpf", replace
*graph export "$figures/inf_past_distribution_censor25.png", replace

*distribution of guesses future inflation(blue)
sum inf_exp_num_i if inf_exp_num_i<25&inf_exp_num_i>-10, detail
///here manually adjusted because it gave the trailing 0s error
scalar mean_inf_exp= round(r(mean),0.1)
scalar pc25_inf_exp= round(r(p25),0.1)
scalar pc50_inf_exp= round(r(p50),0.1)
scalar pc75_inf_exp= round(r(p75),0.1)
scalar sd_inf_exp= round(r(sd),0.1)

twoway (hist inf_exp_num_i if inf_exp_num_i<25&inf_exp_num_i>-10,  bin(30) color(dknavy%70)) , xtitle("Expected Inflation in the next 12 months", size(medium)) xlabel(-10(10)25, nogrid ) yscale(r(0 0.2)) ylabel(,nogrid noticks) ytitle(" ")  ///
text(0.18 16.2 "{bf:25{superscript:th} percentile:} `=pc25_inf_exp'%" ///
			"{bf:Median:} `=pc50_inf_exp'%"	///
			"{bf:Mean:} 6.3%"	///
			"{bf:75{superscript:th} percentile:} `=pc75_inf_exp'%" ///
			"{bf:Standard deviation:} `=sd_inf_exp'%",  box size(small) just(left) color(black%90) margin(l+2 r t+1 b+1)) saving(inf_future, replace)

*graph save "$figures/inf_exp_distribution_censor25.gpf", replace
*graph export "$figures/inf_exp_distribution_censor25.png", replace

graph combine inf_past.gph inf_future.gph, col(2)  imargin(0 0 0 0)
graph save "$figures/FIG_1.gpf", replace
graph export "$figures/FIG_1.png", as(png) width(4000) height(2200) replace
}