clear all

/* Set root directory */
*global dir " " //set origin path
global code "$dir/replication_package/codes"
global survey_data "$dir/replication_package/data"
global output "$dir/replication_package/output"
global figures "$output/figures"
global tables "$output/tables"


*import and clean data
do "$code/data_cleaning/creating_dataset_A"


*set images style
grstyle init
grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"

*generate specific indicators for republican and democrat
gen rep=0 if !missing( political_agg)
replace rep=1 if political_agg==2
label var rep "Republican"

gen ind=0 if !missing( political_agg)
replace ind=1 if political_agg==3
label var ind "Independent"

*************************************************************
****Block 3-4 in the survey - Understanding of inflation*****
*************************************************************


**#TABLE 3: UNDERSTANDING AND IMPORTANCE OF INFLATION
{
preserve
	
foreach var of varlist inf_info_dir_i_en inf_exp_dir_i_en inf_categories_i_en inf_exp_reason_i_en dummy_inf_info_utd dummy_inf_info_att inf_yard_agree correct_under_1 correct_under_2 social_media_info TV_info radio_info newspapers_info {

tab `var', matcell(cps_`var')

mata: st_matrix("cps_`var'", (st_matrix("cps_`var'")  :/ colsum(st_matrix("cps_`var'"))))


local r = rowsof(cps_`var')
forvalues x = 1(1)`r'{
    local rf_`var'`x'_temp= round(cps_`var'[`x',1],0.01)
	local rf_`var'`x': display %5.2f `rf_`var'`x'_temp'
}
}

qui:des
local sample_size_af=r(N)

file open holder using "$tables/TABLE_3.tex", write replace text
file write holder "\begin{tabular}{lcc} " _n

file write holder "\toprule" _n
file write holder "\hline \noalign{\smallskip}  & Share of respondents \\" _n
file write holder "  & giving each answer  \\\hline" _n

file write holder "\noalign{\smallskip}\hline \noalign{\smallskip}	 \textbf{Understanding of inflation}		& 	\\" _n
file write holder " Correct future price given inflation rate 		& `rf_correct_under_12' 	 	\\" _n
file write holder " Correct inflation rate given future price	& `rf_correct_under_22' 	\\" _n
file write holder " & &	\\" _n
file write holder " Agree with the definition of inflation as a & 	\\" _n
file write holder " 'sort of measurement thing and little more' 	& `rf_inf_yard_agree2' 	\\" _n


file write holder " & &	\\" _n
file write holder " \textbf{Over the last 12 months} &   \\" _n
file write holder " Inflation  & `rf_inf_info_dir_i_en1'  \\" _n
file write holder " Deflation  & `rf_inf_info_dir_i_en2'  \\" _n
file write holder " No change in prices   & `rf_inf_info_dir_i_en3'  \\" _n

file write holder " &      \\" _n
file write holder " \textbf{Over the next 12 months} &    \\" _n
file write holder " Inflation  & `rf_inf_exp_dir_i_en1'  \\" _n
file write holder " Deflation  & `rf_inf_exp_dir_i_en2'  \\" _n
file write holder " No change in prices  & `rf_inf_exp_dir_i_en3'  \\" _n


file write holder " &     \\" _n
file write holder " \textbf{Items which experienced the most} &   \\" _n
file write holder " \textbf{substantial inflation in past 12 months} &    \\" _n
file write holder " Food  & `rf_inf_categories_i_en1'  \\" _n
file write holder " Gas   & `rf_inf_categories_i_en2'  \\" _n
file write holder " Rent  & `rf_inf_categories_i_en3'  \\" _n
file write holder " Utilities   & `rf_inf_categories_i_en4'  \\" _n

file write holder " &      \\" _n
file write holder " \textbf{Main source of news about inflation} &    \\" _n
file write holder " Social Media & `rf_social_media_info2'  \\" _n
file write holder " Newspapers & `rf_newspapers_info2'  \\" _n
file write holder " Television & `rf_TV_info2'  \\" _n
file write holder " Radio & `rf_radio_info2'  \\" _n

file write holder " &      \\" _n
file write holder " \textbf{Most influential source when thinking about future inflation} &    \\" _n
file write holder " News reports & `rf_inf_exp_reason_i_en1'  \\" _n
file write holder " Official statistics & `rf_inf_exp_reason_i_en2'  \\" _n
file write holder " Recent price changes of my purchases & `rf_inf_exp_reason_i_en3'  \\" _n
file write holder " Advice from friends and family & `rf_inf_exp_reason_i_en4'  \\" _n

file write holder " &      \\" _n
file write holder " \textbf{Attention for inflation updates} &    \\" _n
file write holder " Find important staying up to date on current and future inflation & `rf_dummy_inf_info_utd2'  \\" _n
file write holder " Increased attention towards inflation in last two years & `rf_dummy_inf_info_att2'  \\" _n

file write holder " &    \\" _n
file write holder " Sample size  &`sample_size_af' \\" _n

file write holder "\bottomrule \end{tabular}" _n
file close holder
	
restore
} 