clear all

/* Set root directory */
*global dir " " //set origin path
global code "$dir/replication_package/codes"
global survey_data "$dir/replication_package/data"
global output "$dir/replication_package/output"
global figures "$output/figures"
global tables "$output/tables"



grstyle init
grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"

*****CREATING THE DATASET
{
*import the first waves of collection and append the last one
do "$code/data_cleaning/creating_dataset_B_2"
tempfile B2
save `B2'

do "$code/data_cleaning/creating_dataset_B_1"
append using `B2'

*here we keep only the relevant het variables. Modify this if you need more
keep ResponseId income_group pol_aff pers_imp_feelings Durationinminutes
*Income group (coarser partition aggregating groups)
gen 			incomegroup_agg =.
replace 		incomegroup_agg = 1 if income_group == 1 | income_group == 2
replace 		incomegroup_agg = 2 if income_group == 3 | income_group == 4 | income_group == 5 
replace 		incomegroup_agg = 3 if  income_group == 6
label define 	incomegroup_agg 1 "0k-39k" 2 "40k-124k" 3 "124k+"
label val 		incomegroup_agg incomegroup_agg

gen political_agg = 1 if( pol_aff==2)
	replace political_agg = 2 if(pol_aff==1)
	replace political_agg = 3 if(pol_aff>2)
label define political_agg 1 "Democrat" 2 "Republican" 3 "Independent and others"
label val political_agg political_agg

tempfile survey
save `survey'

*progressively merge with classification data for open ended question: why interesting inflation
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("inf_info_int_why") firstrow  clear
foreach var of varlist inf_info_int_why_*{
	replace `var'=0 if `var'==.
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m
tempfile survey
save `survey'

*progressively merge with classification data for open ended question: what bad could happen if inflation too high?
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("inf_info_bad_what") firstrow  clear
foreach var of varlist inf_info_bad_what_*{
	replace `var'=0 if `var'==.
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m
tempfile survey
save `survey'

*progressively merge with classification data for open ended question: what bad could happen if inflation too high?
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("inf_info_high_why") firstrow  clear
foreach var of varlist inf_info_high_why_*{
	replace `var'=0 if `var'==.
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m
tempfile survey
save `survey'

*progressively merge with classification data for open ended question: positive impact of inflation?
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("inf_info_positive") firstrow  clear
foreach var of varlist inf_info_positive_*{
	replace `var'=0 if `var'==.
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m
tempfile survey
save `survey'

*progressively merge with classification data for open ended question: impact of inflation?
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("pers_imp_me") firstrow  clear
foreach var of varlist pers_imp_me_*{
	replace `var'=0 if `var'==.
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m
tempfile survey
save `survey'

*progressively merge with classification data for open ended question: what caused changes in income
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("pers_imp_inc_change") firstrow  clear
foreach var of varlist pers_imp_inc_change_*{
	replace `var'=0 if `var'==.
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m
tempfile survey
save `survey'

*progressively merge with classification data for open ended question: angry at who
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("pers_imp_angry_who") firstrow  clear
drop G H I
foreach var of varlist pers_imp_angry_who_*{
	replace `var' = 0 if `var' == .
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m
tempfile survey
save `survey'

*progressively merge with classification data for open ended question: definition
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("inf_def_open_1") firstrow  clear
foreach var of varlist inf_def_open_1_*{
	replace `var'=0 if `var'==.
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m

drop if ResponseId=="TOTAL"
drop if incomegroup_agg==.

*merge the emotion classification
merge 1:1 ResponseId using $survey_data/emotion_classification.dta
drop _m
levelsof emotion_inflation, local(emotions)

foreach name of local emotions {
        gen emotion_`name' = (emotion_inflation == "`name'") 
 
}

*Drop all the ResponseId which were not correctly merged. Now you have 504 observations
drop if substr(ResponseId, 1, 2) != "R_"
}

*#** FIGURE A2
{
su Durationinminutes if Durationinminutes <120, det
return list

hist Durationinminutes if Durationinminutes <120 , color(dknavy) width(5) xline(`r(mean)', lcolor(dknavy) lwidth(thick)) xline(`r(p50)', lcolor(red) lwidth(thick)) ///
	xaxis(1 2) xtitle(" " "Time spent on survey", axis(1) size(large)) xtitle("", axis(2) size(medium)) xlabel(0(10)120, nogrid) xlabel(`r(mean)' "Mean" `r(p50)' "Median", axis(2) angle(45) labsize(medium)) ylabel(, nogrid)   
graph display, ysize(5) xsize(8)
graph export "$figures/FIG_A2.png", as(png)width(5000) height(3333) replace
}