clear all

/* Set root directory */
*global dir " " //set origin path
global code "$dir/replication_package/codes"
global survey_data "$dir/replication_package/data"
global output "$dir/replication_package/output"
global figures "$output/figures"
global tables "$output/tables"


*import and clean data
do "$code/data_cleaning/creating_dataset_A"

grstyle init
grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"

*generate variables used in the analysis
gen rep=0 if !missing( political_agg)
replace rep=1 if political_agg==2
label var rep "Republican"

gen ind=0 if !missing( political_agg)
replace ind=1 if political_agg==3
label var ind "Independent"



*generate indicators for the analysis
*most important cause
tab pers_imp_psy_mostimp_en, gen(pers_imp_psy_mostimp_en_)

*The follwoing two figures combine answers to the questions on general psychological impacts and the most important cause of stress


**#FIGURE A11: INFLATION PSYCHOLOGICAL IMPACTS, SPLIT BY POLITICAL AFFILIATION
***split respondents by political leaning and represent the answers to the inflation impacts as a consumer questions for "democrat", "republican" and "full sample"
{
preserve
global most_imp_psy pers_imp_psy_mostimp_en_7 pers_imp_psy_mostimp_en_4 pers_imp_psy_mostimp_en_6 pers_imp_psy_mostimp_en_3 pers_imp_psy_mostimp_en_5 pers_imp_psy_mostimp_en_1 pers_imp_psy_mostimp_en_2
global generic_imp_psy dummy_stress dummy_neg_outlook 

global j=1

foreach var_selec of varlist $most_imp_psy{
	sum `var_selec' if  political_agg==1
	scalar    low_psych_${j}=r(mean)*100 
	scalar se_low_psych_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
sum `var_selec'
	scalar    full_psych_${j}=r(mean)*100 
	scalar se_full_psych_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
sum `var_selec' if  political_agg==2
	scalar    high_psych_${j}=r(mean)*100 
	scalar se_high_psych_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +2
}
global j=$j +3

foreach var_selec of varlist $generic_imp_psy{
	sum `var_selec' if political_agg==1
	scalar    low_gen_psych_${j}=r(mean)*100 
	scalar se_low_gen_psych_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
	sum `var_selec' 
	scalar    full_gen_psych_${j}=r(mean)*100 
	scalar se_full_gen_psych_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
	sum `var_selec' if political_agg==2
	scalar    high_gen_psych_${j}=r(mean)*100 
	scalar se_high_gen_psych_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +2
}

clear
set obs 38
egen n = seq()

foreach var in low_psych full_psych low_gen_psych full_gen_psych high_psych high_gen_psych{
gen `var' = . 
gen min_`var' = .
gen max_`var' = . 
}

foreach x in 1 5 9 13 17 21 25 {
replace low_psych = low_psych_`x' if n == `x'
replace min_low_psych = low_psych_`x'  - 1.645 * se_low_psych_`x'  if n == `x'
replace max_low_psych = low_psych_`x'  + 1.645 * se_low_psych_`x'  if n == `x'
scalar up_`x'=low_psych_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}

foreach x in 2 6 10 14 18 22 26 {
replace full_psych = full_psych_`x' if n == `x'
replace min_full_psych = full_psych_`x'  - 1.645 * se_full_psych_`x'  if n == `x'
replace max_full_psych = full_psych_`x'  + 1.645 * se_full_psych_`x'  if n == `x'
scalar up_`x'=full_psych_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}

foreach x in 3 7 11 15 19 23 27 {
replace high_psych = high_psych_`x' if n == `x'
replace min_high_psych = high_psych_`x'  - 1.645 * se_high_psych_`x'  if n == `x'
replace max_high_psych = high_psych_`x'  + 1.645 * se_high_psych_`x'  if n == `x'
scalar up_`x'=high_psych_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}

foreach x in 32 36 {
replace low_gen_psych = low_gen_psych_`x' if n == `x'
replace min_low_gen_psych = low_gen_psych_`x'  - 1.645 * se_low_gen_psych_`x'  if n == `x'
replace max_low_gen_psych = low_gen_psych_`x'  + 1.645 * se_low_gen_psych_`x'  if n == `x'
scalar up_`x'=low_gen_psych_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}

foreach x in 33 37 {
replace full_gen_psych = full_gen_psych_`x' if n == `x'
replace min_full_gen_psych = full_gen_psych_`x'  - 1.645 * se_full_gen_psych_`x'  if n == `x'
replace max_full_gen_psych = full_gen_psych_`x'  + 1.645 * se_full_gen_psych_`x'  if n == `x'
scalar up_`x'=full_gen_psych_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}

foreach x in 34 38 {
replace high_gen_psych = high_gen_psych_`x' if n == `x'
replace min_high_gen_psych = high_gen_psych_`x'  - 1.645 * se_high_gen_psych_`x'  if n == `x'
replace max_high_gen_psych = high_gen_psych_`x'  + 1.645 * se_high_gen_psych_`x'  if n == `x'
scalar up_`x'=high_gen_psych_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}

grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"
graph twoway (bar low_psych n, horizontal color(ebblue) barwidth(1)) (rcap min_low_psych max_low_psych n, horizontal color(ebblue)) (bar full_psych n, horizontal color(gray) barwidth(1)) (rcap min_full_psych max_full_psych n, horizontal color(gray)) (bar high_psych n, horizontal color(cranberry) barwidth(1)) (rcap min_high_psych max_high_psych n, horizontal color(cranberry)) (bar low_gen_psych n, horizontal color(ebblue) barwidth(1)) (rcap min_low_gen_psych max_low_gen_psych n, horizontal color(ebblue)) (bar full_gen_psych n, horizontal color(gray) barwidth(1)) (rcap min_full_gen_psych max_full_gen_psych n, horizontal color(gray)) (bar high_gen_psych n, horizontal color(cranberry) barwidth(1)) (rcap min_high_gen_psych max_high_gen_psych n, horizontal color(cranberry)) , ///
			 legend(order(1 3 5) lab(1 "{bf:Democrat}") lab(3 "{bf:Full sample}") lab(5 "{bf:Republican}")  size(large) position(6) cols(3) region(lcolor(black%50) lwidth(thin)) forces  symysize(4) symxsize(4) rowgap(0.7) colgap(0.6) just(left) placement(center)) ///
			 xlabel(0(10)100, nogrid noticks labsize(large)) ylabel( 22 `" "Paying bills/credit card balance" "' 26 `" "Being unable to afford essentials" "' 14 `" "Paying rent"  "' 6 `" "Paying mortgage"  "' ///
			 18 `" "Investment losses" "' 10 `" "Cutting down on going out/holidays" "' 2 `" "Paying my children tuition" "'  29.5 `" "{bf:Most important cause of stress:}" "' 37 `" "Inflation worsened the outlook" "on future economic well-being" "' 33 `" "Inflation caused stress" "' 40.5 `" "{bf:Psychological impacts of inflation:}" "', labsize(large) angle(35)  noticks nogrid) title("") ytitle("") xtitle( "Share of respondents" , size(large))  xsize(11) ysize(5) ///
			 text(1.2 `=pos3_1' "{bf:`=num_1'%}", size(medium) just(center) color(black%90)) ///
			text(2.2 `=pos3_2' "{bf:`=num_2'%}", size(medium) just(center) color(black%90)) ///
			text(3.2 `=pos3_3' "{bf:`=num_3'%}", size(medium) just(center) color(black%90)) ///
			text(5.2 `=pos3_5' "{bf:`=num_5'%}", size(medium) just(center) color(black%90)) ///
			text(6.2 `=pos3_6' "{bf:`=num_6'%}", size(medium) just(center) color(black%90)) ///
			text(7.2 `=pos3_7' "{bf:`=num_7'%}", size(medium) just(center) color(black%90)) ///
			text(9.2 `=pos3_9' "{bf:`=num_9'%}", size(medium) just(center) color(black%90)) ///
			text(10.2 `=pos3_10' "{bf:`=num_10'%}", size(medium) just(center) color(black%90)) ///
			text(11.2 `=pos3_11' "{bf:`=num_11'%}", size(medium) just(center) color(black%90)) ///
			text(13.2 `=pos3_13' "{bf:`=num_13'%}", size(medium) just(center) color(black%90)) ///
			text(14.2 `=pos3_14' "{bf:`=num_14'%}", size(medium) just(center) color(black%90)) ///
			text(15.2 `=pos3_15' "{bf:`=num_15'%}", size(medium) just(center) color(black%90)) ///
			text(17.2 `=pos3_17' "{bf:`=num_17'%}", size(medium) just(center) color(black%90)) ///
			text(18.2 `=pos3_18' "{bf:`=num_18'%}", size(medium) just(center) color(black%90)) ///
			text(19.2 `=pos3_19' "{bf:`=num_19'%}", size(medium) just(center) color(black%90)) ///
			text(21.2 `=pos3_21' "{bf:`=num_21'%}", size(medium) just(center) color(black%90)) ///
			text(22.2 `=pos3_22' "{bf:`=num_22'%}", size(medium) just(center) color(black%90)) ///
			text(23.2 `=pos3_23' "{bf:`=num_23'%}", size(medium) just(center) color(black%90)) ///
			text(25.2 `=pos3_25' "{bf:`=num_25'%}", size(medium) just(center) color(black%90)) ///
			text(26.2 `=pos3_26' "{bf:`=num_26'%}", size(medium) just(center) color(black%90)) ///
			text(27.2 `=pos3_27' "{bf:`=num_27'%}", size(medium) just(center) color(black%90)) ///
			text(32.2 `=pos3_32' "{bf:`=num_32'%}", size(medium) just(center) color(black%90)) ///
			text(33.2 `=pos3_33' "{bf:`=num_33'%}", size(medium) just(center) color(black%90)) ///
			text(34.2 `=pos3_34' "{bf:`=num_34'%}", size(medium) just(center) color(black%90)) ///
			text(36.2 `=pos3_36' "{bf:`=num_36'%}", size(medium) just(center) color(black%90)) ///
			text(37.2 `=pos3_37' "{bf:`=num_37'%}", size(medium) just(center) color(black%90)) ///
			text(38.2 `=pos3_38' "{bf:`=num_38'%}", size(medium) just(center) color(black%90)) ///
			
			resize, xsize(30cm) ysize(20cm)

graph save "$figures/FIG_A11.gpf", replace
graph export "$figures/FIG_A11.png", as(png) width(5000) height(3333) replace

restore

}
