clear all

/* Set root directory */
*global dir " " //set origin path
global code "$dir/replication_package/codes"
global survey_data "$dir/replication_package/data"
global output "$dir/replication_package/output"
global figures "$output/figures"
global tables "$output/tables"



grstyle init
grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"

*****CREATING THE DATASET
{
*import the first waves of collection and append the last one
do "$code/data_cleaning/creating_dataset_B_2"
tempfile B2
save `B2'

do "$code/data_cleaning/creating_dataset_B_1"
append using `B2'

*here we keep only the relevant het variables. Modify this if you need more
keep ResponseId income_group pol_aff pers_imp_feelings
*Income group (coarser partition aggregating groups)
gen 			incomegroup_agg =.
replace 		incomegroup_agg = 1 if income_group == 1 | income_group == 2
replace 		incomegroup_agg = 2 if income_group == 3 | income_group == 4 | income_group == 5 
replace 		incomegroup_agg = 3 if  income_group == 6
label define 	incomegroup_agg 1 "0k-39k" 2 "40k-124k" 3 "124k+"
label val 		incomegroup_agg incomegroup_agg

gen political_agg = 1 if( pol_aff==2)
	replace political_agg = 2 if(pol_aff==1)
	replace political_agg = 3 if(pol_aff>2)
label define political_agg 1 "Democrat" 2 "Republican" 3 "Independent and others"
label val political_agg political_agg

tempfile survey
save `survey'

*progressively merge with classification data for open ended question: why interesting inflation
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("inf_info_int_why") firstrow  clear
foreach var of varlist inf_info_int_why_*{
	replace `var'=0 if `var'==.
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m
tempfile survey
save `survey'

*progressively merge with classification data for open ended question: what bad could happen if inflation too high?
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("inf_info_bad_what") firstrow  clear
foreach var of varlist inf_info_bad_what_*{
	replace `var'=0 if `var'==.
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m
tempfile survey
save `survey'

*progressively merge with classification data for open ended question: what bad could happen if inflation too high?
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("inf_info_high_why") firstrow  clear
foreach var of varlist inf_info_high_why_*{
	replace `var'=0 if `var'==.
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m
tempfile survey
save `survey'

*progressively merge with classification data for open ended question: positive impact of inflation?
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("inf_info_positive") firstrow  clear
foreach var of varlist inf_info_positive_*{
	replace `var'=0 if `var'==.
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m
tempfile survey
save `survey'

*progressively merge with classification data for open ended question: impact of inflation?
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("pers_imp_me") firstrow  clear
foreach var of varlist pers_imp_me_*{
	replace `var'=0 if `var'==.
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m
tempfile survey
save `survey'

*progressively merge with classification data for open ended question: what caused changes in income
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("pers_imp_inc_change") firstrow  clear
foreach var of varlist pers_imp_inc_change_*{
	replace `var'=0 if `var'==.
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m
tempfile survey
save `survey'

*progressively merge with classification data for open ended question: angry at who
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("pers_imp_angry_who") firstrow  clear
drop G H I
foreach var of varlist pers_imp_angry_who_*{
	replace `var' = 0 if `var' == .
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m
tempfile survey
save `survey'

*progressively merge with classification data for open ended question: definition
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("inf_def_open_1") firstrow  clear
foreach var of varlist inf_def_open_1_*{
	replace `var'=0 if `var'==.
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m

drop if ResponseId=="TOTAL"
drop if incomegroup_agg==.

*merge the emotion classification
merge 1:1 ResponseId using $survey_data/emotion_classification.dta
drop _m
levelsof emotion_inflation, local(emotions)

foreach name of local emotions {
        gen emotion_`name' = (emotion_inflation == "`name'") 
 
}

*Drop all the ResponseId which were not correctly merged. Now you have 504 observations
drop if substr(ResponseId, 1, 2) != "R_"
}


**#FIGURE 5A: IF INFLATION INCREASES TOO MUCH, I WORRY ABOUT... [OPEN-ENDED TEXT] -- BY INCOME
***If inflation increases too much what bad may happen? If inflation increases too much there could be
***split respondents by income and represent the answers to the inflation impacts as a consumer questions for "low income", "high income" and "full sample"
{
preserve

global consumer inf_info_bad_what_job inf_info_bad_what_housing inf_info_bad_what_food inf_info_bad_what_instability  inf_info_bad_what_recession inf_info_bad_what_financial  



global j=1

foreach var_selec of varlist $consumer{
	sum `var_selec' if incomegroup_agg==1
	scalar    low_cons_impact_${j}=r(mean)*100 
	scalar low_se_cons_impact_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
sum `var_selec' 
	scalar    full_cons_impact_${j}=r(mean)*100 
	scalar full_se_cons_impact_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
sum `var_selec' if incomegroup_agg==3
	scalar    high_cons_impact_${j}=r(mean)*100 
	scalar high_se_cons_impact_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +2

}



clear
set obs 23
egen n = seq()

foreach var in full_cons_impact low_cons_impact high_cons_impact{
gen `var' = . 
gen min_`var' = .
gen max_`var' = . 
}

foreach x in 1 5 9 13 17 21  {
replace low_cons_impact = low_cons_impact_`x' if n == `x'
replace min_low_cons_impact = low_cons_impact_`x'  - 1.645 * low_se_cons_impact_`x'  if n == `x'
replace max_low_cons_impact = low_cons_impact_`x'  + 1.645 * low_se_cons_impact_`x'  if n == `x'
scalar up_`x'=low_cons_impact_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+13
}

foreach x in 2 6 10 14 18 22  {
replace full_cons_impact = full_cons_impact_`x' if n == `x'
replace min_full_cons_impact = full_cons_impact_`x'  - 1.645 * full_se_cons_impact_`x'  if n == `x'
replace max_full_cons_impact = full_cons_impact_`x'  + 1.645 * full_se_cons_impact_`x'  if n == `x'
scalar up_`x'=full_cons_impact_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+13
}

foreach x in 3 7 11 15 19 23 {
replace high_cons_impact = high_cons_impact_`x' if n == `x'
replace min_high_cons_impact = high_cons_impact_`x'  - 1.645 * high_se_cons_impact_`x'  if n == `x'
replace max_high_cons_impact = high_cons_impact_`x'  + 1.645 * high_se_cons_impact_`x'  if n == `x'
scalar up_`x'=high_cons_impact_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+13
}




grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"
graph twoway (bar low_cons_impact n, horizontal color(orange) barwidth(1) ) (rcap min_low_cons_impact max_low_cons_impact n, horizontal color(orange)) (bar full_cons_impact n, horizontal color(gray) barwidth(1) ) (rcap min_full_cons_impact max_full_cons_impact n, horizontal color(gray))(bar high_cons_impact n, horizontal color("17 119 51") barwidth(1)) (rcap min_high_cons_impact max_high_cons_impact n, horizontal color("17 119 51")), legend(order(1 3 5) lab(1 "{bf:Income <$40k}") lab(3 "{bf:Full sample}") lab(5 "{bf:Income >$125k}")  size(small) position(6) cols(3) region(lcolor(black%50) lwidth(thin))  symysize(4) symxsize(4) rowgap(-2) colgap(0.6) just(left) symplacement(center)) ///
			 xlabel(0(10)50, nogrid noticks labsize(medsmall)) ylabel(18 `" "A recession" "' 2 `" "Lagging salaries/job losses" "'  6 `" "Problems in affording housing" "' 10 `" "Problems in affording food" "' 14 `" "Social instability" "' 22 `" "Financial hardship" "'  , labsize(medium) noticks nogrid)   xtitle(`"Share of respondents"') ytitle("") 	xsize(10) ysize(5)  ///
			text(1 `=pos3_1' "{bf:`=num_1'%}", size(medsmall) just(center) color(black%90)) ///
			text(2 `=pos3_2' "{bf:`=num_2'%}", size(medsmall) just(center) color(black%90)) ///
			text(3 `=pos3_3' "{bf:`=num_3'%}", size(medsmall) just(center) color(black%90)) ///
			text(5 `=pos3_5' "{bf:`=num_5'%}", size(medsmall) just(center) color(black%90)) ///
			text(6 `=pos3_6' "{bf:`=num_6'%}", size(medsmall) just(center) color(black%90)) ///
			text(7 `=pos3_7' "{bf:`=num_7'%}", size(medsmall) just(center) color(black%90)) ///
			text(9 `=pos3_9' "{bf:`=num_9'%}", size(medsmall) just(center) color(black%90)) ///
			text(10 `=pos3_10' "{bf:`=num_10'%}", size(medsmall) just(center) color(black%90)) ///
			text(11 `=pos3_11' "{bf:`=num_11'%}", size(medsmall) just(center) color(black%90)) ///
			text(13 `=pos3_13' "{bf:`=num_13'%}", size(medsmall) just(center) color(black%90)) ///
			text(14 `=pos3_14' "{bf:`=num_14'%}", size(medsmall) just(center) color(black%90)) ///
			text(15 `=pos3_15' "{bf:`=num_15'%}", size(medsmall) just(center) color(black%90)) ///
			text(17 `=pos3_17' "{bf:`=num_17'%}", size(medsmall) just(center) color(black%90)) ///
			text(18 `=pos3_18' "{bf:`=num_18'%}", size(medsmall) just(center) color(black%90)) ///
			text(19 `=pos3_19' "{bf:`=num_19'%}", size(medsmall) just(center) color(black%90)) ///
			text(21 `=pos3_21' "{bf:`=num_21'%}", size(medsmall) just(center) color(black%90)) ///
			text(22 `=pos3_22' "{bf:`=num_22'%}", size(medsmall) just(center) color(black%90)) ///
			text(23 `=pos3_23' "{bf:`=num_23'%}", size(medsmall) just(center) color(black%90)) 
		
		

graph save "$figures/FIG_5A.gpf", replace
graph export "$figures/FIG_5A.png", as(png) width(5000) height(2500) replace

restore

}
