clear all

/* Set root directory */
*global dir " " //set origin path
global code "$dir/replication_package/codes"
global survey_data "$dir/replication_package/data"
global output "$dir/replication_package/output"
global figures "$output/figures"
global tables "$output/tables"


*import and clean data
do "$code/data_cleaning/creating_dataset_A"


grstyle init
grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"



*generate indicator for ranking questions
tab inf_priority_rank_ec_1_en, gen(inf_priority_rank_ec_1_en_)
tab inf_priority_rank_ec_2_en, gen(inf_priority_rank_ec_2_en_)
tab inf_priority_rank_ec_3_en, gen(inf_priority_rank_ec_3_en_)	
tab inf_priority_rank_ec_4_en, gen(inf_priority_rank_ec_4_en_)
tab inf_priority_rank_ec_5_en, gen(inf_priority_rank_ec_5_en_)

tab inf_priority_rank_sc_1_en, gen(inf_priority_rank_sc_1_en_)
tab inf_priority_rank_sc_2_en, gen(inf_priority_rank_sc_2_en_)
tab inf_priority_rank_sc_3_en, gen(inf_priority_rank_sc_3_en_)	
tab inf_priority_rank_sc_4_en, gen(inf_priority_rank_sc_4_en_)
tab inf_priority_rank_sc_5_en, gen(inf_priority_rank_sc_5_en_)
tab inf_priority_rank_sc_6_en, gen(inf_priority_rank_sc_6_en_)

**#FIGURE 20: RANKING OF SOCIAL AND ECONOMIC ISSUES
***split respondents by political leaning and represent the answers to the inflation impacts as a consumer questions for "democrat", "republican" and "full sample"
{
preserve

global econ_issues dummy_defense_first_ec dummy_lowu_first_ec dummy_growth_first_ec dummy_finstab_first_ec dummy_inf_first_ec

global social_issues  dummy_abortion_first_sc dummy_gun_first_sc dummy_educ_first_sc dummy_civil_first_sc dummy_health_first_sc dummy_inf_first_sc


global j=1

foreach var_selec of varlist $social_issues{
	sum `var_selec' if political_agg==1
	scalar    social_issues_d_${j}=r(mean)*100 
	scalar se_social_issues_d_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
sum `var_selec'
	scalar    social_issues_f_${j}=r(mean)*100 
	scalar se_social_issues_f_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
sum `var_selec' if political_agg==2
	scalar    social_issues_r_${j}=r(mean)*100 
	scalar se_social_issues_r_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +2
}

global j=$j +3

foreach var_selec of varlist $econ_issues{
	sum `var_selec' if political_agg==1
	scalar    econ_issues_d_${j}=r(mean)*100 
	scalar se_econ_issues_d_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
sum `var_selec' 
	scalar    econ_issues_f_${j}=r(mean)*100 
	scalar se_econ_issues_f_${j}=(r(sd)/sqrt(r(N)))*100
	global j=$j +1
sum `var_selec' if political_agg==2
	scalar    econ_issues_r_${j}=r(mean)*100 
	scalar se_econ_issues_r_${j}=(r(sd)/sqrt(r(N)))*100
	global j=$j +2
}



clear
set obs 46
egen n = seq()

foreach var in econ_issues_d econ_issues_f social_issues_d social_issues_f  econ_issues_r social_issues_r  {
gen `var' = . 
gen min_`var' = .
gen max_`var' = . 
}

foreach x in 1 5 9 13 17 21{
replace social_issues_d = social_issues_d_`x' if n == `x'
replace min_social_issues_d = social_issues_d_`x'  - 1.645 * se_social_issues_d_`x'  if n == `x'
replace max_social_issues_d = social_issues_d_`x'  + 1.645 * se_social_issues_d_`x'  if n == `x'
scalar up_`x'=social_issues_d_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}

foreach x in 2 6 10 14 18 22{
replace social_issues_f = social_issues_f_`x' if n == `x'
replace min_social_issues_f = social_issues_f_`x'  - 1.645 * se_social_issues_f_`x'  if n == `x'
replace max_social_issues_f = social_issues_f_`x'  + 1.645 * se_social_issues_f_`x'  if n == `x'
scalar up_`x'=social_issues_f_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}

foreach x in 3 7 11 15 19 23{
replace social_issues_r = social_issues_r_`x' if n == `x'
replace min_social_issues_r = social_issues_r_`x'  - 1.645 * se_social_issues_r_`x'  if n == `x'
replace max_social_issues_r = social_issues_r_`x'  + 1.645 * se_social_issues_r_`x'  if n == `x'
scalar up_`x'=social_issues_r_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}

foreach x in 28 32 36 40 44 {
replace econ_issues_d = econ_issues_d_`x' if n == `x'
replace min_econ_issues_d = econ_issues_d_`x'  - 1.645 * se_econ_issues_d_`x'  if n == `x'
replace max_econ_issues_d = econ_issues_d_`x'  + 1.645 * se_econ_issues_d_`x'  if n == `x'
scalar up_`x'=econ_issues_d_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}

foreach x in 29 33 37 41 45 {
replace econ_issues_f = econ_issues_f_`x' if n == `x'
replace min_econ_issues_f = econ_issues_f_`x'  - 1.645 * se_econ_issues_f_`x'  if n == `x'
replace max_econ_issues_f = econ_issues_f_`x'  + 1.645 * se_econ_issues_f_`x'  if n == `x'
scalar up_`x'=econ_issues_f_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}


foreach x in 30 34 38 42 46 {
replace econ_issues_r = econ_issues_r_`x' if n == `x'
replace min_econ_issues_r = econ_issues_r_`x'  - 1.645 * se_econ_issues_r_`x'  if n == `x'
replace max_econ_issues_r = econ_issues_r_`x'  + 1.645 * se_econ_issues_r_`x'  if n == `x'
scalar up_`x'=econ_issues_r_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}

grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"
graph twoway (bar econ_issues_d n, horizontal color(ebblue) barwidth(1)) (rcap min_econ_issues_d max_econ_issues_d n, horizontal color(ebblue)) (bar econ_issues_f n, horizontal color(gray) barwidth(1)) (rcap min_econ_issues_f max_econ_issues_f n, horizontal color(gray))      (bar econ_issues_r n, horizontal color(cranberry) barwidth(1) ) (rcap min_econ_issues_r max_econ_issues_r n, horizontal color(cranberry)) ///
(bar social_issues_d n, horizontal color(ebblue) barwidth(1) ) (rcap min_social_issues_d max_social_issues_d n, horizontal color(ebblue)) (bar social_issues_f n, horizontal color(gray) barwidth(1) ) (rcap min_social_issues_f max_social_issues_f n, horizontal color(gray))       (bar social_issues_r n, horizontal color(cranberry) barwidth(1)) (rcap min_social_issues_r max_social_issues_r n, horizontal color(cranberry)), ///
			 legend(order(1 3 5) lab(1 "{bf:Democrat}") lab(3 "{bf:Full sample}") lab(5 "{bf:Republican}")  size(large) position(6) cols(3) region(lcolor(black%50) lwidth(thin)) forces  symysize(4) symxsize(4) rowgap(0.7) colgap(0.6) just(left) placement(center)) ///
			 xlabel(0(10)100, nogrid noticks labsize(large)) ylabel(2 `" "Abortion" "' 6 `" "Gun rights" "' 10`" "Education" "' 14 `" "Civil rights" "' 18 `" "Healthcare" "' 22 `" "Inflation" "' 25.5 `" "{bf:Social issues:}" "' ///
			29 `" "National defense" "' 33 `" "Low unemployment" "' 37 `" "Economic growth" "' 41 `" "Financial stability" "' 45 `" "Inflation" "' 48.5 `" "{bf:Economic issues:}" "' ,  noticks nogrid labsize(large))   xtitle(`"Share of respondents"', size(large)) ytitle("") ///
			text(1.2 `=pos3_1' "{bf:`=num_1'%}", size(medmsall) just(center) color(black%90)) ///
			text(2.2 `=pos3_2' "{bf:`=num_2'%}", size(medmsall) just(center) color(black%90)) ///
			text(3.2 `=pos3_3' "{bf:`=num_3'%}", size(medmsall) just(center) color(black%90)) ///
			text(5.2 `=pos3_5' "{bf:`=num_5'%}", size(medmsall) just(center) color(black%90)) ///
			text(6.2 `=pos3_6' "{bf:`=num_6'%}", size(medmsall) just(center) color(black%90)) ///
			text(7.2 `=pos3_7' "{bf:`=num_7'%}", size(medmsall) just(center) color(black%90)) ///
			text(9.2 `=pos3_9' "{bf:`=num_9'%}", size(medmsall) just(center) color(black%90)) ///
			text(10.2 `=pos3_10' "{bf:`=num_10'%}", size(medmsall) just(center) color(black%90)) ///
			text(11.2 `=pos3_11' "{bf:`=num_11'%}", size(medmsall) just(center) color(black%90)) ///
			text(13.2 `=pos3_13' "{bf:`=num_13'%}", size(medmsall) just(center) color(black%90)) ///
			text(14.2 `=pos3_14' "{bf:`=num_14'%}", size(medmsall) just(center) color(black%90)) ///
			text(15.2 `=pos3_15' "{bf:`=num_15'%}", size(medmsall) just(center) color(black%90)) ///
			text(17.2 `=pos3_17' "{bf:`=num_17'%}", size(medmsall) just(center) color(black%90)) ///
			text(18.2 `=pos3_18' "{bf:`=num_18'%}", size(medmsall) just(center) color(black%90)) ///
			text(19.2 `=pos3_19' "{bf:`=num_19'%}", size(medmsall) just(center) color(black%90)) ///
			text(21.2 `=pos3_21' "{bf:`=num_21'%}", size(medmsall) just(center) color(black%90)) ///
			text(22.2 `=pos3_22' "{bf:`=num_22'%}", size(medmsall) just(center) color(black%90)) ///
			text(23.2 `=pos3_23' "{bf:`=num_23'%}", size(medmsall) just(center) color(black%90)) ///
			text(28.2 `=pos3_28' "{bf:`=num_28'%}", size(medmsall) just(center) color(black%90)) ///
			text(29.2 `=pos3_29' "{bf:`=num_29'%}", size(medmsall) just(center) color(black%90)) ///
			text(30.2 `=pos3_30' "{bf:`=num_30'%}", size(medmsall) just(center) color(black%90)) ///
			text(32.2 `=pos3_32' "{bf:`=num_32'%}", size(medmsall) just(center) color(black%90)) ///
			text(33.2 `=pos3_33' "{bf:`=num_33'%}", size(medmsall) just(center) color(black%90)) ///
			text(34.2 `=pos3_34' "{bf:`=num_34'%}", size(medmsall) just(center) color(black%90)) ///
			text(36.2 `=pos3_36' "{bf:`=num_36'%}", size(medmsall) just(center) color(black%90)) ///
			text(37.2 `=pos3_37' "{bf:`=num_37'%}", size(medmsall) just(center) color(black%90)) ///
			text(38.2 `=pos3_38' "{bf:`=num_38'%}", size(medmsall) just(center) color(black%90)) ///
			text(40.2 `=pos3_40' "{bf:`=num_40'%}", size(medmsall) just(center) color(black%90)) ///
			text(41.2 `=pos3_41' "{bf:`=num_41'%}", size(medmsall) just(center) color(black%90)) ///
			text(42.2 `=pos3_42' "{bf:`=num_42'%}", size(medmsall) just(center) color(black%90)) ///
			text(44.2 `=pos3_44' "{bf:`=num_44'%}", size(medmsall) just(center) color(black%90)) ///
			text(45.2 `=pos3_45' "{bf:`=num_45'%}", size(medmsall) just(center) color(black%90)) ///
			text(46.2 `=pos3_46' "{bf:`=num_46'%}", size(medmsall) just(center) color(black%90)) ///
			xsize(10) ysize(10) 
			
			resize, xsize(20cm) ysize(20cm)

graph save "$figures/FIG_20.gpf", replace
graph export "$figures/FIG_20.png", as(png) width(4000) height(4000) replace

restore

}
