clear all

/* Set root directory */
*global dir " " //set origin path
global code "$dir/replication_package/codes"
global survey_data "$dir/replication_package/data"
global output "$dir/replication_package/output"
global figures "$output/figures"
global tables "$output/tables"


*import and clean data
do "$code/data_cleaning/creating_dataset_A"


grstyle init
grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"


*generate indicators for the analysis
tab inf_pol_cohesion_en, gen(inf_pol_cohesion_)
tab inf_pol_int_rep_en, gen(inf_pol_int_rep_)
tab inf_pol_cause_pol_en, gen(inf_pol_cause_pol_)



**#TABLE A7: CORRELATES OF PERCEIVED SOCIAL AND POLITICAL CONSEQUENCES OF INFLATIO
{

eststo clear
global table_name "$tables/TABLE_A7"

* Table end
file open  holder using $tables/temp_end.tex, write replace text
file write holder "\hline \hline \end{tabular}" _n
file close holder

* Table start
file open holder using $table_name.tex, write replace text
file write holder "\begin{tabular}{lccc} " _n
file write holder "& \multicolumn{3}{c}{ \textit{Dependent variable:}}  \\" _n
file write holder "& Inflation hurts & Inflation decreases & Inflation decreases \\" _n
file write holder "& international reputation & political stability & social cohesion \\ \hline" _n
file write holder " \cmidrule(lr){2-4}" _n
file close holder

	
global controls_main women age_class_agg2 age_class_agg3  dummy_race_agg2 dummy_race_agg3 dummy_race_agg4  incomegroup_agg_2 incomegroup_agg_3 dummy_employment_agg2 dummy_employment_agg1 dummy_employment_agg4 dummy_married dummy_children dummy_us_area1 dummy_us_area2 dummy_us_area3  college republican political_agg3


eststo clear


eststo: reg dummy_inf_pol_reputation  $controls_main , vce(robust)
local r1: display %5.3f `e(r2_a)'

qui sum dummy_inf_pol_reputation if e(sample) 
local mean1: display %5.3f `r(mean)'
local obs1: display %5.0f `r(N)'
local sd1: display %5.3f `r(sd)'

eststo: reg dummy_inf_pol_stability  $controls_main , vce(robust)
local r2: display %5.3f `e(r2_a)'

qui sum dummy_inf_pol_stability if e(sample) 
local mean2: display %5.3f `r(mean)'
local obs2: display %5.0f `r(N)'
local sd2: display %5.3f `r(sd)'

eststo: reg dummy_inf_pol_cohesion  $controls_main , vce(robust)
local r3: display %5.3f `e(r2_a)'

qui sum dummy_inf_pol_cohesion if e(sample) 
local mean3: display %5.3f `r(mean)'
local obs3: display %5.0f `r(N)'
local sd3: display %5.3f `r(sd)'


esttab using $tables/panel.tex, replace fragment booktabs noconst nobase label cells(b(fmt(3) star) se(par fmt(3))) collabels(none) /// 
starlevels(* .1 ** .05 *** .01) se nonumbers nomtitles nolines nocon noobs compress

eststo clear

*** Means ***
file open holder using $tables/panel_means.tex, write replace text
file write holder "\hline " _n
file write holder "Observations & `obs1' & `obs2' & `obs3'    \\" _n     
file write holder "Adj. R$^{2}$ & `r1' & `r2' & `r3'  \\" _n 
file write holder "Dependent variable mean & `mean1' & `mean2' & `mean3'    \\" _n   
file write holder "Dependent variable std. dev. & `sd1' & `sd2' & `sd3' \\" _n
file close holder

appendfile $tables/panel.tex $table_name.tex
appendfile $tables/panel_means.tex $table_name.tex
appendfile $tables/temp_end.tex $table_name.tex

erase $tables/panel.tex
erase $tables/panel_means.tex
erase $tables/temp_end.tex 

eststo clear
}
