clear all

/* Set root directory */
*global dir " " //set origin path
global code "$dir/replication_package/codes"
global survey_data "$dir/replication_package/data"
global output "$dir/replication_package/output"
global figures "$output/figures"
global tables "$output/tables"


*import and clean data
do "$code/data_cleaning/creating_dataset_A"


grstyle init
grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"


*generate indicators of interest
tab infl_unemp_pref_en, gen(infl_unemp_pref_)


**#TABLE A23: CORRELATES OF THE INFLATION VERSUS UNEMPLOYMENT TRADE-OFF
{

eststo clear
global table_name "$tables/TABLE_A23"

* Table end
file open  holder using $tables/temp_end.tex, write replace text
file write holder "\hline \hline \end{tabular}" _n
file close holder

* Table start
file open holder using $table_name.tex, write replace text
file write holder "\begin{tabular}{lccccccccc} " _n
file write holder "& \multicolumn{9}{c}{ \textit{Dependent variable}}  \\" _n
file write holder "& \multicolumn{2}{c}{ \textbf{Inflation and unemployment}} & \multicolumn{5}{c}{ \textbf{Policy preferences}} & \multicolumn{2}{c}{ \textbf{Inflation and the economy}}   \\" _n
file write holder " \cmidrule(lr){2-3} \cmidrule(lr){4-8}  \cmidrule(lr){9-10}" _n
file write holder "& Inflation and  & Inflation and & Low inflation & Priority to & Equal & Priority to & Low & Inflation & Inflation \\" _n
file write holder "& unemployment & unemployment & at all costs & inflation, but  & priority & unemployment,  & unemployment & indicates & decreases \\ " _n
file write holder "& are related  & are negatively &  & mindful of &  & but mindful & at all costs & a poor state of & exports \\ " _n
file write holder "&  & related & & unemployment & & of inflation  & & the economy &  \\ \hline" _n
file write holder " \cmidrule(lr){2-10}" _n
file close holder

	
global controls_main women age_class_agg2 age_class_agg3  dummy_race_agg2 dummy_race_agg3 dummy_race_agg4  incomegroup_agg_2 incomegroup_agg_3 dummy_employment_agg2 dummy_employment_agg1 dummy_employment_agg4 dummy_married dummy_children dummy_us_area1 dummy_us_area2 dummy_us_area3  college republican political_agg3


eststo clear


eststo: reg dummy_infl_unemp_know  $controls_main , vce(robust)
local r1: display %5.3f `e(r2_a)'

qui sum dummy_infl_unemp_know if e(sample) 
local mean1: display %5.3f `r(mean)'
local obs1: display %5.0f `r(N)'
local sd1: display %5.3f `r(sd)'

eststo: reg dummy_infl_unemp_dir  $controls_main , vce(robust)
local r2: display %5.3f `e(r2_a)'

qui sum dummy_infl_unemp_dir if e(sample) 
local mean2: display %5.3f `r(mean)'
local obs2: display %5.0f `r(N)'
local sd2: display %5.3f `r(sd)'

eststo: reg infl_unemp_pref_5  $controls_main , vce(robust)
local r3: display %5.3f `e(r2_a)'

qui sum infl_unemp_pref_5 if e(sample) 
local mean3: display %5.3f `r(mean)'
local obs3: display %5.0f `r(N)'
local sd3: display %5.3f `r(sd)'


eststo: reg infl_unemp_pref_4  $controls_main , vce(robust)
local r4: display %5.3f `e(r2_a)'

qui sum infl_unemp_pref_4 if e(sample) 
local mean4: display %5.3f `r(mean)'
local obs4: display %5.0f `r(N)'
local sd4: display %5.3f `r(sd)'


eststo: reg infl_unemp_pref_3  $controls_main , vce(robust)
local r5: display %5.3f `e(r2_a)'

qui sum infl_unemp_pref_3 if e(sample) 
local mean5: display %5.3f `r(mean)'
local obs5: display %5.0f `r(N)'
local sd5: display %5.3f `r(sd)'


eststo: reg infl_unemp_pref_2  $controls_main , vce(robust)
local r6: display %5.3f `e(r2_a)'

qui sum infl_unemp_pref_2 if e(sample) 
local mean6: display %5.3f `r(mean)'
local obs6: display %5.0f `r(N)'
local sd6: display %5.3f `r(sd)'

eststo: reg infl_unemp_pref_1  $controls_main , vce(robust)
local r7: display %5.3f `e(r2_a)'

qui sum infl_unemp_pref_1 if e(sample) 
local mean7: display %5.3f `r(mean)'
local obs7: display %5.0f `r(N)'
local sd7: display %5.3f `r(sd)'

eststo: reg dummy_infl_bad_signal  $controls_main , vce(robust)
local r8: display %5.3f `e(r2_a)'

qui sum dummy_infl_bad_signal if e(sample) 
local mean8: display %5.3f `r(mean)'
local obs8: display %5.0f `r(N)'
local sd8: display %5.3f `r(sd)'

eststo: reg dummy_infl_exports  $controls_main , vce(robust)
local r9: display %5.3f `e(r2_a)'

qui sum dummy_infl_exports if e(sample) 
local mean9: display %5.3f `r(mean)'
local obs9: display %5.0f `r(N)'
local sd9: display %5.3f `r(sd)'


esttab using $tables/panel.tex, replace fragment booktabs noconst nobase label cells(b(fmt(3) star) se(par fmt(3))) collabels(none) /// 
starlevels(* .1 ** .05 *** .01) se nonumbers nomtitles nolines nocon noobs compress

eststo clear

*** Means ***
file open holder using $tables/panel_means.tex, write replace text
file write holder "\hline " _n
file write holder "Observations & `obs1' & `obs2' & `obs3' & `obs4' & `obs5' & `obs6' & `obs7' & `obs8'  & `obs9'  \\" _n     
file write holder "Adj. R$^{2}$ & `r1' & `r2' & `r3' & `r4' & `r5' & `r6' & `r7' & `r8'  & `r9'   \\" _n 
file write holder "Dependent variable mean & `mean1' & `mean2' & `mean3'  & `mean4'  & `mean5'  & `mean6' & `mean7' & `mean8' & `mean9' \\" _n   
file write holder "Dependent variable std. dev. & `sd1' & `sd2' & `sd3' & `sd4' & `sd5' & `sd6' & `sd7' & `sd8' & `sd9'  \\" _n
file close holder

appendfile $tables/panel.tex $table_name.tex
appendfile $tables/panel_means.tex $table_name.tex
appendfile $tables/temp_end.tex $table_name.tex

erase $tables/panel.tex
erase $tables/panel_means.tex
erase $tables/temp_end.tex 

eststo clear
}


