clear all

/* Set root directory */
*global dir " " //set origin path
global code "$dir/replication_package/codes"
global survey_data "$dir/replication_package/data"
global output "$dir/replication_package/output"
global figures "$output/figures"
global tables "$output/tables"


*import and clean data
do "$code/data_cleaning/creating_dataset_A"

grstyle init
grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"


*generate indicators for the analysis
tab inf_exp_react_now_en, gen(inf_exp_react_now_agg_)
tab inf_exp_react_later_en, gen(inf_exp_react_later_agg_)

gen dummy_accel_ess = 0 if !missing(react_delay_ess_agg_en)
replace dummy_accel_ess=1 if react_delay_ess_agg_en==1|react_delay_ess_agg_en==2
label var dummy_accel_ess "Accelerated at least some essential goods"

gen dummy_accel_noess = 0 if !missing(react_delay_noess_agg_en)
replace dummy_accel_noess=1 if react_delay_noess_agg_en==1|react_delay_noess_agg_en==2
label var dummy_accel_noess "Accelerated at least some non essential goods"

gen inf_exp_react_now_decrease = 0 if!missing(inf_exp_react_now_en)
replace inf_exp_react_now_decrease=1 if inf_exp_react_now_en==3|inf_exp_react_now_en==4
label var inf_exp_react_now_decrease "Decreased spending somewhat or a lot right away"

gen inf_exp_react_now_increase = 0 if!missing(inf_exp_react_now_en)
replace inf_exp_react_now_increase =1 if inf_exp_react_now_en==1|inf_exp_react_now_en==2
label var inf_exp_react_now_increase "Increased spending somewhat or a lot right away"

gen inf_exp_react_later_decrease = 0 if!missing(inf_exp_react_later_en)
replace inf_exp_react_later_decrease=1 if inf_exp_react_later_en==3|inf_exp_react_later_en==4
label var inf_exp_react_later_decrease "Decrease spending somewhat or a lot later"

gen inf_exp_react_later_increase = 0 if!missing(inf_exp_react_later_en)
replace inf_exp_react_later_increase=1 if inf_exp_react_later_en==1|inf_exp_react_later_en==2
label var inf_exp_react_later_increase "Increase spending somewhat or a lot later"



**#TABLE A13: CORRELATES OF PERSONAL REACTIONS TO INFLATION AS A CONSUMER
{

eststo clear
global table_name "$tables/TABLE_A13"

* Table end
file open  holder using $tables/temp_end.tex, write replace text
file write holder "\hline \hline \end{tabular}" _n
file close holder

* Table start
file open holder using $table_name.tex, write replace text
file write holder "\begin{tabular}{lcccccccccccc} " _n
file write holder "& \multicolumn{12}{c}{ \textit{Dependent variable}}  \\" _n
file write holder "& \multicolumn{6}{c}{ \textbf{Personal reactions to inflation}} & \multicolumn{2}{c}{ \textbf{Reactions to higher}} & \multicolumn{2}{c}{ \textbf{Change in spending}} & \multicolumn{2}{c}{ \textbf{Change in spending close to}} \\" _n
file write holder "& \multicolumn{6}{c}{ \textbf{in household spending}} & \multicolumn{2}{c}{ \textbf{expected inflation}} & \multicolumn{2}{c}{ \textbf{right away}} & \multicolumn{2}{c}{ \textbf{the time when prices increase}}\\" _n
file write holder "  \cmidrule(lr){2-7}  \cmidrule(lr){8-9}  \cmidrule(lr){10-11}  \cmidrule(lr){12-13}" _n
file write holder "& Reduced the  & Delayed the & Accelerated the  & Delayed the & Accelerated the & Shifted shopping & Change spending right & Change spending close & Decrease & Increase & Decrease & Increase \\" _n
file write holder "& quantity of & purchase of & purchase of & purchase of & purchase of & towards lower-priced & away if I expect & to the time when I & somewhat & somewhat & somewhat & somewhat \\ " _n
file write holder "& goods purchased & non-essential goods & non-essential goods &  essential goods & essential goods & lower-quality goods  & prices to increase & expect prices to increase & or a lot & or a lot & or a lot & or a lot \\ \hline" _n
file write holder " \cmidrule(lr){2-13}" _n
file close holder

	
global controls_main women age_class_agg2 age_class_agg3  dummy_race_agg2 dummy_race_agg3 dummy_race_agg4  incomegroup_agg_2 incomegroup_agg_3 dummy_employment_agg2 dummy_employment_agg1 dummy_employment_agg4 dummy_married dummy_children dummy_us_area1 dummy_us_area2 dummy_us_area3  college republican political_agg3


eststo clear


eststo: reg dummy_react_quant  $controls_main , vce(robust)
local r1: display %5.3f `e(r2_a)'

qui sum dummy_react_quant if e(sample) 
local mean1: display %5.3f `r(mean)'
local obs1: display %5.0f `r(N)'
local sd1: display %5.3f `r(sd)'

eststo: reg dummy_delay_noess  $controls_main , vce(robust)
local r2: display %5.3f `e(r2_a)'

qui sum dummy_delay_noess if e(sample) 
local mean2: display %5.3f `r(mean)'
local obs2: display %5.0f `r(N)'
local sd2: display %5.3f `r(sd)'

eststo: reg dummy_accel_noess  $controls_main , vce(robust)
local r3: display %5.3f `e(r2_a)'

qui sum dummy_accel_noess if e(sample) 
local mean3: display %5.3f `r(mean)'
local obs3: display %5.0f `r(N)'
local sd3: display %5.3f `r(sd)'


eststo: reg dummy_delay_ess  $controls_main , vce(robust)
local r4: display %5.3f `e(r2_a)'

qui sum dummy_delay_ess if e(sample) 
local mean4: display %5.3f `r(mean)'
local obs4: display %5.0f `r(N)'
local sd4: display %5.3f `r(sd)'


eststo: reg dummy_accel_ess  $controls_main , vce(robust)
local r5: display %5.3f `e(r2_a)'

qui sum dummy_accel_ess if e(sample) 
local mean5: display %5.3f `r(mean)'
local obs5: display %5.0f `r(N)'
local sd5: display %5.3f `r(sd)'


eststo: reg dummy_react_qual  $controls_main , vce(robust)
local r6: display %5.3f `e(r2_a)'

qui sum dummy_react_qual if e(sample) 
local mean6: display %5.3f `r(mean)'
local obs6: display %5.0f `r(N)'
local sd6: display %5.3f `r(sd)'

eststo: reg dummy_react_timing_now  $controls_main , vce(robust)
local r7: display %5.3f `e(r2_a)'

qui sum dummy_react_timing_now if e(sample) 
local mean7: display %5.3f `r(mean)'
local obs7: display %5.0f `r(N)'
local sd7: display %5.3f `r(sd)'

eststo: reg dummy_react_timing_later  $controls_main , vce(robust)
local r8: display %5.3f `e(r2_a)'

qui sum dummy_react_timing_later if e(sample) 
local mean8: display %5.3f `r(mean)'
local obs8: display %5.0f `r(N)'
local sd8: display %5.3f `r(sd)'

eststo: reg inf_exp_react_now_decrease  $controls_main , vce(robust)
local r9: display %5.3f `e(r2_a)'

qui sum inf_exp_react_now_decrease if e(sample) 
local mean9: display %5.3f `r(mean)'
local obs9: display %5.0f `r(N)'
local sd9: display %5.3f `r(sd)'

eststo: reg inf_exp_react_now_increase  $controls_main , vce(robust)
local r10: display %5.3f `e(r2_a)'

qui sum inf_exp_react_now_increase if e(sample) 
local mean10: display %5.3f `r(mean)'
local obs10: display %5.0f `r(N)'
local sd10: display %5.3f `r(sd)'


eststo: reg inf_exp_react_later_decrease  $controls_main , vce(robust)
local r11: display %5.3f `e(r2_a)'

qui sum inf_exp_react_later_decrease if e(sample) 
local mean11: display %5.3f `r(mean)'
local obs11: display %5.0f `r(N)'
local sd11: display %5.3f `r(sd)'


eststo: reg inf_exp_react_later_increase  $controls_main , vce(robust)
local r12: display %5.3f `e(r2_a)'

qui sum inf_exp_react_later_increase if e(sample) 
local mean12: display %5.3f `r(mean)'
local obs12: display %5.0f `r(N)'
local sd12: display %5.3f `r(sd)'


esttab using $tables/panel.tex, replace fragment booktabs noconst nobase label cells(b(fmt(3) star) se(par fmt(3))) collabels(none) /// 
starlevels(* .1 ** .05 *** .01) se nonumbers nomtitles nolines nocon noobs compress

eststo clear

*** Means ***
file open holder using $tables/panel_means.tex, write replace text
file write holder "\hline " _n
file write holder "Observations & `obs1' & `obs2' & `obs3' & `obs4' & `obs5' & `obs6' & `obs7' & `obs8'  & `obs9' & `obs10' & `obs11' & `obs12'   \\" _n     
file write holder "Adj. R$^{2}$ & `r1' & `r2' & `r3' & `r4' & `r5' & `r6' & `r7' & `r8'  & `r9' & `r10' & `r11' & `r12'   \\" _n 
file write holder "Dependent variable mean & `mean1' & `mean2' & `mean3'  & `mean4'  & `mean5'  & `mean6' & `mean7' & `mean8' & `mean9' & `mean10' & `mean11' & `mean12'\\" _n   
file write holder "Dependent variable std. dev. & `sd1' & `sd2' & `sd3' & `sd4' & `sd5' & `sd6' & `sd7' & `sd8' & `sd9' & `sd10' & `sd11' & `sd12'  \\" _n
file close holder

appendfile $tables/panel.tex $table_name.tex
appendfile $tables/panel_means.tex $table_name.tex
appendfile $tables/temp_end.tex $table_name.tex

erase $tables/panel.tex
erase $tables/panel_means.tex
erase $tables/temp_end.tex 

eststo clear
	
}