clear all

/* Set root directory */
*global dir " " //set origin path
global code "$dir/replication_package/codes"
global survey_data "$dir/replication_package/data"
global output "$dir/replication_package/output"
global figures "$output/figures"
global tables "$output/tables"


*******SURVEY A*******

*import and clean data of survey A
do "$code/data_cleaning/creating_dataset_A"

*store the shares of the different demographics across respondents of survey A
{
	
	foreach var of varlist gender age_group income_group us_area race dummy_employment_agg2 education_agg emp_status marital_status dummy_children pol_aff vote_2020 vote_who political_agg  {

tab `var', matcell(cps_`var')

mata: st_matrix("cps_`var'", (st_matrix("cps_`var'")  :/ colsum(st_matrix("cps_`var'"))))


local r = rowsof(cps_`var')
forvalues x = 1(1)`r'{
    local rf_`var'`x'_temp= round(cps_`var'[`x',1],0.01)
	local rf_`var'`x': display %5.2f `rf_`var'`x'_temp'
	
}
}


qui:des
local sample_size_af=r(N)
}





*********************
**#****Survey B*******
*********************
*Import, merge the dataset of Survey B and encode the relevant variables

{
*import survey dataset B1 and B2, clean and save them
do "$code/data_cleaning/creating_dataset_B_2"
tempfile B2
save `B2'

do "$code/data_cleaning/creating_dataset_B_1"
append using `B2'

*here we keep only the relevant variables
keep screen age_group income_group gender us_area race ResponseId income_group pol_aff pers_imp_feelings age education_level emp_status marital_status us_area children vote_2020 vote_who
*Income group (coarser partition aggregating groups)
encode screen, gen(complete)

gen women=.
replace women=0 if complete==1
replace women=1 if gender==2

gen dummy_children=.
replace dummy_children=0 if (complete==1 & children==1)
replace dummy_children=1 if complete==1 & (children==2|children==3|children==4|children==5|children==6)

gen age_class_agg= 0 if !mi(age)
replace age_class_agg=1 if age >= 18 & age <= 29
replace age_class_agg=2 if age >= 30 & age <= 49
replace age_class_agg=3 if age >= 50 & age <= 69
label define age_class_agg 1 "18-29" 2 "30-49" 3 "50-69"
label val age_class_agg age_class_agg

tab(age_class_agg), gen(age_class_agg)

tab(us_area), gen(dummy_us_area)


gen 			race_group = "White" 	if complete==1
replace 		race_group = "Black" 	if(race==2 & complete==1)
replace 		race_group = "Hispanic" if(race==3 & complete==1)
replace 		race_group = "Other" 	if(race>3 & complete==1)
label define 	race_agg 0 "White" 1 "Black" 2 "Hispanic" 3 "Other"
encode 			race_group, gen(race_agg) label(race_agg)

tab race_agg, gen(dummy_race_agg)



gen 			incomegroup_agg =.
replace 		incomegroup_agg = 1 if income_group == 1 | income_group == 2
replace 		incomegroup_agg = 2 if income_group == 3 | income_group == 4 | income_group == 5 
replace 		incomegroup_agg = 3 if  income_group == 6
label define 	incomegroup_agg 1 "0k-39k" 2 "40k-124k" 3 "124k+"
label val 		incomegroup_agg incomegroup_agg

tab incomegroup_agg, gen(incomegroup_agg_)

gen political_agg = 1 if( pol_aff==2)
	replace political_agg = 2 if(pol_aff==1)
	replace political_agg = 3 if(pol_aff>2)
label define political_agg 1 "Democrat" 2 "Republican" 3 "Independent and others"
label val political_agg political_agg

tab political_agg, gen(political_agg)


gen 			college=.
replace 		college=0 if complete==1
replace 		college=1 if education_level>5 
label define 	college_degree 0 "No College" 1 "4-year College Degree"
label val 		college college_degree
label var 		college "College Degree"


**Education group (coarser partition aggregating groups)
gen 	education_agg=.
replace education_agg=1 if education_level==1 | education_level==2 
replace education_agg=2 if education_level==3 | education_level==4 | education_level==5
replace education_agg=3 if education_level==6 | education_level==7 
replace education_agg=4 if education_level==8 | education_level==9 
label define education_agg 1 "Less than HS" 2 "Less than 4-year college" 3 "4-year college/Master's" 4 "Professional degree"
label val education_agg education_agg

label variable education_agg "Education level (agg)"


gen employment_agg = 1 if complete==1
	replace employment_agg = 2 if(complete==1 & emp_status<4)
	replace employment_agg = 3 if(complete==1 & emp_status==4 |complete==1 & emp_status==6)
	replace employment_agg = 4 if(complete==1 & emp_status==7)
label define employment_agg 1 "Student" 2 "Working" 3 "Not working" 4 "Retiree"
label val employment_agg employment_agg

tab employment_agg, gen(dummy_emp_agg)


gen dummy_married = 0 if !missing(marital_status)
replace dummy_married=1 if marital_status==2



gen republican=.
replace republican=0 if complete==1
replace republican=1 if pol_aff==1

gen democrat=.
replace democrat=0 if complete==1
replace democrat=1 if pol_aff==2



label var age_class_agg1 "Age 18-29"
label var age_class_agg2 "Age 30-49"
label var age_class_agg3 "Age 50-69"
label var political_agg2 "Republican"
label var incomegroup_agg_1 "Low-income"
label var incomegroup_agg_2 "Middle-income"
label var incomegroup_agg_3 "High-income"
label var women "Female"
label var democrat "Democrat"
label var republican "Republican"
label var political_agg3 "Independent and Others"
label var dummy_race_agg1 "White"
label var dummy_race_agg2 "Black"
label var dummy_race_agg3 "Hispanic"
label var dummy_race_agg4 "Other"
label var dummy_emp_agg1 "Student"
label var dummy_emp_agg2 "Working"
label var dummy_emp_agg3 "Not working"
label var dummy_emp_agg4 "Retiree"
label var dummy_children "Has children"
label var dummy_us_area1 "Northeast"
label var dummy_us_area2 "South"
label var dummy_us_area3 "Midwest"
label var dummy_us_area4 "West"
label var college "4-year college"
label var dummy_married "Married"

tempfile survey
save `survey'

*progressively merge with survey data: why interesting inflation
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("inf_info_int_why") firstrow  clear
foreach var of varlist inf_info_int_why_*{
	replace `var'=0 if `var'==.
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m
tempfile survey
save `survey'

*progressively merge with survey data: what bad could happen if inflation too high?
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("inf_info_bad_what") firstrow  clear
foreach var of varlist inf_info_bad_what_*{
	replace `var'=0 if `var'==.
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m
tempfile survey
save `survey'

*progressively merge with survey data: what bad could happen if inflation too high?
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("inf_info_high_why") firstrow  clear
foreach var of varlist inf_info_high_why_*{
	replace `var'=0 if `var'==.
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m
tempfile survey
save `survey'

*progressively merge with survey data: positivie impact of inflation?
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("inf_info_positive") firstrow  clear
foreach var of varlist inf_info_positive_*{
	replace `var'=0 if `var'==.
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m
tempfile survey
save `survey'

*progressively merge with survey data: impact of inflation?
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("pers_imp_me") firstrow  clear
foreach var of varlist pers_imp_me_*{
	replace `var'=0 if `var'==.
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m
tempfile survey
save `survey'

*progressively merge with survey data: what caused changes in income
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("pers_imp_inc_change") firstrow  clear
foreach var of varlist pers_imp_inc_change_*{
	replace `var'=0 if `var'==.
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m
tempfile survey
save `survey'

*progressively merge with survey data: angry at who
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("pers_imp_angry_who") firstrow  clear
drop G H I
foreach var of varlist pers_imp_angry_who_*{
	replace `var' = 0 if `var' == .
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m
tempfile survey
save `survey'

*progressively merge with survey data: definition
import excel "$survey_data/BPEA_survey_B_classification.xlsx", sheet("inf_def_open_1") firstrow  clear
foreach var of varlist inf_def_open_1_*{
	replace `var'=0 if `var'==.
}
rename ResponseID ResponseId
duplicates drop ResponseId, force
merge 1:1 ResponseId using `survey'
drop _m

drop if ResponseId=="TOTAL"
drop if incomegroup_agg==.

*merge the emotion classification
merge 1:1 ResponseId using $survey_data/emotion_classification.dta
drop _m
levelsof emotion_inflation, local(emotions)

foreach name of local emotions {
        gen emotion_`name' = (emotion_inflation == "`name'") 
 
}

*Drop all the ResponseId which were not correctly merged. Now you have 504 observations
drop if substr(ResponseId, 1, 2) != "R_"
}



*store the shares of the different demographics across respondents of survey B
{
	
	foreach var of varlist gender age_group income_group us_area race dummy_emp_agg2 education_agg emp_status marital_status dummy_children pol_aff vote_2020 vote_who political_agg  {

tab `var', matcell(cps_`var')

mata: st_matrix("cps_`var'", (st_matrix("cps_`var'")  :/ colsum(st_matrix("cps_`var'"))))


local r_B = rowsof(cps_`var')
forvalues x = 1(1)`r_B'{
    local rf_`var'`x'_temp_B= round(cps_`var'[`x',1],0.01)
	local rf_`var'`x'_B: display %5.2f `rf_`var'`x'_temp_B'
	
}
}


qui:des
local sample_size_af_B=r(N)
}




**#TABLE1: SAMPLE REPRESENTATIVITY

*Sample representativity table: share of respondents who... vs US population share who...
{


file open holder using "$tables/TABLE_1.tex", write replace text
file write holder "\begin{tabular}{lcccc} " _n

file write holder "\toprule" _n
file write holder "\hline \noalign{\smallskip}  & Survey A & Survey B & US population   \\\hline" _n


file write holder "\noalign{\smallskip}\hline \noalign{\smallskip} \textbf{Targeted characteristics} & &    \\" _n
file write holder "Male  & `rf_gender1' & `rf_gender1_B' & 0.49 \\" _n
file write holder " Female   & `rf_gender2' & `rf_gender2_B' & 0.51  \\" _n
file write holder " & &   \\" _n
file write holder " 18-29 years old & `rf_age_group1' & `rf_age_group1_B' & 0.23 \\" _n
file write holder " 30-39 years old & `rf_age_group2' & `rf_age_group2_B' & 0.21 \\" _n
file write holder " 40-49 years old & `rf_age_group3' & `rf_age_group3_B' & 0.19 \\" _n
file write holder " 50-59 years old & `rf_age_group4' & `rf_age_group4_B' & 0.19 \\" _n
file write holder " 60-69 years old & `rf_age_group5' & `rf_age_group5_B' & 0.18 \\ " _n
file write holder " & &   \\" _n

file write holder " \\$0-\\$19,999   & `rf_income_group1' & `rf_income_group1_B' & 0.13  \\" _n
file write holder " \\$20,000-\\$39,999   & `rf_income_group2'  & `rf_income_group2_B' & 0.16  \\" _n
file write holder " \\$40,000-\\$69,999 & `rf_income_group3'  & `rf_income_group3_B' & 0.20 \\" _n
file write holder " \\$70,000-\\$99,999   & `rf_income_group4' & `rf_income_group4_B' & 0.15  \\" _n
file write holder " \\$100,000-\\$124,999    & `rf_income_group5' & `rf_income_group5_B' & 0.09  \\" _n
file write holder " \\$125,000+           & `rf_income_group6' & `rf_income_group6_B' & 0.26  \\" _n
file write holder " &  & & \\" _n

file write holder " White       			 &  `rf_race1' &  `rf_race1_B'  & 0.76   \\" _n
file write holder " African-American/Black     &  `rf_race2' &  `rf_race2_B'  & 0.13\\" _n
file write holder " Hispanic/Latino             &  `rf_race3' &  `rf_race3_B' & 0.19  \\" _n
file write holder " Asian/Asian-American        &  `rf_race4' &  `rf_race4_B' & 0.06  \\" _n
file write holder " &  & & \\" _n

file write holder " Northeast       & `rf_us_area1' & `rf_us_area1_B' & 0.18   \\" _n
file write holder " South        & `rf_us_area2'  & `rf_us_area2_B' & 0.37  \\" _n
file write holder " Midwest       & `rf_us_area3'  & `rf_us_area3_B' & 0.21  \\" _n
file write holder " West       & `rf_us_area4'  & `rf_us_area4_B' & 0.24  \\" _n


file write holder " & & &   \\" _n
file write holder " \textbf{Non-targeted characteristics} & &  \\" _n
file write holder " Married  & `rf_marital_status2' & `rf_marital_status2_B' & 0.52 \\" _n
file write holder " Single  & `rf_marital_status1' & `rf_marital_status1_B' & 0.35  \\" _n
file write holder " Separated/Divorced   & `rf_marital_status3' & `rf_marital_status3_B' & 0.12 \\" _n
file write holder " Widowed   & `rf_marital_status4' & `rf_marital_status4_B' & 0.02 \\" _n

file write holder " & & &     \\" _n
file write holder " Has children  & `rf_dummy_children2' & `rf_dummy_children2_B' & 0.40  \\" _n


file write holder " &  & &  \\" _n
file write holder " Less than High School  & `rf_education_agg1'  & `rf_education_agg1_B' & 0.09 \\" _n
file write holder " Less than 4-year college  & `rf_education_agg2' & `rf_education_agg2_B' & 0.55 \\" _n
file write holder " 4-year college/Master's   & `rf_education_agg3' & `rf_education_agg3_B' & 0.32 \\" _n
file write holder " Professional degree  & `rf_education_agg4' & `rf_education_agg4_B' & 0.03 \\" _n

file write holder " &   & &  \\" _n
file write holder " Employed  &  `rf_dummy_employment_agg22' & `rf_dummy_emp_agg22_B' & 0.70  \\" _n
file write holder " Unemployed   &  `rf_emp_status4' & `rf_emp_status4_B' & 0.03  \\" _n

file write holder " &  & &   \\" _n
file write holder " Republican	  &  `rf_political_agg2' & `rf_political_agg2_B'  & 0.26   \\" _n
file write holder " Democrat    &  `rf_political_agg1' &  `rf_political_agg1_B'   & 0.25  \\" _n
file write holder " Independent \& others    &  `rf_political_agg3' & `rf_political_agg3_B' & 0.47     \\" _n

file write holder " &  & &    \\" _n
file write holder "Voted in 2020 presidential election &  `rf_vote_20201' & `rf_vote_20201_B' & 0.61     \\" _n

file write holder " & & &    \\" _n
file write holder "Voted for Biden in 2020 presidential election &  `rf_vote_who1' & `rf_vote_who1_B'  & 0.51   \\" _n
file write holder "Voted for Trump in 2020 presidential election &  `rf_vote_who2' &  `rf_vote_who2_B'  &  0.47  \\" _n

file write holder " &  & &   \\" _n
file write holder " Sample size  & `sample_size_af' &`sample_size_af_B' \\" _n



file write holder "\bottomrule \end{tabular}" _n
file close holder
}


