clear all

/* Set root directory */
*global dir " " //set origin path
global code "$dir/replication_package/codes"
global survey_data "$dir/replication_package/data"
global output "$dir/replication_package/output"
global figures "$output/figures"
global tables "$output/tables"


*import and clean data
do "$code/data_cleaning/creating_dataset_A"

grstyle init
grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"

*generate variables used in the analysis
gen rep=0 if !missing( political_agg)
replace rep=1 if political_agg==2
label var rep "Republican"

gen ind=0 if !missing( political_agg)
replace ind=1 if political_agg==3
label var ind "Independent"


tab inf_wage_theories, gen(inf_wage_theories_)





**#FIGURE15: INFLATION IMPACTS AS A WORKER
***split respondents by income and represent the answers to the inflation impacts as a consumer questions for "low income", "high income" and "full sample"

*generate indicators for answers to question "Imagine that next year the inflation rate unexpectedly doubles. How long would it probably take before your income has increased enough so that you can afford the same things as you do today? In other words, how long will it be before a full inflation correction in your income has taken place?" 
gen less_than_seven = 0 if pers_imp_work_2_me_en!=. & pers_imp_work_2_me_en!=6
replace less_than_seven = 1 if pers_imp_work_2_me_en<3

gen btw_seven_and_one = 0 if pers_imp_work_2_me_en!=.& pers_imp_work_2_me_en!=6
replace btw_seven_and_one = 1 if pers_imp_work_2_me_en==3

gen more_than_one = 0 if pers_imp_work_2_me_en!=.& pers_imp_work_2_me_en!=6
replace more_than_one = 1 if pers_imp_work_2_me_en>3 & pers_imp_work_2_me_en!=. & pers_imp_work_2_me_en!=6

*generate indicator equal to 1 if answer is "my income would be higher" to the question "Try to imagine how things would be different if we had not experienced the inflation we did over the last two years, so that prices of things you buy had not risen to the levels that we actually see today. How different do you think your income (the total dollars you earn in a month) would be now, in comparison with your actual income now, if we had had no inflation?"
gen income_would_be_higher = 0 if pers_imp_work_hyp_sh_en!=.&pers_imp_work_hyp_sh_en!=4
replace income_would_be_higher = 1 if pers_imp_work_hyp_sh_en==3

*generate indicator equal to 1 if answered concerned to question "Considering the impact of inflation, how concerned are you about your future earnings and employment status?""
gen dummy_concern = 0 if concern_future_work_en!=.
replace dummy_concern = 1 if concern_future_work_en>3 & concern_future_work_en!=.

{


preserve
global wage_impacts dummy_wage_rel dummy_wage_high_rel dummy_wage_prices 

global work_impacts  dummy_work_satisf   income_would_be_higher dummy_concern

global hyp more_than_one btw_seven_and_one less_than_seven  


global j=1

foreach var_selec of varlist $wage_impacts{
	sum `var_selec' if incomegroup_agg==1
	scalar    low_wage_impact_${j}=r(mean)*100 
	scalar se_low_wage_impact_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
	sum `var_selec' 
	scalar    full_wage_impact_${j}=r(mean)*100 
	scalar se_full_wage_impact_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
	sum `var_selec' if incomegroup_agg==3
	scalar    high_wage_impact_${j}=r(mean)*100 
	scalar se_high_wage_impact_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +2
}

global j = $j + 3

foreach var_selec of varlist $work_impacts{
	sum `var_selec' if incomegroup_agg==1
	scalar    low_work_impact_${j}=r(mean)*100 
	scalar se_low_work_impact_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
sum `var_selec' 
	scalar    full_work_impact_${j}=r(mean)*100 
	scalar se_full_work_impact_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
	sum `var_selec' if incomegroup_agg==3
	scalar    high_work_impact_${j}=r(mean)*100 
	scalar se_high_work_impact_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +2
}

global j = $j + 3

foreach var_selec of varlist $hyp{
	sum `var_selec' if incomegroup_agg==1
	scalar    low_hyp_${j}=r(mean)*100 
	scalar se_low_hyp_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
	sum `var_selec' 
	scalar    full_hyp_${j}=r(mean)*100 
	scalar se_full_hyp_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +1
	sum `var_selec' if incomegroup_agg==3
	scalar    high_hyp_${j}=r(mean)*100 
	scalar se_high_hyp_${j}=(r(sd)/sqrt(r(N)))*100
global j=$j +2
}



clear
set obs 41
egen n = seq()

foreach var in low_wage_impact full_wage_impact high_wage_impact low_work_impact full_work_impact high_work_impact low_hyp full_hyp high_hyp{
gen `var' = . 
gen min_`var' = .
gen max_`var' = . 
}

foreach x in 1 5 9 {
replace low_wage_impact = low_wage_impact_`x' if n == `x'
replace min_low_wage_impact = low_wage_impact_`x'  - 1.645 * se_low_wage_impact_`x'  if n == `x'
replace max_low_wage_impact = low_wage_impact_`x'  + 1.645 * se_low_wage_impact_`x'  if n == `x'
scalar up_`x'=low_wage_impact_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}

foreach x in 2 6 10 {
replace full_wage_impact = full_wage_impact_`x' if n == `x'
replace min_full_wage_impact = full_wage_impact_`x'  - 1.645 * se_full_wage_impact_`x'  if n == `x'
replace max_full_wage_impact = full_wage_impact_`x'  + 1.645 * se_full_wage_impact_`x'  if n == `x'
scalar up_`x'=full_wage_impact_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}

foreach x in 3 7 11 {
replace high_wage_impact = high_wage_impact_`x' if n == `x'
replace min_high_wage_impact = high_wage_impact_`x'  - 1.645 * se_high_wage_impact_`x'  if n == `x'
replace max_high_wage_impact = high_wage_impact_`x'  + 1.645 * se_high_wage_impact_`x'  if n == `x'
scalar up_`x'=high_wage_impact_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}

foreach x in 16 20 24{
replace low_work_impact = low_work_impact_`x' if n == `x'
replace min_low_work_impact = low_work_impact_`x'  - 1.645 * se_low_work_impact_`x'  if n == `x'
replace max_low_work_impact = low_work_impact_`x'  + 1.645 * se_low_work_impact_`x'  if n == `x'
scalar up_`x'=low_work_impact_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}

foreach x in 17 21 25{
replace full_work_impact = full_work_impact_`x' if n == `x'
replace min_full_work_impact = full_work_impact_`x'  - 1.645 * se_full_work_impact_`x'  if n == `x'
replace max_full_work_impact = full_work_impact_`x'  + 1.645 * se_full_work_impact_`x'  if n == `x'
scalar up_`x'=full_work_impact_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}

foreach x in 18 22 26{
replace high_work_impact = high_work_impact_`x' if n == `x'
replace min_high_work_impact = high_work_impact_`x'  - 1.645 * se_high_work_impact_`x'  if n == `x'
replace max_high_work_impact = high_work_impact_`x'  + 1.645 * se_high_work_impact_`x'  if n == `x'
scalar up_`x'=high_work_impact_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}

foreach x in 31 35 39{
replace low_hyp = low_hyp_`x' if n == `x'
replace min_low_hyp = low_hyp_`x'  - 1.645 * se_low_hyp_`x'  if n == `x'
replace max_low_hyp = low_hyp_`x'  + 1.645 * se_low_hyp_`x'  if n == `x'
scalar up_`x'=low_hyp_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}

foreach x in 32 36 40{
replace full_hyp = full_hyp_`x' if n == `x'
replace min_full_hyp = full_hyp_`x'  - 1.645 * se_full_hyp_`x'  if n == `x'
replace max_full_hyp = full_hyp_`x'  + 1.645 * se_full_hyp_`x'  if n == `x'
scalar up_`x'=full_hyp_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}

foreach x in 33 37 41 {
replace high_hyp = high_hyp_`x' if n == `x'
replace min_high_hyp = high_hyp_`x'  - 1.645 * se_high_hyp_`x'  if n == `x'
replace max_high_hyp = high_hyp_`x'  + 1.645 * se_high_hyp_`x'  if n == `x'
scalar up_`x'=high_hyp_`x'
	scalar num_`x'= round(up_`x', 1)
	scalar pos1_`x'=up_`x'-15
	scalar pos2_`x'=up_`x'+25
	scalar pos3_`x'=up_`x'+11
}


grstyle set plain
set scheme modern
graph set window fontface "LMRoman10-Regular"
graph twoway (bar low_wage_impact n, horizontal color(orange) barwidth(1)) (rcap min_low_wage_impact max_low_wage_impact n, horizontal color(orange)) (bar full_wage_impact n, horizontal color(gray) barwidth(1)) (rcap min_full_wage_impact max_full_wage_impact n, horizontal color(gray)) (bar high_wage_impact n, horizontal color("17 119 51") barwidth(1)) (rcap min_high_wage_impact max_high_wage_impact n, horizontal color("17 119 51")) (bar low_work_impact n, horizontal color(orange) barwidth(1)) (rcap min_low_work_impact max_low_work_impact n, horizontal color(orange)) (bar full_work_impact n, horizontal color(gray) barwidth(1)) (rcap min_full_work_impact max_full_work_impact n, horizontal color(gray)) (bar high_work_impact n, horizontal color("17 119 51") barwidth(1)) (rcap min_high_work_impact max_high_work_impact n, horizontal color("17 119 51")) (bar low_hyp n, horizontal color(orange) barwidth(1)) (rcap min_low_hyp max_low_hyp n, horizontal color(orange)) (bar full_hyp n, horizontal color(gray) barwidth(1)) (rcap min_full_hyp max_full_hyp n, horizontal color(gray)) (bar high_hyp n, horizontal color("17 119 51") barwidth(1)) (rcap min_high_hyp max_high_hyp n, horizontal color("17 119 51")), ///
			 legend(order(1 3 5) lab(1 "{bf:Income <$40k}") lab(3 "{bf:Full sample}") lab(5 "{bf:Income >$125k}")  size(large) position(6) cols(3) region(lcolor(black%50) lwidth(thin)) just(center) symysize(4) symxsize(4)  symplacement(south) ) xlabel(0(10)100, nogrid noticks labsize(large)) ylabel(2 `" "Wages of other people are rising more quickly than mine" "' 6 `" "Wages of higher income people are rising more quickly than mine" "' 10 `" "Prices increase faster than wages" "' 13.5 `" "{bf:Rate of wage increases}" "' 17 `" "If my wage increased but prices increased just as much," " my job satisfaction would be lower" "' 25 `" "Very concerned about future employment and earnings" "' 21 `" "If inflation had been lower, my income would be higher" "' 28.5 `" "{bf:Work impacts of inflation}" "' 32 `" "More than 1 year" "' 36 `" "Between 7 months and 1 year" "' 40 `" "Less than 7 months" "' 43.5`" "{bf:If inflation doubled, how long until your wage doubles?}"  "', labsize(large) noticks nogrid) xtitle(`"Share of respondents"', size(large)) ytitle("") ///
			text(1.2 `=pos3_1' "{bf:`=num_1'%}", size(medsmall) just(center) color(black%90)) ///
			text(2.2 `=pos3_2' "{bf:`=num_2'%}", size(medsmall) just(center) color(black%90)) ///
			text(3.2 `=pos3_3' "{bf:`=num_3'%}", size(medsmall) just(center) color(black%90)) ///
			text(5.2 `=pos3_5' "{bf:`=num_5'%}", size(medsmall) just(center) color(black%90)) ///
			text(6.2 `=pos3_6' "{bf:`=num_6'%}", size(medsmall) just(center) color(black%90)) ///
			text(7.2 `=pos3_7' "{bf:`=num_7'%}", size(medsmall) just(center) color(black%90)) ///
			text(9.2 `=pos3_9' "{bf:`=num_9'%}", size(medsmall) just(center) color(black%90)) ///
			text(10.2 `=pos3_10' "{bf:`=num_10'%}", size(medsmall) just(center) color(black%90)) ///
			text(11.2 `=pos3_11' "{bf:`=num_11'%}", size(medsmall) just(center) color(black%90)) ///
			text(16.2 `=pos3_16' "{bf:`=num_16'%}", size(medsmall) just(center) color(black%90)) ///
			text(17.2 `=pos3_17' "{bf:`=num_17'%}", size(medsmall) just(center) color(black%90)) ///
			text(18.2 `=pos3_18' "{bf:`=num_18'%}", size(medsmall) just(center) color(black%90)) ///
			text(20.2 `=pos3_20' "{bf:`=num_20'%}", size(medsmall) just(center) color(black%90)) ///
			text(21.2 `=pos3_21' "{bf:`=num_21'%}", size(medsmall) just(center) color(black%90)) ///
			text(22.2 `=pos3_22' "{bf:`=num_22'%}", size(medsmall) just(center) color(black%90)) ///
			text(24.2 `=pos3_24' "{bf:`=num_24'%}", size(medsmall) just(center) color(black%90)) ///
			text(25.2 `=pos3_25' "{bf:`=num_25'%}", size(medsmall) just(center) color(black%90)) ///
			text(26.2 `=pos3_26' "{bf:`=num_26'%}", size(medsmall) just(center) color(black%90)) ///
			text(31.2 `=pos3_31' "{bf:`=num_31'%}", size(medsmall) just(center) color(black%90)) ///
			text(32.2 `=pos3_32' "{bf:`=num_32'%}", size(medsmall) just(center) color(black%90)) ///
			text(33.2 `=pos3_33' "{bf:`=num_33'%}", size(medsmall) just(center) color(black%90)) ///
			text(35.2 `=pos3_35' "{bf:`=num_35'%}", size(medsmall) just(center) color(black%90)) ///
			text(36.2 `=pos3_36' "{bf:`=num_36'%}", size(medsmall) just(center) color(black%90)) ///
			text(37.2 `=pos3_37' "{bf:`=num_37'%}", size(medsmall) just(center) color(black%90)) ///
			text(39.2 `=pos3_39' "{bf:`=num_39'%}", size(medsmall) just(center) color(black%90)) ///
			text(40.2 `=pos3_40' "{bf:`=num_40'%}", size(medsmall) just(center) color(black%90)) ///
			text(41.2 `=pos3_41' "{bf:`=num_41'%}", size(medsmall) just(center) color(black%90)) ///
			xsize(10) ysize(5) 
			
			resize, xsize(29cm) ysize(20cm)



graph save "$figures/FIG_15.gpf", replace
graph export "$figures/FIG_15.png", as(png) width(5000) height(3448) replace

restore
}
