# Replication Code Documentation

## Code

Running below code in a terminal will generate all the figures and tables under the folder `results/`. Replace `python` with the virtual environment path if necessary.

```
python code/main.py
```

`main.py` depends on three modules `parse_data.py`, `analytics.py` and `plottings.py`


### Core functions

#### prase_data

- `get_vdem_data`: Returns polarization and violence data from raw V-Dem dataset.
- `get_imf_data`: Returns debt and fiscal surplus data. This parses IMF Government Gross Debt data and Primary balance data, filling the missing values with the World Development Indicator dataset from the World Bank.
- `get_frule_data`: Returns fiscal rule indicators (budget balance rule and debt rule).

#### analytics

- `calc_table1_stats`: Return 5-year debt reduction and political variable pairs or fiscal surplus and political variable pairs for two periods: 1980-2000 and 2000-2022. The plot for the 2000-2022 period, using the default country list, aligns with the years and country pairs from Table 1 of Arslanalp, Eichengreen, and Henry (2024). The datapoints plotted for the 1980-2000 period correspond to the starting year of the maximum debt reduction each country experienced during 1980-2000.
  - Parameters:
    - lst (list): list of countries, default by the list of countries is in Table 1 of Arslanalp, Eichengreen, and Henry (2024)
    - fiscal_surp (bool, default false): indicator whether to use Fiscal Surplus, instead of Debt Reduction
    - delta (bool, default false): indicator whether to use the 5-year change of the political indicators.
- `calc_all_sample_stats`: Calculates variables over the full country sample. The full country sample covers all countries that are common in both IMF data (imputed with World Bank data) and V-Dem.

#### plottings

- `plot_scatter_max_debt_reduction`: Returns scatter plot of maximum debt reduction or fiscal surplus, against polarization variable, with fiscal rules as a marker. Figure 1 and 2.
- `plot_scatter_all_sample`: Returns scatter plot using all the countries in the sample. Figure 3.
  - 5-year debt change versus 5-year polarization change.
  - Fiscal surplus against polarization level. 
- `plot_time_series_variables`: Returns time-series plot of Debt, polarization and violence for a given country code (3-digit code).


## Data Reference

### IMF data
- Government Debt: [Central Government Gross Debt](https://www.imf.org/external/datamapper/GGXWDG_NGDP@WEO/OEMDC/ADVEC/WEOWORLD)
- Fiscal Surplus: [Government Primary Balance](https://www.imf.org/external/datamapper/pb@FPP/USA)
- Fiscal Rule: [Fiscal rule](https://www.imf.org/external/datamapper/fiscalrules/matrix/matrix.htm)

### World Bank
- Government Debt and Fiscal Surplus: [World Development Indicator](https://datatopics.worldbank.org/world-development-indicators/)

### V-Dem
- Polarization and Violence: [Country-Year: V-Dem Full+Others version 14](https://v-dem.net/data/the-v-dem-dataset/country-year-v-dem-fullothers-v14/)

