import warnings
warnings.filterwarnings('ignore')

import pandas as pd
from config import *
import matplotlib.pyplot as plt
from analytics import calc_all_sample_stats
from plottings import plot_scatter_max_debt_reduction, plot_scatter_all_sample, plot_time_series_variables


if __name__ == '__main__':
    
    for x in ['polar', 'vio']:
        for y in ['debt_red', 'fiscal_surp']:
            fig, _ = plot_scatter_max_debt_reduction('em_table1', x=x, y=y, mker=True, title = False)
            fig.savefig(FIG_DIR / f"table1_scatter_{y}-{x}.png", bbox_inches='tight', dpi=300)
            plt.close()
    print('Figure 1 and 2 generated')
    
    fig, _ = plot_scatter_all_sample()
    fig.savefig(FIG_DIR / f"allsample_scatter_polar.png", bbox_inches='tight', dpi=300)
    plt.close()
    print("Figure 3, Full Sample Scatter Plot, generated")
    
    fig, _ = plot_time_series_variables('USA')
    fig.savefig(FIG_DIR / "time_series_USA.png", bbox_inches='tight', dpi=300)
    plt.close()
    print("Figure 4, Polarization in the US and Debt, generated")
    
    df = calc_all_sample_stats()
    codes = df.dropna().index.levels[1].to_numpy().copy()
    codes.resize((len(codes)//10 + 1, 10))
    countries = pd.DataFrame(codes).replace(0, '')
    countries.to_csv(TAB_DIR/ "all_sample_countries.csv", index=False, header=False)
    print("Table 1, Full Sample Countries list generated")
    
    