// =============================================================================
//
// Debt Decomposition
//
// =============================================================================

graph close _all
use "$cleaned/working.dta", clear

* inflation in the US 
gen tmp = inf_gdp_def if country=="USA"
egen inf_gdp_def_USA = mean(tmp), by(year)
drop tmp

keep if country=="JAM"

* nominal exchange rate depreciation
gen er_dep = er_official/L.er_official - 1
gen er_dep_weo = er_weo/L.er_weo - 1
drop er_dep_weo							

* real exchange rate depreciation
gen er_dep_real = (1+er_dep)*(1+inf_gdp_def_USA/100)/(1+inf_gdp_def/100)  - 1 
	* AEH formula => these two are equivalent!
gen z= (er_official/L.er_official)*(1+inf_gdp_def_USA/100)/(1+inf_gdp_def/100)-1

* All variables are in %/100 (multiply by 100 below) -- except r_real, real_gdp_gr, LCshare (need to divide by 100)
* change in public debt
gen    b = ggxwdg_gdp // cg // cg=central govt debt;  ggxwdg_gdp = general government gross debt
// left hand side variable: change of public debt
gen D1_b = b - L.b 
// primary deficit
gen d    = - ggxonlb_gdp
// r/(1+g) b(t-1)
gen r_term = ((r_real/100)/(1+(real_gdp_gr/100))) * L.b
// -g/(1+g) b(t-1)
gen g_term = -((real_gdp_gr/100)/(1+(real_gdp_gr/100))) * L.b
gen r_minus_g_term = r_term + g_term 
gen resid  = D1_b - d - r_term - g_term


// share of FC denominated debt
gen a = (1-LCshare/100)
// z * a /((1+g)(1+p_star)) * b(t-1)
gen za_term = ( z * a / ( (1+(real_gdp_gr/100))*(1+(inf_gdp_def_USA/100)))) * L.ggxwdg_gdp
// (p - p_star)/((1+g)(1+p)*(1+p_star)) * b(t-1)
gen inf_term = ( (inf_gdp_def/100 - inf_gdp_def_USA/100)*a / ( (1+(real_gdp_gr/100)) * ( 1+ (inf_gdp_def/100)) * ( 1+ (inf_gdp_def_USA/100) )) ) *  L.ggxwdg_gdp

gen resid2 = D1_b - d - r_term - g_term - za_term - inf_term

* exchange rate contribution (RER + inflation terms)
gen er_term = za_term + inf_term

* Multiply values for figure by 100
foreach x of varlist d r_term g_term za_term inf_term resid resid2{
	replace  `x'=`x'*100
}


/*-------------------------------------------
	Figure for Decomposition
---------------------------------------------*/
* Debt decomposition: bar by year
local y0 =2006
graph bar  d r_term g_term za_term inf_term resid2 if inrange(year,`y0',2019), ///
over(year, lab(angle(45))) stack ylabel(-20(10)30) ///
legend(order( 1 "Primary deficit" 2 "Real interest rate" 3 "Real GDP growth" ///
			  4 "Real exchange rate" 5 "Relative inflation" 6 "Residual") cols(2) size(medium) ) ///
ytitle("Contribution to {&Delta} b in % of GDP") ///
bar(1, color(blue)) ///
bar(2, color(gold)) ///
bar(3, color(red)) ///
bar(4, color(dkgreen)) ///
bar(5, color(pink)) ///
bar(6, color(gs8)) 
graph export "$pres/Fig_debt_decomposition_by_year.pdf", as(pdf) replace

