// =============================================================================
//
// Jamaica Time Series
//
// =============================================================================

graph close _all
use "$cleaned/working.dta", clear

* inflation in the US 
gen tmp = inf_gdp_def if country=="USA"
egen inf_gdp_def_USA = mean(tmp), by(year)
drop tmp

* nominal exchange rate depreciation
gen er_dep = er_official/L.er_official - 1
gen er_dep_weo = er_weo/L.er_weo - 1
drop er_dep_weo							

* real exchange rate depreciation
gen er_dep_real = (1+er_dep)*(1+inf_gdp_def_USA/100)/(1+inf_gdp_def/100)  - 1 
	* AEH formula => these two are equivalent!
gen z= (er_official/L.er_official)*(1+inf_gdp_def_USA/100)/(1+inf_gdp_def/100)-1


*** Replication of Figure 1 in AEH

keep if country=="JAM"

* government debt
twoway  (line debt_gdp year if inrange(year,2000,2022), yscale(range(0 160)) ylabel(0(20)160) xlabel(2000(2)2022) xtitle("")  ///
              ytitle("Government debt-to-GDP (in %)")) ///
		(line /*ggxcnl_gdp*/ /*surplus_gdp*/ prim_surplus_gdp year if inrange(year,2000,2022), lcolor(%0 %0) ///
				yaxis(2) xlabel(2000(2)2022) ylabel(0(2)12, axis(2))  ///
				ytitle("Surplus-to-GDP (in %)", axis(2)) ///
				legend(order( 1 "Government debt/GDP (left axis)" 2 /*"Total surplus/GDP (right axis)" 3*/ "Primary surplus/GDP (right axis)")))
graph export "$pres/Fig_debt_surplus1.pdf", as(pdf) replace

* primary surplus and government debt
twoway  (line debt_gdp year if inrange(year,2000,2022), yscale(range(0 160)) ylabel(0(20)160) xlabel(2000(2)2022) xtitle("")  ///
              ytitle("Government debt-to-GDP (in %)")) ///
		(line /*ggxcnl_gdp surplus_gdp*/ prim_surplus_gdp year if inrange(year,2000,2022), lcolor(navy%100)  ///
				yaxis(2) xlabel(2000(2)2022) ylabel(0(2)12, axis(2))  ///
				ytitle("Surplus-to-GDP (in %)", axis(2)) ///
				legend(order( 1 "Government debt/GDP (left axis)" 2 /*"Total surplus/GDP (right axis)" 3*/ "Primary surplus/GDP (right axis)")))
graph export "$pres/Fig_debt_surplus2.pdf", as(pdf) replace



