// =============================================================================
//
//	Merge data together
//
// =============================================================================

use "$cleaned/weo", clear


*** world bank gdppc to extend series

merge 1:1 country year using "$cleaned/wb", nogen keep(1 3)

ren cpi_wb cpi_wdi

*** Jamaica LC debt share
merge 1:1 country year using "$cleaned/LCdebt_share_JAM.dta",  keep(1 3) nogen

*** trebesch dataset

* country in trebesch dataset
preserve
	use "$cleaned/trebesch_all.dta", clear
	keep country 
	duplicates drop country, force
	gen trebesch_flag=1
	tempfile trebesch_flag
	save `trebesch_flag'
restore 

* convert the data into annual frequency
preserve
	use "$cleaned/trebesch_all.dta", clear
	ren start_restru_year year
	collapse (max) debt_restru pref_haircut mkt_haircut face_val_reduc* *_preempt post_default *_year, ///
		by(country year)
	tempfile trebesch_cases
	save `trebesch_cases'
restore 

merge m:1 country using `trebesch_flag'

drop if _merge==2
ren _merge trebesch_smp
replace trebesch_smp = (trebesch_smp==3)
// trebesch gather data from 1970 to 2013
replace trebesch_smp = 0 if ~inrange(year, 1970, 2013)
label values trebesch_smp .

merge 1:1 country year using `trebesch_cases', keep(1 3) 
replace _merge = (_merge==3) 
replace _merge = . if trebesch_smp==0
ren _merge debt_restru_year														
label values debt_restru_year .


// =============================================================================
//
//	Create Key Variables
//
// =============================================================================

cap drop country_num
egen country_num = group(country) 
xtset country_num year

*** inflation
gen inf_gdp_def_wdi = 100*(gdp_def_linked/L.gdp_def_linked - 1)
gen inf_gdp_def 	= 100*(gdp_def_weo/L.gdp_def_weo - 1)
gen inf_cpi_wdi     = 100*(cpi_wdi/L.cpi_wdi - 1)


*** net export
gen net_ex_gdp = ex_gdp-im_gdp

*** real gdp growth
gen real_gdp_gr = 100*(gdp_const_lcu/L.gdp_const_lcu - 1)

*** interest payments, effective nominal and real r 

gen interest_payments_gdp = ggxonlb_gdp - ggxcnl_gdp  // primary net lending/borrowing - net lending/borrowing (see def of WEO)
gen r_nom =  100*interest_payments_gdp / ggxwdg_gdp	// nominal interest payments to GDP / debt to GDP => effective interest rate
gen r_real = 100*((1+r_nom/100)/(1+inf_gdp_def/100) - 1)

gen r_minus_g = r_real - real_gdp_gr
winsor2 r_minus_g, cuts(1 99) replace

*** government debt related variables

gen debt_gdp = ggxwdg_gdp*100
gen surplus_gdp = ggxcnl_gdp*100
gen prim_surplus_gdp = ggxonlb_gdp*100
gen exp_gdp =ggx_gdp*100
gen rev_gdp =ggr_gdp*100
gen non_interest_exp_gdp = exp_gdp - 100*interest_payments_gdp
gen diff_gdp = rev_gdp - exp_gdp

*** exchange rate
gen er_weo = nominal_gdp_lcu/nominal_gdp_usd 


*** identify large public debt reduction staring year

gen Fd5_ggxwdg_gdp = F5.ggxwdg_gdp - ggxwdg_gdp
winsor2 Fd5_ggxwdg_gdp, replace cuts(1 99)

preserve

	keep if Fd5_ggxwdg_gdp< -.2
	keep country country_num year Fd5_ggxwdg_gdp
	keep if year<=2022 - 5 // since some of the public debt are forecast data

	*** identify the public debt reduction starting year
	
	* group the consecutive years meeting criterion as an episode
	sort country year
	by country: gen fake_time = _n //
	xtset country_num fake_time

	gen break_year = year - l.year
	replace break_year = 0 if break_year==. // fill the country with only one year data available
	
	* find the gap between episodes
	* if the gap is small, identify as the same episode
	replace break_year = (break_year>3) 
	bysort country (year): gen n_episode=sum(break_year)+1 // episode index for each country
	
	* the start year of the episode as debt reduction year
	bysort country n_episode: egen base_year = min(year)
	gen debt_reduct = (year==base_year)
	
	keep if debt_reduct
	keep country year
	tempfile public_debt_reduction_timing
	save `public_debt_reduction_timing'

restore


merge 1:1 country year using `public_debt_reduction_timing'
* mark the large debt reduction year with 1
gen large_debt_red = (_merge==3) if Fd5_ggxwdg_gdp!=. 
label var large_debt_red "Large Sustained Government Debt Reductions"
drop _merge


*** debt restructure within plus/minus 7 years

xtset country_num year

gen restru_flag = 1 if debt_restru_year==1 ///
| L.debt_restru_year==1 | L2.debt_restru_year==1 | L3.debt_restru_year==1 | L4.debt_restru_year==1 | L5.debt_restru_year==1 | L6.debt_restru_year==1 | L7.debt_restru_year==1 ///
| F.debt_restru_year==1 | F2.debt_restru_year==1 | F3.debt_restru_year==1 | F4.debt_restru_year==1 | F5.debt_restru_year==1 | F6.debt_restru_year==1 | F7.debt_restru_year==1



*** drop a few cases countries
drop if country=="AFG" // war related

*** save
save "$cleaned/working.dta", replace
