clear
set more off
cap log close

ssc install labutil, replace

/*******************************************************************************

	Set Your Directories Here
	
*******************************************************************************/


glo dropbox 	"/Users/everner-mbp-22/Dropbox (Personal)/Research"
//glo dropbox 	"/Users/paulwdai/Dropbox (Personal)"
glo dir 		"$dropbox/Completed/BPEA_Jamaica_Discussion_Replication_Files"
glo work 		"$dropbox/Shared-Paul-Emil/Completed/BPEA_Jamaica_Discussion_Replication_Files"
glo input		"$work/input"
glo output		"$work/output"
glob pres       "$output"
glo cleaned		"$work/cleaned"
glo code 		"$work/code"


/*******************************************************************************

	Plot Setting
	
*******************************************************************************/

cd "$code"
set scheme cleanplots_ev2, perm


glo cnavy  `""4 82 117""' // some navy blue
glo cpink  `""220 57 119""' // some pink
glo cgreen  `""8 144 153""' // some green blue
glo cgrass  `""124 203 162""' // some grassgreen
glo corang  `""240 116 110""' // some orange
glo cpurpl  `""124 29 111""'  // some purple

glo c1  "$cnavy"
glo c2  "$cpink"
glo c3  "$cgreen"
glo c4  "$cgrass"
glo c5  "$corang"
glo c6  "$cpurpl"

glo m1  "mc($c1) m(S)"
glo m2  "mc($c2) m(T)"
glo m3  "mc($c3) m(O)"
glo m4  "mc($c4) m(D)"
glo m5  "mc($c5) m(Sh)"
glo m6  "mc($c6) m(Th)"
glo mJ  "mlcolor(gold) mfcolor(gold) m(Th)"


glo l1  "lcolor($c1) lwidth(thick)"
glo l2  "lcolor($c2) lwidth(thick)"
glo l3  "lcolor($c3) lwidth(thick)"
glo l4  "lcolor($c4) lwidth(thick)"
glo l5  "lcolor($c5) lwidth(thick)"
glo l6  "lcolor($c6) lwidth(thick)"
glo lJ  "lcolor(green) lwidth(thick)"

glo legend_setup "rows(1) region(lstyle(none)) size(*1.2) fcolor(white%0) "

glo fig_size "xsize(8) ysize(6)"



/*******************************************************************************

	Run Do Files
	
*******************************************************************************/


do "$code/01_Load_Data.do"
do "$code/02_Assemble_Data.do"
do "$code/03_Figure1.do"
do "$code/04_Figure2.do"
do "$code/05_Figure3_Figure4.do"
