***This program merges the master data with the daily brazil debt forecast data
import excel "raw/PublicDebtFocus.xlsx", describe
local _range = r(range_1)

local _range = subinstr("`_range'", "1", "2", 1)

*Importing Focus Projections for Public Debt
import excel "raw/PublicDebtFocus.xlsx", sheet("Dívida bruta do governo geral") cellrange(`_range') firstrow clear

foreach var of varlist _all {
	
	if "Data" != "`var'" {
		local _label: var label `var'
		rename `var' debt_`_label'
	}
}

rename Data mdy

gen month = month(mdy)
gen year = year(mdy)

reshape long debt_, i(mdy) j(forecast_yr)

gen horizon = forecast_yr- year(mdy)

preserve
drop if debt_ == .
rename debt_ mean_debt_
drop if horizon == -1
keep mdy mean_debt_ horizon
reshape wide mean_debt_, i(mdy) j(horizon)
save data/brazil_debt_projs_corr_mean.dta, replace
restore

use data/inflation_master.dta, clear
merge 1:1 mdy using data/brazil_debt_projs_corr_mean.dta, nogen
