import excel "raw/MarketParticipantsSurvey_BoE_CPI.xlsx", sheet("Medians") cellrange(A3:K4) firstrow clear

keep if A == "Five years ahead"

rename A _var

foreach var of varlist _all {
    if "`var'" != "_var" {
	    local _label: var label `var'
		di "`_label'"
		local _label = subinstr("`_label'", "-", "_", .)
		rename `var' value_`_label'
	}
}

reshape long value_, i(_var) j(date, string)

split date, p("_")

replace date1 = "1" if date1 == "Jan"
replace date1 = "2" if date1 == "Feb"
replace date1 = "3" if date1 == "Mar"
replace date1 = "4" if date1 == "Apr"
replace date1 = "5" if date1 == "May"
replace date1 = "6" if date1 == "Jun"
replace date1 = "7" if date1 == "Jul"
replace date1 = "8" if date1 == "Aug"
replace date1 = "9" if date1 == "Sep"
replace date1 = "10" if date1 == "Oct"
replace date1 = "11" if date1 == "Nov"
replace date1 = "12" if date1 == "Dec"

destring date*, replace

replace date2 = date2+2000

gen ym = ym(date2, date1)

format ym %tmMon/CCYY

replace date = subinstr(date, "_", "-", .)
sencode date, gsort(ym) g(date_enc)

summ date_enc
local _max = r(max)

twoway (line value_ date_enc, sort lwidth(thick) lcolor(navy)), graphregion(color(white)) plotregion(color(white)) ytitle("") legend(off) title("") xtitle("") yscale(range(1.5 3.5)) ylabel(1.5(0.5)3.5) xlabel(1(1)`_max', valuelabel labsize(medsmall) angle(30)) name(fig_4b, replace)
gr export output/fig_4b.png, as(png) replace